/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.calc.ProgressController;
import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.HiDPIIconButton;
import com.actelion.research.gui.swing.SwingUIHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JProgressPanel
extends JPanel
implements ActionListener,
ProgressController {
    private static final long serialVersionUID = 538182660L;
    private static final int SHOW_ERROR = 1;
    private static final int START_PROGRESS = 2;
    private static final int UPDATE_PROGRESS = 3;
    private static final int STOP_PROGRESS = 4;
    private JProgressBar mProgressBar = new JProgressBar();
    private JLabel mProgressLabel = new JLabel();
    private JButton mCancelButton;
    private volatile boolean mCancelAction;
    private volatile float mUpdateFactor;
    private volatile boolean mUpdateActionPending;
    private volatile int mUpdateStatus;

    public JProgressPanel(boolean bl) {
        Font font = UIManager.getFont("Label.font");
        Font font2 = font.deriveFont(1, 0.88f * (float)font.getSize());
        this.mProgressLabel.setForeground(LookAndFeelHelper.isDarkLookAndFeel() ? Color.RED.brighter() : Color.RED.darker());
        this.mProgressLabel.setFont(font2);
        Dimension dimension = new Dimension(HiDPIHelper.scale(80.0f), HiDPIHelper.scale(10.0f));
        this.mProgressBar.setVisible(false);
        this.mProgressBar.setPreferredSize(dimension);
        this.mProgressBar.setMaximumSize(dimension);
        this.mProgressBar.setMinimumSize(dimension);
        this.mProgressBar.setSize(dimension);
        double[][] dArrayArray = new double[][]{{-2.0, 4.0, -2.0, 4.0, -1.0}, {-1.0, -2.0, -1.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.add((Component)this.mProgressBar, "0,1");
        this.add((Component)this.mProgressLabel, "4,0,4,2");
        if (bl) {
            this.mCancelButton = new HiDPIIconButton("closeButton.png", null, "close");
            this.mCancelButton.setVisible(false);
            this.mCancelButton.addActionListener(this);
            double[][] dArrayArray2 = new double[][]{{-2.0}, {-1.0, -2.0, -1.0}};
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new TableLayout(dArrayArray2));
            jPanel.add((Component)this.mCancelButton, "0,1");
            this.add((Component)jPanel, "2,0,2,2");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("close")) {
            this.mCancelAction = true;
            return;
        }
    }

    public void cancel() {
        this.mCancelAction = true;
    }

    public void initializeThreadMustDie() {
        this.mCancelAction = false;
    }

    @Override
    public void startProgress(String string, int n, int n2) {
        this.doActionThreadSafe(2, string, n, n2);
    }

    @Override
    public void updateProgress(int n) {
        this.doActionThreadSafe(3, null, n, 0);
    }

    @Override
    public void updateProgress(int n, String string) {
        this.doActionThreadSafe(3, string, n, 0);
    }

    @Override
    public void stopProgress() {
        this.doActionThreadSafe(4, null, 0, 0);
    }

    @Override
    public void showErrorMessage(String string) {
        this.doActionThreadSafe(1, string, 0, 0);
    }

    public void showMessage(String string) {
        this.mProgressLabel.setText(string);
    }

    @Override
    public boolean threadMustDie() {
        return this.mCancelAction;
    }

    private void doActionThreadSafe(int n, String string, int n2, int n3) {
        if (n == 2) {
            this.mUpdateFactor = n3 - n2 <= 10000 ? 1.0f : 10000.0f / (float)(n3 - n2);
            this.mUpdateStatus = n2;
        }
        if (n == 3) {
            int n4 = this.mUpdateStatus = n2 >= 0 ? n2 : this.mUpdateStatus - n2;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.doAction(n, string, n2, n3);
        } else if (n == 3) {
            if (!this.mUpdateActionPending) {
                this.mUpdateActionPending = true;
                try {
                    SwingUtilities.invokeLater(() -> {
                        this.doAction(n, string, n2, n3);
                        this.mUpdateActionPending = false;
                    });
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                SwingUtilities.invokeLater(() -> this.doAction(n, string, n2, n3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doAction(int n, String string, int n2, int n3) {
        switch (n) {
            case 1: {
                JOptionPane.showMessageDialog(SwingUIHelper.getWindow(this), string);
                break;
            }
            case 2: {
                this.mProgressBar.setVisible(true);
                this.mProgressBar.setIndeterminate(n2 == n3);
                if (n2 != n3) {
                    this.mProgressBar.setMinimum(Math.round(this.mUpdateFactor * (float)n2));
                    this.mProgressBar.setMaximum(Math.round(this.mUpdateFactor * (float)n3));
                    this.mProgressBar.setValue(Math.round(this.mUpdateFactor * (float)n2));
                }
                if (this.mCancelButton != null) {
                    this.mCancelButton.setVisible(true);
                }
                this.mProgressLabel.setText(string);
                break;
            }
            case 3: {
                this.mProgressBar.setValue(Math.round(this.mUpdateFactor * (float)this.mUpdateStatus));
                if (string == null) break;
                this.mProgressLabel.setText(string);
                break;
            }
            case 4: {
                this.mProgressLabel.setText("");
                this.mProgressBar.setValue(this.mProgressBar.getMinimum());
                this.mProgressBar.setVisible(false);
                if (this.mCancelButton == null) break;
                this.mCancelButton.setVisible(false);
            }
        }
    }
}

