/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.JMultiPanelTitle;
import com.actelion.research.gui.MultiPanelDragListener;
import com.actelion.research.gui.MultiPanelObject;
import com.actelion.research.util.DoubleFormat;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JMultiPanelView
extends JPanel
implements MultiPanelDragListener {
    static final long serialVersionUID = 537330452L;
    public static final String VIEW_HEIGHT = "height";
    private ArrayList<MultiPanelObject> mPanelList;
    private TableLayout mLayout;
    private int mDragTitle;
    private int mDragStart;
    private int[] mDragStartPanelHeight;

    public JMultiPanelView() {
        double[][] dArrayArray = new double[][]{{-1.0}, new double[0]};
        this.mLayout = new TableLayout(dArrayArray);
        this.setLayout(this.mLayout);
        this.setOpaque(false);
        this.mPanelList = new ArrayList();
    }

    public void add(JComponent jComponent, String string) {
        this.add(jComponent, string, this.mPanelList.size());
    }

    public void add(JComponent jComponent, String string, int n) {
        double d = this.suggestHeight();
        JMultiPanelTitle jMultiPanelTitle = new JMultiPanelTitle(this, string);
        if (n == 0) {
            jMultiPanelTitle.setDragEnabled(false);
            for (int i = 0; i < this.mPanelList.size(); ++i) {
                this.mPanelList.get((int)i).titlePanel.setDragEnabled(true);
            }
        }
        this.mLayout.insertRow(2 * n, JMultiPanelTitle.HEIGHT);
        this.mLayout.insertRow(2 * n + 1, d);
        super.add((Component)jMultiPanelTitle, "0, " + 2 * n);
        super.add((Component)jComponent, "0, " + (2 * n + 1));
        this.mPanelList.add(n, new MultiPanelObject(jComponent, jMultiPanelTitle, string));
        this.validateHeights();
    }

    public int getViewCount() {
        return this.mPanelList.size();
    }

    public JComponent getView(int n) {
        return this.mPanelList.get((int)n).panel;
    }

    public void setTitle(int n, String string) {
        this.mPanelList.get((int)n).titlePanel.setTitle(string);
    }

    public void remove(JComponent jComponent) {
        super.remove(jComponent);
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            if (this.mPanelList.get((int)i).panel != jComponent) continue;
            super.remove(this.mPanelList.get((int)i).titlePanel);
            this.mPanelList.remove(i);
            this.mLayout.deleteRow(2 * i);
            this.mLayout.deleteRow(2 * i);
            this.validateHeights();
            return;
        }
    }

    public String getProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            MultiPanelObject multiPanelObject = this.mPanelList.get(i);
            if (!(this.mLayout.getRow(2 * i + 1) > 0.0)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append("height[" + multiPanelObject.title + "]=" + DoubleFormat.toString(this.mLayout.getRow(2 * i + 1)));
        }
        return stringBuffer.toString();
    }

    public void setProperties(String string) {
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            this.mLayout.setRow(2 * i + 1, 0.0);
        }
        if (string.startsWith("height[")) {
            int n;
            boolean[] blArray = new boolean[this.mPanelList.size()];
            int n2 = VIEW_HEIGHT.length() + 1;
            while (n2 < string.length() && (n = string.indexOf("]=", n2)) != -1) {
                String string2 = string.substring(n2, n);
                int n3 = string.indexOf(";", n);
                if (n3 == -1) {
                    n3 = string.length();
                }
                for (int i = 0; i < this.mPanelList.size(); ++i) {
                    if (blArray[i] || !this.mPanelList.get(i).titleMatches(string2)) continue;
                    blArray[i] = true;
                    try {
                        double d = Double.parseDouble(string.substring(n + 2, n3));
                        this.mLayout.setRow(2 * i + 1, Math.min(0.999999, d));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                n2 = n3 + VIEW_HEIGHT.length() + 2;
            }
        }
        this.validateHeights();
    }

    @Override
    public void dragStarted(int n, JMultiPanelTitle jMultiPanelTitle) {
        this.mDragTitle = 0;
        while (this.mDragTitle < this.mPanelList.size() && this.mPanelList.get((int)this.mDragTitle).titlePanel != jMultiPanelTitle) {
            ++this.mDragTitle;
        }
        if (this.mDragTitle != 0) {
            this.mDragStartPanelHeight = this.getPanelHeights();
            this.mDragStart = this.getAbsoluteY(n, this.mDragStartPanelHeight);
        }
    }

    @Override
    public void dragContinued(int n) {
        if (this.mDragTitle != 0) {
            int n2;
            int n3;
            int[] nArray = this.getPanelHeights();
            int n4 = this.getAbsoluteY(n, nArray) - this.mDragStart;
            int[] nArray2 = new int[this.mPanelList.size()];
            for (n3 = 0; n3 < this.mPanelList.size(); ++n3) {
                nArray2[n3] = this.mDragStartPanelHeight[n3];
            }
            if (n4 < 0) {
                n3 = 0;
                for (n2 = this.mDragTitle - 1; n2 >= 0; --n2) {
                    if (-n4 <= this.mDragStartPanelHeight[n2] - 6) {
                        int n5 = n2;
                        nArray2[n5] = nArray2[n5] + n4;
                        n3 -= n4;
                        break;
                    }
                    if (-n4 <= this.mDragStartPanelHeight[n2]) {
                        nArray2[n2] = 0;
                        n3 += this.mDragStartPanelHeight[n2];
                        break;
                    }
                    n4 += this.mDragStartPanelHeight[n2];
                    n3 += this.mDragStartPanelHeight[n2];
                    nArray2[n2] = 0;
                }
                int n6 = this.mDragTitle;
                nArray2[n6] = nArray2[n6] + n3;
            } else if (n4 > 0) {
                n3 = 0;
                for (n2 = this.mDragTitle; n2 < this.mPanelList.size(); ++n2) {
                    if (n4 <= this.mDragStartPanelHeight[n2] - 6) {
                        int n7 = n2;
                        nArray2[n7] = nArray2[n7] - n4;
                        n3 += n4;
                        break;
                    }
                    if (n4 <= this.mDragStartPanelHeight[n2]) {
                        nArray2[n2] = 0;
                        n3 += this.mDragStartPanelHeight[n2];
                        break;
                    }
                    n4 -= this.mDragStartPanelHeight[n2];
                    n3 += this.mDragStartPanelHeight[n2];
                    nArray2[n2] = 0;
                }
                int n8 = this.mDragTitle - 1;
                nArray2[n8] = nArray2[n8] + n3;
            }
            n3 = 0;
            for (n2 = 0; n2 < this.mPanelList.size(); ++n2) {
                n3 += nArray[n2];
            }
            for (n2 = 0; n2 < this.mPanelList.size(); ++n2) {
                if (nArray2[n2] != nArray[n2]) {
                    this.mLayout.setRow(n2 * 2 + 1, Math.min(0.999999, (double)nArray2[n2] / (double)n3));
                }
                this.revalidate();
            }
        }
    }

    private int[] getPanelHeights() {
        int[] nArray = new int[this.mPanelList.size()];
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            nArray[i] = this.mPanelList.get((int)i).panel.getHeight();
        }
        return nArray;
    }

    private int getAbsoluteY(int n, int[] nArray) {
        int n2 = n;
        for (int i = 0; i < this.mDragTitle; ++i) {
            n2 += JMultiPanelTitle.HEIGHT + nArray[i];
        }
        return n2;
    }

    private double suggestHeight() {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            if (this.mLayout.getRow(2 * i + 1) == 0.0) continue;
            d += this.mLayout.getRow(2 * i + 1);
            ++n;
        }
        return n == 0 ? 1.0 : d / (double)n;
    }

    private void validateHeights() {
        double d = 0.0;
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            d += this.mLayout.getRow(2 * i + 1);
        }
        if (d != 0.0) {
            double d2 = 1.0 / d;
            for (int i = 0; i < this.mPanelList.size(); ++i) {
                this.mLayout.setRow(2 * i + 1, Math.min(0.999999, d2 * this.mLayout.getRow(2 * i + 1)));
            }
        }
        this.revalidate();
    }
}

