/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.JChemistryView;
import com.actelion.research.gui.editor.SwingEditorDialog;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingUIHelper;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

public class JEditableChemistryView
extends JChemistryView {
    private static final String EDIT_MESSAGE = "<double click or drag & drop>";
    private StereoMolecule[] mMolecules;
    private Reaction mReaction;

    public JEditableChemistryView(int n) {
        super(n);
        if (n == 1) {
            this.mReaction = new Reaction();
            super.setContent(this.mReaction);
        } else {
            this.mMolecules = new StereoMolecule[1];
            this.mMolecules[0] = new StereoMolecule();
            super.setContent(this.mMolecules);
        }
        this.setEditable(true);
    }

    public StereoMolecule[] getStructures() {
        return this.mMolecules;
    }

    public Reaction getReaction() {
        return this.mReaction;
    }

    @Override
    public void setContent(StereoMolecule[] stereoMoleculeArray) {
        this.setContent(stereoMoleculeArray, null);
    }

    @Override
    public void setContent(Reaction reaction) {
        this.setContent(reaction, null);
    }

    @Override
    public void setContent(StereoMolecule[] stereoMoleculeArray, DrawingObjectList drawingObjectList) {
        this.mMolecules = stereoMoleculeArray;
        super.setContent(stereoMoleculeArray, drawingObjectList);
    }

    @Override
    public void setContent(Reaction reaction, DrawingObjectList drawingObjectList) {
        if (reaction == null) {
            this.mReaction.clear();
        } else {
            this.mReaction = reaction;
        }
        super.setContent(this.mReaction, drawingObjectList);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.isEnabled() && this.isEditable()) {
            if (this.getChemistryType() == 1) {
                this.editReaction();
            } else {
                this.editMolecules();
            }
            return;
        }
        super.mouseClicked(mouseEvent);
    }

    private boolean isEmpty() {
        if (this.getChemistryType() == 1) {
            return this.mReaction == null || this.mReaction.isEmpty();
        }
        if (this.mMolecules != null) {
            for (StereoMolecule stereoMolecule : this.mMolecules) {
                if (stereoMolecule.getAllAtoms() == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        super.paintComponent(graphics);
        if (this.isEnabled() && this.isEditable() && this.isEmpty()) {
            graphics.setFont(graphics.getFont().deriveFont(0, HiDPIHelper.scale(10.0f)));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(EDIT_MESSAGE, graphics);
            graphics.drawString(EDIT_MESSAGE, insets.left + (int)((double)dimension.width - rectangle2D.getWidth()) / 2, insets.top + (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        }
    }

    private void editReaction() {
        SwingEditorDialog swingEditorDialog = this.createDrawDialog("Edit Reaction", new Reaction(this.mReaction));
        swingEditorDialog.setVisible(true);
        if (!swingEditorDialog.isCancelled()) {
            Reaction reaction = swingEditorDialog.getReactionAndDrawings();
            if (reaction != null) {
                int n;
                for (n = 0; n < reaction.getMolecules(); ++n) {
                    reaction.getMolecule(n).removeAtomSelection();
                }
                for (n = 0; n < this.mReaction.getCatalysts(); ++n) {
                    reaction.addCatalyst(this.mReaction.getCatalyst(n));
                }
            }
            this.setContent(reaction);
            this.informListeners();
        }
    }

    private void editMolecules() {
        StereoMolecule[] stereoMoleculeArray = new StereoMolecule[this.mMolecules.length];
        for (int i = 0; i < this.mMolecules.length; ++i) {
            stereoMoleculeArray[i] = new StereoMolecule(this.mMolecules[i]);
        }
        SwingEditorDialog swingEditorDialog = this.createDrawDialog("Edit Molecules", stereoMoleculeArray);
        swingEditorDialog.setVisible(true);
        if (!swingEditorDialog.isCancelled()) {
            StereoMolecule[] stereoMoleculeArray2 = swingEditorDialog.getDrawArea().getFragments();
            this.setContent(stereoMoleculeArray2);
            this.informListeners();
        }
    }

    protected SwingEditorDialog createDrawDialog(String string, Reaction reaction) {
        SwingEditorDialog swingEditorDialog = new SwingEditorDialog(SwingUIHelper.getWindow(this), reaction, Dialog.ModalityType.DOCUMENT_MODAL);
        if (string != null) {
            swingEditorDialog.setTitle(string);
        }
        return swingEditorDialog;
    }

    protected SwingEditorDialog createDrawDialog(String string, StereoMolecule[] stereoMoleculeArray) {
        SwingEditorDialog swingEditorDialog = new SwingEditorDialog(SwingUIHelper.getWindow(this), stereoMoleculeArray, Dialog.ModalityType.DOCUMENT_MODAL);
        if (string != null) {
            swingEditorDialog.setTitle(string);
        }
        return swingEditorDialog;
    }
}

