/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.JDrawArea;
import com.actelion.research.gui.JDrawToolbar;
import com.actelion.research.gui.StructureListener;
import com.actelion.research.gui.clipboard.ClipboardHandler;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

@Deprecated
public class JDrawDialog
extends JDialog
implements ActionListener,
KeyListener {
    static final long serialVersionUID = 537268249L;
    private static final String DEFAULT_TITLE = "OSIRIS Structure Editor";
    private StereoMolecule mMolecule;
    protected JDrawToolbar mToolBar;
    protected JDrawArea mArea;
    private JPanel mButtonPanel;
    private boolean mIsCancelled;
    private ArrayList<StructureListener> mListener;

    public JDrawDialog(Window window, StereoMolecule stereoMolecule) {
        this(window, stereoMolecule, DEFAULT_TITLE);
    }

    public JDrawDialog(Window window, StereoMolecule stereoMolecule, Dialog.ModalityType modalityType) {
        this(window, stereoMolecule, DEFAULT_TITLE, modalityType);
    }

    public JDrawDialog(Window window, StereoMolecule stereoMolecule, String string) {
        this(window, stereoMolecule, string, Dialog.DEFAULT_MODALITY_TYPE);
    }

    public JDrawDialog(Window window, StereoMolecule stereoMolecule, String string, Dialog.ModalityType modalityType) {
        super(window, string, modalityType);
        this.mMolecule = stereoMolecule == null ? new StereoMolecule() : new StereoMolecule(stereoMolecule);
        this.initialize(window, 0);
    }

    public JDrawDialog(Window window, StereoMolecule[] stereoMoleculeArray, String string, Dialog.ModalityType modalityType) {
        super(window, string, modalityType);
        this.mMolecule = new StereoMolecule();
        this.initialize(window, 1);
        if (stereoMoleculeArray != null) {
            this.mArea.setFragments(stereoMoleculeArray);
        }
    }

    public JDrawDialog(Window window, Reaction reaction, String string, Dialog.ModalityType modalityType) {
        super(window, string, modalityType);
        this.mMolecule = new StereoMolecule();
        this.initialize(window, 4);
        if (reaction != null) {
            this.mArea.setReaction(reaction);
        }
    }

    public JDrawDialog(Window window) {
        this(window, false, DEFAULT_TITLE);
    }

    public JDrawDialog(Window window, boolean bl) {
        this(window, bl, DEFAULT_TITLE);
    }

    public JDrawDialog(Window window, boolean bl, String string) {
        super(window, string, Dialog.DEFAULT_MODALITY_TYPE);
        this.mMolecule = new StereoMolecule();
        this.mMolecule.setFragment(bl);
        this.initialize(window, 0);
    }

    public JDrawDialog(Window window, StereoMolecule[] stereoMoleculeArray) {
        this(window, stereoMoleculeArray, DEFAULT_TITLE);
    }

    public JDrawDialog(Window window, StereoMolecule[] stereoMoleculeArray, Dialog.ModalityType modalityType) {
        this(window, stereoMoleculeArray, DEFAULT_TITLE, modalityType);
    }

    public JDrawDialog(Window window, StereoMolecule[] stereoMoleculeArray, String string) {
        this(window, stereoMoleculeArray, string, Dialog.DEFAULT_MODALITY_TYPE);
    }

    public JDrawDialog(Window window, Reaction reaction) {
        this(window, reaction, DEFAULT_TITLE);
    }

    public JDrawDialog(Window window, Reaction reaction, Dialog.ModalityType modalityType) {
        this(window, reaction, DEFAULT_TITLE, modalityType);
    }

    public JDrawDialog(Window window, Reaction reaction, String string) {
        this(window, reaction, string, Dialog.DEFAULT_MODALITY_TYPE);
    }

    private void initialize(Component component, int n) {
        this.addKeyListener(this);
        this.mArea = new JDrawArea(this.mMolecule, n);
        this.mArea.setClipboardHandler(new ClipboardHandler());
        this.mArea.setPreferredSize(new Dimension(HiDPIHelper.scale(n == 4 ? 800.0f : 480.0f), HiDPIHelper.scale(300.0f)));
        this.getContentPane().add((Component)this.mArea, "Center");
        this.mToolBar = new JDrawToolbar(this.mArea, n);
        this.getContentPane().add((Component)this.mToolBar, "West");
        this.mButtonPanel = new JPanel();
        this.mButtonPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 8, 0));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        this.mButtonPanel.add((Component)jPanel, "East");
        JButton jButton3 = new JButton("Help");
        jButton3.addActionListener(this);
        this.mButtonPanel.add((Component)jButton3, "West");
        this.mButtonPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.getContentPane().add((Component)this.mButtonPanel, "South");
        this.mListener = new ArrayList();
        this.pack();
        this.setLocationRelativeTo(component);
        this.mIsCancelled = true;
    }

    public void addStructureListener(StructureListener structureListener) {
        this.mListener.add(structureListener);
    }

    public JDrawArea getDrawArea() {
        return this.mArea;
    }

    public void setAccessory(Component component) {
        this.mButtonPanel.add(component, "North");
        this.pack();
    }

    public StereoMolecule getStructure() {
        return this.mMolecule;
    }

    public Reaction getReaction() {
        return this.mArea.getReaction();
    }

    public Reaction getReactionAndDrawings() {
        return this.mArea.getReactionAndDrawings();
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Help")) {
            this.mArea.showHelpDialog();
            return;
        }
        if (actionEvent.getActionCommand().equals("OK")) {
            for (StructureListener structureListener : this.mListener) {
                structureListener.structureChanged(this.mMolecule);
            }
            this.mIsCancelled = false;
        }
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.mArea.keyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.mArea.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

