/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.ExtendedMolecule;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Deprecated
public class JBondQueryFeatureDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 537331746L;
    private ExtendedMolecule mMol;
    private int mBond;
    private int mFirstSpanItem;
    private JCheckBox mCBSingle;
    private JCheckBox mCBDouble;
    private JCheckBox mCBTriple;
    private JCheckBox mCBDelocalized;
    private JCheckBox mCBMetalLigand;
    private JCheckBox mCBIsBridge;
    private JCheckBox mCBMatchStereo;
    private JComboBox mComboBoxRing;
    private JComboBox mComboBoxRingSize;
    private JComboBox mComboBoxMinAtoms;
    private JComboBox mComboBoxMaxAtoms;

    protected JBondQueryFeatureDialog(Window window, ExtendedMolecule extendedMolecule, int n) {
        super(window, extendedMolecule.isSelectedAtom(extendedMolecule.getBondAtom(0, n)) && extendedMolecule.isSelectedAtom(extendedMolecule.getBondAtom(1, n)) ? "Multiple Bond Properties" : "Bond Properties", Dialog.DEFAULT_MODALITY_TYPE);
        this.init(window, extendedMolecule, n);
    }

    private void init(Component component, ExtendedMolecule extendedMolecule, int n) {
        this.mMol = extendedMolecule;
        this.mBond = n;
        JPanel jPanel = new JPanel();
        double[][] dArrayArray = new double[][]{{8.0, -1.0, -2.0, -2.0, 8.0}, {8.0, -2.0, -2.0, -2.0, -2.0, -2.0, 8.0, -2.0, 8.0, -2.0, 8.0, -2.0, 16.0, -2.0, 4.0, -2.0, 4.0, -2.0, 16.0}};
        jPanel.setLayout(new TableLayout(dArrayArray));
        this.mCBSingle = new JCheckBox("Single");
        jPanel.add((Component)this.mCBSingle, "1,1,3,1");
        this.mCBDouble = new JCheckBox("Double");
        jPanel.add((Component)this.mCBDouble, "1,2,3,2");
        this.mCBTriple = new JCheckBox("Triple");
        jPanel.add((Component)this.mCBTriple, "1,3,3,3");
        this.mCBDelocalized = new JCheckBox("Delocalized");
        jPanel.add((Component)this.mCBDelocalized, "1,4,3,4");
        this.mCBMetalLigand = new JCheckBox("Coordinate (0-order)");
        jPanel.add((Component)this.mCBMetalLigand, "1,5,3,5");
        this.mComboBoxRing = new JComboBox();
        this.mComboBoxRing.addItem("any ring state");
        this.mComboBoxRing.addItem("is not in a ring");
        this.mComboBoxRing.addItem("is any ring bond");
        this.mComboBoxRing.addItem("is non-aromatic ring bond");
        this.mComboBoxRing.addItem("is aromatic bond");
        this.mComboBoxRing.addActionListener(this);
        jPanel.add((Component)this.mComboBoxRing, "1,7,3,7");
        this.mComboBoxRingSize = new JComboBox();
        this.mComboBoxRingSize.addItem("any ring size");
        this.mComboBoxRingSize.addItem("is in 3-membered ring");
        this.mComboBoxRingSize.addItem("is in 4-membered ring");
        this.mComboBoxRingSize.addItem("is in 5-membered ring");
        this.mComboBoxRingSize.addItem("is in 6-membered ring");
        this.mComboBoxRingSize.addItem("is in 7-membered ring");
        jPanel.add((Component)this.mComboBoxRingSize, "1,9,3,9");
        this.mCBMatchStereo = new JCheckBox("Match Stereo Configuration", (extendedMolecule.getBondQueryFeatures(n) & 0x100000) != 0);
        this.mCBMatchStereo.addActionListener(this);
        jPanel.add((Component)this.mCBMatchStereo, "1,11,3,11");
        this.mCBIsBridge = new JCheckBox("Is atom bridge between");
        this.mCBIsBridge.addActionListener(this);
        jPanel.add((Component)this.mCBIsBridge, "1,13,3,13");
        this.mComboBoxMinAtoms = new JComboBox();
        int n2 = 16;
        for (int i = 0; i < n2; ++i) {
            this.mComboBoxMinAtoms.addItem("" + i);
        }
        jPanel.add((Component)this.mComboBoxMinAtoms, "2,15");
        jPanel.add((Component)new JLabel(" and"), "3,15");
        this.mComboBoxMinAtoms.addActionListener(this);
        this.mComboBoxMaxAtoms = new JComboBox();
        this.populateComboBoxMaxAtoms(0);
        jPanel.add((Component)this.mComboBoxMaxAtoms, "2,17");
        jPanel.add((Component)new JLabel(" atoms"), "3,17");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 8, 8, 8));
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 6, 8, 0));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(this);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "East");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.mMol.ensureHelperArrays(7);
        this.setInitialStates();
        this.pack();
        this.setLocationRelativeTo(component);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.mCBIsBridge || actionEvent.getSource() == this.mComboBoxRing) {
            this.enableItems();
            return;
        }
        if (actionEvent.getSource() == this.mComboBoxMinAtoms && this.mFirstSpanItem != (n = this.mComboBoxMinAtoms.getSelectedIndex())) {
            int n2 = this.mFirstSpanItem + this.mComboBoxMaxAtoms.getSelectedIndex();
            int n3 = this.populateComboBoxMaxAtoms(n);
            if (n2 < n) {
                this.mComboBoxMaxAtoms.setSelectedIndex(0);
            } else if (n2 < n + n3) {
                this.mComboBoxMaxAtoms.setSelectedIndex(n2 - n);
            } else {
                this.mComboBoxMaxAtoms.setSelectedIndex(n3 - 1);
            }
            this.mFirstSpanItem = n;
        }
        if (actionEvent.getActionCommand() == "Cancel") {
            this.dispose();
        } else if (actionEvent.getActionCommand() == "OK") {
            this.setQueryFeatures();
            this.dispose();
        }
    }

    private void setInitialStates() {
        int n;
        int n2 = this.mMol.getBondQueryFeatures(this.mBond);
        int n3 = n = this.mMol.getBondType(this.mBond) == 64 || this.mMol.isDelocalizedBond(this.mBond) ? 4 : this.mMol.getBondOrder(this.mBond);
        if ((n2 & 1) != 0 || n == 1) {
            this.mCBSingle.setSelected(true);
        }
        if ((n2 & 2) != 0 || n == 2) {
            this.mCBDouble.setSelected(true);
        }
        if ((n2 & 4) != 0 || n == 3) {
            this.mCBTriple.setSelected(true);
        }
        if ((n2 & 8) != 0 || n == 4) {
            this.mCBDelocalized.setSelected(true);
        }
        if ((n2 & 0x10) != 0 || n == 0) {
            this.mCBMetalLigand.setSelected(true);
        }
        if ((n2 & 0x100000) != 0) {
            this.mCBMatchStereo.setSelected(true);
        }
        int n4 = n2 & 0x180;
        int n5 = n2 & 0x600000;
        if (n4 == 128) {
            this.mComboBoxRing.setSelectedIndex(1);
        } else if (n5 == 0x200000) {
            this.mComboBoxRing.setSelectedIndex(4);
        } else if (n4 == 256) {
            if (n5 == 0) {
                this.mComboBoxRing.setSelectedIndex(2);
            } else if (n5 == 0x400000) {
                this.mComboBoxRing.setSelectedIndex(3);
            }
        }
        int n6 = (n2 & 0xE0000) >> 17;
        this.mComboBoxRingSize.setSelectedIndex(n6 == 0 ? 0 : n6 - 2);
        if ((n2 & 0x1FE00) != 0) {
            this.mCBIsBridge.setSelected(true);
            int n7 = (n2 & 0x1E00) >> 9;
            int n8 = (n2 & 0x1E000) >> 13;
            this.mComboBoxMinAtoms.setSelectedIndex(n7);
            this.populateComboBoxMaxAtoms(n7);
            this.mComboBoxMaxAtoms.setSelectedIndex(n8);
        }
        this.enableItems();
    }

    private int populateComboBoxMaxAtoms(int n) {
        this.mComboBoxMaxAtoms.removeAllItems();
        int n2 = 16;
        for (int i = 0; i < n2; ++i) {
            this.mComboBoxMaxAtoms.addItem("" + (n + i));
        }
        return n2;
    }

    private void enableItems() {
        boolean bl = this.mCBIsBridge.isSelected();
        this.mCBSingle.setEnabled(!bl);
        this.mCBDouble.setEnabled(!bl);
        this.mCBTriple.setEnabled(!bl);
        this.mCBDelocalized.setEnabled(!bl);
        this.mCBMetalLigand.setEnabled(!bl);
        this.mCBMatchStereo.setEnabled(!bl && this.mMol.getBondOrder(this.mBond) == 2 && this.mMol.getBondParity(this.mBond) != 0 && this.mMol.getBondParity(this.mBond) != 3);
        this.mComboBoxRing.setEnabled(!bl);
        this.mComboBoxRingSize.setEnabled(!bl && this.mComboBoxRing.getSelectedIndex() != 1);
        this.mComboBoxMinAtoms.setEnabled(bl);
        this.mComboBoxMaxAtoms.setEnabled(bl);
    }

    private void setQueryFeatures() {
        if (this.isSelectedBond(this.mBond)) {
            for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
                if (!this.isSelectedBond(i)) continue;
                this.setQueryFeatures(i);
            }
        } else {
            this.setQueryFeatures(this.mBond);
        }
    }

    private void setQueryFeatures(int n) {
        int n2 = 0;
        if (this.mCBIsBridge.isSelected()) {
            int n3 = this.mComboBoxMinAtoms.getSelectedIndex();
            int n4 = this.mComboBoxMaxAtoms.getSelectedIndex();
            n2 |= n3 << 9;
            n2 |= n4 << 13;
            n2 &= 0xFFFFFFE0;
        } else {
            int n5;
            int n6;
            int n7 = -1;
            if (this.mCBSingle.isSelected()) {
                this.mMol.setBondType(n, 1);
                n7 = 1;
            } else if (this.mCBDelocalized.isSelected() && !this.mMol.isDelocalizedBond(n)) {
                this.mMol.setBondType(n, 64);
                n7 = 4;
            } else if (this.mCBDouble.isSelected()) {
                this.mMol.setBondType(n, 2);
                n7 = 2;
            } else if (this.mCBTriple.isSelected()) {
                this.mMol.setBondType(n, 4);
                n7 = 3;
            } else if (this.mCBMetalLigand.isSelected()) {
                this.mMol.setBondType(n, 32);
                n7 = 0;
            }
            if (this.mCBSingle.isSelected() && n7 != 1) {
                n2 |= 1;
            }
            if (this.mCBDouble.isSelected() && n7 != 2) {
                n2 |= 2;
            }
            if (this.mCBTriple.isSelected() && n7 != 3) {
                n2 |= 4;
            }
            if (this.mCBDelocalized.isSelected() && n7 != 4) {
                n2 |= 8;
            }
            if (this.mCBMetalLigand.isSelected() && n7 != 0) {
                n2 |= 0x10;
            }
            if (this.mCBMatchStereo.isSelected()) {
                n2 |= 0x100000;
            }
            if (this.mComboBoxRing.getSelectedIndex() != 0) {
                if (this.mComboBoxRing.getSelectedIndex() == 1) {
                    if (!this.mMol.isRingBond(n)) {
                        n2 |= 0x80;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 2) {
                    if (!this.mMol.isRingBond(n)) {
                        n2 |= 0x100;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 3) {
                    if (!this.mMol.isAromaticBond(n)) {
                        n2 |= 0x400100;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 4 && !this.mMol.isAromaticBond(n)) {
                    n2 |= 0x200000;
                }
            }
            if (this.mComboBoxRingSize.getSelectedIndex() != 0 && (n6 = this.mComboBoxRingSize.getSelectedIndex() + 2) != (n5 = this.mMol.getBondRingSize(n))) {
                n2 |= n6 << 17;
            }
        }
        this.mMol.setBondQueryFeature(n, 0xFFFFFF, false);
        this.mMol.setBondQueryFeature(n, n2, true);
    }

    private boolean isSelectedBond(int n) {
        return this.mMol.isSelectedAtom(this.mMol.getBondAtom(0, n)) && this.mMol.isSelectedAtom(this.mMol.getBondAtom(1, n));
    }
}

