/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

@Deprecated
public class JAtomQueryFeatureDialog
extends JDialog
implements ActionListener,
ItemListener {
    static final long serialVersionUID = 537265952L;
    private Component mParent;
    private ExtendedMolecule mMol;
    private int mAtom;
    private JCheckBox mCBAny;
    private JCheckBox mCBBlocked;
    private JCheckBox mCBSubstituted;
    private JCheckBox mCBMatchStereo;
    private JCheckBox mCBExcludeGroup;
    private JComboBox mChoiceArom;
    private JComboBox mChoiceRingState;
    private JComboBox mChoiceRingSize;
    private JComboBox mChoiceCharge;
    private JComboBox mChoiceNeighbours;
    private JComboBox mChoiceHydrogen;
    private JComboBox mChoicePi;
    private JComboBox mChoiceReactionParityHint;
    private JTextField mTFAtomList;
    private JLabel mLabelAtomList;

    protected JAtomQueryFeatureDialog(Window window, ExtendedMolecule extendedMolecule, int n, boolean bl) {
        super(window, extendedMolecule.isSelectedAtom(n) ? "Multiple Atom Properties" : "Atom Properties", Dialog.DEFAULT_MODALITY_TYPE);
        this.init(window, extendedMolecule, n, bl);
    }

    private void init(Component component, ExtendedMolecule extendedMolecule, int n, boolean bl) {
        this.mParent = component;
        this.mMol = extendedMolecule;
        this.mAtom = n;
        boolean bl2 = false;
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(bl2);
        int n2 = HiDPIHelper.scale(8.0f);
        int[] nArray = new int[]{n2, n2 / 2, n2 * 3 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 * 3 / 2, 0, 0, 0};
        int[] nArray2 = new int[]{n2 * 3 / 2, n2 / 2};
        double[] dArray = new double[1 + 2 * nArray.length + (bl ? 2 * nArray2.length : 0)];
        int n3 = 0;
        for (int n4 : nArray) {
            dArray[n3++] = n4;
            dArray[n3++] = -2.0;
        }
        if (bl) {
            for (int n4 : nArray2) {
                dArray[n3++] = n4;
                dArray[n3++] = -2.0;
            }
        }
        dArray[n3++] = n2;
        double[][] dArrayArray = new double[][]{{n2, -2.0, n2, -2.0, n2}, dArray};
        jPanel.setLayout(new TableLayout(dArrayArray));
        this.mCBAny = new JCheckBox("any atomic number");
        this.mCBAny.setOpaque(bl2);
        this.mCBAny.addItemListener(this);
        jPanel.add((Component)this.mCBAny, "1,1,3,1");
        this.mLabelAtomList = new JLabel("excluded atoms:");
        this.mLabelAtomList.setOpaque(bl2);
        this.mTFAtomList = new JTextField(8);
        jPanel.add((Component)this.mLabelAtomList, "1,3");
        jPanel.add((Component)this.mTFAtomList, "3,3");
        this.mChoiceArom = new JComboBox();
        this.mChoiceArom.setOpaque(bl2);
        this.mChoiceArom.addItem("any aromatic state");
        this.mChoiceArom.addItem("is aromatic");
        this.mChoiceArom.addItem("is not aromatic");
        jPanel.add((Component)this.mChoiceArom, "1,5,3,5");
        this.mChoiceRingState = new JComboBox();
        this.mChoiceRingState.setOpaque(bl2);
        this.mChoiceRingState.addItem("any ring state");
        this.mChoiceRingState.addItem("is chain atom");
        this.mChoiceRingState.addItem("is any ring atom");
        this.mChoiceRingState.addItem("has 2 ring bonds");
        this.mChoiceRingState.addItem("has 3 ring bonds");
        this.mChoiceRingState.addItem("has >3 ring bonds");
        jPanel.add((Component)this.mChoiceRingState, "1,7,3,7");
        this.mChoiceRingSize = new JComboBox();
        this.mChoiceRingSize.setOpaque(bl2);
        this.mChoiceRingSize.addItem("any ring size");
        this.mChoiceRingSize.addItem("is in 3-membered ring");
        this.mChoiceRingSize.addItem("is in 4-membered ring");
        this.mChoiceRingSize.addItem("is in 5-membered ring");
        this.mChoiceRingSize.addItem("is in 6-membered ring");
        this.mChoiceRingSize.addItem("is in 7-membered ring");
        jPanel.add((Component)this.mChoiceRingSize, "1,9,3,9");
        this.mChoiceCharge = new JComboBox();
        this.mChoiceCharge.setOpaque(bl2);
        this.mChoiceCharge.addItem("any atom charge");
        this.mChoiceCharge.addItem("has no charge");
        this.mChoiceCharge.addItem("has negative charge");
        this.mChoiceCharge.addItem("has positive charge");
        jPanel.add((Component)this.mChoiceCharge, "1,11,3,11");
        this.mChoiceNeighbours = new JComboBox();
        this.mChoiceNeighbours.setOpaque(bl2);
        this.mChoiceNeighbours.addItem("any non-H neighbour count");
        this.mChoiceNeighbours.addItem("has exactly 1 neighbour");
        this.mChoiceNeighbours.addItem("has exactly 2 neighbours");
        this.mChoiceNeighbours.addItem("has exactly 3 neighbours");
        this.mChoiceNeighbours.addItem("has less than 3 neighbours");
        this.mChoiceNeighbours.addItem("has less than 4 neighbours");
        this.mChoiceNeighbours.addItem("has more than 1 neighbour");
        this.mChoiceNeighbours.addItem("has more than 2 neighbours");
        this.mChoiceNeighbours.addItem("has more than 3 neighbours");
        jPanel.add((Component)this.mChoiceNeighbours, "1,13,3,13");
        this.mChoiceHydrogen = new JComboBox();
        this.mChoiceHydrogen.setOpaque(bl2);
        this.mChoiceHydrogen.addItem("any hydrogen count");
        this.mChoiceHydrogen.addItem("no hydrogen");
        this.mChoiceHydrogen.addItem("exactly 1 hydrogen");
        this.mChoiceHydrogen.addItem("exactly 2 hydrogens");
        this.mChoiceHydrogen.addItem("at least 1 hydrogen");
        this.mChoiceHydrogen.addItem("at least 2 hydrogens");
        this.mChoiceHydrogen.addItem("at least 3 hydrogens");
        this.mChoiceHydrogen.addItem("less than 2 hydrogens");
        this.mChoiceHydrogen.addItem("less than 3 hydrogens");
        jPanel.add((Component)this.mChoiceHydrogen, "1,15,3,15");
        this.mChoicePi = new JComboBox();
        this.mChoicePi.setOpaque(bl2);
        this.mChoicePi.addItem("any pi electron count");
        this.mChoicePi.addItem("no pi electrons");
        this.mChoicePi.addItem("exactly 1 pi electron");
        this.mChoicePi.addItem("exactly 2 pi electrons");
        this.mChoicePi.addItem("at least 1 pi electron");
        jPanel.add((Component)this.mChoicePi, "1,17,3,17");
        this.mCBBlocked = new JCheckBox("prohibit further substitution");
        this.mCBBlocked.setOpaque(bl2);
        this.mCBBlocked.addItemListener(this);
        jPanel.add((Component)this.mCBBlocked, "1,19,3,19");
        this.mCBSubstituted = new JCheckBox("require further substitution");
        this.mCBSubstituted.setOpaque(bl2);
        this.mCBSubstituted.addItemListener(this);
        jPanel.add((Component)this.mCBSubstituted, "1,21,3,21");
        this.mCBMatchStereo = new JCheckBox("match stereo center");
        this.mCBMatchStereo.setOpaque(bl2);
        jPanel.add((Component)this.mCBMatchStereo, "1,23,3,23");
        this.mCBExcludeGroup = new JCheckBox("is part of exclude group");
        this.mCBExcludeGroup.setOpaque(bl2);
        jPanel.add((Component)this.mCBExcludeGroup, "1,25,3,25");
        if (bl) {
            jPanel.add((Component)new JLabel("Stereo center hint for product:"), "1,27,3,27");
            this.mChoiceReactionParityHint = new JComboBox();
            this.mChoiceReactionParityHint.setOpaque(bl2);
            this.mChoiceReactionParityHint.addItem("Make unknown in product");
            this.mChoiceReactionParityHint.addItem("Keep reactant configuration");
            this.mChoiceReactionParityHint.addItem("Invert reactant configuration");
            this.mChoiceReactionParityHint.addItem("Racemise configuration");
            jPanel.add((Component)this.mChoiceReactionParityHint, "1,29,3,29");
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 8, 8, 8));
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2, 8, 0));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(this);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "East");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
        this.setLocationRelativeTo(component);
        this.mMol.ensureHelperArrays(31);
        this.setInitialStates();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "Cancel") {
            this.dispose();
        } else if (actionEvent.getActionCommand() == "OK") {
            this.setQueryFeatures();
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.mCBAny) {
            if (this.mCBAny.isSelected()) {
                this.mTFAtomList.setText("");
                this.mLabelAtomList.setText("excluded atoms:");
            } else {
                this.mTFAtomList.setText(this.mMol.getAtomLabel(this.mAtom));
                this.mLabelAtomList.setText("allowed atoms:");
            }
        } else if (itemEvent.getItemSelectable() == this.mCBBlocked && itemEvent.getStateChange() == 1) {
            this.mCBSubstituted.setSelected(false);
            this.mChoiceNeighbours.setSelectedIndex(0);
        } else if (itemEvent.getItemSelectable() == this.mCBSubstituted && itemEvent.getStateChange() == 1) {
            this.mCBBlocked.setSelected(false);
        }
    }

    private void setInitialStates() {
        long l = this.mMol.getAtomQueryFeatures(this.mAtom);
        if ((l & 1L) != 0L) {
            this.mCBAny.setSelected(true);
            this.mLabelAtomList.setText("excluded atoms:");
        } else {
            this.mLabelAtomList.setText("allowed atoms:");
        }
        this.mTFAtomList.setText(this.mMol.getAtomList(this.mAtom) == null ? "" : this.mMol.getAtomListString(this.mAtom));
        long l2 = l & 0x400000000006L;
        if (l2 == 2L) {
            this.mChoiceArom.setSelectedIndex(1);
        } else if (l2 == 4L) {
            this.mChoiceArom.setSelectedIndex(2);
        }
        long l3 = l & 0x78L;
        if (l3 == 112L) {
            this.mChoiceRingState.setSelectedIndex(1);
        } else if (l3 == 8L) {
            this.mChoiceRingState.setSelectedIndex(2);
        } else if (l3 == 104L) {
            this.mChoiceRingState.setSelectedIndex(3);
        } else if (l3 == 88L) {
            this.mChoiceRingState.setSelectedIndex(4);
        } else if (l3 == 56L) {
            this.mChoiceRingState.setSelectedIndex(5);
        }
        long l4 = (l & 0x1C00000L) >> 22;
        this.mChoiceRingSize.setSelectedIndex(l4 == 0L ? 0 : (int)l4 - 2);
        long l5 = l & 0x3E0000L;
        if (l5 == 0x3A0000L) {
            this.mChoiceNeighbours.setSelectedIndex(1);
        } else if (l5 == 0x360000L) {
            this.mChoiceNeighbours.setSelectedIndex(2);
        } else if (l5 == 0x2E0000L) {
            this.mChoiceNeighbours.setSelectedIndex(3);
        } else if (l5 == 0x300000L) {
            this.mChoiceNeighbours.setSelectedIndex(4);
        } else if (l5 == 0x200000L) {
            this.mChoiceNeighbours.setSelectedIndex(5);
        } else if (l5 == 393216L) {
            this.mChoiceNeighbours.setSelectedIndex(6);
        } else if (l5 == 917504L) {
            this.mChoiceNeighbours.setSelectedIndex(7);
        } else if (l5 == 0x1E0000L) {
            this.mChoiceNeighbours.setSelectedIndex(8);
        }
        long l6 = l & 0xE000000L;
        if (l6 == 0xA000000L) {
            this.mChoiceCharge.setSelectedIndex(1);
        } else if (l6 == 0xC000000L) {
            this.mChoiceCharge.setSelectedIndex(2);
        } else if (l6 == 0x6000000L) {
            this.mChoiceCharge.setSelectedIndex(3);
        }
        long l7 = l & 0x780L;
        if (l7 == 1792L) {
            this.mChoiceHydrogen.setSelectedIndex(1);
        } else if (l7 == 1664L) {
            this.mChoiceHydrogen.setSelectedIndex(2);
        } else if (l7 == 1408L) {
            this.mChoiceHydrogen.setSelectedIndex(3);
        } else if (l7 == 128L) {
            this.mChoiceHydrogen.setSelectedIndex(4);
        } else if (l7 == 384L) {
            this.mChoiceHydrogen.setSelectedIndex(5);
        } else if (l7 == 896L) {
            this.mChoiceHydrogen.setSelectedIndex(6);
        } else if (l7 == 1536L) {
            this.mChoiceHydrogen.setSelectedIndex(7);
        } else if (l7 == 1024L) {
            this.mChoiceHydrogen.setSelectedIndex(8);
        }
        long l8 = l & 0x1C000L;
        if (l8 == 98304L) {
            this.mChoicePi.setSelectedIndex(1);
        } else if (l8 == 81920L) {
            this.mChoicePi.setSelectedIndex(2);
        } else if (l8 == 49152L) {
            this.mChoicePi.setSelectedIndex(3);
        } else if (l8 == 16384L) {
            this.mChoicePi.setSelectedIndex(4);
        }
        if ((l & 0x800L) != 0L) {
            this.mCBBlocked.setSelected(true);
        }
        if ((l & 0x1000L) != 0L) {
            this.mCBSubstituted.setSelected(true);
        }
        if ((l & 0x2000L) != 0L) {
            this.mCBMatchStereo.setSelected(true);
        }
        if ((l & 0x20000000L) != 0L) {
            this.mCBExcludeGroup.setSelected(true);
        }
        if (this.mChoiceReactionParityHint != null) {
            long l9 = l & 0xC0000000L;
            if (l9 == 0x40000000L) {
                this.mChoiceReactionParityHint.setSelectedIndex(1);
            } else if (l9 == 0x80000000L) {
                this.mChoiceReactionParityHint.setSelectedIndex(2);
            } else if (l9 == 0xC0000000L) {
                this.mChoiceReactionParityHint.setSelectedIndex(3);
            }
        }
    }

    private void setQueryFeatures() {
        int[] nArray = this.createAtomList();
        if (this.mMol.isSelectedAtom(this.mAtom)) {
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                if (!this.mMol.isSelectedAtom(i)) continue;
                this.setQueryFeatures(i, nArray);
            }
        } else {
            this.setQueryFeatures(this.mAtom, nArray);
        }
    }

    private void setQueryFeatures(int n, int[] nArray) {
        int n2 = 0;
        if (this.mCBAny.isSelected()) {
            n2 = (int)((long)n2 | 1L);
            this.mMol.setAtomList(n, nArray, true);
        } else {
            this.mMol.setAtomList(n, nArray, false);
        }
        if (!this.mMol.isAromaticAtom(n)) {
            if (this.mChoiceArom.getSelectedIndex() == 1) {
                n2 = (int)((long)n2 | 2L);
            } else if (this.mChoiceArom.getSelectedIndex() == 2) {
                n2 = (int)((long)n2 | 4L);
            }
        }
        int n3 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (!this.mMol.isRingBond(this.mMol.getConnBond(n, i))) continue;
            ++n3;
        }
        switch (this.mChoiceRingState.getSelectedIndex()) {
            case 1: {
                if (n3 != 0) break;
                n2 = (int)((long)n2 | 0x70L);
                break;
            }
            case 2: {
                n2 = (int)((long)n2 | 8L);
                break;
            }
            case 3: {
                if (n3 >= 3) break;
                n2 = (int)((long)n2 | 0x68L);
                break;
            }
            case 4: {
                if (n3 >= 4) break;
                n2 = (int)((long)n2 | 0x58L);
                break;
            }
            case 5: {
                n2 = (int)((long)n2 | 0x38L);
            }
        }
        if (this.mChoiceRingSize.getSelectedIndex() != 0) {
            n2 |= this.mChoiceRingSize.getSelectedIndex() + 2 << 22;
        }
        switch (this.mChoiceCharge.getSelectedIndex()) {
            case 1: {
                n2 = (int)((long)n2 | 0xA000000L);
                break;
            }
            case 2: {
                n2 = (int)((long)n2 | 0xC000000L);
                break;
            }
            case 3: {
                n2 = (int)((long)n2 | 0x6000000L);
            }
        }
        switch (this.mChoiceNeighbours.getSelectedIndex()) {
            case 1: {
                if (this.mMol.getConnAtoms(n) == 1) {
                    n2 = (int)((long)n2 | 0x800L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 1) break;
                n2 = (int)((long)n2 | 0x3A0000L);
                break;
            }
            case 2: {
                if (this.mMol.getConnAtoms(n) == 2) {
                    n2 = (int)((long)n2 | 0x800L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 2) break;
                n2 = (int)((long)n2 | 0x360000L);
                break;
            }
            case 3: {
                if (this.mMol.getConnAtoms(n) == 3) {
                    n2 = (int)((long)n2 | 0x800L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 3) break;
                n2 = (int)((long)n2 | 0x2E0000L);
                break;
            }
            case 4: {
                if (this.mMol.getConnAtoms(n) == 2) {
                    n2 = (int)((long)n2 | 0x800L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 2) break;
                n2 = (int)((long)n2 | 0x300000L);
                break;
            }
            case 5: {
                if (this.mMol.getConnAtoms(n) == 3) {
                    n2 = (int)((long)n2 | 0x800L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 3) break;
                n2 = (int)((long)n2 | 0x200000L);
                break;
            }
            case 6: {
                if (this.mMol.getConnAtoms(n) == 1) {
                    n2 = (int)((long)n2 | 0x1000L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 1) break;
                n2 = (int)((long)n2 | 0x60000L);
                break;
            }
            case 7: {
                if (this.mMol.getConnAtoms(n) == 2) {
                    n2 = (int)((long)n2 | 0x1000L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 2) break;
                n2 = (int)((long)n2 | 0xE0000L);
                break;
            }
            case 8: {
                if (this.mMol.getConnAtoms(n) == 3) {
                    n2 = (int)((long)n2 | 0x1000L);
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 3) break;
                n2 = (int)((long)n2 | 0x1E0000L);
            }
        }
        switch (this.mChoiceHydrogen.getSelectedIndex()) {
            case 1: {
                n2 = (int)((long)n2 | 0x700L);
                break;
            }
            case 2: {
                n2 = (int)((long)n2 | 0x680L);
                break;
            }
            case 3: {
                n2 = (int)((long)n2 | 0x580L);
                break;
            }
            case 4: {
                n2 = (int)((long)n2 | 0x80L);
                break;
            }
            case 5: {
                n2 = (int)((long)n2 | 0x180L);
                break;
            }
            case 6: {
                n2 = (int)((long)n2 | 0x380L);
                break;
            }
            case 7: {
                n2 = (int)((long)n2 | 0x600L);
                break;
            }
            case 8: {
                n2 = (int)((long)n2 | 0x400L);
            }
        }
        switch (this.mChoicePi.getSelectedIndex()) {
            case 1: {
                n2 = (int)((long)n2 | 0x18000L);
                break;
            }
            case 2: {
                n2 = (int)((long)n2 | 0x14000L);
                break;
            }
            case 3: {
                n2 = (int)((long)n2 | 0xC000L);
                break;
            }
            case 4: {
                n2 = (int)((long)n2 | 0x4000L);
            }
        }
        if (this.mCBBlocked.isSelected() && (this.mMol.getFreeValence(n) > 0 || this.mMol.getAtomCharge(n) == 0 && (this.mMol.getAtomicNo(n) == 5 || this.mMol.isNitrogenFamily(n) || this.mMol.isChalcogene(n)))) {
            n2 = (int)((long)n2 | 0x800L);
        }
        if (this.mCBSubstituted.isSelected() && (this.mMol.getFreeValence(n) > 0 || this.mMol.getAtomCharge(n) == 0 && (this.mMol.getAtomicNo(n) == 5 || this.mMol.isNitrogenFamily(n) || this.mMol.isChalcogene(n)))) {
            n2 = (int)((long)n2 | 0x1000L);
        }
        if (this.mCBMatchStereo.isSelected()) {
            n2 = (int)((long)n2 | 0x2000L);
        }
        if (this.mCBExcludeGroup.isSelected()) {
            n2 = (int)((long)n2 | 0x20000000L);
        }
        if (this.mChoiceReactionParityHint != null) {
            switch (this.mChoiceReactionParityHint.getSelectedIndex()) {
                case 1: {
                    n2 = (int)((long)n2 | 0x40000000L);
                    break;
                }
                case 2: {
                    n2 = (int)((long)n2 | 0x80000000L);
                    break;
                }
                case 3: {
                    n2 = (int)((long)n2 | 0xC0000000L);
                }
            }
        }
        this.mMol.setAtomQueryFeature(n, -1L, false);
        this.mMol.setAtomQueryFeature(n, n2, true);
    }

    private int[] createAtomList() {
        int n;
        String string = this.mTFAtomList.getText();
        if (string.length() == 0) {
            return null;
        }
        int[] nArray = null;
        do {
            String string2;
            if ((n = string.indexOf(44)) == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n);
                string = n == string.length() - 1 ? "" : string.substring(n + 1);
            }
            int n2 = Molecule.getAtomicNoFromLabel(string2);
            if (n2 == 0) continue;
            if (n2 == 1) {
                JOptionPane.showMessageDialog(this.mParent, "'H' cannot be part of an atom list and is removed.");
                continue;
            }
            if (nArray == null) {
                nArray = new int[]{n2};
                continue;
            }
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 != nArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray.length] = n2;
            nArray = nArray2;
        } while (n != -1);
        if (nArray != null) {
            Arrays.sort(nArray);
        }
        return nArray;
    }
}

