/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.CompoundCollectionListener;
import com.actelion.research.gui.CompoundCollectionModel;
import java.util.ArrayList;
import java.util.Collection;

public abstract class DefaultCompoundCollectionModel<T>
implements CompoundCollectionModel<T> {
    private ArrayList<T> mCompoundList = new ArrayList();
    private ArrayList<CompoundCollectionListener> mListenerList = new ArrayList();
    private boolean mEnableEvents = true;

    @Override
    public void addCompound(T t) {
        int n = this.mCompoundList.size();
        this.mCompoundList.add(t);
        this.informListeners(n, n);
    }

    @Override
    public void addCompound(int n, T t) {
        int n2 = this.mCompoundList.size();
        this.mCompoundList.add(n, t);
        this.informListeners(n, n2);
    }

    @Override
    public void addCompoundList(Collection<T> collection) {
        if (collection.size() != 0) {
            for (T t : collection) {
                this.mCompoundList.add(t);
            }
            this.informListeners(this.mCompoundList.size() - collection.size(), collection.size() - 1);
        }
    }

    @Override
    public void setCompound(int n, T t) {
        this.mCompoundList.set(n, t);
        this.informListeners(n, n);
    }

    @Override
    public void setCompoundList(Collection<T> collection) {
        int n = this.mCompoundList.size() - 1;
        this.mCompoundList.clear();
        for (T t : collection) {
            this.mCompoundList.add(t);
        }
        this.informListeners(0, Math.max(n, collection.size() - 1));
    }

    @Override
    public void addCompoundCollectionListener(CompoundCollectionListener compoundCollectionListener) {
        this.mListenerList.add(compoundCollectionListener);
    }

    @Override
    public T getCompound(int n) {
        return this.mCompoundList.get(n);
    }

    @Override
    public void removeCompoundCollectionListener(CompoundCollectionListener compoundCollectionListener) {
        this.mListenerList.remove(compoundCollectionListener);
    }

    @Override
    public void clear() {
        int n = this.mCompoundList.size() - 1;
        this.mCompoundList.clear();
        this.informListeners(0, n);
    }

    @Override
    public void addMoleculeList(Collection<StereoMolecule> collection) {
        this.mEnableEvents = false;
        int n = this.mCompoundList.size();
        for (StereoMolecule stereoMolecule : collection) {
            this.addMolecule(this.mCompoundList.size(), stereoMolecule);
        }
        this.mEnableEvents = true;
        this.informListeners(n, this.mCompoundList.size() - 1);
    }

    @Override
    public abstract void addMolecule(int var1, StereoMolecule var2);

    @Override
    public abstract void setMolecule(int var1, StereoMolecule var2);

    @Override
    public abstract StereoMolecule getMolecule(int var1);

    @Override
    public StereoMolecule getMoleculeForDisplay(int n) {
        return this.getMolecule(n);
    }

    @Override
    public int getSize() {
        return this.mCompoundList.size();
    }

    @Override
    public void remove(int n) {
        this.mCompoundList.remove(n);
        this.informListeners(n, this.mCompoundList.size());
    }

    private void informListeners(int n, int n2) {
        if (this.mEnableEvents) {
            for (CompoundCollectionListener compoundCollectionListener : this.mListenerList) {
                compoundCollectionListener.collectionUpdated(n, n2);
            }
        }
    }

    public static class Native
    extends DefaultCompoundCollectionModel<Object> {
        @Override
        public StereoMolecule getMolecule(int n) {
            Object t = this.getCompound(n);
            return t instanceof StereoMolecule ? (StereoMolecule)t : (t instanceof String ? new IDCodeParser(true).getCompactMolecule((String)t) : null);
        }

        @Override
        public void setMolecule(int n, StereoMolecule stereoMolecule) {
            this.setCompound(n, stereoMolecule);
        }

        @Override
        public void addMolecule(int n, StereoMolecule stereoMolecule) {
            this.addCompound(n, stereoMolecule);
        }
    }

    public static class IDCodeWithName
    extends DefaultCompoundCollectionModel<String[]> {
        @Override
        public StereoMolecule getMolecule(int n) {
            StereoMolecule stereoMolecule = new IDCodeParser().getCompactMolecule(((String[])this.getCompound(n))[0]);
            stereoMolecule.setName(((String[])this.getCompound(n))[1]);
            return stereoMolecule;
        }

        @Override
        public void setMolecule(int n, StereoMolecule stereoMolecule) {
            String[] stringArray = new String[2];
            Canonizer canonizer = new Canonizer(stereoMolecule);
            stringArray[0] = canonizer.getIDCode().concat(" ").concat(canonizer.getEncodedCoordinates());
            stringArray[1] = stereoMolecule.getName();
            this.setCompound(n, stringArray);
        }

        @Override
        public void addMolecule(int n, StereoMolecule stereoMolecule) {
            String[] stringArray = new String[2];
            Canonizer canonizer = new Canonizer(stereoMolecule);
            stringArray[0] = canonizer.getIDCode().concat(" ").concat(canonizer.getEncodedCoordinates());
            stringArray[1] = stereoMolecule.getName();
            this.addCompound(n, stringArray);
        }
    }

    public static class IDCode
    extends DefaultCompoundCollectionModel<String> {
        @Override
        public StereoMolecule getMolecule(int n) {
            return new IDCodeParser(true).getCompactMolecule((String)this.getCompound(n));
        }

        @Override
        public void setMolecule(int n, StereoMolecule stereoMolecule) {
            Canonizer canonizer = new Canonizer(stereoMolecule);
            this.setCompound(n, canonizer.getIDCode() + " " + canonizer.getEncodedCoordinates());
        }

        @Override
        public void addMolecule(int n, StereoMolecule stereoMolecule) {
            Canonizer canonizer = new Canonizer(stereoMolecule);
            this.addCompound(n, canonizer.getIDCode() + " " + canonizer.getEncodedCoordinates());
        }
    }

    public static class Molecule
    extends DefaultCompoundCollectionModel<StereoMolecule> {
        @Override
        public StereoMolecule getMolecule(int n) {
            return (StereoMolecule)this.getCompound(n);
        }

        @Override
        public void setMolecule(int n, StereoMolecule stereoMolecule) {
            this.setCompound(n, stereoMolecule);
        }

        @Override
        public void addMolecule(int n, StereoMolecule stereoMolecule) {
            this.addCompound(n, stereoMolecule);
        }
    }
}

