/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.shredder;

import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;

public class MoleculeShredder {
    public static final int cModeSetAtomQFNoMoreNeighbours = 1;
    public static final int cModeExcludeCoreFragments = 64;
    public static final int cModeRetainSubstituentTypes = 2;
    public static final int cModeDiscardSubstitutionInfo = 128;
    public static final int cModeCoreFragmentsOnly = 4;
    public static final int cModeOneSpereAroundCoreOnly = 32;
    public static final int cModeCutTerminalBondsAlso = 8;
    public static final int cModeCutSpacersOffRings = 16;
    public static final int cColorFragmentsInMolecule = 256;
    private final int cMaxCoreFragments = 8;
    private StereoMolecule mMol;
    private boolean[] mIsCuttableBond;
    private boolean[][] mAreNeighbours;
    private int mMode;
    private int mCuttableBonds;
    private int mCoreFragments;
    private int[] mCoreFragmentNo;
    private ArrayList<Long> mFragmentList;

    public MoleculeShredder(StereoMolecule stereoMolecule, int n) {
        this.mMol = stereoMolecule;
        this.mMol.ensureHelperArrays(7);
        this.mMode = n;
        this.locateCuttableBonds();
        this.locateCoreFragments();
        if ((n & 4) == 0) {
            this.createCoreNeighbourMatrix();
        }
        this.createFragmentList();
    }

    public int getFragments() {
        return this.mFragmentList.size();
    }

    public int getCoreFragments() {
        return this.mCoreFragments;
    }

    public StereoMolecule getFragment(StereoMolecule stereoMolecule, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean[] blArray = new boolean[this.mMol.getAtoms()];
        long l = this.mFragmentList.get(n);
        for (n6 = 0; n6 < this.mCoreFragments; ++n6) {
            if ((l & 1L << n6) == 0L) continue;
            for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
                if (this.mCoreFragmentNo[n5] != n6) continue;
                blArray[n5] = true;
            }
        }
        if (stereoMolecule == null) {
            n6 = 0;
            for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
                if (!blArray[n5]) continue;
                ++n6;
            }
            n5 = 0;
            for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
                n3 = this.mMol.getBondAtom(0, n4);
                n2 = this.mMol.getBondAtom(1, n4);
                if (blArray[n3] && blArray[n2]) {
                    ++n5;
                    continue;
                }
                if (!blArray[n3] && !blArray[n2] || (this.mMode & 2) == 0) continue;
                ++n5;
            }
            stereoMolecule = new StereoMolecule(n6, n5);
            stereoMolecule.setFragment(true);
        } else {
            stereoMolecule.deleteMolecule();
            stereoMolecule.setFragment(true);
        }
        int[] nArray = new int[this.mMol.getAtoms()];
        for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
            if (blArray[n5]) {
                nArray[n5] = this.mMol.copyAtom(stereoMolecule, n5, 0, 0);
            }
            if ((this.mMode & 0x100) == 0) continue;
            if (blArray[n5]) {
                this.mMol.setAtomColor(n5, 448);
                continue;
            }
            this.mMol.setAtomColor(n5, 0);
        }
        if ((this.mMode & 1) != 0) {
            for (n5 = 0; n5 < stereoMolecule.getAllAtoms(); ++n5) {
                stereoMolecule.setAtomQueryFeature(n5, 2048L, true);
            }
        }
        for (n5 = 0; n5 < this.mMol.getBonds(); ++n5) {
            int[] nArray2;
            n4 = this.mMol.getBondAtom(0, n5);
            n3 = this.mMol.getBondAtom(1, n5);
            if (blArray[n4] && blArray[n3]) {
                this.mMol.copyBond(stereoMolecule, n5, 0, 0, nArray, false);
                continue;
            }
            if (!this.mIsCuttableBond[n5] || (this.mMode & 0x80) != 0) continue;
            if (blArray[n4]) {
                if ((this.mMode & 2) == 0) {
                    stereoMolecule.setAtomQueryFeature(nArray[n4], 2048L, false);
                    stereoMolecule.setAtomQueryFeature(nArray[n4], 4096L, true);
                } else {
                    n2 = stereoMolecule.addAtom(6);
                    stereoMolecule.addBond(nArray[n4], n2, this.mMol.getBondType(n5));
                    if (this.mMol.getAtomicNo(n3) != 6) {
                        nArray2 = new int[]{6};
                        stereoMolecule.setAtomList(n2, nArray2, true);
                    }
                }
            }
            if (!blArray[n3]) continue;
            if ((this.mMode & 2) == 0) {
                stereoMolecule.setAtomQueryFeature(nArray[n3], 2048L, false);
                stereoMolecule.setAtomQueryFeature(nArray[n3], 4096L, true);
                continue;
            }
            n2 = stereoMolecule.addAtom(6);
            stereoMolecule.addBond(nArray[n3], n2, this.mMol.getBondType(n5));
            if (this.mMol.getAtomicNo(n4) == 6) continue;
            nArray2 = new int[]{6};
            stereoMolecule.setAtomList(n2, nArray2, true);
        }
        return stereoMolecule;
    }

    private void locateCuttableBonds() {
        this.mCuttableBonds = 0;
        this.mIsCuttableBond = new boolean[this.mMol.getBonds()];
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if ((this.mMode & 8) != 0) {
                if (this.mMol.isRingBond(i) || this.mMol.getBondOrder(i) != 1) continue;
                this.mIsCuttableBond[i] = true;
                ++this.mCuttableBonds;
                continue;
            }
            if ((this.mMode & 0x10) != 0) {
                if (this.mMol.isRingBond(i) || !this.mMol.isRingAtom(this.mMol.getBondAtom(0, i)) && !this.mMol.isRingAtom(this.mMol.getBondAtom(1, i))) continue;
                this.mIsCuttableBond[i] = true;
                ++this.mCuttableBonds;
                continue;
            }
            if (this.mMol.isRingBond(i) || this.mMol.getBondOrder(i) != 1 || this.mMol.getConnAtoms(this.mMol.getBondAtom(0, i)) <= 1 || this.mMol.getConnAtoms(this.mMol.getBondAtom(1, i)) <= 1) continue;
            this.mIsCuttableBond[i] = true;
            ++this.mCuttableBonds;
        }
    }

    private void locateCoreFragments() {
        int n;
        this.mCoreFragmentNo = new int[this.mMol.getAtoms()];
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            this.mCoreFragmentNo[n] = -1;
        }
        this.mCoreFragments = 0;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mCoreFragmentNo[n] != -1) continue;
            this.mCoreFragmentNo[n] = this.mCoreFragments;
            int[] nArray = new int[this.mMol.getAtoms()];
            nArray[0] = n;
            int n2 = 0;
            for (int i = 0; i <= n2; ++i) {
                for (int j = 0; j < this.mMol.getConnAtoms(nArray[i]); ++j) {
                    int n3;
                    if (this.mIsCuttableBond[this.mMol.getConnBond(nArray[i], j)] || this.mCoreFragmentNo[n3 = this.mMol.getConnAtom(nArray[i], j)] != -1) continue;
                    nArray[++n2] = n3;
                    this.mCoreFragmentNo[n3] = this.mCoreFragments;
                }
            }
            ++this.mCoreFragments;
        }
    }

    private void createCoreNeighbourMatrix() {
        this.mAreNeighbours = new boolean[this.mCoreFragments][this.mCoreFragments];
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (!this.mIsCuttableBond[i]) continue;
            int n = this.mCoreFragmentNo[this.mMol.getBondAtom(0, i)];
            int n2 = this.mCoreFragmentNo[this.mMol.getBondAtom(1, i)];
            this.mAreNeighbours[n][n2] = true;
            this.mAreNeighbours[n2][n] = true;
        }
    }

    private void createFragmentList() {
        int n;
        this.mFragmentList = new ArrayList();
        if (this.mCoreFragments == 1) {
            return;
        }
        if (this.mCoreFragments > 64) {
            return;
        }
        if ((this.mMode & 4) == 0 && this.mCoreFragments > 8) {
            return;
        }
        for (n = 0; n < this.mCoreFragments; ++n) {
            this.mFragmentList.add(new Long(1L << n));
        }
        if ((this.mMode & 4) != 0) {
            return;
        }
        if ((this.mMode & 0x20) != 0) {
            this.createOneSphereFragmentList();
        } else {
            this.createFullPermutationFragmentList();
        }
        if ((this.mMode & 0x40) != 0) {
            for (n = 0; n < this.mCoreFragments; ++n) {
                this.mFragmentList.remove(0);
            }
        }
    }

    private void createFullPermutationFragmentList() {
        int n = 0;
        for (int i = 2; i < this.mCoreFragments; ++i) {
            int n2 = this.mFragmentList.size();
            while (n < n2) {
                long l = this.mFragmentList.get(n);
                for (int j = 0; j < this.mCoreFragments; ++j) {
                    if ((l & 1L << j) == 0L) continue;
                    for (int k = 0; k < this.mCoreFragments; ++k) {
                        if (!this.mAreNeighbours[j][k] || (l & 1L << k) != 0L) continue;
                        long l2 = l | 1L << k;
                        boolean bl = false;
                        for (int i2 = n2; i2 < this.mFragmentList.size(); ++i2) {
                            if (l2 != this.mFragmentList.get(i2)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        this.mFragmentList.add(new Long(l2));
                    }
                }
                ++n;
            }
        }
    }

    private void createOneSphereFragmentList() {
        int n;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.mCoreFragments; ++n) {
            arrayList.add(new Integer(n));
        }
        for (n = 2; n < this.mCoreFragments; ++n) {
            int n3 = this.mFragmentList.size();
            while (n2 < n3) {
                long l = this.mFragmentList.get(n2);
                int n4 = (Integer)arrayList.get(n2);
                for (int i = 0; i < this.mCoreFragments; ++i) {
                    if (!this.mAreNeighbours[n4][i] || (l & 1L << i) != 0L) continue;
                    long l2 = l | 1L << i;
                    boolean bl = false;
                    for (int j = n3; j < this.mFragmentList.size(); ++j) {
                        if (l2 != this.mFragmentList.get(j)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.mFragmentList.add(new Long(l2));
                    arrayList.add(new Integer((Integer)arrayList.get(n2)));
                }
                ++n2;
            }
        }
    }
}

