/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.shredder;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.TorsionDescriptor;
import com.actelion.research.chem.conf.TorsionDescriptorHelper;
import com.actelion.research.chem.shredder.Fragment3D;
import com.actelion.research.chem.shredder.Fragment3DData;
import com.actelion.research.util.IntArrayComparator;
import java.util.ArrayList;
import java.util.TreeSet;

public class Fragmenter3D {
    private int mMinAtoms;
    private int mMaxAtoms;
    private int mMaxBonds;
    private int mMinExits;
    private int mMaxExits;
    private ArrayList<Fragment3D> mFragmentList;

    public Fragmenter3D(int n, int n2, int n3, int n4, int n5) {
        this.mMinAtoms = n;
        this.mMaxAtoms = n2;
        this.mMaxBonds = n3;
        this.mMinExits = n4;
        this.mMaxExits = n5;
        this.mFragmentList = new ArrayList();
    }

    public ArrayList<Fragment3D> getFragments(StereoMolecule stereoMolecule) {
        this.mFragmentList.clear();
        stereoMolecule.stripSmallFragments();
        stereoMolecule.removeExplicitHydrogens(false, true);
        boolean[] blArray = new boolean[stereoMolecule.getAllBonds()];
        int n = TorsionDB.findRotatableBonds(stereoMolecule, true, blArray);
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        int n2 = stereoMolecule.getFragmentNumbers(nArray, blArray, true);
        int[] nArray2 = new int[n2];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            int n3 = nArray[i];
            nArray2[n3] = nArray2[n3] + 1;
        }
        Fragment3DData[] fragment3DDataArray = new Fragment3DData[n2];
        for (int i = 0; i < n2; ++i) {
            fragment3DDataArray[i] = new Fragment3DData(stereoMolecule, nArray, i, nArray2[i]);
        }
        TreeSet<int[]> treeSet = new TreeSet<int[]>(new IntArrayComparator());
        boolean[] blArray2 = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            blArray2[i] = true;
            this.addNewFragments(stereoMolecule, nArray, blArray2, i, 1, fragment3DDataArray[i].atomCount, treeSet, fragment3DDataArray);
            blArray2[i] = false;
        }
        return this.mFragmentList;
    }

    private void addNewFragments(StereoMolecule stereoMolecule, int[] nArray, boolean[] blArray, int n, int n2, int n3, TreeSet<int[]> treeSet, Fragment3DData[] fragment3DDataArray) {
        if (n2 - this.mMaxBonds > 1 || n3 > this.mMaxAtoms) {
            return;
        }
        int[] nArray2 = new int[n2];
        int n4 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            nArray2[n4++] = i;
        }
        if (treeSet.contains(nArray2)) {
            return;
        }
        treeSet.add(nArray2);
        if (n3 >= this.mMinAtoms) {
            this.addFragment(stereoMolecule, nArray, blArray);
        }
        for (int n5 : fragment3DDataArray[n].neighbourFragment) {
            if (blArray[n5]) continue;
            blArray[n5] = true;
            this.addNewFragments(stereoMolecule, nArray, blArray, n5, n2 + 1, n3 + fragment3DDataArray[n5].atomCount, treeSet, fragment3DDataArray);
            blArray[n5] = false;
        }
    }

    private void addFragment(StereoMolecule stereoMolecule, int[] nArray, boolean[] blArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        boolean[] blArray2 = new boolean[stereoMolecule.getAllAtoms()];
        boolean[] blArray3 = new boolean[stereoMolecule.getAllAtoms()];
        for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
            if (!blArray[nArray[n2]]) continue;
            blArray2[n2] = true;
            ++n3;
            for (n = 0; n < stereoMolecule.getConnAtoms(n2); ++n) {
                int n5 = stereoMolecule.getConnAtom(n2, n);
                if (blArray[nArray[n5]]) continue;
                blArray2[n5] = true;
                blArray3[n5] = true;
                ++n3;
                ++n4;
            }
        }
        if (n4 < this.mMinExits || n4 > this.mMaxExits) {
            return;
        }
        n2 = 0;
        for (n = 0; n < stereoMolecule.getAllBonds(); ++n) {
            if (!blArray2[stereoMolecule.getBondAtom(0, n)] || !blArray2[stereoMolecule.getBondAtom(1, n)]) continue;
            ++n2;
        }
        int[] nArray2 = new int[stereoMolecule.getAllAtoms()];
        StereoMolecule stereoMolecule2 = new StereoMolecule(n3, n2);
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray2, false, nArray2);
        stereoMolecule2.setFragment(false);
        stereoMolecule2.center();
        int[] nArray3 = new int[n4];
        int n6 = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!blArray3[i]) continue;
            stereoMolecule2.setAtomCustomLabel(nArray2[i], "*");
            nArray3[n6++] = nArray2[i];
        }
        Canonizer canonizer = new Canonizer(stereoMolecule2, 8);
        String string = canonizer.getIDCode();
        String string2 = canonizer.getEncodedCoordinates();
        TorsionDescriptor torsionDescriptor = new TorsionDescriptorHelper(canonizer.getCanMolecule()).getTorsionDescriptor();
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = canonizer.getGraphIndexes()[nArray3[i]];
        }
        this.mFragmentList.add(new Fragment3D(string, string2, torsionDescriptor, nArray3));
    }
}

