/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.shredder;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class FragmentGenerator {
    private final int mMinSize;
    private final int mMaxSize;
    private final StereoMolecule mMol;
    private final int mAtomCount;
    private final BitSet[] mForbiddenBits;
    private final BitSet[] mNeighbourBits;
    private final List<BitSet> mFragmentBits = new ArrayList<BitSet>();

    public List<BitSet> getFragments() {
        return this.mFragmentBits;
    }

    public List<int[]> getFragmentsAsIntArrays() {
        ArrayList<int[]> arrayList = new ArrayList<int[]>(this.mFragmentBits.size());
        for (int i = 0; i < this.mFragmentBits.size(); ++i) {
            arrayList.add(this.mFragmentBits.get(i).stream().toArray());
        }
        return arrayList;
    }

    public List<boolean[]> getFragmentsAsBooleanArrays() {
        ArrayList<boolean[]> arrayList = new ArrayList<boolean[]>(this.mFragmentBits.size());
        for (int i = 0; i < this.mFragmentBits.size(); ++i) {
            int[] nArray = this.mFragmentBits.get(i).stream().toArray();
            boolean[] blArray = new boolean[this.mAtomCount];
            for (int j = 0; j < nArray.length; ++j) {
                blArray[nArray[j]] = true;
            }
            arrayList.add(blArray);
        }
        return arrayList;
    }

    public List<StereoMolecule> getFragmentsAsMolecules() {
        List<boolean[]> list = this.getFragmentsAsBooleanArrays();
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>(this.mFragmentBits.size());
        for (int i = 0; i < this.mFragmentBits.size(); ++i) {
            StereoMolecule stereoMolecule = new StereoMolecule();
            this.mMol.copyMoleculeByAtoms(stereoMolecule, list.get(i), true, null);
            stereoMolecule.ensureHelperArrays(31);
            arrayList.add(stereoMolecule);
        }
        return arrayList;
    }

    public FragmentGenerator(StereoMolecule stereoMolecule, int n, int n2) {
        int n3;
        BitSet bitSet;
        int n4;
        this.mMol = stereoMolecule;
        this.mMol.ensureHelperArrays(31);
        this.mAtomCount = this.mMol.getAtoms();
        this.mMinSize = n;
        this.mMaxSize = n2;
        this.mForbiddenBits = new BitSet[this.mAtomCount];
        for (n4 = 0; n4 < this.mAtomCount; ++n4) {
            bitSet = new BitSet(this.mAtomCount);
            for (n3 = 0; n3 < n4; ++n3) {
                bitSet.set(n3, true);
            }
            this.mForbiddenBits[n4] = bitSet;
        }
        this.mNeighbourBits = new BitSet[this.mAtomCount];
        for (n4 = 0; n4 < this.mAtomCount; ++n4) {
            bitSet = new BitSet(this.mAtomCount);
            for (n3 = 0; n3 < this.mMol.getConnAtoms(n4); ++n3) {
                bitSet.set(this.mMol.getConnAtom(n4, n3), true);
            }
            this.mNeighbourBits[n4] = bitSet;
        }
        this.computeFragments();
    }

    public StereoMolecule getCanonizedInputMolecule() {
        return this.mMol;
    }

    public void computeFragments() {
        for (int i = 0; i < this.mAtomCount; ++i) {
            BitSet bitSet = new BitSet();
            bitSet.set(i, true);
            BitSet bitSet2 = (BitSet)this.mNeighbourBits[i].clone();
            bitSet2.andNot(this.mForbiddenBits[i]);
            this.generate_recursive(bitSet, (BitSet)this.mForbiddenBits[i].clone(), bitSet2, 1);
        }
    }

    private void generate_recursive(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, int n) {
        int n2 = n;
        if (n2 >= this.mMaxSize) {
            return;
        }
        for (int i = 0; i < bitSet3.size(); ++i) {
            if (!bitSet3.get(i)) continue;
            BitSet[] bitSetArray = this.add_candidate(bitSet, bitSet2, bitSet3, i);
            if (n2 + 1 >= this.mMinSize && n2 + 1 <= this.mMaxSize) {
                this.mFragmentBits.add(bitSetArray[0]);
            }
            this.generate_recursive(bitSetArray[0], bitSetArray[1], bitSetArray[2], n + 1);
        }
    }

    private BitSet[] add_candidate(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, int n) {
        BitSet bitSet4 = (BitSet)bitSet.clone();
        bitSet4.set(n);
        BitSet bitSet5 = (BitSet)bitSet2.clone();
        BitSet bitSet6 = (BitSet)bitSet3.clone();
        bitSet6.and((BitSet)this.mForbiddenBits[n].clone());
        bitSet5.or(bitSet6);
        BitSet bitSet7 = (BitSet)bitSet3.clone();
        bitSet7.or(this.mNeighbourBits[n]);
        bitSet7.andNot(bitSet5);
        bitSet7.andNot(bitSet4);
        return new BitSet[]{bitSet4, bitSet5, bitSet7};
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = "O1CCCCC1N1CCCCC1";
        String string2 = "O1C=C[C@H]([C@H]1O2)c3c2cc(OC)c4c3OC(=O)C5=C4CCC(=O)5";
        String string3 = "daD@@DjUZxHH@B";
        String string4 = "CCCC(C)N(CCC)CCC";
        SmilesParser smilesParser = new SmilesParser();
        StereoMolecule stereoMolecule = new StereoMolecule();
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        StereoMolecule stereoMolecule3 = new StereoMolecule();
        StereoMolecule stereoMolecule4 = new StereoMolecule();
        try {
            smilesParser.parse(stereoMolecule, string);
            smilesParser.parse(stereoMolecule2, string2);
            smilesParser.parse(stereoMolecule4, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        IDCodeParser iDCodeParser = new IDCodeParser();
        iDCodeParser.parse(stereoMolecule3, string3);
        FragmentGenerator fragmentGenerator = new FragmentGenerator(stereoMolecule2, 10, 10);
        fragmentGenerator.computeFragments();
        List<StereoMolecule> list = fragmentGenerator.getFragmentsAsMolecules();
        System.out.println("Frag[idcode]");
        for (StereoMolecule stereoMolecule5 : list) {
            System.out.println(stereoMolecule5.getIDCode());
        }
        System.out.println("\n\n");
        long l = System.currentTimeMillis();
        FragmentGenerator fragmentGenerator2 = new FragmentGenerator(stereoMolecule2, 10, 10);
        long l2 = System.currentTimeMillis();
        System.out.println("Num Fragments: " + fragmentGenerator2.getFragments().size());
        System.out.println("Time: " + (l2 - l));
        System.out.println("Try enumerate all fragements for C");
        long l3 = System.currentTimeMillis();
        FragmentGenerator fragmentGenerator3 = new FragmentGenerator(stereoMolecule3, 1, 40);
        fragmentGenerator3.computeFragments();
        long l4 = System.currentTimeMillis();
        System.out.println("Frags: " + fragmentGenerator3.getFragments().size() + " Time: " + (l4 - l3));
        System.out.println("Frags[idcode]");
        int n = 0;
        for (BitSet bitSet : fragmentGenerator3.getFragments()) {
            object = new StereoMolecule();
            boolean[] blArray = new boolean[stereoMolecule3.getAtoms()];
            for (int i = 0; i < blArray.length; ++i) {
                if (!bitSet.get(i)) continue;
                blArray[i] = true;
            }
            stereoMolecule3.copyMoleculeByAtoms((ExtendedMolecule)object, blArray, true, null);
            if (n++ >= 500) continue;
            System.out.println(((StereoMolecule)object).getIDCode());
        }
        System.out.println("Try enumerate all fragements for D");
        long l5 = System.currentTimeMillis();
        stereoMolecule4.ensureHelperArrays(31);
        object = new FragmentGenerator(stereoMolecule4, 7, 9);
        ((FragmentGenerator)object).computeFragments();
        long l6 = System.currentTimeMillis();
        System.out.println("Frags: " + ((FragmentGenerator)object).getFragments().size() + " Time: " + (l6 - l5));
        System.out.println("Frags[idcode]");
        n = 0;
        for (BitSet serializable : ((FragmentGenerator)object).getFragments()) {
            StereoMolecule stereoMolecule5 = new StereoMolecule();
            boolean[] blArray = new boolean[stereoMolecule4.getAtoms()];
            for (int i = 0; i < stereoMolecule4.getAtoms(); ++i) {
                if (!serializable.get(i)) continue;
                blArray[i] = true;
            }
            ((FragmentGenerator)object).getCanonizedInputMolecule().copyMoleculeByAtoms(stereoMolecule5, blArray, true, null);
            if (n++ >= 500) continue;
            System.out.println(stereoMolecule5.getIDCode());
        }
        System.out.println("\n\n");
        System.out.println("Frags[idcode]");
        for (StereoMolecule stereoMolecule6 : ((FragmentGenerator)object).getFragmentsAsMolecules()) {
            System.out.println(stereoMolecule6.getIDCode());
        }
        System.out.println();
    }
}

