/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction.mapping;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.mapping.SimilarityGraphBasedReactionMapper;
import java.util.Arrays;

public class MappingScorer {
    private static final boolean SCORE_SIMPLE = false;
    private static final boolean SCORE_HYDROGEN = false;
    private StereoMolecule mReactant;
    private StereoMolecule mProduct;

    public MappingScorer(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this.mReactant = stereoMolecule;
        this.mProduct = stereoMolecule2;
    }

    public int[] createReactantToProductAtomMap(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[this.mReactant.getAtoms() + 1];
        Arrays.fill(nArray3, -1);
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) continue;
            nArray3[nArray2[i]] = i;
        }
        int[] nArray4 = new int[this.mReactant.getAtoms()];
        Arrays.fill(nArray4, -1);
        for (int i = 0; i < nArray.length; ++i) {
            nArray4[i] = nArray3[nArray[i]];
        }
        return nArray4;
    }

    public float scoreMapping(int[] nArray) {
        int n;
        int n2;
        float f = 0.0f;
        Object var3_3 = null;
        boolean[] blArray = new boolean[this.mProduct.getAtoms()];
        int[] objectArray = nArray;
        int n3 = objectArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = objectArray[n2];
            if (n == -1) continue;
            blArray[n] = true;
        }
        boolean[] blArray2 = new boolean[this.mProduct.getBonds()];
        for (n3 = 0; n3 < this.mReactant.getBonds(); ++n3) {
            n2 = this.mReactant.getBondAtom(0, n3);
            n = this.mReactant.getBondAtom(1, n3);
            int n4 = nArray[n2];
            int n5 = nArray[n];
            float f2 = this.getFractionalBondOrder(this.mReactant, n3);
            if (n4 == -1 || n5 == -1) {
                if (n4 == -1 && n5 == -1) continue;
                f += this.getBondCreateOrBreakPenalty(this.mReactant, n3);
                continue;
            }
            int n6 = this.mProduct.getBond(n4, n5);
            if (n6 == -1) {
                f += this.getBondCreateOrBreakPenalty(this.mReactant, n3);
                continue;
            }
            blArray2[n6] = true;
            f += this.getBondChangePenalty(n3, n6);
        }
        for (n3 = 0; n3 < this.mProduct.getBonds(); ++n3) {
            if (blArray2[n3]) continue;
            f += this.getBondCreateOrBreakPenalty(this.mProduct, n3);
        }
        for (n3 = 0; n3 < this.mReactant.getAtoms(); ++n3) {
            if (this.mReactant.getAtomParity(n3) == 0) continue;
            f += this.getParityInversionPenalty(n3, nArray);
        }
        return -f;
    }

    private float getBondCreateOrBreakPenalty(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getBondAtom(0, n);
        int n3 = stereoMolecule.getBondAtom(1, n);
        boolean bl = stereoMolecule.isElectronegative(n2);
        boolean bl2 = stereoMolecule.isElectronegative(n3);
        if (!bl && !bl2) {
            return stereoMolecule.isAromaticBond(n) ? 2.1f : 1.9f + (float)stereoMolecule.getBondOrder(n) / 10.0f;
        }
        if (bl && bl2) {
            return 1.7f;
        }
        if (bl && stereoMolecule.isMetalAtom(n3) || bl2 && stereoMolecule.isMetalAtom(n2)) {
            return 1.7f;
        }
        if (bl && SimilarityGraphBasedReactionMapper.hasOxo(stereoMolecule, n3, n2) || bl2 && SimilarityGraphBasedReactionMapper.hasOxo(stereoMolecule, n2, n3)) {
            return 1.8f;
        }
        if (bl && SimilarityGraphBasedReactionMapper.hasNonCarbonNeighbour(stereoMolecule, n3, n2) || bl2 && SimilarityGraphBasedReactionMapper.hasNonCarbonNeighbour(stereoMolecule, n2, n3)) {
            return 1.85f;
        }
        if (bl && stereoMolecule.isAromaticAtom(n3) || bl2 && stereoMolecule.isAromaticAtom(n2)) {
            return 1.95f;
        }
        return 1.9f;
    }

    private float getFractionalBondOrder(StereoMolecule stereoMolecule, int n) {
        return stereoMolecule.isDelocalizedBond(n) ? 1.5f : (float)stereoMolecule.getBondOrder(n);
    }

    private int getBondType(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.isDelocalizedBond(n)) {
            return 0;
        }
        return stereoMolecule.getBondTypeSimple(n);
    }

    private float getBondChangePenalty(int n, int n2) {
        return this.getBondType(this.mReactant, n) == this.getBondType(this.mProduct, n2) ? 0.0f : 1.0f;
    }

    private float getParityInversionPenalty(int n, int[] nArray) {
        int n2 = nArray[n];
        if (n2 != -1 && this.mProduct.getAtomParity(n2) != 0 && this.hasSameNeighbours(n, n2, nArray)) {
            int n3 = this.mReactant.getAtomParity(n);
            int n4 = this.mProduct.getAtomParity(n2);
            if (n3 == 3 ? n4 == 1 || n4 == 2 : n4 == 3 || this.isTHParityInversion(n, nArray) == (n3 == n4)) {
                return 5.0f;
            }
        }
        return 0.0f;
    }

    private boolean isTHParityInversion(int n, int[] nArray) {
        boolean bl = false;
        if (this.mReactant.getAtomPi(n) == 0) {
            for (int i = 1; i < this.mReactant.getConnAtoms(n); ++i) {
                for (int j = 0; j < i; ++j) {
                    int n2 = this.mReactant.getConnAtom(n, i);
                    int n3 = this.mReactant.getConnAtom(n, j);
                    int n4 = nArray[n2];
                    int n5 = nArray[n3];
                    if (n4 == -1 || n5 == -1 || !(n4 > n5 ^ n2 > n3)) continue;
                    bl = !bl;
                }
            }
        }
        return bl;
    }

    private boolean hasSameNeighbours(int n, int n2, int[] nArray) {
        if (this.mReactant.getConnAtoms(n) != this.mProduct.getConnAtoms(n2)) {
            return false;
        }
        for (int i = 0; i < this.mReactant.getConnAtoms(n); ++i) {
            int n3 = this.mReactant.getConnAtom(n, i);
            boolean bl = false;
            for (int j = 0; j < this.mProduct.getConnAtoms(n2); ++j) {
                if (nArray[n3] != this.mProduct.getConnAtom(n2, j)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

