/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import java.io.Serializable;

public class ReactionSearchSpecification
implements Serializable {
    static final long serialVersionUID = 538970147L;
    private static final int TYPE_MASK = 255;
    public static final int TYPE_NO_REACTION = 0;
    public static final int TYPE_SUBREACTION = 1;
    public static final int TYPE_SIMILARITY = 2;
    public static final int TYPE_RETRON = 3;
    public static final int TYPE_EXACT_STRICT = 4;
    public static final int TYPE_EXACT_NO_STEREO = 5;
    private int mSearchType;
    private String[] mQuery;
    private long[][] mReactionDescriptor;
    private long[][] mReactantDescriptor;
    private long[][] mProductDescriptor;
    private long[][] mRetronDescriptor;
    private float mReactionCenterSimilarity;
    private float mPeripherySimilarity;

    public ReactionSearchSpecification(int n, String[] stringArray, long[][] lArray, long[][] lArray2, long[][] lArray3, float f, float f2) {
        this.mSearchType = n;
        this.mQuery = stringArray;
        this.mReactionDescriptor = lArray;
        this.mReactantDescriptor = lArray2;
        this.mProductDescriptor = lArray3;
        this.mReactionCenterSimilarity = f;
        this.mPeripherySimilarity = f2;
    }

    public ReactionSearchSpecification(int n, String[] stringArray, long[][] lArray, long[][] lArray2, long[][] lArray3) {
        this.mSearchType = n;
        this.mQuery = stringArray;
        this.mReactionDescriptor = lArray;
        this.mReactantDescriptor = lArray2;
        this.mProductDescriptor = lArray3;
    }

    public ReactionSearchSpecification(String[] stringArray, long[][] lArray) {
        this.mSearchType = 3;
        this.mQuery = stringArray;
        this.mRetronDescriptor = lArray;
    }

    public int getReactionCount() {
        return this.mQuery == null ? 0 : this.mQuery.length;
    }

    public String getEncodedQuery(int n) {
        return this.mQuery[n];
    }

    public long[] getReactionDescriptor(int n) {
        return this.mReactionDescriptor == null ? null : this.mReactionDescriptor[n];
    }

    public long[] getReactantDescriptor(int n) {
        return this.mReactantDescriptor == null ? null : this.mReactantDescriptor[n];
    }

    public long[] getProductDescriptor(int n) {
        return this.mProductDescriptor == null ? null : this.mProductDescriptor[n];
    }

    public long[] getRetronDescriptor(int n) {
        return this.mReactionDescriptor == null ? null : this.mReactionDescriptor[n];
    }

    public boolean isSimilaritySearch() {
        return (this.mSearchType & 0xFF) == 2;
    }

    public boolean isNoReactionSearch() {
        return (this.mSearchType & 0xFF) == 0;
    }

    public boolean isSubreactionSearch() {
        return (this.mSearchType & 0xFF) == 1;
    }

    public boolean isRetronSearch() {
        return (this.mSearchType & 0xFF) == 3;
    }

    public boolean isExactSearch() {
        return (this.mSearchType & 0xFF) == 4;
    }

    public boolean isNoStereoSearch() {
        return (this.mSearchType & 0xFF) == 5;
    }

    public void removeDescriptors() {
        this.mReactionDescriptor = null;
        this.mReactantDescriptor = null;
        this.mProductDescriptor = null;
        this.mRetronDescriptor = null;
    }

    public float getReactionCenterSimilarity() {
        return this.mReactionCenterSimilarity;
    }

    public float getPeripherySimilarity() {
        return this.mPeripherySimilarity;
    }

    public String validate() {
        int n = this.getReactionCount();
        if (n == 0) {
            return "No query reactions defined.";
        }
        for (int i = 0; i < n; ++i) {
            if (this.getEncodedQuery(i) != null && this.getEncodedQuery(i).length() != 0) continue;
            return "Empty reaction among query reactions.";
        }
        if (this.isSimilaritySearch()) {
            if ((double)this.getReactionCenterSimilarity() < 0.5 || (double)this.getReactionCenterSimilarity() > 1.0) {
                return "Reaction center similarity threshold out of allowed range.";
            }
            if ((double)this.getPeripherySimilarity() < 0.0 || (double)this.getPeripherySimilarity() > 1.0) {
                return "Periphery similarity threshold out of allowed range.";
            }
        }
        return null;
    }

    public String toString() {
        int n = this.mSearchType & 0xFF;
        String string = n == 1 ? "subreaction" : (n == 2 ? "similarity(" + this.mReactionCenterSimilarity + "/" + this.mPeripherySimilarity + ")" : (n == 3 ? "retron" : (n == 4 ? "exact" : (n == 5 ? "noStereo" : "undefined"))));
        return "type:" + string + (this.mQuery == null ? " reaction:null" : (this.mQuery.length == 1 ? " reaction:" + (this.mQuery[0] == null ? "null" : this.mQuery[0]) : " reactionCount:" + this.mQuery.length)) + (this.mReactionDescriptor == null ? "" : " reactionDescriptorCount:" + this.mReactionDescriptor.length) + (this.mReactantDescriptor == null ? "" : " reactantDescriptorCount:" + this.mReactantDescriptor.length) + (this.mProductDescriptor == null ? "" : " productDescriptorCount:" + this.mProductDescriptor.length) + (this.mRetronDescriptor == null ? "" : " retronDescriptorCount:" + this.mRetronDescriptor.length);
    }
}

