/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.CommonSubGraphHelper;
import com.actelion.research.chem.reaction.IReactionMapper;
import com.actelion.research.chem.reaction.Reaction;
import java.util.ArrayList;
import java.util.Arrays;

public class MCSReactionMapper
implements IReactionMapper {
    private static int[] COLORTABLE = new int[]{0, 64, 128, 192, 256, 320, 384};
    static final int PRODUCTFLAG = 200;
    static final int REACTANTFLAG_ATOMNUMBER = 105;
    static final int PRODUCTFLAG_ATOMNUMBER = 106;
    static final int REACTANTFLAG = 100;
    private int mapIndex = 0;
    private static int colorIndex = 1;

    public static int getNextColor() {
        ++colorIndex;
        if ((colorIndex %= COLORTABLE.length) == 0) {
            ++colorIndex;
        }
        return COLORTABLE[colorIndex];
    }

    public Reaction matchReaction(Reaction reaction) {
        return this.mapReaction(reaction, null);
    }

    @Override
    public Reaction mapReaction(Reaction reaction, SSSearcher sSSearcher) {
        this.mapIndex = 0;
        try {
            StereoMolecule stereoMolecule;
            int n;
            CommonSubGraphHelper.Result result = CommonSubGraphHelper.getMCS(reaction, null, sSSearcher);
            while (result != null) {
                int n2;
                int n3;
                int n4;
                int n5;
                n = MCSReactionMapper.getNextColor();
                stereoMolecule = result.getMolecule();
                stereoMolecule.setFragment(true);
                StereoMolecule stereoMolecule2 = reaction.getReactant(result.getReactant());
                int[] nArray = this.findMatches(stereoMolecule, stereoMolecule2, sSSearcher);
                if (nArray == null || nArray.length <= 0) break;
                this.applyMaps(stereoMolecule, stereoMolecule2, nArray);
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    n4 = nArray[n5];
                    n3 = 100 + stereoMolecule2.getAtomicNo(n4);
                    stereoMolecule2.setAtomList(n4, new int[]{n3});
                    n2 = stereoMolecule2.getAtomMass(n4);
                    stereoMolecule2.setAtomicNo(n4, 105);
                    stereoMolecule2.setAtomMass(n4, n2);
                }
                stereoMolecule2 = reaction.getProduct(result.getProduct());
                stereoMolecule.setFragment(true);
                nArray = this.findMatches(stereoMolecule, stereoMolecule2, sSSearcher);
                this.applySourceMapOnTarget(stereoMolecule, stereoMolecule2, nArray);
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    n4 = nArray[n5];
                    n3 = 200 + stereoMolecule2.getAtomicNo(n4);
                    stereoMolecule2.setAtomList(n4, new int[]{n3});
                    n2 = stereoMolecule2.getAtomMass(n4);
                    stereoMolecule2.setAtomicNo(n4, 106);
                    stereoMolecule2.setAtomMass(n4, n2);
                }
                System.out.println(result);
                result = CommonSubGraphHelper.getMCS(reaction, null, sSSearcher);
            }
            for (n = 0; n < reaction.getMolecules(); ++n) {
                stereoMolecule = reaction.getMolecule(n);
                for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                    if (stereoMolecule.getAtomicNo(i) == 105) {
                        if (stereoMolecule.getAtomList(i) == null) continue;
                        int n6 = stereoMolecule.getAtomMass(i);
                        stereoMolecule.setAtomicNo(i, stereoMolecule.getAtomList(i)[0] - 100);
                        stereoMolecule.setAtomMass(i, n6);
                        stereoMolecule.setAtomList(i, null);
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(i) != 106 || stereoMolecule.getAtomList(i) == null) continue;
                    int n7 = stereoMolecule.getAtomMass(i);
                    stereoMolecule.setAtomicNo(i, stereoMolecule.getAtomList(i)[0] - 200);
                    stereoMolecule.setAtomMass(i, n7);
                    stereoMolecule.setAtomList(i, null);
                }
            }
            reaction.setFragment(false);
            return reaction;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void resetFragments(Reaction reaction) {
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            reaction.getMolecule(i).setFragment(false);
        }
    }

    public void removeMapping(Reaction reaction) {
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            StereoMolecule stereoMolecule = reaction.getMolecule(i);
            for (int j = 0; j < stereoMolecule.getAllAtoms(); ++j) {
                stereoMolecule.setAtomMapNo(j, 0, false);
            }
        }
    }

    private int[] findMatches(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, SSSearcher sSSearcher) {
        sSSearcher.setMol(stereoMolecule, stereoMolecule2);
        int n = sSSearcher.findFragmentInMolecule(4, 8);
        ArrayList<int[]> arrayList = sSSearcher.getMatchList();
        if (arrayList != null && arrayList.size() != 0) {
            return arrayList.get(0);
        }
        return null;
    }

    private int[] highlightQuery(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int n, SSSearcher sSSearcher) {
        sSSearcher.setMol(stereoMolecule, stereoMolecule2);
        int n2 = sSSearcher.findFragmentInMolecule(4, 8);
        ArrayList<int[]> arrayList = sSSearcher.getMatchList();
        if (arrayList != null && arrayList.size() != 0) {
            for (int[] nArray : arrayList) {
                for (int i = 0; i < nArray.length; ++i) {
                    stereoMolecule2.setAtomColor(nArray[i], n);
                }
            }
            return arrayList.get(0);
        }
        return null;
    }

    private void applyMaps(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            stereoMolecule.setAtomMapNo(i, ++this.mapIndex, true);
            stereoMolecule2.setAtomMapNo(nArray[i], this.mapIndex, true);
        }
    }

    private void applySourceMapOnTarget(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = stereoMolecule.getAtomMapNo(i);
            stereoMolecule2.setAtomMapNo(nArray[i], n, true);
        }
    }

    private boolean validateMapping(Reaction reaction) {
        StereoMolecule stereoMolecule;
        int n;
        int n2 = reaction.getReactants();
        int n3 = reaction.getProducts();
        int[][] nArrayArray = new int[n2][];
        int[][] nArrayArray2 = new int[n3][];
        for (n = 0; n < n2; ++n) {
            stereoMolecule = reaction.getReactant(n);
            nArrayArray[n] = this.getMappingNos(stereoMolecule);
        }
        for (n = 0; n < n3; ++n) {
            stereoMolecule = reaction.getProduct(n);
            nArrayArray2[n] = this.getMappingNos(stereoMolecule);
        }
        return this.matchMappings(nArrayArray, nArrayArray2);
    }

    private boolean matchMappings(int[][] nArray, int[][] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int n : nArray[i]) {
                if (n == 0) continue;
                boolean bl = false;
                for (int j = 0; j < nArray2.length; ++j) {
                    for (int n2 : nArray2[j]) {
                        if (n != n2) continue;
                        bl = true;
                    }
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    private int[] getMappingNos(StereoMolecule stereoMolecule) {
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        int n = stereoMolecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            nArray[n] = stereoMolecule.getAtomMapNo(i);
        }
        return nArray;
    }

    private void remove(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, StereoMolecule stereoMolecule3) {
        StereoMolecule[] stereoMoleculeArray;
        SSSearcher sSSearcher = new SSSearcher();
        for (StereoMolecule stereoMolecule4 : stereoMoleculeArray = new StereoMolecule[]{stereoMolecule2, stereoMolecule3}) {
            int n;
            sSSearcher.setMol(stereoMolecule, stereoMolecule4);
            sSSearcher.findFragmentInMolecule(4, 8);
            ArrayList<int[]> arrayList = sSSearcher.getMatchList();
            if (arrayList == null || arrayList.size() == 0) continue;
            int n2 = 0;
            for (int[] nArray : arrayList) {
                for (n = 0; n < nArray.length; ++n) {
                    ++n2;
                }
            }
            Object object = new int[n2];
            int n3 = 0;
            for (int[] nArray : arrayList) {
                for (int i = 0; i < nArray.length; ++i) {
                    object[n3++] = nArray[i];
                }
            }
            Arrays.sort((int[])object);
            for (n = ((Object)object).length - 1; n >= 0; --n) {
                stereoMolecule4.deleteAtom((int)object[n]);
            }
        }
    }
}

