/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Scanner;

public class ClassificationData {
    private static final String CLASSDATA = "53\nRC+2R     XF+2X      C000000    01\nRC+R+re   XF+X+xa    B000000    01\nRC+R+E    XF+X+A     AF00000    01\nRC+E+re   XF+A+xa    9F00000    01\nRC+R      XF+X       8000000    11\nRC+RE     XF+XA      7300000    02\nRC+re     XF+xa      7000000    01\nRC+S'     XF+S'      6FD0000    13\nRC+E      XF+A       6F00000    01\nXAC+2E    REF+2A     6B00000    12\nRAC+R     XEF+X      5100000    01\nRAC+re    XEF+xa     4100000    01\nRC'+re    XF'+xa     4030000    01\nRC        XF         4000000    01\nXAC+re    REF+xa     3D00000    12\nRC+E      XF+A       3300000    01\nXC+re     RF+xa      3000000    01\nXC+S'     RF+S'      2FD0000    01\nXC+E      RF+A       2F00000    01\nRAC+RA*   XEF+XE*    2200000    11\nXAC+A     REF+E      1A00000    12\nRAC+R     XEF+X      1500000    02\nRAC+H'    XEF+H'     1200000    12\nRAC       XEF        1100000    12\nRC'       XF'        1030000    03\nRAC'      XEF'       1001000    14\nRC''      XF''       1000300    05\nRAC''     XEF''      1000010    16\nRC'''     XF'''      1000003    07\nRC        XF         1000000    01\nXC'''     RF'''       FFFFFF    07\nXAC''     REF''       FFFFD0    16\nXC''      RF''        FFFF00    05\nXAC'      REF'        FFD000    14\nXC'       RF'         FF0000    03\nXAC       REF         D00000    12\nXAC+A     REF+E       A10000    12\nXAC+A+xe  REF+E+ra    A00000    12\nXAC+X     REF+R       900000    12\nRAC+xe    XEF+ra      100000    01\nRC'+xe    XF'+ra       30000    03\nXC        RF               0    01\nXAC'+xe   REF'+ra      -3000    14\nXC'+xe    RF'+ra      -10000    03\nXAC+xe    REF+ra     -300000    02\nXA+X+xe   RF+R+ra    -700000    12\nXC+E      RF+A       -D00000    01\nXC+H'     RF+H'      -FF0000    03\nXC+xe     RF+ra     -1000000    01\nXC+XE     RF+RA     -1100000    01\nXC+A      RF+E      -2F00000    11\nXC+X      RF+R      -4000000    11\nXC+2X     RF+2R     -8000000    11\n27\nACC''     EFF''       100001\n2RC+E'    2XF+A'        7003\nACC'+R+xe EFF'+X+ra     5000\nACC'+2E'  EFF'+2A'      3003\nACC'      EFF'          1001\nRC+RC'+re XF+XF'+xa      704\nRC+RC'    XF+XF'         701\nRC+XC+E   XF+RF+A         6F\nACC+R     EFF+X           51\nACC+R+xe  EFF+X+ra        50\nACC+2re   EFF+2xa         44\nACC+re    EFF+xa          41\nACC+re+xe EFF+xa+ra       40\n2XC+E     2RF+A           2F\n2RAC      2XEF            22\nACC       EFF             11\nACC+xe    EFF+ra          10\nXC+XAC    RF+REF           D\n2RC+re    2XF+xa           B\n2RC       2XF              8\n2RC+xe    2XF+ra           7\nRC+XC     XF+RF            4\n2XC+re    2RF+xa           3\nACC''+re  EFF''+xa         1\n2XC*      2RF*             0\n2XC+xe    2RF+ra          -1\n2XC+XE    2RF+RA         -11\n13\nRC+REF     6F00000\nFC+R       4000000\nRC+RF+E    3300000\nFC+re      3000000\nXC+REF     2F00000\nRAC+RF     1100000\nFC''        FFFF00\nFC'         FF0000\nXAC+XF      900000\nFC               0\nFC+xe*    -1000000\nFC+xa     -3000000\nFC+X      -4000000\n14\nXAC+XAC   REF+REF     A10000\nRAC+XAC   XEF+REF     E10000\nXC+XC'    RF+RF'      FF0000\nXAC+XAC'  REF+REF'    FFA100\nRAC+XAC'  XEF+REF'    FFE100\nXC+XC''   RF+RF''     FFFF00\nAC''      EF''       1000010\nAC'       EF'        1001000\nRAC+RAC'  XEF+XEF'   1200100\nRAC+RAC   XEF+XEF    1210000\nRC+XC''   XF+RF''    3000100\nRC+XC'    XF+RF'     3010000\nRC+RC''   XF+XF''    7000100\nRC+RC'    XF+XF'     7010000\n221\nRE''      300003  2  2  1  00000106  00000601\nE''       2FFFFF  1  2  0  00000106\nRA''      100001  2  2  1  00004146  00004641\nA''        FFFFD  1  2  0  00004641\n2R'        30401  1  4  0  01034345\nS'+R'      303FD  1  4  0  01034543\n2R'        30203  4  4  1  01054353  01055343  05014353  05015343\nR'+H'      301FF  2  4  0  01054353  01055343\nR''        30001  1  2  0  00000145\nS''        2FFFD  1  2  0  00000145\nR'+S'      2FE03  4  4  1  01054353  01055343  05014353  05015343\nH'+S'      2FDFF  2  4  0  01435305  01534305\nH'+S'      2FC01  1  4  0  01430345\nS'+X'      2FBFD  1  4  0  01434503\n2S'        2FA03  4  4  1  01054353  01055343  05014353  05015343\nX'+S'      2F9FF  2  4  0  01435305  01534305\n2R'        10601  4  4  1  03134145  13034145  03134541  13034541\nR'+S'      105FD  2  4  0  03134541  13034541\nH'+R'      103FF  1  4  0  03054143\nR'+H'      10201  4  4  1  03134145  13034145  03134541  13034541\nS'+H'      101FD  2  4  0  45031341  45130341\nH''         FFFF  1  2  0  00000541\n2H'         FE01  4  4  1  03134145  13034145  03134541  13034541\nX'+H'       FDFD  2  4  0  45031341  45130341\nH'+X'       FBFF  1  4  0  43030541\nRE'2R       7007  8  4  1  01110414  01111404  11010414  11011404  04140111  04141101  14040111  14041101\nRE'+R       7003  2  4  0  01110441  11010441\nE'+R        6FFF  2  4  0  01110441  11010441\nRA'+R       5001  2  4  0  01415144  01514144\nA'+R        4FFD  2  4  0  01444151  01445141\nR'+RE       3601  2  4  0  01021244  01120244\nS'+RE       35FD  2  4  0  01021244  01120244\nR'+RE       3403  1  4  0  01020442\nH'+RE       33FF  1  4  0  01020442\nH'+RE       3201  2  4  0  01021244  01120244\nS'+E        31FD  2  4  0  01440212  01441202\n2R'         3113  2  4  1  01044243  04014342\nR'+H'       310F  1  4  0  01044243\nR'+S'       30D3  1  4  0  01044342\nS'+H'       30CF  1  4  0  01430442\nR'+E        303F  1  4  0  01030443\nR'+RA       3021  2  4  0  01435344  01534344\nR'+A        301D  2  4  0  01444353  01445343\nRE'         3003  2  2  1  00000104  00000401\nE'          2FFF  1  2  0  00000104\nE'+X        2FFB  2  4  0  01440414  01441404\nS'+RA       2FE1  2  4  0  01435344  01534344\nS'+A        2FDD  2  4  0  01444353  01445343\nS'+E        2FC3  1  4  0  01044303\nS'+XE       2FBF  1  4  0  01430304\nS'+A        2FA1  2  4  0  01435344  01534344\nS'+XA       2F9D  2  4  0  01435344  01534344\nH'+E        2E01  2  4  0  01021244  01120244\nX'+E        2DFD  2  4  0  01440212  01441202\nX'+R'       2D0F  1  4  0  01420443\n2S'         2CD3  2  4  1  01044243  04014342\nX'+S'       2CCF  1  4  0  01424304\nX'+E        2BFF  1  4  0  01420204\nR'+RA       1401  1  4  0  02414244\nS'+RA       13FD  1  4  0  02444142\n2R'         1331  2  4  1  02034144  03024441\nR'+S'       132D  1  4  0  02034441\nR'+H'       12F1  1  4  0  02034144\nH'+S'       12ED  1  4  0  02440341\nH'+RA       11FF  2  4  0  04414252  04415242\nR'+E        105F  2  4  0  03130441  13030441\nR'+A        103D  1  4  0  03444143\nH'+E        101F  2  4  0  03130441  13030441\nRA'         1001  2  2  1  00004144  00004441\nA'           FFD  1  2  0  00004441\nA'+X         FF9  2  4  0  44540441  54440441\nH'+XE        FDF  2  4  0  03130441  13030441\nH'+A         FC1  1  4  0  43034144\nH'+XA        FBD  1  4  0  43440341\nR'+X'        F2D  1  4  0  03440241\n2H'          EF1  2  4  1  02034144  03024441\nX'+H'        EED  1  4  0  44020341\nH'+A         DFF  2  4  0  42520441  52420441\nX'+A         BFD  1  4  0  42440241\nX'+A         9FF  2  4  0  42520441  52420441\nR'+R         701  2  4  0  01114143  11014143\nS'+R         6FD  2  4  0  01114341  11014341\nS'+R+X       6F9  4  4  0  01114353  01115343  11014353  11015343\nR'+RE        631  2  4  0  01110243  11010243\nS'+RE        62D  2  4  0  01110243  11010243\n2R'          602  4  4  0  01114353  01115343  11014353  11015343\nR'+S'        5FE  4  4  0  01114353  01115343  11014353  11015343\n2S'          5FA  4  4  0  01114353  01115343  11014353  11015343\nR'+E         5F1  2  4  0  01110243  11010243\nS'+E         5ED  2  4  0  01114302  11014302\nR'+R         503  2  4  0  01034151  01035141\nH'+R         4FF  2  4  0  01034151  01035141\n2RE          363  4  4  1  01021203  01120203  03021201  03120201\nE+RE         35F  2  4  0  01021203  01120203\nRA+RE        341  1  4  0  01024243\nA+RE         33D  1  4  0  01024342\nE+RE         323  4  4  1  01030212  01031202  03010212  03011202\n2E           31F  2  4  0  01021203  01120203\nR'+RA        312  2  4  0  01424353  01425343\nR'+A         30E  2  4  0  01435342  01534342\nS'+A         30A  2  4  0  01435342  01534342\nR'           301  1  2  0  00000143\nS'           2FD  1  2  0  00000143\nS'+X         2F9  2  4  0  01435303  01534303\n2E           2E3  4  4  1  01030212  01031202  03010212  03011202\nXE+E         2DF  2  4  0  01021203  01120203\nR'+A         2D2  2  4  0  01424353  01425343\nS'+A         2CE  2  4  0  01424353  01425343\nS'+XA        2CA  2  4  0  01424353  01425343\nA+E          2C1  1  4  0  01420243\nXA+E         2BD  1  4  0  01424302\nR'+E         231  2  4  0  02011143  02110143\nS'+E         22D  2  4  0  02430111  02431101\nH'+RA        20F  2  4  0  03415142  03514142\nR'+H'        202  1  0  0  00000000\n2H'          1FE  4  4  0  03134151  03135141  13034151  13035141\nX'+S'        1FA  4  4  0  43530111  43531101  53430111  53431101\nH'+E         1F1  2  4  0  01110243  11010243\nX'+E         1ED  2  4  0  43011102  43110102  \nH'+A         1CF  2  4  0  42034151  42035141\nRA+E         13F  1  4  0  02034142\nH'+E         12E  2  4  0  02031341  02130341\n2RA          121  4  4  1  41425243  41524243  43425241  43524241\nRA+A         11D  2  4  0  43414252  43415242\nH'            FF  1  2  0  00000341\nH'+X          FB  2  4  0  43031341  43130341\nH'+XE         EE  2  4  0  02031341  02130341\nRA+A          E1  4  4  1  42524143  52424143  42524341  52424341\n2A            DD  2  4  0  43425241  43524241\nA+XE          BF  1  4  0  42020341\nRE+2R         B3  6  4  0  01112102  01211102  11012102  11210102  21011102  21110102\nE+2R          AF  6  4  0  01112102  01211102  11012102  11210102  21011102  21110102\n2A            A1  4  4  1  42524143  52424143  42524341  52424341\n2E+R          9E  6  4  0  01112141  01211141  11012141  11210141  21011141  21110141\nA+XA          9D  2  4  0  42524341  52424341\nRE+2R         77  8  4  1  01110212  01111202  11010212  11011202  02120111  02121101  12020111  12021101\nRE+R          73  2  4  0  01110241  11010241\nE+R           6F  2  4  0  01110241  11010241\n2RE           66  8  4  1  01110212  01111202  11010212  11011202  02120111  02121101  12020111  12021101\nRE+E          62  4  4  0  01110212  01111202  11010212  11011202\n2E            5E  4  4  0  01110212  01111202  11010212  11011202\nRA+R          51  2  4  0  01415142  01514142\nA+R           4D  2  4  0  01424151  01425141\nRE            33  2  2  1  00000102  00000201\nE             2F  1  2  0  00000102\nE+X           2B  2  4  0  01420212  01421202\n2RA*          22  1  0  0  00000000\nA+RA*         1E  1  0  0  00000000\n2A            1A  4  4  0  42524151  42525141  52424151  52425141\n2A+X          16  6  4  0  42526202  42625202  52426202  52624202  62425202  62524202\nRA            11  2  2  1  00004142  00004241\nA              D  1  2  0  00004241\n3R             C  6  4  0  01112141  01211141  11012141  11210141  21011141  21110141\nA+X            9  2  4  0  42520241  52420241\n2R             8  4  4  0  01114151  01115141  11014151  11015141\nA+2X           5  6  4  0  42526241  42625241  52426241  52624241  62425241  62524241\nR              4  1  2  0  00000141\nS              0  4  4  0  01114151  01115141  11014151  11015141\nX             -4  1  2  0  00004101\n2X            -8  4  4  0  41510111  41511101  51410111  51411101\n3X            -C  6  4  0  41516101  41615101  51416101  51614101  61415101  61514101\nXE           -11  2  2  1  00000102  00000201\nXE+X         -15  2  4  0  42010212  42011202\n2A*          -22  1  0  0  00000000\nXA+A         -26  4  4  0  42524151  42525141  52424151  52425141\nXA           -33  2  2  1  00004142  00004241\nXA+X         -37  2  4  0  41425202  41524202\nXA+2X        -3B  6  4  0  41425262  41426252  41524262  41526242  41624252  41625242\n2XA          -66  8  4  1  41514252  41515242  51414252  51415242  42524151  42525141  52424151  52425141\nXA+2X        -77  8  4  1  41514252  41515242  51414252  51415242  42524151  42525141  52424151  52425141\n2E           -A1  4  4  1  02120103  12020103  02120301  12020301\nA+E          -C3  1  4  0  02430142\nXE+E         -E1  4  4  1  02120103  12020103  02120301  12020301\nH'+A         -F2  2  4  0  43530142  53430142\nX'+A         -F6  2  4  0  43530142  53430142\nX'          -103  1  2  0  00004301\nX'+X        -107  2  4  0  43530103  53430103\n2XE         -121  4  4  1  01021203  01120203  03021201  03120201\nX'+A        -132  2  4  0  42435301  42534301\nX'+XA       -136  2  4  0  42435301  42534301\nXA+XE       -143  1  4  0  42430102\nX'+E        -1D3  2  4  0  02430111  02431101\nX'+H'       -202  1  0  0  00000000\n2X'         -206  4  4  0  43530111  43531101  53430111  53431101\nX'+XE       -213  2  4  0  43011102  43110102\n2A          -2E3  4  4  1  41434252  41435242  43414252  43415242\nX'+X        -305  2  4  0  41430313  41431303\nA+XA        -323  4  4  1  41434252  41435242  43414252  43415242\n2XA         -363  4  4  1  41425243  41524243  43425241  43524241\nS'+E        -A03  2  4  0  02124401  12024401\nH'+E        -C01  1  4  0  02010442\nS'+XE       -E03  2  4  0  44021201  44120201\n2H'         -EF1  2  4  1  01044243  04014342\nX'+H'       -F31  1  4  0  43010442\nH'+A        -FE3  2  4  0  44014353  44015343\nXE'        -1001  2  2  1  00000104  00000401\nXE'+X      -1005  2  4  0  44010414  44011404\nH'+XA      -1023  2  4  0  44014353  44015343\nX'+XE      -1041  1  4  0  43010304\nX'+XA      -1063  2  4  0  43534401  53434401\nX'+XE      -1203  2  4  0  44010212  44011202\n2X'        -1331  2  4  1  42430104  43420401\nS'+A       -2C03  1  4  0  02414442\n2S'        -2CD3  2  4  1  02034144  03024441\nX'+S'      -2D13  1  4  0  02414403\nXA'        -3003  2  2  1  00004144  00004441\nXA'+X      -3007  2  4  0  41445404  41544404\nX'+XA      -3043  1  4  0  41434403\n2X'        -3113  2  4  1  41440203  44410302\nXA'+2X     -7007  8  4  1  41514454  41515444  51414454  51415444  44544151  44545141  54444151  54445141\nS'+H'      -FC03  1  4  0  03450143\n2H'        -FE01  4  4  1  01054353  01055343  05014353  05015343\nX''       -10003  1  2  0  00004501\nX'+H'     -10201  4  4  1  43530105  53430105  43530501  53430501\n2X'       -10403  1  4  0  43450103\n2X'       -10601  4  4  1  43530105  53430105  43530501  53430501\n2S'       -2FA03  4  4  1  03134145  13034145  03134541  13034541\nX'+S'     -2FE03  4  4  1  41450313  41451303  45410313  45411303\n2X'       -30203  4  4  1  41450313  41451303  45410313  45411303\nXE''     -100000  2  2  1  00000106  00000601\nXA''     -300003  2  2  1  00004146  00004641";
    private String GRPNAMES = "8 02 Hydrogen\n8 04 Deuterium\n8 06 Tritium\n8 24 Sodium\n8 25 Potassium\n8 26 Rubidium\n8 27 Cesium\n8 28 Lithium\n8 2A Magnesium\n8 2C Calcium\n8 2D Strontium\n8 2E Barium\n8 2F Radium\n8 30 Beryllium\n8 32 Aluminium\n8 34 Gallium\n8 36 Indium\n8 37 Thallium\n8 38 Boron\n8 3A Silicon\n8 3B Germanium\n8 3C Tin\n8 3D Lead\n8 3E Antimony\n8 3F Bismuth\n8 40 Scandium\n8 41 Yttrium\n8 42 Lanthanum\n8 43 Actinium\n8 44 Titanium\n8 45 Zirconium/Hafnium\n8 46 Vanadium\n8 47 Niobium/Tantalum\n8 48 Copper\n8 49 Silver\n8 4A Gold\n8 4C Zinc\n8 4D Cadmium\n8 4E Mercury\n8 50 Chromium\n8 52 Molybdenum\n8 53 Tungsten\n8 54 Manganese\n8 55 Iron\n8 56 Cobalt\n8 57 Nickel\n8 59 Ruthenium\n8 5A Rhodium\n8 5B Palladium\n8 5C Rhenium\n8 5D Osmium\n8 5E Iridium\n8 5F Platinum\n8 62 Cerium\n8 63 Praseodymium\n8 64 Neodymium\n8 65 Promethium\n8 66 Samarium\n8 67 Europium\n8 68 Gadolinium\n8 69 Terbium\n8 6A Dysprosium\n8 6B Holmium\n8 6C Erbium\n8 6D Thulium\n8 6E Ytterbium\n8 6F Lutetium\n8 72 Thorium\n8 73 Protactinium\n8 74 Uranium\n8 75 Neptunium\n8 76 Plutonium\n8 77 Americium\n8 78 Curium\n8 79 Berkelium\n8 7A Californium\n8 7B Einsteinium\n8 7C Fermium\n8 7D Mendelevium\n8 7E Nobelium\n8 7F Lawrencium\n8 80 methoxy\n8 81 saturated primary alkoxy (except methoxy)\n8 82 saturated secondary alkoxy\n8 83 saturated tertiary alkoxy\n8 84 allyloxy or benzyloxy\n8 86 phenoxy\n8 87 alkenoxy\n8 88 hetero substituted methoxy\n8 89 primary alpha hetero substituted alkoxy (except methoxy)\n8 8A secondary alpha hetero substituted alkoxy\n8 8C di hetero substituted methoxy\n8 8D di hetero substituted alkoxy (except methoxy)\n8 8E tri hetero substituted methoxy\n8 90 peroxo\n8 91 -O-N group\n8 92 sulfonate, sulfinate, sulfenate, sulfate, sulfite\n8 93 phosphate, phosphite, phosphonate, phosphinate\n8 94 -O-? (except -OH, -O-O, -O-N, -O-S, -O-P, -O-Si, -O-C)\n8 98 hydroxy\n8 9A silyloxy\n8 9C oxo\n8 A0 primary amino\n8 A1 monoalkyl amino\n8 A2 dialkyl amino\n8 A3 imine -N=C\n8 A4 monohetero substituted amino\n8 A6 dihetero substituted amino\n8 A8 ammonium, alkylammonium\n8 AA immonium -N(+)=C\n8 AB isonitril\n8 AC monohetero substituted ammonium\n8 AE nitro, di- or trihetero substituted ammonium\n8 B0 immonium =N(+)R2\n8 B2 mono hetero substituted immonium =N(+)ZR\n8 B3 dihetero substituted immonium =N(+)Z2\n8 B4 imine, alkylimine =NH, =NR\n8 B6 hetero substituted imine =N-Z\n8 B8 nitrile\n8 D0 carbenium\n8 D8 fluoride\n8 DC chloride\n8 DE bromide\n8 DF iodide\n8 E0 phosphide\n8 E2 phosphonium\n8 E4 mono- or dihetero substituted phosphide\n8 E6 tri- or higher hetero substituted phosphide\n8 E8 any arsenium group\n8 F0 sulfonic or sulfinic acid derivative\n8 F1 selenonic or seleninic acid derivative\n8 F2 sulfenic acid derivative\n8 F3 selenenic acid derivative\n8 F4 sulfoxide, dihetero substituted sulfide\n8 F5 selenoxide, dihetero substituted selenide\n8 F6 sulfone, tetrahetero substituted sulfide\n8 F7 selenone, tetrahetero substituted selenide\n8 F8 sulfide\n8 F9 thiocarbonyl\n8 FA selenide\n8 FC telluride\n8 FE hetero subsituted telluride\n7 24 Sodium,Potassium\n7 26 Rubidium,Cesium\n7 2C Calcium,Strontium\n7 2E Barium,Radium\n7 36 Indium,Thallium\n7 3A Silicon,Germanium\n7 3C Tin,Lead\n7 3E Antimony,Bismuth\n7 40 Scandium,Yttrium\n7 42 Lanthanum,Actinium\n7 44 Titanium,Zirconium,Hafnium\n7 46 Vanadium,Niobium,Tantalum\n7 48 Copper,Silver\n7 4C Zinc,Cadmium\n7 52 Molybdenum,Tungsten\n7 54 Manganese,Iron\n7 56 Cobalt,Nickel\n7 5A Rhodium,Palladium\n7 5C Rhenium,Osmium\n7 5E Iridium,Platinum\n7 62 Cerium, Praseodymium\n7 64 Neodymium, Promethium\n7 66 Samarium, Europium\n7 68 Gadolinium, Terbium\n7 6A Dysprosium, Holmium\n7 6C Erbium, Thulium\n7 6E Ytterbium, Lutetium\n7 72 Thorium, Protactinium\n7 74 Uranium, Neptunium\n7 76 Plutonium, Americium\n7 78 Curium, Berkelium\n7 7A Californium, Einsteinium\n7 7C Fermium, Mendelevium\n7 7E Nobelium, Lawrencium\n7 80 saturated primary alkoxy\n7 82 saturated secondary or tertiary alkoxy\n7 86 phenoxy or alkenoxy\n7 88 primary alpha hetero substituted alkoxy\n7 8C di hetero substituted alkoxy\n7 90 -O-O or -O-N group\n7 92 -O-P or -O-S group\n7 A0 -NH2, -NHR\n7 A2 dialkyl amino, -N=C\n7 AA immonium -N(+)=C, isonitril\n7 B2 hetero substituted immonium =N(+)ZR, =N(+)Z2\n7 DE bromide,iodide\n7 F0 sulfonic, sulfinic, selenonic or seleninic acid derivative\n7 F2 sulfenic or selenenic acid derivative\n7 F4 sulfoxide, selenoxide or S/Se group in same oxidation state\n7 F6 sulfone, selenone or S/Se group in same oxidation state\n7 F8 sulfide, thiocarbonyl\n6 04 Deuterium,Tritium\n6 24 Sodium,Potassium,Rubidium,Cesium\n6 28 Lithium,Magnesium\n6 2C Calcium,Strontium,Barium,Radium\n6 30 Beryllium,Aluminium\n6 34 Gallium,Indium,Thallium\n6 38 Boron,Silicon,Germanium\n6 3C Tin,Lead,Antimony,Bismuth\n6 40 Scandium,Yttrium,Lanthanum,Actinium\n6 44 Ti,Zr,Hf,V,Nb,Ta\n6 48 Copper,Silver,Gold\n6 4C Zinc,Cadmium,Mercury\n6 50 Chromium,Molybdenum,Tungsten\n6 54 Manganese,Iron,Cobalt,Nickel\n6 58 Ruthenium,Rhodium,Palladium\n6 5C Rhenium,Osmium,Iridium,Platinum\n6 64 Nd,Pm,Sm,Eu\n6 68 Gd,Tb,Dy,Ho\n6 6C Er,Tm,Yb,Lu\n6 74 U,Np,Pu,Am\n6 78 Cm,Bk,Cf,Es\n6 7C Fm,Md,No,Lr\n6 80 saturated alkoxy\n6 84 allyloxy, benzyloxy, phenoxy or alkenoxy\n6 88 alpha monohetero substituted alkoxy\n6 8C di- or trihetero substituted alkoxy\n6 90 -O-O, -O-N, -O-P or -O-S group\n6 98 hydroxy,silyloxy\n6 A0 -NH2, -NHR, -NR2, -N=C\n6 A4 -NHZ, -NRZ, -NZ2\n6 A8 ammonium, immonium -N(+)=C, isonitril\n6 AC nitro, hetero substituted ammonium\n6 B0 =N(+)R2, =N(+)ZR, =N(+)Z2\n6 B4 =NH, =NR, =NZ\n6 DC chloride,bromide,iodide\n6 E0 phosphide, phosphonium\n6 F0 -SZ, -SZ3, -SZ5, -SeZ, -SeZ3, -SeZ5\n6 F4 -SZ2, -SZ4, -SeZ2, -SeZ4\n6 F8 sulfide, selenide, thiocarbonyl\n6 FC any tellurium group\n5 00 Hydrogen,Deuterium,Tritium\n5 28 Li,Mg,Ca,Sr,Ba,Ra\n5 30 Be,Al,Ga,In,Tl\n5 38 B,Si,Ge,Sn,Pb,Sb,Bi\n5 40 Sc,Y,La,Ac,Ti,Zr,Hf,V,Nb,Ta\n5 48 Cu,Ag,Au,Zn,Cd,Hg\n5 50 Cr,Mo,W,Mn,Fe,Co,Ni\n5 58 Ru,Rh,Pd,Re,Os,Ir,Pt\n5 60 Ce,Pr,Nd,Pm,Sm,Eu\n5 68 Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu\n5 70 Th,Pa,U,Np,Pu,Am\n5 78 Cm,Bk,Cf,Es,Fm,Md,No,Lr\n5 80 alkoxy, alkenoxy, phenoxy\n5 88 alpha hetero substituted alkoxy\n5 90 -O-? (? <> H,Si,C)\n5 98 oxo,hydroxy,silyloxy\n5 A0 -NH2, -NHR, -NR2, -NHZ, -NRZ, -NZ2, -N=C\n5 A8 -N(+), isonitril\n5 B0 =NH, =NR, =NZ, =N(+)R2, =N(+)ZR, =N(+)Z2\n5 D8 halogenide\n5 E0 any phoshorous group\n5 F0 any oxidized sulfur or selenium group\n5 F8 sulfide, selenide, thiocarbonyl or any tellurium group\n4 20 metal of group I A or II A except Be\n4 30 electropositive element of group III A, IV A, V A or Be\n4 40 element of group I B, II B, III B, IV B or V B\n4 50 element of group VI B, VII B or VIII B\n4 60 lanthanide\n4 70 actinide\n4 80 -O-C\n4 90 -O-? (except -O-C), oxo\n4 A0 any single bond nitrogen group\n4 B0 any double bond nitrogen group or nitrile\n4 D0 halogenide or carbenium\n4 E0 any phoshorous or arsenium group\n4 F0 any sulfur, selenium or tellurium group\n3 20 electropositive element of group I-V A except Hydrogen\n3 40 transition element\n3 60 rare earth element\n3 80 any oxygen group\n3 A0 any nitrogen group\n3 E0 any P,As,S,Se or Te group\n2 00 electropositive element of group I-V A\n2 40 transition element, rare earth\n2 80 any oxygen or nitrogen group\n2 C0 any P,As,S,Se,Te,F,Cl,Br or I group\n1 00 any electropositive element\n1 80 any electronegative element\n0 00 anything\n";
    private String EFGNAMES = "8 0000 non allylic R3C-Li\n8 0001 C=C-CR2-Li\n8 0002 non allylic X-C-Li\n8 0003 C=C-C(-X)-Li\n8 0004 non allylic R3C-Na,K,Rb,Cs\n8 0005 C=C-CR2-Na,K,Rb,Cs\n8 0006 non allylic X-C-Na,K,Rb,Cs\n8 0007 C=C-C(-X)-Na,K,Rb,Cs\n8 0008 non allylic R3C-Mg,Be\n8 0009 C=C-CR2-Mg,Be\n8 000A non allylic X-C-Mg,Be\n8 000B C=C-C(-X)-Mg,Be\n8 000C non allylic R3C-Ca,Sr,Ba\n8 000D C=C-CR2-Ca,Sr,Ba\n8 000E non allylic X-C-Ca,Sr,Ba\n8 000F C=C-C(-X)-Ca,Sr,Ba\n8 0010 non allylic R3C-Al\n8 0011 C=C-CR2-Al\n8 0012 non allylic X-C-Al\n8 0013 C=C-C(-X)-Al\n8 0014 non allylic R3C-Ga,In,Tl\n8 0015 C=C-CR2-Ga,In,Tl\n8 0016 non allylic X-C-Ga,In,Tl\n8 0017 C=C-C(-X)-Ga,In,Tl\n8 0018 non allylic R3C-Ge,Sn,Pb\n8 0019 C=C-CR2-Ge,Sn,Pb\n8 001A non allylic X-C-Ge,Sn,Pb\n8 001B C=C-C(-X)-Ge,Sn,Pb\n8 001C non allylic R3C-Sb,Bi\n8 001D C=C-CR2-Sb,Bi\n8 001E non allylic X-C-Sb,Bi\n8 001F C=C-C(-X)-Sb,Bi\n8 0020 non allylic R3C-Cu,Ag,Au\n8 0021 C=C-CR2-Cu,Ag,Au\n8 0022 non allylic X-C-Cu,Ag,Au\n8 0023 C=C-C(-X)-Cu,Ag,Au\n8 0024 non allylic R3C-Zn,Cd,Hg\n8 0025 C=C-CR2-Zn,Cd,Hg\n8 0026 non allylic X-C-Zn,Cd,Hg\n8 0027 C=C-C(-X)-Zn,Cd,Hg\n8 0028 non allylic R3C-Sc,Y,La,Ac\n8 0029 C=C-CR2-Sc,Y,La,Ac\n8 002A non allylic X-C-Sc,Y,La,Ac\n8 002B C=C-C(-X)-Sc,Y,La,Ac\n8 002C non allylic R3C-rare Earth\n8 002D C=C-CR2-rare Earth\n8 002E non allylic X-C-rare Earth\n8 002F C=C-C(-X)-rare Earth\n8 0030 non allylic R3C-Ti,Zr,Hf\n8 0031 C=C-CR2-Ti,Zr,Hf\n8 0032 non allylic X-C-Ti,Zr,Hf\n8 0033 C=C-C(-X)-Ti,Zr,Hf\n8 0034 non allylic R3C-V,Cr type\n8 0035 C=C-CR2-V,Cr type\n8 0036 non allylic X-C-V,Cr type\n8 0037 C=C-C(-X)-V,Cr type\n8 0038 non allylic R3C-Mn,Fe,Co,Ni\n8 0039 C=C-CR2-Mn,Fe,Co,Ni\n8 003A non allylic X-C-Mn,Fe,Co,Ni\n8 003B C=C-C(-X)-Mn,Fe,Co,Ni\n8 003C non allylic R3C-Pd type\n8 003D C=C-CR2-Pd type\n8 003E non allylic X-C-Pd type\n8 003F C=C-C(-X)-Pd type\n8 0040 BH(-)X3,R-BH(-)X2\n8 0041 R2-BH(-)X\n8 0042 R3BH(-)\n8 0043 (C-)4B(-)\n8 0044 (C-)3B(-)X\n8 0045 (C-)2B(-)X2\n8 0046 C-B(-)X3\n8 0047 B(-)X4\n8 0048 (C-)2BH\n8 0049 C-BH2\n8 004A C-BHX\n8 004B BH2X\n8 004C BH(NR2)2\n8 004D BH(OR)2\n8 004E BHX2  X<>N,O\n8 004F Met at B\n8 0050 (C-)2B-N\n8 0051 (C-)2B-O\n8 0052 (C-)2B-S\n8 0053 (C-)2B-X  X<>N,O,S\n8 0054 B(NR2)3\n8 0055 B(OR)3\n8 0056 BX3  X<>N,O\n8 0057 B=X\n8 0058 Ar-B(OR)2\n8 0059 C(pi<>0)-B(OR)2\n8 005A C=C-C-B(OR)2\n8 005B C(aliph)-B(OR)2\n8 005C C-B(NR2)2\n8 005D C-BX2  X<>N,O\n8 005E (C-)3B\n8 0060 R4P(+)\n8 0061 RnP(+)X(4-n)  n<>4\n8 0062 (C-)2PH\n8 0063 C-PH2 type\n8 0064 (C-)3P=C\n8 0065 C-P=C\n8 0066 C=PH\n8 0067 rare P=C\n8 0068 Ar3P\n8 0069 (C-)3P except Ar3P\n8 006A P(-O-?)3\n8 006B PX3 except P(-O-?)3\n8 006C R3P=O type\n8 006D R3P=X  X<>O; RP=X\n8 006E R2PX type\n8 006F R3PX2,RPX2\n8 0070 R2P(=O)-X\n8 0071 R2P(=X)-Y  X<>O\n8 0072 RP(=O)(OR)2\n8 0073 RP(=O)X2  X<>O\n8 0074 RP(=X)Y2  X<>O\n8 0075 X=PY3  X<>O\n8 0076 O=P(OR)3\n8 0077 O=PX3  X<>O\n8 0078 As(z=3)\n8 0079 As(z=5)\n8 007A rare AsXn\n8 007B C-As-C\n8 007C C-AsH2 type\n8 007D C-AsX2\n8 007E C-As(z=4)\n8 007F rare C-AsXn\n8 0080 N-TMS\n8 0081 N-SiEtMe2\n8 0082 N-Si(iPr)Me2\n8 0083 N-Si(tBu)Me2\n8 0084 N-SiMe(iPr)2\n8 0085 N-SiEt(iPr)2\n8 0086 N-SiMe(tBu)2\n8 0087 N-Si(tBu)Ph2\n8 0088 O-TMS\n8 0089 O-SiEtMe2\n8 008A O-Si(iPr)Me2\n8 008B O-Si(tBu)Me2\n8 008C O-SiMe(iPr)2\n8 008D O-SiEt(iPr)2\n8 008E O-SiMe(tBu)2\n8 008F O-Si(tBu)Ph2\n8 0090 (C-)2Si(-O)2\n8 0091 (C-)2Si(-N)2\n8 0092 (C-)2Si(-S)2\n8 0093 (C-)2SiX2  X<>N,O,S\n8 0094 C-Si(-O)3\n8 0095 C-SiX3  X<>O\n8 0096 Si(-O)4\n8 0097 SiX4  X<>O\n8 0098 (C-)3Si-P\n8 0099 (C-)3Si-S\n8 009A (C-)3Si-X  X<>N,O,P,S\n8 009C Si-NH-?=X type\n8 009D Si-N(-C,X)-?=X\n8 009E Si-NH-?  non stabilized N\n8 009F Si-N(-C,X)2  non stabilized N\n8 00A0 (C-)3SiH\n8 00A1 (C-)2SiH2\n8 00A2 C-SiH3\n8 00A4 (C-)2SiH-O\n8 00A5 (C-)2SiH-X  X<>O\n8 00A6 C-SiH2-O\n8 00A7 C-SiH2-X  X<>O\n8 00A8 RSiH(-O)2\n8 00A9 RSiH(-N)2\n8 00AA RSiH(-S)2\n8 00AB RSiHX2  X<>N,O,S\n8 00AC SiH(-O)3\n8 00AD SiHX3  X<>O\n8 00B0 alkinylsilane\n8 00B1 alkenylsilane\n8 00B2 arylsilane\n8 00B3 allylsilane\n8 00B4 acylsilane\n8 00B5 tetraalkylsilane\n8 00B8 aromatic -C=N- or -N=N-\n8 00B9 aromatic -NH-\n8 00BA O(arom)\n8 00BB S(arom)\n8 00BC quinone\n8 00BD dihetero 3-ring\n8 00BE B at N\n8 00BF N-Met  Met<>B,Si\n8 00C0 X=?-C#CH\n8 00C1 C=C-C#CH\n8 00C2 X-C#CH\n8 00C3 C(sat)-C#CH\n8 00C4 X-C#C-X\n8 00C5 C=C-C#C-X\n8 00C6 C(sat)-C#C-X\n8 00C7 C(sat)-C#C-C(sat)\n8 00C8 X=?-C#C-?=X\n8 00C9 C=C-C#C-?=X\n8 00CA X=?-C#C-X\n8 00CB C(sat)-C#C-?=X\n8 00CC C=C-C#C-C=C\n8 00CD C(sat)-C#C-C=C\n8 00CE ?-C#C-B\n8 00CF ?-C#C-Met  Met,?<>B\n8 00D0 C(sat)-CH=CH2\n8 00D1 C=C-CH=CH2\n8 00D2 C(sat)-CH=CH-C(sat) type\n8 00D3 C=C-CH=CH-C type\n8 00D4 C-CH=C(-C)2\n8 00D5 C=C-CH=C(-C)2 type\n8 00D6 (C-)2C=C(-C)2\n8 00D7 C=C-C(-C)=C(-C)2\n8 00D8 (X=?-)2C=C-?=X type\n8 00D9 X=?-RC=CR-?=X type\n8 00DA C-C=C(-C)-?=X type\n8 00DB R-HC=CH-?=X type\n8 00DC X=?-XC=C-?=X type\n8 00DD X=?-C=CX type\n8 00DE X=?-XC=CX-? type\n8 00DF X=?-XC=CX2\n8 00E0 X2C=CX-?\n8 00E1 ?-XC=CX-? type\n8 00E2 R-HC=CH-X type\n8 00E3 C-C=CX-C type\n8 00E4 C3-ring with double bond\n8 00E5 featureless C3-ring\n8 00E6 stabilized C3-ring\n8 00E7 allylic C3-ring\n8 00E8 X-C=C=C-C=X type\n8 00E9 X-C=C=CR2 type\n8 00EA C=C=C-C=X type\n8 00EB dull C=C=C\n8 00EC X=?-Ar\n8 00ED X-Ar\n8 00EE featureless Ar\n8 00F0 XnC*(-C)4-n\n8 00F1 X=?-C*H\n8 00F2 C=C-C*H\n8 00F3 featureless C*H\n8 00F4 C-Te-X\n8 00F5 C-Te(z=3)\n8 00F6 C-Te(z=5)\n8 00F7 rare C-TeXn\n8 00F8 TeX2\n8 00F9 Te(z=4)\n8 00FA Te(z=6)\n8 00FB rare TeXn\n8 00FC C-Te-C\n8 00FD C-Te(z=2)-C\n8 00FE C-Te(z=4)-C\n8 00FF rare C-TeXn-C\n8 0100 Ar-F\n8 0101 C#C-F\n8 0102 C=C(-C)-F\n8 0103 C=CH-F\n8 0104 C=C-CR2-F\n8 0105 non allylic R-CH2-F\n8 0106 non allylic (C-)2CH-F\n8 0107 non allylic (C-)3C-F\n8 0108 C=CX-F\n8 0109 C=C-CX-F\n8 010A non allylic R2CX-F\n8 010C F3C-?=X\n8 010D F3C-R(non stabilized)\n8 010E stabilized F-CX2-R\n8 010F non stabilized F-CX2-R\n8 0110 R-CO-F\n8 0111 R-C(=X)-F  X<>N,O\n8 0112 R-C(=N)-F\n8 0113 F-CN\n8 0114 F-C(=O)-X\n8 0115 F-C(=N)-X\n8 0116 F-C(=X)-Y  X<>N,O\n8 0117 F-CX3\n8 0118 F-O-C\n8 0119 F-O-X\n8 011A F at P\n8 011B F at S\n8 011C F at amide N\n8 011D F at amine N\n8 011E F at B\n8 011F F at Si\n8 0120 Ar-Cl\n8 0121 C#C-Cl\n8 0122 C=C(-C)-Cl\n8 0123 C=CH-Cl\n8 0124 C=C-CR2-Cl\n8 0125 non allylic R-CH2-Cl\n8 0126 non allylic (C-)2CH-Cl\n8 0127 non allylic (C-)3C-Cl\n8 0128 C=CX-Cl\n8 0129 C=C-CX-Cl\n8 012A non allylic R2CX-Cl\n8 012C Cl3C-X=Y\n8 012D Cl3C-R(non stabilized)\n8 012E stabilized Cl-CX2-R\n8 012F non stabilized Cl-CX2-R\n8 0130 R-CO-Cl\n8 0131 R-C(=X)-Cl  X<>N,O\n8 0132 R-C(=N)-Cl\n8 0133 Cl-CN\n8 0134 Cl-C(=O)-X\n8 0135 Cl-C(=N)-X\n8 0136 Cl-C(=X)-Y  X<>N,O\n8 0137 Cl-CX3\n8 0138 Cl-O-C\n8 0139 Cl-O-X\n8 013A Cl at P\n8 013B Cl at S\n8 013C Cl at amide N\n8 013D Cl at amine N\n8 013E Cl at B\n8 013F Cl at Si\n8 0140 Ar-Br\n8 0141 C#C-Br\n8 0142 C=C(-C)-Br\n8 0143 C=CH-Br\n8 0144 C=C-CR2-Br\n8 0145 non allylic R-CH2-Br\n8 0146 non allylic (C-)2CH-Br\n8 0147 non allylic (C-)3C-Br\n8 0148 C=CX-Br\n8 0149 C=C-CX-Br\n8 014A non allylic R2CX-Br\n8 014C Br3C-X=Y\n8 014D Br3C-R(non stabilized)\n8 014E stabilized Br-CX2-R\n8 014F non stabilized Br-CX2-R\n8 0150 R-CO-Br\n8 0151 R-C(=X)-Br  X<>N,O\n8 0152 R-C(=N)-Br\n8 0153 Br-CN\n8 0154 Br-C(=O)-X\n8 0155 Br-C(=N)-X\n8 0156 Br-C(=X)-Y  X<>N,O\n8 0157 Br-CX3\n8 0158 Br-O-C\n8 0159 Br-O-X\n8 015A Br at P\n8 015B Br at S\n8 015C Br at amide N\n8 015D Br at amine N\n8 015E Br at B\n8 015F Br at Si\n8 0160 Ar-I\n8 0161 C#C-I\n8 0162 C=C(-C)-I\n8 0163 C=CH-I\n8 0164 C=C-CR2-I\n8 0165 non allylic R-CH2-I\n8 0166 non allylic (C-)2CH-I\n8 0167 non allylic (C-)3C-I\n8 0168 C=CX-I\n8 0169 C=C-CX-I\n8 016A non allylic R2CX-I\n8 016B R-IX4 type\n8 016C I3C-X=Y\n8 016D I3C-R(non stabilized)\n8 016E stabilized I-CX2-R\n8 016F non stabilized I-CX2-R\n8 0170 R-CO-I\n8 0171 R-C(=X)-I  X<>N,O\n8 0172 R-C(=N)-I\n8 0173 I-CN\n8 0174 I-C(=O)-X\n8 0175 I-C(=N)-X\n8 0176 I-C(=X)-Y  X<>N,O\n8 0177 I-CX3\n8 0178 I-O-C\n8 0179 I-O-X\n8 017A I at P\n8 017B I at S\n8 017C I at amide N\n8 017D I at amine N\n8 017E I at B\n8 017F I at Si\n8 0180 C-SeOH\n8 0181 C-Se-O-?  ?<>H\n8 0182 C-Se-Cl\n8 0183 C-SeX  X<>O,Cl,Se\n8 0184 C-SeSeH\n8 0185 C-SeSe-C\n8 0186 C-SeSe(z>1)\n8 0187 X-SeH\n8 0188 C-Se(=O)-C\n8 0189 rare Se(z=2)\n8 018A O-SeO2-O\n8 018B rare Se(z=6)\n8 018C C-SeO2-C\n8 018D O-Se(=O)-O\n8 018E X-Se(=O)-X  X<>O\n8 018F rare Se(z=4)\n8 0190 C-Se(=O)-OH\n8 0191 C-Se(=O)-O-?  ?<>H\n8 0192 C-Se(=O)-X  X<>O\n8 0193 rare Se(z=3)\n8 0194 C-SeO2-OH\n8 0195 C-SeO2-O-?  ?<>H\n8 0196 C-SeO2-X  X<>O\n8 0197 rare Se(z=5)\n8 0198 C-C(=Se)-C\n8 0199 R-CH(=Se)\n8 019A C-C(=Se)-X\n8 019B HC(=Se)-X\n8 019C X-C(=Se)-X\n8 019E C-Se-C\n8 019F C-SeH\n8 01A0 Ar-Se\n8 01A1 C=C(-X)-Se\n8 01A2 C#C-Se; C=CH-Se\n8 01A3 C=C(-C)-Se\n8 01A4 (C-)3C-Se\n8 01A5 (C-)2CH-Se\n8 01A6 R-CH2-Se\n8 01A7 C=C-CR2-Se\n8 01A8 X=C-Se\n8 01A9 (C-)2C(-X)-Se\n8 01AA C-CH(-X)-Se\n8 01AB X-CH2-Se\n8 01AC C-CX2-Se\n8 01AD H-CX2-Se\n8 01AE CX3-Se\n8 01B0 Ar-CH=O\n8 01B2 C=C-CH=O\n8 01B3 C#C-CH=O\n8 01B4 (C-)3C-CH=O\n8 01B6 (C-)2CH-CH=O\n8 01B7 RCH2-CH=O\n8 01B8 X3C-CH=O\n8 01BA C-CX2-CH=O\n8 01BB X2CH-CH=O\n8 01BC X-CH2-CH=O\n8 01BD XCH(-C)-CH=O\n8 01BE XC(-C)2-CH=O\n8 01C0 Ar-S\n8 01C1 C#C-S\n8 01C2 C=C(-C)-S\n8 01C3 C=CH-S\n8 01C4 R-CH2-S\n8 01C5 (C-)2CH-S\n8 01C6 (C-)3C-S\n8 01C7 C=C-CR2-S\n8 01C8 C=C(S)-S\n8 01C9 C=CX-S  X<>S\n8 01CA S-C(-C)2-S\n8 01CB X-C(-C)2-S  X<>S\n8 01CC S-CH(-C)-S\n8 01CD X-CH(-C)-S  X<>S\n8 01CE S-CH2-S\n8 01CF X-CH2-S  X<>S\n8 01D0 -SCN\n8 01D1 X=C-S\n8 01D2 R-CX2-S\n8 01D3 S-CX3\n8 01D4 H2C=N-?\n8 01D5 H2C=O\n8 01D6 H2C=S\n8 01D8 C=C-CN\n8 01D9 R3C-CN\n8 01DA R2CX-CN\n8 01DB R-CX2-CN; CX3-CN\n8 01DC H-CN\n8 01DD X-CN\n8 01DE B-CN; Si-CN\n8 01DF Met-CN, Met<>B,Si\n8 01E0 (C-)3C-O-CX(-C)2\n8 01E1 (C-)2CH-O-CX(-C)2\n8 01E2 C-CH2-O-CX(-C)2\n8 01E3 CH3-O-CX(-C)2\n8 01E4 Ar-O-CX(-C)2\n8 01E6 Ar-O-CHX-C\n8 01E7 Ar-O-CH2-X\n8 01E8 (C-)3C-O-CHX-C\n8 01E9 (C-)2CH-O-CHX-C\n8 01EA C-CH2-O-CHX-C\n8 01EB CH3-O-CHX-C\n8 01EC (C-)3C-O-CH2-X\n8 01ED (C-)2CH-O-CH2-X\n8 01EE C-CH2-O-CH2-X\n8 01EF CH3-O-CH2-X\n8 01F0 (C-)2CX-O-CX(-C)2\n8 01F2 (C-)2CX-O-CHX-C\n8 01F3 C-CHX-O-CHX-C\n8 01F4 (C-)2CX-O-CH2-X\n8 01F6 C-CHX-O-CH2-X\n8 01F7 X-CH2-O-CH2-X\n8 01F8 (C-)3C-O-CX2-C\n8 01F9 (C-)2CH-O-CX2-C\n8 01FA C-CH2-O-CX2-C\n8 01FB CH3-O-CX2-C\n8 01FC (C-)3C-O-CHX2\n8 01FD (C-)2CH-O-CHX2\n8 01FE C-CH2-O-CHX2\n8 01FF CH3-O-CHX2\n8 0200 X=?-N3 type\n8 0201 X-N3\n8 0202 C=C-N3 type\n8 0203 aliph C-N3 type\n8 0204 C=N(+)=N(-) type\n8 0205 O-NO2\n8 0206 C-N(+)#C type\n8 0207 R-N(+)#N\n8 0209 R-NO2\n8 020A N=NR(+)-O\n8 020B rare X=NR(+)-Y\n8 020C C=N(+)(-C)-O type\n8 020D rare C=N(+)(-R)-X\n8 020E R3N(+)-O\n8 020F -C#N(+)-O\n8 0210 R4N(+) type\n8 0211 R3N(+)-X  X<>O\n8 0212 R2N(+)X2\n8 0213 R-N(+)X3\n8 0214 C=NH2(+)\n8 0215 C=N(+)R-C\n8 0216 C=N(+)(-O)2 type\n8 0217 C=N(+)X2  X<>O\n8 0218 C=C=NR type\n8 0219 C=C=O\n8 021A C=C=S\n8 021B C=C=X  X<>N,O,S\n8 021C -N=C=O type\n8 021D -N=C=S type\n8 021E ?-N=C=N-?\n8 021F ?-N=C=X  X<>N,O,S\n8 0220 C-C(=N-?)-N-?=X\n8 0221 C-C(=N-?)-O-?=X\n8 0222 C-C(=N-?)-S-?=X\n8 0223 C-C(=N-?)-Y-?=X  Y<>N,O,S\n8 0224 C-C(=N-?)-N(without -?=X)\n8 0225 C-C(=N-?)-O(without -?=X)\n8 0226 C-C(=N-?)-S(without -?=X)\n8 0227 C-C(=N-?)-X  X<>N,O,S non AT\n8 0228 ?-N=CH-N-?=X\n8 0229 ?-N=CH-O-?=X\n8 022A ?-N=CH-S-?=X\n8 022B ?-N=CH-X-?=Y  X<>N,O,S\n8 022C ?-N=CH-N(without -?=X)\n8 022D ?-N=CH-O(without -?=X)\n8 022E ?-N=CH-S(without -?=X)\n8 022F ?-N=CH-X(X<>N,O,S)(without -?=X)\n8 0230 N-C(=N-?)-N\n8 0231 N-C(=N-?)-O\n8 0232 N-C(=N-?)-S\n8 0233 N-C(=N-?)-X  X<>N,O,S\n8 0234 O-C(=N-?)-O\n8 0235 O-C(=N-?)-S\n8 0236 O-C(=N-?)-X  X<>N,O,S\n8 0238 S-C(=N-?)-S\n8 0239 S-C(=N-?)-X  X<>N,O,S\n8 023A Y-C(=N-?)-X  X,Y<>N,O,S\n8 023C C=C-C(=N-?)-C\n8 023D C(sat)-C(=N-?)-C(sat)\n8 023E C=C-CH=N-?\n8 023F C(sat)-CH=N-?\n8 0240 Ar-N\n8 0241 C=C(-X)-N\n8 0242 C#C-N; C=CH-N\n8 0243 C=C(-C)-N\n8 0244 (C-)3C-N\n8 0245 (C-)2CH-N\n8 0246 R-CH2-N\n8 0247 C=C-CR2-N\n8 0248 X=C-N\n8 0249 (C-)2C(-X)-N\n8 024A C-CH(-X)-N\n8 024B X-CH2-N\n8 024C C-CX2-N\n8 024D H-CX2-N\n8 024E CX3-N\n8 0250 C=NH\n8 0252 C=N-C(-C)2-R\n8 0253 C=N-CH2-R\n8 0254 C=N-C(-C)=C\n8 0255 C=N-CH=C type\n8 0256 C=N-CXR2 type\n8 0257 C=N-Ar\n8 0258 C=N-C=X\n8 0259 C=N-SO2-? type\n8 025A rare C=N-X\n8 025C C=N-N=C type\n8 025D C=N-NR2 type\n8 025E C=N-OH\n8 025F C=N-O-?  ?<>H\n8 0260 N-N=O\n8 0261 -O-N=O\n8 0262 X-N=O  X<>N,O\n8 0263 Y-N=X  X<>N,O\n8 0264 NX3\n8 0265 X-N=N-  X<>N,O\n8 0266 -O-N=N-\n8 0267 N-N=N-\n8 0268 R-N=N-\n8 0269 R-N=O\n8 026A R-N=X  X<>N,O\n8 026B R-NX2\n8 026C (C-)2N-N\n8 026D (C-)2N-X  X<>N,O\n8 026E (C-)2N-OH\n8 026F (C-)2N-O-?  ?<>H\n8 0270 NH2-N\n8 0271 -O-NH2\n8 0272 NH2-X  X<>N,O\n8 0274 C-NH-N\n8 0275 C-NH-X  X<>N,O\n8 0276 C-NH-OH\n8 0277 C-NH-O-?  ?<>H\n8 0278 amine type (C-)3N\n8 0279 amine type (C-)2NH\n8 027A amine type C-NH2\n8 027B amide type C-NH2\n8 027C amide type (C-)2NH\n8 027D amide type (C-)3N\n8 027E imide type (C-)2NH\n8 027F imide type (C-)3N\n8 0280 N-C(=O)-N\n8 0281 N-C(=O)-O\n8 0282 N-C(=O)-S\n8 0283 N-C(=O)-X  X<>N,O,S\n8 0284 O-C(=O)-O\n8 0285 O-C(=O)-S\n8 0286 O-C(=O)-X  X<>N,O,S\n8 0288 S-C(=O)-S\n8 0289 S-C(=O)-X  X<>N,O,S\n8 028A Y-C(=O)-X  X,Y<>N,O,S\n8 0290 C-C(=O)-N-?=X\n8 0291 C-C(=O)-O-?=X\n8 0292 C-C(=O)-S-?=X\n8 0293 C-C(=O)-Y-?=X  Y<>N,O,S\n8 0294 C-C(=O)-N(without -?=X)\n8 0295 C-C(=O)-O(without -?=X)\n8 0296 C-C(=O)-S(without -?=X)\n8 0297 C-C(=O)-X(X<>N,O,S)(without -?=X)\n8 0298 O=CH-N-?=X\n8 0299 O=CH-O-?=X\n8 029A O=CH-S-?=X\n8 029B O=CH-X-?=Y  X<>N,O,S\n8 029C O=CH-N(without -?=X)\n8 029D O=CH-O(without -?=X)\n8 029E O=CH-S(without -?=X)\n8 029F O=CH-X(X<>N,O,S)(without -?=X)\n8 02A0 Ar-C(=O)-C=C\n8 02A1 C=C-C(=O)-C=C\n8 02A2 (C-)3C-C(=O)-C=C\n8 02A3 R2CH-C(=O)-C=C\n8 02A4 X3C-C(=O)-C=C\n8 02A5 R-CX2-C(=O)-C=C\n8 02A6 (C-)2CX-C(=O)-C=C\n8 02A7 R-CH(-X)-C(=O)-C=C\n8 02A8 ?-CX2-C(=O)-CX3\n8 02A9 R-CX2-C(=O)-CX2-R type\n8 02AA C-CHX-C(=O)-CX(-C)2 type\n8 02AB R-CHX-C(=O)-CH2-R type\n8 02AC X3C-C(=O)-Ar\n8 02AD R-CX2-C(=O)-Ar\n8 02AE (C-)2CX-C(=O)-Ar\n8 02AF R-CH(-X)-C(=O)-Ar\n8 02B0 Ar-C(=O)-Ar\n8 02B2 (C-)3C-C(=O)-Ar\n8 02B3 R2CH-C(=O)-Ar\n8 02B4 (C-)3C-C(=O)-CH(-C)2 type\n8 02B5 R-CH2-C(=O)-CH2-R type\n8 02B8 allene oxide\n8 02B9 alkenyl oxirane\n8 02BA hetero subst. oxirane\n8 02BB alkyl oxirane\n8 02BC alkylidene aziridine\n8 02BD alkenyl aziridine\n8 02BE hetero subst. aziridine\n8 02BF alkyl aziridine\n8 02C0 N-C(=S)-N\n8 02C1 N-C(=S)-O\n8 02C2 N-C(=S)-S\n8 02C3 N-C(=S)-X  X<>N,O,S\n8 02C4 O-C(=S)-O\n8 02C5 O-C(=S)-S\n8 02C6 O-C(=S)-X  X<>N,O,S\n8 02C8 S-C(=S)-S\n8 02C9 S-C(=S)-X  X<>N,O,S\n8 02CA Y-C(=S)-X  X,Y<>N,O,S\n8 02CC C=C-C(=S)-C\n8 02CD C(pi=0)-C(=S)-C(pi=0)\n8 02CE C=C-CH=S\n8 02CF C(pi=0)-CH=S\n8 02D0 C-C(=S)-N\n8 02D1 C-C(=S)-O\n8 02D2 C-C(=S)-S\n8 02D3 C-C(=S)-X  X<>N,O,S\n8 02D4 S=CH-N\n8 02D5 S=CH-O\n8 02D6 S=CH-S\n8 02D7 S=CH-X  X<>N,O,S\n8 02D8 C-S-SH\n8 02D9 C-S-S-C\n8 02DA C-S-S(z>1)\n8 02DB C-S-X  X<>S\n8 02DC C-S-C\n8 02DD C-SH; C-S-Met\n8 02DE X-SH\n8 02DF S(+)\n8 02E0 C-S(=O)-C\n8 02E1 rare S(z=2)\n8 02E2 X-SO2-X\n8 02E3 rare S(z=6)\n8 02E4 C-SO2-C\n8 02E5 O-S(=O)-O\n8 02E6 X-S(=O)-X  X<>O\n8 02E7 rare S(z=4)\n8 02E8 C-S(=O)-O\n8 02E9 C-S(=O)-X  X<>O\n8 02EA rare S(z=3)\n8 02EC C-SO2-O\n8 02ED C-SO2-X  X<>O\n8 02EE rare S(z=5)\n8 02F0 Ar-O-CX2-C\n8 02F1 Ar-O-CHX2\n8 02F4 C-CX2-O-CX2-C\n8 02F6 CHX2-O-CX2-C\n8 02F7 CHX2-O-CHX2\n8 02F8 (C-)2CX-O-CX2-C\n8 02FA C-CHX-O-CX2-C\n8 02FB X-CH2-O-CX2-C\n8 02FC (C-)2CX-O-CHX2\n8 02FE C-CHX-O-CHX2\n8 02FF X-CH2-O-CHX2\n8 0300 Ar-O-C=X\n8 0301 X=C-O-C=X\n8 0304 (C-)3C-O-C=X\n8 0305 (C-)2CH-O-C=X\n8 0306 C-CH2-O-C=X\n8 0307 CH3-O-C=X\n8 0308 (C-)2CX-O-C=X\n8 030A C-CHX-O-C=X\n8 030B X-CH2-O-C=X\n8 030C C-CX2-O-C=X\n8 030D CHX2-O-C=X\n8 0310 C=CX-O-C(-C)3\n8 0311 C=CX-O-CH(-C)2\n8 0312 C=CX-O-CH2-C\n8 0313 C=CX-O-CH3\n8 0314 C=CX-O-Ar\n8 0315 C=CX-O-CX=C\n8 0316 C=CX-O-CH=C\n8 0317 C=CX-O-C(-C)=C\n8 0318 C=CX-O-C=X\n8 031A C=CX-O-CX2-C\n8 031B C=CX-O-CHX2\n8 031C C=CX-O-CH2-X\n8 031D C=CX-O-CHX-C\n8 031E C=CX-O-CX(-C)2\n8 0320 C=C(-C)-O-CX2-C\n8 0321 C=CH-O-CX2-C\n8 0322 C=C(-C)-O-CHX2\n8 0323 C=CH-O-CHX2\n8 0324 C=C(-C)-O-C=X\n8 0325 C=CH-O-C=X\n8 0326 C=C(-C)-O-CX3\n8 0327 C=CH-O-CX3\n8 0328 C=C(-C)-O-CX(-C)2\n8 0329 C=CH-O-CX(-C)2\n8 032C C=C(-C)-O-CHX-C\n8 032D C=CH-O-CHX-C\n8 032E C=C(-C)-O-CH2-X\n8 032F C=CH-O-CH2-X\n8 0330 C=CH-O-CH=C\n8 0331 C=C(-C)-O-CH=C\n8 0332 C=C(-C)-O-C(-C)=C\n8 0334 C=CH-O-Ar\n8 0335 C=C(-C)-O-Ar\n8 0338 C=CH-O-C(-C)3\n8 0339 C=CH-O-CH(-C)2\n8 033A C=CH-O-CH2-C\n8 033B C=CH-O-CH3\n8 033C C=C(-C)-O-C(-C)3\n8 033D C=C(-C)-O-CH(-C)2\n8 033E C=C(-C)-O-CH2-C\n8 033F C=C(-C)-O-CH3\n8 0340 Ar-O-C(-C)3\n8 0341 Ar-O-CH(-C)2\n8 0342 Ar-O-CH2-C\n8 0343 Ar-O-CH3\n8 0344 Ar-O-Ar\n8 0345 (C-)3C-O-C(-C)3\n8 0346 (C-)3C-O-CH(-C)2\n8 0347 (C-)2CH-O-CH(-C)2\n8 0348 (C-)3C-O-CH2-C\n8 0349 (C-)3C-O-CH3\n8 034A (C-)2CH-O-CH2-C\n8 034C (C-)2CH-O-CH3\n8 034D C-CH2-O-CH2-C\n8 034E C-CH2-O-CH3\n8 034F CH3-O-CH3\n8 0350 Ar-OH\n8 0352 C#C-OH; C=CH-OH\n8 0353 C=C(-C)-OH\n8 0354 (C-)3C-OH\n8 0355 (C-)2CH-OH\n8 0356 C-CH2-OH\n8 0357 CH3-OH\n8 0358 C=C(-X)-OH\n8 0359 (C-)2C(-X)-OH\n8 035A C-CH(-X)-OH\n8 035B X-CH2-OH\n8 035C C-CX2-OH\n8 035D H-CX2-OH\n8 035E CX3-OH\n8 035F X=C-OH\n8 0360 P-O-B\n8 0361 P-O-Si\n8 0362 P-O-X  X<>N,O,P,S\n8 0364 P-O-O\n8 0365 P-O-N\n8 0366 P-O-P\n8 0367 P-O-S\n8 0368 S-O-B\n8 0369 S-O-Si\n8 036A B-O-B\n8 036C S-O-O\n8 036D S-O-N\n8 036E S-O-S\n8 036F S-O-X  X<>N,O,P,S\n8 0370 N-O-B\n8 0371 N-O-Si\n8 0372 Si-O-Si\n8 0373 Si-O-B\n8 0374 N-O-O\n8 0375 N-O-N\n8 0376 N-O-X  X<>N,O,P,S\n8 0378 B-O-O\n8 0379 Si-O-O\n8 037A O-O-O\n8 037B X-O-O  X<>N,O,P,S\n8 037C B-O-X  X<>N,O,P,S\n8 037D Si-O-X  X<>N,O,P,S\n8 037E X-O-X  X<>N,O,P,S\n8 0380 B-O-Ar\n8 0381 B-O-C=X\n8 0382 B-O-CH=C\n8 0383 B-O-C(-C)=C\n8 0384 B-O-C(-C)3\n8 0385 B-O-CH(-C)2\n8 0386 B-O-CH2-C\n8 0387 B-O-CH3\n8 0388 B-O-CX=C\n8 0389 B-O-CX(-C)2\n8 038A B-O-CHX-C\n8 038B B-O-CH2-X\n8 038C B-O-CX2-C\n8 038D B-O-CHX2\n8 038E B-O-CX3\n8 038F B-OH\n8 0390 Si-O-Ar\n8 0391 Si-O-C=X\n8 0392 Si-O-CH=C\n8 0393 Si-O-C(-C)=C\n8 0394 Si-O-C(-C)3\n8 0395 Si-O-CH(-C)2\n8 0396 Si-O-CH2-C\n8 0397 Si-O-CH3\n8 0398 Si-O-CX=C\n8 0399 Si-O-CX(-C)2\n8 039A Si-O-CHX-C\n8 039B Si-O-CH2-X\n8 039C Si-O-CX2-C\n8 039D Si-O-CHX2\n8 039E Si-O-CX3\n8 039F Si-OH\n8 03A0 X-O-Ar  X<>N,O,P,S\n8 03A1 X-O-C=Y  X<>N,O,P,S\n8 03A2 X-O-CH=C  X<>N,O,P,S\n8 03A3 X-O-C(-C)=C  X<>N,O,P,S\n8 03A4 X-O-C(-C)3  X<>N,O,P,S\n8 03A5 X-O-CH(-C)2  X<>N,O,P,S\n8 03A6 X-O-CH2-C  X<>N,O,P,S\n8 03A7 X-O-CH3  X<>N,O,P,S\n8 03A8 X-O-CY=C  X<>N,O,P,S\n8 03A9 X-O-CY(-C)2  X<>N,O,P,S\n8 03AA X-O-CHY-C  X<>N,O,P,S\n8 03AB X-O-CH2-Y  X<>N,O,P,S\n8 03AC X-O-CY2-C  X<>N,O,P,S\n8 03AD X-O-CHY2  X<>N,O,P,S\n8 03AE X-O-CY3  X<>N,O,P,S\n8 03AF X-OH  X<>N,O,P,S\n8 03B0 X3C-O-Ar\n8 03B1 X3C-O-C=X\n8 03B4 X3C-O-C(-C)3\n8 03B5 X3C-O-CH(-C)2\n8 03B6 X3C-O-CH2-C\n8 03B7 X3C-O-CH3\n8 03B8 X3C-O-CX=C\n8 03B9 X3C-O-CX(-C)2\n8 03BA X3C-O-CHX-C\n8 03BB X3C-O-CH2-X\n8 03BC X3C-O-CX2-C\n8 03BD X3C-O-CHX2\n8 03BE X3C-O-CX3\n8 03C0 O-O-Ar\n8 03C1 O-O-C=X\n8 03C2 O-O-CH=C\n8 03C3 O-O-C(-C)=C\n8 03C4 O-O-C(-C)3\n8 03C5 O-O-CH(-C)2\n8 03C6 O-O-CH2-C\n8 03C7 O-O-CH3\n8 03C8 O-O-CX=C\n8 03C9 O-O-CX(-C)2\n8 03CA O-O-CHX-C\n8 03CB O-O-CH2-X\n8 03CC O-O-CX2-C\n8 03CD O-O-CHX2\n8 03CE O-O-CX3\n8 03CF O-OH\n8 03D0 N-O-Ar\n8 03D1 N-O-C=X\n8 03D2 N-O-CH=C\n8 03D3 N-O-C(-C)=C\n8 03D4 N-O-C(-C)3\n8 03D5 N-O-CH(-C)2\n8 03D6 N-O-CH2-C\n8 03D7 N-O-CH3\n8 03D8 N-O-CX=C\n8 03D9 N-O-CX(-C)2\n8 03DA N-O-CHX-C\n8 03DB N-O-CH2-X\n8 03DC N-O-CX2-C\n8 03DD N-O-CHX2\n8 03DE N-O-CX3\n8 03DF N-OH\n8 03E0 P-O-Ar\n8 03E1 P-O-C=X\n8 03E2 P-O-CH=C\n8 03E3 P-O-C(-C)=C\n8 03E4 P-O-C(-C)3\n8 03E5 P-O-CH(-C)2\n8 03E6 P-O-CH2-C\n8 03E7 P-O-CH3\n8 03E8 P-O-CX=C\n8 03E9 P-O-CX(-C)2\n8 03EA P-O-CHX-C\n8 03EB P-O-CH2-X\n8 03EC P-O-CX2-C\n8 03ED P-O-CHX2\n8 03EE P-O-CX3\n8 03EF P-OH\n8 03F0 S-O-Ar\n8 03F1 S-O-C=X\n8 03F2 S-O-CH=C\n8 03F3 S-O-C(-C)=C\n8 03F4 S-O-C(-C)3\n8 03F5 S-O-CH(-C)2\n8 03F6 S-O-CH2-C\n8 03F7 S-O-CH3\n8 03F8 S-O-CX=C\n8 03F9 S-O-CX(-C)2\n8 03FA S-O-CHX-C\n8 03FB S-O-CH2-X\n8 03FC S-O-CX2-C\n8 03FD S-O-CHX2\n8 03FE S-O-CX3\n8 03FF S-OH\n7 0000 R3C-Li\n7 0002 X-C-Li\n7 0004 R3C-Na,K,Rb,Cs\n7 0006 X-C-Na,K,Rb,Cs\n7 0008 R3C-Mg,Be\n7 000A X-C-Mg,Be\n7 000C R3C-Ca,Sr,Ba\n7 000E X-C-Ca,Sr,Ba\n7 0010 R3C-Al\n7 0012 X-C-Al\n7 0014 R3C-Ga,In,Tl\n7 0016 X-C-Ga,In,Tl\n7 0018 R3C-Ge,Sn,Pb\n7 001A X-C-Ge,Sn,Pb\n7 001C R3C-Sb,Bi\n7 001E X-C-Sb,Bi\n7 0020 R3C-Cu,Ag,Au\n7 0022 X-C-Cu,Ag,Au\n7 0024 R3C-Zn,Cd,Hg\n7 0026 X-C-Zn,Cd,Hg\n7 0028 R3C-Sc,Y,La,Ac\n7 002A X-C-Sc,Y,La,Ac\n7 002C R3C-rare Earth\n7 002E X-C-rare Earth\n7 0030 R3C-Ti,Zr,Hf\n7 0032 X-C-Ti,Zr,Hf\n7 0034 R3C-V,Cr type\n7 0036 X-C-V,Cr type\n7 0038 R3C-Mn,Fe,Co,Ni\n7 003A X-C-Mn,Fe,Co,Ni\n7 003C R3C-Pd type\n7 003E X-C-Pd type\n7 0040 BH(-)X3; R-BH(-)X2; R2-BH(-)X\n7 0042 R4B(-)\n7 0044 (C-)3B(-)X; (C-)2B(-)X2\n7 0046 C-B(-)X3; B(-)X4\n7 0048 (C-)2BH; C-BH2\n7 004A C-BHX; BH2X\n7 004C BH(NR2)2; BH(OR)2\n7 0050 (C-)2B-N; (C-)2B-O\n7 0052 (C-)2B-X  X<>N,O\n7 0054 B(NR2)3; B(OR)3\n7 0058 C=C-B(OR)2\n7 005A R3C-B(OR)2\n7 005C C-BX2  X<>O\n7 0060 RnP(+)X(4-n)\n7 0062 R2PH\n7 0064 (C-)3P=C; C-P=C\n7 0068 (C-)3P\n7 006A PX3\n7 006C R3P=X; RP=X\n7 006E R2PX type; R3PX2; RPX2\n7 0070 R2P(=X)-Y\n7 0072 RP(=O)X2\n7 0074 RP(=X)Y2  X<>O; X=PY3  X<>O\n7 0076 O=PX3\n7 0078 As(z=3,5)\n7 007C C-AsH2 type; C-AsX2\n7 007E C-AsXn  n<>2\n7 0080 N-TMS; N-SiEtMe2\n7 0082 N-Si(iPr)Me2; N-Si(tBu)Me2\n7 0084 N-SiMe(iPr)2; N-SiEt(iPr)2\n7 0086 N-SiMe(tBu)2; N-Si(tBu)Ph2\n7 0088 O-TMS; O-SiEtMe2\n7 008A O-Si(iPr)Me2; O-Si(tBu)Me2\n7 008C O-SiMe(iPr)2; O-SiEt(iPr)2\n7 008E O-SiMe(tBu)2; O-Si(tBu)Ph2\n7 0090 (C-)2Si(-O)2; (C-)2Si(-N)2\n7 0092 (C-)2SiX2  X<>N,O\n7 0094 C-SiX3\n7 0096 SiX4\n7 0098 (C-)3Si-P; (C-)3Si-S\n7 009C Si-N-?=X\n7 009E Si-N  non stabilized N\n7 00A0 (C-)2SiH-R\n7 00A4 (C-)2SiH-X\n7 00A6 C-SiH2-X\n7 00A8 RSiH(-O)2; RSiH(-N)2\n7 00AA RSiHX2  X<>N,O\n7 00AC SiHX3\n7 00B0 alkinyl-, alkenylsilane\n7 00B8 aromatic ring with N\n7 00BA aromatic ring with O,S\n8 00BE N-Met  Met<>Si\n7 00C0 X=?-C#CH; C=C-C#CH\n7 00C2 X-C#CH; C(sat)-C#CH\n7 00C4 X-C#C-X; C=C-C#C-X\n7 00C6 C(sat)-C#C-X; C(sat)-C#C-C(sat)\n7 00C8 X=?-C#C-?=X; C=C-C#C-?=X\n7 00CA X=?-C#C-X; C(sat)-C#C-?=X\n7 00CC C=C-C#C-C=C; C(sat)-C#C-C=C\n7 00CE ?-C#C-Met\n7 00D0 C-CH=CH2\n7 00D2 C-CH=CH-C\n7 00D4 C-CH=C(-C)2 type\n7 00D6 (C-)2C=C(-C)2 type\n7 00D8 (X=?-)2C=C-?=X type; X=?-RC=CR-?=X type\n7 00DA C-C=C(-C)-?=X type; R-HC=CH-?=X type\n7 00DC X=?-XC=C-?=X type; X=?-C=CX type\n7 00DE X=?-XC=CX-? type; X=?-XC=CX2\n7 00E0 X2C=CX-?; ?-XC=CX-? type\n7 00E2 R-HC=CH-X type; C-C=CX-C type\n7 00E4 saturated or unsaturated cyclopropane\n7 00E6 stabilized or allylic cyclopropane\n7 00E8 donor substituted allene\n7 00EA non donor substituted allene\n7 00EC X=?-Ar; X-Ar\n7 00F0 XnC*(-C)4-n; X=?-C*H\n7 00F2 C=C-C*H; featureless C*H\n7 00F4 C-Te-X; C-Te(z=3)\n7 00F6 C-TeXn  n<>1,3\n7 00F8 Te(z=2,4)\n7 00FA TeXn  n<>2,4\n7 00FC C-Te-C; C-TeX2-C\n7 00FE C-TeXn-C  n<>0,2\n7 0100 Ar-F; C#C-F\n7 0102 C=CR-F\n7 0104 C=C-CR2-F; C(sat)-CH2-F\n7 0106 non allylic (C-)2CR-F\n7 0108 C=CX-F; C=C-CX-F\n7 010C F3C-C\n7 010E F-CX2-R\n7 0110 R-C(=X)-F  X<>N\n7 0112 R-C(=N)-F; F-CN\n7 0114 F-C(=X)-Y  X=N,O\n7 0116 F-C(=X)-Y  X<>N,O; F-CX3\n7 0118 F at O\n7 011A F at P,S\n7 011C F at N\n7 011E F at B,Si\n7 0120 Ar-Cl; C#C-Cl\n7 0122 C=CR-Cl\n7 0124 C=C-CR2-Cl; C(sat)-CH2-Cl\n7 0126 non allylic (C-)2CR-Cl\n7 0128 C=CX-Cl; C=C-CX-Cl\n7 012C Cl3C-C\n7 012E Cl-CX2-R\n7 0130 R-C(=X)-Cl  X<>N\n7 0132 R-C(=N)-Cl; Cl-CN\n7 0134 Cl-C(=X)-Y  X=N,O\n7 0136 Cl-C(=X)-Y  X<>N,O; Cl-CX3\n7 0138 Cl at O\n7 013A Cl at P,S\n7 013C Cl at N\n7 013E Cl at B,Si\n7 0140 Ar-Br; C#C-Br\n7 0142 C=CR-Br\n7 0144 C=C-CR2-Br; C(sat)-CH2-Br\n7 0146 non allylic (C-)2CR-Br\n7 0148 C=CX-Br; C=C-CX-Br\n7 014C Br3C-C\n7 014E Br-CX2-R\n7 0150 R-C(=X)-Br  X<>N\n7 0152 R-C(=N)-Br; Br-CN\n7 0154 Br-C(=X)-Y  X=N,O\n7 0156 Br-C(=X)-Y  X<>N,O; Br-CX3\n7 0158 Br at O\n7 015A Br at P,S\n7 015C Br at N\n7 015E Br at B,Si\n7 0160 Ar-I; C#C-I\n7 0162 C=CR-I\n7 0164 C=C-CR2-I; C(sat)-CH2-I\n7 0166 non allylic (C-)2CR-I\n7 0168 C=CX-I; C=C-CX-I\n7 016A non allylic R2CX-I\n7 016C I3C-C\n7 016E I-CX2-R\n7 0170 R-C(=X)-I  X<>N\n7 0172 R-C(=N)-I; I-CN\n7 0174 I-C(=X)-Y  X=N,O\n7 0176 I-C(=X)-Y  X<>N,O; I-CX3\n7 0178 I at O\n7 017A I at P,S\n7 017C I at N\n7 017E I at B,Si\n7 0180 C-Se-O-?\n7 0182 C-SeX  X<>O,Se\n7 0184 C-SeSe-R\n7 0188 Se(z=2)\n7 018A Se(z=6)\n7 018C C-SeO2-C; O-Se(=O)-O\n7 018E X-Se(=O)-X  X<>O; rare Se(z=4)\n7 0190 C-Se(=O)-O-?\n7 0192 C-Se(=O)-X  X<>O; rare Se(z=3)\n7 0194 C-SeO2-O-?\n7 0196 C-SeO2-X  X<>O; rare Se(z=5)\n7 0198 R-C(=Se)-R\n7 019A R-C(=Se)-X\n7 019E C-Se-R\n7 01A0 Ar-Se; C=C(-X)-Se\n7 01A2 C#C-Se; C=CR-Se\n7 01A4 (C-)2CR-Se\n7 01AA X-CHR-Se\n7 01AC R-CX2-Se\n7 01B2 C=C-CH=O; C#C-CH=O\n7 01B6 R2CH-CH=O\n7 01BA R-CX2-CH=O\n7 01BC X-CHR-CH=O\n7 01C0 Ar-S; C#C-S\n7 01C2 C=CR-S\n7 01C4 R2CH-S\n7 01C8 C=CX-S\n7 01CA X-C(-C)2-S\n7 01CC X-CH(-C)-S\n7 01CE X-CH2-S\n7 01D0 -SCN; X=C-S\n7 01D2 R-CX2-S; S-CX3\n7 01D4 H2C=X  X=N,O\n7 01D8 C=C-CN; R3C-CN\n7 01DA R2CX-CN; R-CX2-CN; CX3-CN; \n7 01DC H-CN; X-CN\n7 01DE Met-CN\n7 01E0 (C-)2CR-O-CX(-C)2\n7 01E2 R-CH2-O-CX(-C)2\n7 01E6 Ar-O-CHR-X\n7 01E8 (C-)2CR-O-CHX-C\n7 01EA R-CH2-O-CHX-C\n7 01EC (C-)2CR-O-CH2-X\n7 01EE R-CH2-O-CH2-X\n7 01F2 C-CRX-O-CHX-C\n7 01F6 R-CHX-O-CH2-X\n7 01F8 (C-)2CR-O-CX2-C\n7 01FA R-CH2-O-CX2-C\n7 01FC (C-)2CR-O-CHX2\n7 01FE R-CH2-O-CHX2\n7 0200 X=?-N3 type; X-N3\n7 0202 C=C-N3 type; aliph C-N3 type\n7 0206 C-N(+)#C type; R-N(+)#N\n7 020A X=NR(+)-Y\n7 020C C=N(+)(-R)-X\n7 020E R3N(+)-O; -C#N(+)-O\n7 0210 R4N(+) type; R3N(+)-X  X<>O\n7 0212 R2N(+)X2; R-N(+)X3\n7 0214 C=NR2(+)\n7 0216 C=N(+)X2\n7 0218 C=C=NR type; C=C=O\n7 021A C=C=X  X<>N,O\n7 021C -N=C=O type; -N=C=S type\n7 021E -N=C=X  X<>O,S\n7 0220 C-C(=N-?)-Y-?=X  Y=N,O\n7 0222 C-C(=N-?)-Y-?=X  Y<>N,O\n7 0224 C-C(=N-?)-X  X=N,O non AT\n7 0226 C-C(=N-?)-X  X<>N,O non AT\n7 0228 ?-N=CH-X-?=Y  X=N,O\n7 022A ?-N=CH-X-?=Y  X<>N,O\n7 022C ?-N=CH-X  X=N,O non AT\n7 022E ?-N=CH-X  X<>N,O non AT\n7 0230 N-C(=N-?)-X  X=N,O\n7 0232 N-C(=N-?)-X  X<>N,O\n7 0234 O-C(=N-?)-X  X=O,S\n7 0238 S-C(=N-?)-X  X<>N,O\n7 023C C-C(=N-?)-C\n7 023E C-CH=N-?\n7 0240 Ar-N; C=C(-X)-N\n7 0242 C#C-N; C=CR-N\n7 0244 (C-)2CR-N\n7 0248 X=C-N; (C-)2C(-X)-N\n7 024A X-CHR-N\n7 024C R-CX2-N\n7 0252 C=N-CR3\n7 0254 C=N-CR=C type\n7 0258 C=N-?=X\n7 025C C=N-N=C; C=N-NR2 type\n7 025E C=N-O-?\n7 0260 X-N=O  X=N,O\n7 0262 X-N=O  X<>N,O; Y-N=X  X<>N,O\n7 0266 X-N=N-  X=N,O\n7 0268 R-N=X  X=N,O\n7 026C (C-)2N-X  X<>O\n7 026E (C-)2N-O-?\n7 0270 X-NH2  X=N,O\n7 0274 C-NH-X  X<>O\n7 0276 C-NH-O-?\n7 0278 amine type (C-)2NR\n7 027A C-NH2\n7 027C amide type (C-)2NR\n7 027E imide type (C-)2NR\n7 0280 N-C(=O)-X  X=N,O\n7 0282 N-C(=O)-X  X<>N,O\n7 0284 O-C(=O)-X  X=O,S\n7 0288 S-C(=O)-X  X<>N,O\n7 0290 C-C(=O)-X-?=Y  X=N,O\n7 0293 C-C(=O)-X-?=Y  X<>N,O\n7 0294 C-C(=O)-X  X=N,O non AT\n7 0296 C-C(=O)-X  X<>N,O non AT\n7 0298 O=CH-X-?=Y  X=N,O\n7 029A O=CH-X-?=Y  X<>N,O\n7 029C O=CH-X  X=N,O non AT\n7 029E O=CH-X  X<>N,O non AT\n7 02A0 Ar-C(=O)-C=C; C=C-C(=O)-C=C\n7 02A2 R3C-C(=O)-C=C\n7 02A4 X3C-C(=O)-C=C; R-CX2-C(=O)-C=C\n7 02A6 R2C(-X)-C(=O)-C=C\n7 02A8 CX2-C(=O)-CX2 type\n7 02AA R-CHX-C(=O)-CXR2 type\n7 02AC ?-CX2-C(=O)-Ar\n7 02AE R2C(-X)-C(=O)-Ar\n7 02B2 R3C-C(=O)-Ar\n7 02B4 R3C-C(=O)-CR3\n7 02C0 N-C(=S)-X  X=N,O\n7 02C2 N-C(=S)-X  X<>N,O\n7 02C4 O-C(=S)-X  X=O,S\n7 02C8 S-C(=S)-X  X<>N,O\n7 02CC C-C(=S)-C\n7 02CE C-CH=S\n7 02D0 C-C(=S)-X  X=N,O\n7 02D2 C-C(=S)-X  X<>N,O\n7 02D4 S=CH-X  X=N,O\n7 02D6 S=CH-X  X<>N,O\n7 02D8 C-S-S-R\n7 02DA C-S-S(z>1); C-S-X  X<>S\n7 02DC C-S-R; C-S-Met\n7 02E0 S(z=2)\n7 02E2 S(z=6)\n7 02E4 C-SO2-C; O-S(=O)-O\n7 02E6 X-S(=O)-X  X<>O; rare S(z=4)\n7 02E8 C-S(=O)-X\n7 02EC C-SO2-X\n7 02F0 Ar-O-CX2-R\n7 02F6 CHX2-O-CX2-R\n7 02FA R-CHX-O-CX2-C\n7 02FE R-CHX-O-CHX2\n7 0300 Ar-O-C=X; X=C-O-C=X\n7 0304 (C-)2CR-O-C=X\n7 0306 R-CH2-O-C=X\n7 030A R-CHX-O-C=X\n7 030C R-CX2-O-C=X\n7 0310 C=CX-O-CR(-C)2\n7 0312 C=CX-O-CH2-R\n7 0314 C=CX-O-Ar; C=CX-O-CX=C\n7 0316 C=CX-O-CR=C\n7 031A C=CX-O-CX2-R\n7 031C C=CX-O-CHX-R\n7 0320 C=CR-O-CX2-C\n7 0322 C=CR-O-CHX2\n7 0324 C=CR-O-C=X\n7 0326 C=CR-O-CX3\n7 0328 C=CR-O-CX(-C)2\n7 032C C=CR-O-CHX-C\n7 032E C=CR-O-CH2-X\n7 0330 C=CR-O-CH=C\n7 0334 C=CR-O-Ar\n7 0338 C=CH-O-CR(-C)2\n7 033A C=CH-O-CH2-R\n7 033C C=C(-C)-O-CR(-C)2\n7 033E C=C(-C)-O-CH3\n7 0340 Ar-O-CR(-C)2\n7 0342 Ar-O-CH2-R\n7 0344 Ar-O-Ar; (C-)3C-O-C(-C)3\n7 0346 (C-)2CR-O-CH(-C)2\n7 0348 (C-)3C-O-CH2-R\n7 034C (C-)2CH-O-CH3; C-CH2-O-CH2-C\n7 034E R-CH2-O-CH3\n7 0352 C#C-OH; C=CR-OH\n7 0354 (C-)2CR-OH\n7 0356 R-CH2-OH\n7 0358 C=C(-X)-OH; (C-)2C(-X)-OH\n7 035A R-CH(-X)-OH\n7 035C R-CX2-OH\n7 035E CX3-OH; X=C-OH\n7 0360 P-O-B; P-O-Si\n7 0364 P-O-O; P-O-N\n7 0366 P-O-P; P-O-S\n7 0368 S-O-B; S-O-Si\n7 036C S-O-O; S-O-N\n7 036E S-O-X  X<>N,O,P\n7 0370 N-O-B; N-O-Si\n7 0372 Si-O-Si; Si-O-B\n7 0374 N-O-O; N-O-N\n7 0378 B-O-O; Si-O-O\n7 037A X-O-O  X<>N,P,S\n7 037C B-O-X, Si-O-X  X<>N,O,P,S\n7 0380 B-O-Ar; B-O-C=X\n7 0382 B-O-CR=C\n7 0384 B-O-CR(-C)2\n7 0386 B-O-CH2-R\n7 0388 B-O-CX=C; B-O-CX(-C)2\n7 038A B-O-CHX-R\n7 038C B-O-CX2-R\n7 0390 Si-O-Ar; Si-O-C=X\n7 0392 Si-O-CR=C\n7 0394 Si-O-CR(-C)2\n7 0396 Si-O-CH2-R\n7 0398 Si-O-CX=C; Si-O-CX(-C)2\n7 039A Si-O-CHX-R\n7 039C Si-O-CX2-R\n7 03A0 X-O-Ar, X-O-C=Y  X<>N,O,P,S\n7 03A2 X-O-CR=C  X<>N,O,P,S\n7 03A4 X-O-CR(-C)2  X<>N,O,P,S\n7 03A6 X-O-CH2-R  X<>N,O,P,S\n7 03A8 X-O-CY=C, X-O-CY(-C)2  X<>N,O,P,S\n7 03AA X-O-CHY-R  X<>N,O,P,S\n7 03AC X-O-CY2-R  X<>N,O,P,S\n7 03B0 X3C-O-Ar; X3C-O-C=X\n7 03B4 X3C-O-CR(-C)2\n7 03B6 X3C-O-CH2-R\n7 03B8 X3C-O-CX=C; X3C-O-CX(-C)2\n7 03BA X3C-O-CHX-R\n7 03BC X3C-O-CX2-R\n7 03C0 O-O-Ar; O-O-C=X\n7 03C2 O-O-CR=C\n7 03C4 O-O-CR(-C)2\n7 03C6 O-O-CH2-R\n7 03C8 O-O-CX=C; O-O-CX(-C)2\n7 03CA O-O-CHX-R\n7 03CC O-O-CX2-R\n7 03D0 N-O-Ar; N-O-C=X\n7 03D2 N-O-CR=C\n7 03D4 N-O-CR(-C)2\n7 03D6 N-O-CH2-R\n7 03D8 N-O-CX=C; N-O-CX(-C)2\n7 03DA N-O-CHX-R\n7 03DC N-O-CX2-R\n7 03E0 P-O-Ar; P-O-C=X\n7 03E2 P-O-CR=C\n7 03E4 P-O-CR(-C)2\n7 03E6 P-O-CH2-R\n7 03E8 P-O-CX=C; P-O-CX(-C)2\n7 03EA P-O-CHX-R\n7 03EC P-O-CX2-R\n7 03F0 S-O-Ar; S-O-C=X\n7 03F2 S-O-CR=C\n7 03F4 S-O-CR(-C)2\n7 03F6 S-O-CH2-R\n7 03F8 S-O-CX=C; S-O-CX(-C)2\n7 03FA S-O-CHX-R\n7 03FC S-O-CX2-R\n6 0000 C-Li\n6 0004 C-Na,K,Rb,Cs\n6 0008 C-Mg,Be\n6 000C C-Ca,Sr,Ba\n6 0010 C-Al\n6 0014 C-Ga,In,Tl\n6 0018 C-Ge,Sn,Pb\n6 001C C-Sb,Bi\n6 0020 C-Cu,Ag,Au\n6 0024 C-Zn,Cd,Hg\n6 0028 C-Sc,Y,La,Ac\n6 002C C-rare Earth\n6 0030 C-Ti,Zr,Hf\n6 0034 C-V,Nb,Ta,Cr,Mo,W\n6 0038 C-Mn,Fe,Co,Ni\n6 003C C-Pd type\n6 0040 RnBH(-)X(3-n); (C-)4B(-)\n6 0044 (C-)nB(-)X(4-n)  n<>4\n6 0048 R-BH-C; R-BH-X\n6 004C BHX2; Met at B\n6 0050 (C-)2B-X\n6 0054 BX3; B=X\n6 0058 C-B(OR)2\n6 005C C-BX2  X<>O; (C-)3B\n6 0060 (?-)4P(+); C-PH-R\n6 0064 P=C\n6 0068 (C-)3P; PX3\n6 006C R3P=X; R3PX2; RPX2; R2PX\n6 0080 little bulky N-Si(-C)3\n6 0084 bulky N-Si(-C)3\n6 0088 little bulky O-Si(-C)3\n6 008C bulky O-Si(-C)3\n6 0090 (C-)2SiX2\n6 0094 C-SiX3; SiX4\n6 0098 (C-)3Si-X  X<>N,O\n6 009C Si-N\n6 00A0 C-SiHR2\n6 00A4 C-SiHR-X\n6 00A8 RSiHX2\n6 00B0 (C-)3Si-C(pi>0); allylsilane\n6 00B8 aromatic N,O or S\n6 00C0 ?-C#CH\n6 00C8 (X,C)-C#C-?=X\n6 00D0 C-CH=CH-R; (C-)2-C=CH2\n6 00D4 C-CR=C(-C)2\n6 00D8 activated R2C=CR2\n6 00DC activated C=C-X\n6 00E0 not activated C=C-X\n6 00E4 C3-ring\n6 00E8 C=C=C\n6 00EC aromatic ring\n6 00F0 assymetric carbon\n6 00F4 C-TeXn\n6 00F8 TeXn\n6 00FC C-TeXn-C\n6 0100 C(z=1,pi>0)-F\n6 0104 R3C-F\n6 0108 C=CX-F; R2CX-F\n6 010C R-CX2-F\n6 0110 R-C(=X)-F; F-CN\n6 0114 F-C(=X)-Y; F-CX3\n6 0120 C(z=1,pi>0)-Cl\n6 0124 R3C-Cl\n6 0128 C=CX-Cl; R2CX-Cl\n6 012C R-CX2-Cl\n6 0130 R-C(=X)-Cl; Cl-CN\n6 0134 Cl-C(=X)-Y; Cl-CX3\n6 0140 C(z=1,pi>0)-Br\n6 0144 R3C-Br\n6 0148 C=CX-Br; R2CX-Br\n6 014C R-CX2-Br\n6 0150 R-C(=X)-Br; Br-CN\n6 0154 Br-C(=X)-Y; Br-CX3\n6 0160 C(z=1,pi>0)-I\n6 0164 R3C-I\n6 0168 C=CX-I; R2CX-I; R-IX4 type\n6 016C R-CX2-I\n6 0170 R-C(=X)-I; I-CN\n6 0174 I-C(=X)-Y; I-CX3\n6 0180 C-SeX  X<>Se\n6 0184 C-Se-Se; X-SeH\n6 0188 Se(z=2,6)\n6 018C Se(z=4)\n6 0190 Se(z=3)\n6 0194 Se(z=5)\n6 0198 R-C(=Se)-?\n6 01A0 C(pi>0)-Se\n6 01A4 R3C-Se\n6 01A8 X=C-Se; R2C(-X)-Se\n6 01AC ?-CX2-Se\n6 01B0 C(pi>0)-CH=O\n6 01B4 R3C-CH=O\n6 01B8 ?-CX2-CH=O\n6 01BC X-CR2-CH=O\n6 01C0 C(z=1,pi>0)-S\n6 01C4 R3C-S\n6 01C8 C=CX-S; X-C(-C)2-S\n6 01CC X-CHR-S\n6 01D4 H2C=X  X=N,O,S\n6 01D8 C-CN\n6 01DC ?-CN  ?<>C\n6 01E0 R3C-O-CX(-C)2\n6 01E4 Ar-O-CXR2\n6 01E8 R3C-O-CHX-C\n6 01EC R3C-O-CH2-X\n6 01F0 C-CR(-X)-O-CR(-X)-C\n6 01F4 R2CX-O-CH2-X\n6 01F8 R3C-O-CX2-C\n6 01FC R3C-O-CHX2\n6 0200 azide\n6 0208 X=NR(+)-Y\n6 0210 RnN(+)X(4-n) except R3N(+)-O\n6 0214 C=N(+)\n6 0218 C=C=X\n6 021C ?-N=C=X\n6 0220 C-C(=N-?)-Y-?=X\n6 0224 C-C(=N-?)-X(without -?=X)\n6 0228 ?-N=CH-X-?=Y\n6 022C ?-N=CH-X(without -?=X)\n6 0230 N-C(=N-?)-X\n6 0234 O-C(=N-?)-X  X<>N\n6 0238 Y-C(=N-?)-X  X,Y<>N,O\n6 023C C-C(=N-?)-R\n6 0240 C(pi>0)-N\n6 0244 R3C-N\n6 0248 X=C-N; R2C(-X)-N\n6 024C (R,X)-CX2-N\n6 0250 C=NH; C=N-CR3\n6 0254 C=N-C(pi>0); C=N-CXR2 type\n6 0258 C=N-?=X; C=N-X  X<>N,O\n6 025C C=N-X  X=N,O\n6 0260 Y-N=X  X<>N\n6 0264 NX3; X-N=N-\n6 0268 R-N=X; R-NX2\n6 026C (C-)2N-X\n6 0270 NH2-X\n6 0274 C-NH-X\n6 0278 amine type R3N; amide type C-NH2\n6 027C amide or imide type (C-)2NR\n6 0280 N-C(=O)-X\n6 0284 O-C(=O)-X  X<>N\n6 0288 Y-C(=O)-X  X,Y<>N,O\n6 0290 C-C(=O)-Y-?=X\n6 0294 C-C(=O)-X(without -?=X)\n6 0298 O=CH-X-?=Y\n6 029C O=CH-X(without -?=X)\n6 02A0 C(pi>0)-C(=O)-C=C; R3C-C(=O)-C=C\n6 02A4 X-C(pi=0,z>0)-C(=O)-C=C\n6 02A8 X-C(pi=0)-C(=O)-C(pi=0)\n6 02AC X-C-C(=O)-Ar\n6 02B0 Ar-C(=O)-Ar; R3C-C(=O)-Ar\n6 02B4 R3C-C(=O)-CR3\n6 02B8 oxirane\n6 02BC aziridine\n6 02C0 N-C(=S)-X\n6 02C4 O-C(=S)-X  X<>N\n6 02C8 Y-C(=S)-X  X,Y<>N,O\n6 02CC C-C(=S)-R\n6 02D0 C-C(=S)-X\n6 02D4 S=CH-X\n6 02D8 C-S-X\n6 02E0 S(z=2,6)\n6 02E4 S(z=4)\n6 02E8 S(z=3)\n6 02EC S(z=5)\n6 02F4 R-CX2-O-CX2-R\n6 02F8 R2CX-O-CX2-C\n6 02FC R2CX-O-CHX2\n6 0304 R3C-O-C=X\n6 0308 R2CX-O-C=X\n6 0310 C=CX-O-CR3\n6 0314 C=CX-O-C(pi>0)\n6 0318 C=CX-O-C=X; C=CX-O-CX2-R\n6 031C C=CX-O-CR2-X\n6 0320 C=CR-O-CX2-R\n6 0324 C=CR-O-C=X; C=CR-O-CX3\n6 032C C=CR-O-CHX-R\n6 0330 C=CR-O-CR=C\n6 0338 C=CH-O-CR3\n6 033C C=C(-C)-O-CR3\n6 0340 Ar-O-CR3\n6 0344 Ar-O-Ar; (C-)2CR-O-CR(-C)2\n6 0348 (C-)3C-O-CH2-R; (C-)2CH-O-CH2-C\n6 034C (C-)2CH-O-CH3; R-CH2-O-CH2-R\n6 0350 C(z=1,pi>0)-OH\n6 0354 R3C-OH\n6 0358 C=C(-X)-OH; X-CR2-OH\n6 035C R-CX2-OH; CX3-OH; X=C-OH\n6 0360 P-O-B,Si,X  X<>N,O,P,S\n6 0364 P-O-X  X=N,O,P,S\n6 0368 S-O-B; S-O-Si; B-O-B\n6 036C S-O-X  X<>P\n6 0370 N-O-B; N-O-Si; Si-O-Si; Si-O-B\n6 0374 N-O-X  X<>P,S\n6 0378 B-O-O; Si-O-O; X-O-O  X<>N,P,S\n6 037C B-O-X, Si-O-X, X-O-X  X<>N,O,P,S\n6 0380 B-O-C=X; B-O-C(pi>0,z=1)\n6 0384 B-O-CR3\n6 0388 B-O-CX=C; B-O-CR2-X\n6 038C B-O-CX2-?; B-OH\n6 0390 Si-O-C=X; Si-O-C(pi>0,z=1)\n6 0394 Si-O-CR3\n6 0398 Si-O-CX=C; Si-O-CR2-X\n6 039C Si-O-CX2-?; Si-OH\n6 03A0 X-O-C=Y, X-O-C(pi>0,z=1)  X<>N,O,P,S\n6 03A4 X-O-CR3  X<>N,O,P,S\n6 03A8 X-O-CY=C, X-O-CR2-Y  X<>N,O,P,S\n6 03AC X-O-CY2-?, X-OH  X<>N,O,P,S\n6 03B0 X3C-O-C=X, X3C-O-C(pi>0,z=1)\n6 03B4 X3C-O-CR3\n6 03B8 X3C-O-CX=C; X3C-O-CR2-X\n6 03BC X3C-O-CX2-?\n6 03C0 O-O-C=X; O-O-C(pi>0,z=1)\n6 03C4 O-O-CR3\n6 03C8 O-O-CX=C; O-O-CR2-X\n6 03CC O-O-CX2-?; O-OH\n6 03D0 N-O-C=X; N-O-C(pi>0,z=1)\n6 03D4 N-O-CR3\n6 03D8 N-O-CX=C; N-O-CR2-X\n6 03DC N-O-CX2-?; N-OH\n6 03E0 P-O-C=X; P-O-C(pi>0,z=1)\n6 03E4 P-O-CR3\n6 03E8 P-O-CX=C; P-O-CR2-X\n6 03EC P-O-CX2-?; P-OH\n6 03F0 S-O-C=X; S-O-C(pi>0,z=1)\n6 03F4 S-O-CR3\n6 03F8 S-O-CX=C; S-O-CR2-X\n6 03FC S-O-CX2-?; S-OH\n5 0000 C-Li,Na,K,Rb,Cs\n5 0008 C-Mg,Be,Ca,Sr,Ba\n5 0010 C-Al,Ga,In,Tl\n5 0018 C-Ge,Sn,Pb,Sb,Bi\n5 0020 C-Cu,Ag,Au,Zn,Cd,Hg\n5 0028 C-Sc,Y,La,Ac,rare Earth\n5 0030 C-Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W\n5 0038 C-Mn,Fe,Co,Ni; C-Pd type\n5 0040 (?-)4B(-)\n5 0048 ?-BH-?; Met at B\n5 0058 C-BX2; (C-)3B\n5 0070 P(=X)-Y; RP(=X)Y2; X=PY3\n5 0078 any As\n5 0080 N-Si(-C)3\n5 0088 O-Si(-C)3\n5 0090 (C-)2SiX2; C-SiX3; SiX4\n5 00A0 C-SiHR-?\n5 00A8 ?-SiHX2\n5 00B0 (C-)4Si\n5 00D0 non activated R2C=CR2\n5 00D8 activated C=C\n5 00F8 TeXn; C-TeXn-C\n5 0100 C(z=1)-F\n5 0108 C=CX-F; R2CX-F; R-CX2-F\n5 0110 ?-C(=X)-F; F-CN; F-CX3\n5 0120 C(z=1)-Cl\n5 0128 C=CX-Cl; R2CX-Cl; R-CX2-Cl\n5 0130 ?-C(=X)-Cl; Cl-CN; Cl-CX3\n5 0140 C(z=1)-Br\n5 0148 C=CX-Br; R2CX-Br; R-CX2-Br\n5 0150 ?-C(=X)-Br; Br-CN; Br-CX3\n5 0160 C(z=1)-I\n5 0168 C=CX-I; R2CX-I; R-CX2-I\n5 0170 ?-C(=X)-I; I-CN; I-CX3\n5 0180 C-SeX; X-SeH\n5 0188 Se(z=2,4,6)\n5 0190 Se(z=3,5)\n5 0198 C=Se; C-Se-C; C-SeH\n5 01A0 C(z=1)-Se\n5 01A8 C(z>1)-Se\n5 01B0 C(pi>0)-CH=O; R3C-CH=O\n5 01B8 C(pi=0,z>0)-CH=O\n5 01C0 C(z=1)-S\n5 01C8 C=CX-S; X-CR2-S\n5 01D8 ?-CN\n5 01E8 R3C-O-CHX-R\n5 01F0 X-CR2-O-CR2-X\n5 01F8 R3C-O-CX2-R\n5 0220 C-C(=N-?)-X\n5 0228 ?-N=CH-X\n5 0230 X-C(=N-?)-Y  X=N,O\n5 0258 C=N-?=X; C=N-X\n5 0260 Y-N=X; NX3\n5 0270 R-NH-X\n5 0278 R3N\n5 0280 X-C(=O)-Y  X=N,O\n5 0290 C-C(=O)-X\n5 0298 O=CH-X\n5 02A0 C-C(=O)-C=C\n5 02A8 X-C(pi=0)-C(=O)-C(pi=0); X-C-C(=O)-Ar\n5 02B0 Ar-C(=O)-Ar; R3C-C(=O)-Ar; R3C-C(=O)-CR3\n5 02B8 oxirane; aziridine\n5 02C0 X-C(=S)-Y  X=N,O\n5 02D0 R-C(=S)-X\n5 02D8 C-S-?; X-SH; S(+)\n5 02E0 S(z=2,4,6)\n5 02E8 S(z=3,5)\n5 02F8 R2CX-O-CX2-R\n5 0308 R2CX-O-C=X; R-CX2-O-C=X\n5 0310 C=CX-O-CR3; C=CX-O-C(pi>0)\n5 0318 C=CX-O-C=X; C=CX-O-CX2-R; C=CX-O-CR2-X\n5 0320 C=CR-O-C=X; C=CR-O-CX2-R; C=CR-O-CX3\n5 0328 C=CR-O-CR2-X\n5 0330 C=CR-O-C(pi>0,z=1)\n5 0338 C=CR-O-CR3\n5 0340 Ar-O-CR3; Ar-O-Ar; (C-)2CR-O-CR(-C)2\n5 0348 R-CH2-O-CR3\n5 0350 C(z=1)-OH\n5 0358 C(z>1)-OH\n5 0360 P-O-B,Si,X\n5 0380 B-O-C=X; B-O-C(z=1)\n5 0388 B-O-C(z>1); B-OH\n5 0390 Si-O-C=X; Si-O-C(z=1)\n5 0398 Si-O-C(z>1); Si-OH\n5 03A0 X-O-C=Y, X-O-C(z=1)  X<>N,O,P,S\n5 03A8 X-O-C(z>1), X-OH  X<>N,O,P,S\n5 03B0 X3C-O-C=X, X3C-O-C(z=1)\n5 03B8 X3C-O-C(z>1)\n5 03C0 O-O-C=X; O-O-C(z=1)\n5 03C8 O-O-C(z>1); O-OH\n5 03D0 N-O-C=X; N-O-C(z=1)\n5 03D8 N-O-C(z>1); N-OH\n5 03E0 P-O-C=X; P-O-C(z=1)\n5 03E8 P-O-C(z>1); P-OH\n5 03F0 S-O-C=X; S-O-C(z=1)\n5 03F8 S-O-C(z>1); S-OH\n4 0000 C-Met (group I A,II A)\n4 0010 C-Met (group III A,IV A, V A except B,Si)\n4 0020 C-Met (group I B,II B, III B, rare earth)\n4 0030 C-Met (group IV B,V B, VI B, VII B, VIII B)\n4 0080 X-Si(-C)3  X=N,O\n4 00C0 C#C\n4 00D0 non activated R2C=CR2; activated C=C\n4 0180 Se(z=1,2,4,6)\n4 0190 Se(z=0,3,5)\n4 01A0 C-Se\n4 01B0 C-CH=O\n4 01C0 C(z=1,2)-S\n4 01F0 X-CR2-O-CR2-X; R3C-O-CX2-R\n4 0220 R-C(=N-?)-X\n4 0230 X-C(=N-?)-Y; C-C(=N-?)-R\n4 0240 C-N\n4 0250 C=N\n4 0260 ?-N=X; NX3; R-NX2; (C-)2N-X\n4 0270 R-NH-X; R3N\n4 0280 X-C(=O)-Y\n4 0290 R-C(=O)-X\n4 02A0 C-C(=O)-C=C; X-C-C(=O)-C\n4 02C0 X-C(=S)-Y; C-C(=S)-R\n4 02E0 S(z=2,3,4,5,6)\n4 02F0 Ar-O-CX2-R; R-CX2-O-CX2-R; R2CX-O-CX2-R\n4 0300 Ar-O-C=X; R3C(pi=0,z<>4)-O-C=X\n4 0310 C=CX-O-C(z<>4)\n4 0320 C=CR-O-C(pi=0)-X\n4 0330 C=CR-O-C(z=1)\n4 0340 Ar-O-Ar; Ar-O-CR3; R3C-O-CR3\n4 0350 C-OH\n4 0380 B-O-R\n4 0390 Si-O-R\n4 03A0 X-O-R  X<>N,O,P,S\n4 03B0 X3C-O-C\n4 03C0 O-O-R\n4 03D0 N-O-R\n4 03E0 P-O-R\n4 03F0 S-O-R\n3 0000 C-Met (group I to V A except B,Si)\n3 0020 C-Met (group I to VIII B, rare earth)\n3 0040 any B\n3 0060 any P or As\n3 0080 (C-)nSiX(4-n)  n<>4; Si-N\n3 0100 any F\n3 0120 any Cl\n3 0140 any Br\n3 0160 any I\n3 0180 any Se\n3 01C0 C-S; H2C=X  X=N,O,S; ?-CN\n3 01E0 R3C-O-CR2-X; Ar-O-CR2-X; X-CR2-O-CR2-X; R3C-O-CX2-R\n3 0200 any N(+); C=C=X; ?-N=C=X\n3 0220 ?-C(=N-?)-?  except H2C=N-?\n3 0240 C-N; C=N\n3 0260 ?-N=X; RnNX(3-n)\n3 0280 ?-C(=O)-X\n3 02A0 any ketone; oxirane; aziridine\n3 02C0 any C=S; C-S-?; X-SH; S(+)\n3 0320 C=CR-O-C(pi=0); C=CR-O-C(z=1)\n3 0380 B-O-R; Si-O-R\n3 03C0 O-O-R; N-O-R\n3 03E0 P-O-R; S-O-R\n2 0000 C-Met  Met<>B,Si\n2 00C0 any unsaturated C, C3-ring or assymetric carbon; any Te\n2 0100 any F or Cl\n2 0140 any Br or I\n2 0280 any C=O; oxirane; aziridine\n2 03C0 X-O-R  X=N,O,P,S\n1 0100 any halogene\n1 0200 any N; C=C=X\n0 0000 anything";
    private static final int[] GRP_OFFSET = new int[]{511, 510, 508, 504, 496, 480, 448, 384, 256, 0};
    private static final int[] EFG_OFFSET = new int[]{2044, 2040, 2032, 2016, 1984, 1920, 1792, 1536, 1024, 0};
    private static ClassificationData sInstance;
    private int mHEntries;
    private int mDEntries;
    private int mEEntries;
    private int mCEntries;
    private int mREntries;
    private String[] mHRxnTb1;
    private String[] mHRxnTb2;
    private String[] mDRxnTb1;
    private String[] mDRxnTb2;
    private String[] mERxnTb;
    private String[] mCRxnTb1;
    private String[] mCRxnTb2;
    private String[] mRRxnTb;
    private String[] mGRPName;
    private String[] mEFGName;
    private int[] mHRxnDe;
    private int[] mHRxnDefs;
    private int[] mDRxnDe;
    private int[] mERxnDe;
    private int[] mCRxnDe;
    private int[] mRRxnDe;
    private int[] mRRxn_fGrpNo;
    private boolean[] mRRxn_Sym;
    private int[][] mRRxnDefs;

    private ClassificationData() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassificationData getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<ClassificationData> clazz = ClassificationData.class;
        synchronized (ClassificationData.class) {
            if (sInstance == null) {
                ClassificationData classificationData = new ClassificationData();
                classificationData.initialize();
                sInstance = classificationData;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void initialize() {
        int n;
        String string;
        int n2;
        int n3;
        BufferedReader bufferedReader;
        int n4;
        Scanner scanner = new Scanner(CLASSDATA);
        this.mHEntries = scanner.nextInt();
        this.mHRxnTb1 = new String[this.mHEntries];
        this.mHRxnTb2 = new String[this.mHEntries];
        this.mHRxnDe = new int[this.mHEntries];
        this.mHRxnDefs = new int[this.mHEntries];
        for (n4 = 0; n4 < this.mHEntries; ++n4) {
            this.mHRxnTb1[n4] = scanner.next();
            this.mHRxnTb2[n4] = scanner.next();
            String string2 = scanner.next();
            this.mHRxnDe[n4] = Integer.parseInt(string2, 16);
            this.mHRxnDefs[n4] = Integer.parseInt(scanner.next(), 16);
        }
        this.mDEntries = scanner.nextInt();
        this.mDRxnTb1 = new String[this.mDEntries];
        this.mDRxnTb2 = new String[this.mDEntries];
        this.mDRxnDe = new int[this.mDEntries];
        for (n4 = 0; n4 < this.mDEntries; ++n4) {
            this.mDRxnTb1[n4] = scanner.next();
            this.mDRxnTb2[n4] = scanner.next();
            this.mDRxnDe[n4] = Integer.parseInt(scanner.next(), 16);
        }
        this.mEEntries = scanner.nextInt();
        this.mERxnTb = new String[this.mEEntries];
        this.mERxnDe = new int[this.mEEntries];
        for (n4 = 0; n4 < this.mEEntries; ++n4) {
            this.mERxnTb[n4] = scanner.next();
            this.mERxnDe[n4] = Integer.parseInt(scanner.next(), 16);
        }
        this.mCEntries = scanner.nextInt();
        this.mCRxnTb1 = new String[this.mCEntries];
        this.mCRxnTb2 = new String[this.mCEntries];
        this.mCRxnDe = new int[this.mCEntries];
        for (n4 = 0; n4 < this.mCEntries; ++n4) {
            this.mCRxnTb1[n4] = scanner.next();
            this.mCRxnTb2[n4] = scanner.next();
            this.mCRxnDe[n4] = Integer.parseInt(scanner.next(), 16);
        }
        this.mREntries = scanner.nextInt();
        this.mRRxnTb = new String[this.mREntries];
        this.mRRxnDe = new int[this.mREntries];
        this.mRRxn_fGrpNo = new int[this.mREntries];
        this.mRRxn_Sym = new boolean[this.mREntries];
        this.mRRxnDefs = new int[this.mREntries][];
        for (n4 = 0; n4 < this.mREntries; ++n4) {
            this.mRRxnTb[n4] = scanner.next();
            this.mRRxnDe[n4] = Integer.parseInt(scanner.next(), 16);
            this.mRRxnDefs[n4] = new int[scanner.nextInt()];
            this.mRRxn_fGrpNo[n4] = scanner.nextInt();
            this.mRRxn_Sym[n4] = scanner.nextInt() == 1;
            for (int i = 0; i < this.mRRxnDefs[n4].length; ++i) {
                this.mRRxnDefs[n4][i] = Integer.parseInt(scanner.next(), 16);
            }
        }
        this.mGRPName = new String[512];
        try {
            bufferedReader = new BufferedReader(new StringReader(this.GRPNAMES));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                n3 = string3.charAt(0) - 48;
                n2 = Integer.parseInt(string3.substring(2, 4), 16);
                string = string3.substring(5);
                n = this.getGRPNameIndex(n2, n3);
                this.mGRPName[n] = string;
                string3 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mEFGName = new String[2048];
        try {
            bufferedReader = new BufferedReader(new StringReader(this.EFGNAMES));
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                n3 = string4.charAt(0) - 48;
                n2 = Integer.parseInt(string4.substring(2, 6), 16);
                string = string4.substring(7);
                n = this.getEFGNameIndex(n2, n3);
                this.mEFGName[n] = string;
                string4 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getGRPNameIndex(int n, int n2) {
        return GRP_OFFSET[n2] + (n >> 8 - n2);
    }

    private int getEFGNameIndex(int n, int n2) {
        return EFG_OFFSET[n2] + (n >> 8 - n2);
    }

    public String getEFGName(int n, int n2) {
        return this.mEFGName[this.getEFGNameIndex(n, n2)];
    }

    public int getHEntries() {
        return this.mHEntries;
    }

    public int getDEntries() {
        return this.mDEntries;
    }

    public int getEEntries() {
        return this.mEEntries;
    }

    public int getCEntries() {
        return this.mCEntries;
    }

    public int getREntries() {
        return this.mREntries;
    }

    public int getHRxnDelta(int n) {
        return this.mHRxnDe[n];
    }

    public int getDRxnDelta(int n) {
        return this.mDRxnDe[n];
    }

    public int getERxnDelta(int n) {
        return this.mERxnDe[n];
    }

    public int getCRxnDelta(int n) {
        return this.mCRxnDe[n];
    }

    public int getRRxnDelta(int n) {
        return this.mRRxnDe[n];
    }

    public String getCRingClosureName(int n) {
        return this.mCRxnTb1[n];
    }

    public String getCRingOpeningName(int n) {
        return this.mCRxnTb2[n];
    }

    public String getDConstructionName(int n) {
        return this.mDRxnTb1[n];
    }

    public String getDFragmentationName(int n) {
        return this.mDRxnTb2[n];
    }

    public String getERearrangementName(int n) {
        return this.mERxnTb[n];
    }

    public String getHConstructionName(int n) {
        return this.mHRxnTb1[n];
    }

    public String getHFragmentationName(int n) {
        return this.mHRxnTb2[n];
    }

    public int getHRxnGroupDef(int n) {
        return this.mHRxnDefs[n];
    }

    public String getRRefuncName(int n) {
        return this.mRRxnTb[n];
    }

    public int getRRxnDef(int n, int n2, int n3) {
        int[] nArray = new int[]{255, 65280, 0xFF0000, -16777216};
        return (this.mRRxnDefs[n][n2] & nArray[n3]) >> 8 * n3;
    }

    public int getRRxnFGroups(int n) {
        return this.mRRxn_fGrpNo[n];
    }

    public int getRRxnMasks(int n) {
        return this.mRRxnDefs[n].length;
    }

    public boolean getRRxnSymmetric(int n) {
        return this.mRRxn_Sym[n];
    }
}

