/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.calc.geometry.Triangle;
import com.actelion.research.calc.regression.linear.simple.LinearRegression;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.properties.complexity.ModelExhaustiveStatistics;
import com.actelion.research.chem.properties.complexity.ResultFragmentsStatistic;
import com.actelion.research.chem.properties.complexity.SymmetryCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SummaryFragments {
    public static final String TAG_SUM_UNIQUE_FRAGMENTS_UNTIL_MAX = "SumUniqueFragmentsUntilMaxFrags";
    public static final String TAG_NUM_BONDS_AT_MAXIMUM_FREQ = "NumBondsAtMaxFreq";
    public static final String TAG_NUM_BONDS_AT_MAXIMUM_SLOPE = "NumBondsAtMaxSlope";
    public static final String TAG_MAXIMUM_SLOPE = "MaxSlope";
    public static final String TAG_RATIO_USED_BONDS_UP_TO_MAX_FREQ = "RatioUsedBondsUpToMaxFreq";
    public static final String TAG_RATIO_NON_SYMMETRIC_ATOMS = "RatioNonSymmetricAtoms";
    public static final String TAG_COMPLEXITY = "Complexity";
    private static final int DELTA_SLOPE = 1;
    private int nAtomsMolecule;
    private int nBondsMolecule;
    private StereoMolecule mol;
    private int sumFragsUntilMaximumFrequency;
    private int numBondsAtMaximumFrequency;
    private int numBondsAtMaxSlope;
    private double maximumSlope;
    private double ratioUsedBondsUpToMaxFreq;
    private double ratioNonSymmetricAtoms;
    private double score;

    public SummaryFragments(ResultFragmentsStatistic resultFragmentsStatistic) {
        this.nAtomsMolecule = resultFragmentsStatistic.getAtoms();
        this.nBondsMolecule = resultFragmentsStatistic.getBonds();
        this.mol = resultFragmentsStatistic.getMol();
        this.summary(resultFragmentsStatistic.getExhaustiveStatistics());
    }

    private void summary(List<ModelExhaustiveStatistics> list) {
        int n = 1;
        Collections.sort(list, ModelExhaustiveStatistics.getComparatorNumBonds());
        double[] dArray = new double[list.size()];
        int[] nArray = new int[list.size()];
        double d = 0.0;
        this.numBondsAtMaximumFrequency = -1;
        int n2 = -1;
        this.sumFragsUntilMaximumFrequency = 0;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            ModelExhaustiveStatistics modelExhaustiveStatistics = list.get(i);
            dArray[i] = d2 = Math.log(modelExhaustiveStatistics.getUnique());
            nArray[i] = modelExhaustiveStatistics.getNumBondsInFragment();
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            this.numBondsAtMaximumFrequency = nArray[i];
            n2 = i;
            this.sumFragsUntilMaximumFrequency += modelExhaustiveStatistics.getUnique();
        }
        double d3 = SummaryFragments.getIntegratedAreaWeighted(nArray, dArray, n2);
        int n3 = n;
        int n4 = list.size() - n;
        double[] dArray2 = new double[list.size()];
        this.maximumSlope = -10000.0;
        this.numBondsAtMaxSlope = 0;
        for (int i = n3; i < n4; ++i) {
            double d4;
            int n5 = i - n;
            int n6 = i + n + 1;
            LinearRegression linearRegression = new LinearRegression();
            for (int j = n5; j < n6; ++j) {
                linearRegression.addPoint(j, dArray[j]);
            }
            linearRegression.regress();
            dArray2[i] = d4 = linearRegression.getSlope();
            if (!(d4 > this.maximumSlope)) continue;
            this.numBondsAtMaxSlope = nArray[i];
            this.maximumSlope = d4;
        }
        this.ratioUsedBondsUpToMaxFreq = (double)this.numBondsAtMaximumFrequency / (double)this.nBondsMolecule;
        this.ratioNonSymmetricAtoms = 1.0 - SymmetryCalculator.getRatioSymmetricAtoms(this.mol);
        this.score = d3 * this.ratioUsedBondsUpToMaxFreq * this.maximumSlope * this.ratioNonSymmetricAtoms;
    }

    public int getAtomsMolecule() {
        return this.nAtomsMolecule;
    }

    public int getBondsMolecule() {
        return this.nBondsMolecule;
    }

    public StereoMolecule getMol() {
        return this.mol;
    }

    public int getNumBondsAtMaximumFrequency() {
        return this.numBondsAtMaximumFrequency;
    }

    public double getMaximumSlope() {
        return this.maximumSlope;
    }

    public int getNumBondsAtMaxSlope() {
        return this.numBondsAtMaxSlope;
    }

    public double getRatioUsedBondsUpToMaxFreq() {
        return this.ratioUsedBondsUpToMaxFreq;
    }

    public double getRatioNonSymmetricAtoms() {
        return this.ratioNonSymmetricAtoms;
    }

    public int getSumFragsUntilMaximumFrequency() {
        return this.sumFragsUntilMaximumFrequency;
    }

    public double getComplexityScore() {
        return this.score;
    }

    public static double getIntegratedAreaWeighted(int[] nArray, double[] dArray, int n) {
        double d = 0.0;
        int n2 = n + 1;
        for (int i = 1; i < n2; ++i) {
            double d2;
            double d3 = nArray[i] - nArray[i - 1];
            double d4 = dArray[i] - dArray[i - 1];
            double d5 = Triangle.getAreaRightTriangle(d3, d4);
            double d6 = d5 + (d2 = dArray[i - 1] * d3);
            if (d6 < 1.0) {
                d6 = 1.0;
            }
            d += Math.log(d6);
        }
        return d;
    }

    public static List<String> getHeaderTags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Atoms");
        arrayList.add("Bonds");
        arrayList.add(TAG_SUM_UNIQUE_FRAGMENTS_UNTIL_MAX);
        arrayList.add(TAG_NUM_BONDS_AT_MAXIMUM_FREQ);
        arrayList.add(TAG_NUM_BONDS_AT_MAXIMUM_SLOPE);
        arrayList.add(TAG_MAXIMUM_SLOPE);
        arrayList.add(TAG_RATIO_USED_BONDS_UP_TO_MAX_FREQ);
        arrayList.add(TAG_RATIO_NON_SYMMETRIC_ATOMS);
        arrayList.add(TAG_COMPLEXITY);
        return arrayList;
    }
}

