/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.properties.complexity.FragmentDefinedByBondsIdCode;
import com.actelion.research.util.datamodel.IntVec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultipleNonOverlapSolution {
    public static final String TAG_MultipleNonOverlapSolution = "MultipleNonOverlapSolution";
    private static final String TAG_ATTR_NUM_EQUAL_IDCODES = "equalIdCodes";
    private static final String TAG_INDEX_SOLUTION_CHECKED = "IndexSolution";
    private static final String TAG_ATTR_INDEX_SOLUTION_CHECKED = "intVecSolution";
    private static final String TAG_CONTAINER = "Container";
    private static final String TAG_ATTR_CONTAINER = "intVecContainer";
    private static final String TAG_LIST_ISOMORPH = "ListNonOverlapIsomorph";
    private static final String TAG_ISOMORPH = "NonOverlapIsomorph";
    private static final String TAG_ATTR_ISOMORPH = "isomorph";
    private IntVec arrIndexSolutionChecked;
    private FragmentDefinedByBondsIdCode container;
    private List<FragmentDefinedByBondsIdCode> liNonOverLappingIsomorphSubstruct;
    private int numEqualIdCodes;

    private MultipleNonOverlapSolution() {
    }

    public MultipleNonOverlapSolution(int n, FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode, int n2) {
        this.numEqualIdCodes = n;
        this.arrIndexSolutionChecked = new IntVec(IntVec.getSizeForBits(n));
        this.arrIndexSolutionChecked.setBit(n2);
        this.container = new FragmentDefinedByBondsIdCode(fragmentDefinedByBondsIdCode);
        this.container.addBits(fragmentDefinedByBondsIdCode.getBitArray());
        this.liNonOverLappingIsomorphSubstruct = new ArrayList<FragmentDefinedByBondsIdCode>();
        this.liNonOverLappingIsomorphSubstruct.add(fragmentDefinedByBondsIdCode);
    }

    public MultipleNonOverlapSolution(MultipleNonOverlapSolution multipleNonOverlapSolution) {
        this.numEqualIdCodes = multipleNonOverlapSolution.numEqualIdCodes;
        this.arrIndexSolutionChecked = new IntVec(multipleNonOverlapSolution.arrIndexSolutionChecked);
        this.container = new FragmentDefinedByBondsIdCode(multipleNonOverlapSolution.container);
        this.liNonOverLappingIsomorphSubstruct = new ArrayList<FragmentDefinedByBondsIdCode>();
        this.liNonOverLappingIsomorphSubstruct.addAll(multipleNonOverlapSolution.liNonOverLappingIsomorphSubstruct);
    }

    boolean isSolutionIncluded(int n) {
        return this.arrIndexSolutionChecked.isBitSet(n);
    }

    void addSolution(FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode, int n) {
        this.arrIndexSolutionChecked.setBit(n);
        this.container.addBits(fragmentDefinedByBondsIdCode.getBitArray());
        this.liNonOverLappingIsomorphSubstruct.add(fragmentDefinedByBondsIdCode);
    }

    boolean isOverlap(FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode) {
        return this.container.isOverlappingBits(fragmentDefinedByBondsIdCode.getBitArray());
    }

    public int hashCode() {
        return this.container.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MultipleNonOverlapSolution)) {
            return false;
        }
        MultipleNonOverlapSolution multipleNonOverlapSolution = (MultipleNonOverlapSolution)object;
        return this.arrIndexSolutionChecked.equal(multipleNonOverlapSolution.arrIndexSolutionChecked);
    }

    boolean isAllChecked() {
        int n = 0;
        for (int i = 0; i < this.numEqualIdCodes; ++i) {
            if (!this.arrIndexSolutionChecked.isBitSet(i)) continue;
            ++n;
        }
        return n == this.numEqualIdCodes;
    }

    public IntVec getCheckerArray() {
        return this.arrIndexSolutionChecked;
    }

    public FragmentDefinedByBondsIdCode getContainer() {
        return this.container;
    }

    public List<FragmentDefinedByBondsIdCode> getLiNonOverLappingIsomorphSubstruct() {
        return this.liNonOverLappingIsomorphSubstruct;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.arrIndexSolutionChecked.toStringBinaryDense());
        return stringBuilder.toString();
    }

    public Element getXMLElement(Document document) throws ParserConfigurationException, DOMException, IOException {
        Element element = document.createElement(TAG_MultipleNonOverlapSolution);
        element.setAttribute(TAG_ATTR_NUM_EQUAL_IDCODES, Integer.toString(this.numEqualIdCodes));
        Element element2 = document.createElement(TAG_INDEX_SOLUTION_CHECKED);
        element2.setAttribute(TAG_ATTR_INDEX_SOLUTION_CHECKED, this.arrIndexSolutionChecked.write2String());
        Element element3 = document.createElement(TAG_CONTAINER);
        element3.setAttribute(TAG_ATTR_CONTAINER, this.container.write2String());
        Element element4 = document.createElement(TAG_LIST_ISOMORPH);
        for (FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode : this.liNonOverLappingIsomorphSubstruct) {
            Element element5 = document.createElement(TAG_ISOMORPH);
            element5.setAttribute(TAG_ATTR_ISOMORPH, fragmentDefinedByBondsIdCode.write2String());
            element4.appendChild(element5);
        }
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        return element;
    }

    public static MultipleNonOverlapSolution readXMLElement(Element element) throws ParserConfigurationException, DOMException, IOException {
        Object object;
        Object object2;
        int n = Integer.parseInt(element.getAttribute(TAG_ATTR_NUM_EQUAL_IDCODES));
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = nodeList.item(i);
            object = object2.getNodeName();
            if (TAG_INDEX_SOLUTION_CHECKED.equals(object)) {
                element2 = (Element)object2;
                continue;
            }
            if (TAG_CONTAINER.equals(object)) {
                element3 = (Element)object2;
                continue;
            }
            if (!TAG_LIST_ISOMORPH.equals(object)) continue;
            element4 = (Element)object2;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(element2.getAttribute(TAG_ATTR_INDEX_SOLUTION_CHECKED).getBytes());
        object2 = IntVec.read(byteArrayInputStream);
        ((InputStream)byteArrayInputStream).close();
        object = new ByteArrayInputStream(element3.getAttribute(TAG_ATTR_CONTAINER).getBytes());
        FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode = FragmentDefinedByBondsIdCode.read((InputStream)object);
        ((InputStream)object).close();
        ArrayList<FragmentDefinedByBondsIdCode> arrayList = new ArrayList<FragmentDefinedByBondsIdCode>();
        NodeList nodeList2 = element4.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            String string = node.getNodeName();
            if (!TAG_ISOMORPH.equals(string)) continue;
            Element element5 = (Element)node;
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(element5.getAttribute(TAG_ATTR_ISOMORPH).getBytes());
            FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode2 = FragmentDefinedByBondsIdCode.read(byteArrayInputStream2);
            ((InputStream)byteArrayInputStream2).close();
            arrayList.add(fragmentDefinedByBondsIdCode2);
        }
        MultipleNonOverlapSolution multipleNonOverlapSolution = new MultipleNonOverlapSolution();
        multipleNonOverlapSolution.numEqualIdCodes = n;
        multipleNonOverlapSolution.arrIndexSolutionChecked = object2;
        multipleNonOverlapSolution.container = fragmentDefinedByBondsIdCode;
        multipleNonOverlapSolution.liNonOverLappingIsomorphSubstruct = arrayList;
        return multipleNonOverlapSolution;
    }
}

