/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.properties.complexity.BitArray128;
import com.actelion.research.chem.properties.complexity.BitArray128Factory;
import com.actelion.research.chem.properties.complexity.IBitArray;
import com.actelion.research.chem.properties.complexity.IBitArrayFactory;
import com.actelion.research.util.datamodel.IntArray;
import java.util.ArrayList;
import java.util.List;

public class ContainerBitArray {
    private static boolean ELUSIVE = false;
    private static final int CAPACITY_ADD = 1024;
    private static final int MAX_CAPACITY_ADD = 0x10000000;
    private static final int LIMIT2FULL = 1500000000;
    private static final int CAPACITY_FULL = Integer.MAX_VALUE;
    private List<IBitArray> li;
    private IntArray arrAvailable;
    private int capacityAdd;
    private int bits;
    IBitArrayFactory<? extends IBitArray> bitArrayCreator;

    public ContainerBitArray(int n, int n2) {
        if (n != 128) {
            throw new RuntimeException("Do not know a factory to construct " + n + " bits array.");
        }
        this.bitArrayCreator = new BitArray128Factory();
        this.bits = n;
        if (n2 > 1500000000) {
            n2 = Integer.MAX_VALUE;
        }
        this.capacityAdd = 1024;
        this.arrAvailable = new IntArray(n2);
        this.li = new ArrayList<IBitArray>(n2);
        this.addResources(n2);
    }

    public void calculateHash(IBitArray iBitArray) {
        this.bitArrayCreator.calculateHash(iBitArray);
    }

    public int getSizeBinaryArray() {
        return this.bits;
    }

    public void reset() {
        this.arrAvailable.reset();
        for (int i = 0; i < this.li.size(); ++i) {
            this.arrAvailable.add(i);
        }
    }

    private void addResources(int n) {
        if (this.li.size() == Integer.MAX_VALUE) {
            new RuntimeException("Maximum capacity reached").toString();
            return;
        }
        int n2 = this.li.size();
        for (int i = 0; i < n; ++i) {
            int n3 = n2 + i;
            this.li.add(this.bitArrayCreator.getNew(n3));
            this.arrAvailable.add(n3);
            if (this.li.size() != Integer.MAX_VALUE) continue;
            new RuntimeException("Maximum capacity reached").toString();
            break;
        }
    }

    public IBitArray get() {
        if (this.arrAvailable.length() == 0) {
            throw new CapacityReachedError("Maximum capacity " + this.arrAvailable.getCapacity() + " reached!");
        }
        int n = this.arrAvailable.removeLast();
        IBitArray iBitArray = this.li.get(n);
        iBitArray.reset();
        return iBitArray;
    }

    public void receycle(IBitArray iBitArray) {
        this.arrAvailable.add(iBitArray.getIndex());
    }

    public IBitArray getWithCopy(BitArray128 bitArray128) {
        IBitArray iBitArray = this.get();
        iBitArray.copyIntoThis(bitArray128);
        return iBitArray;
    }

    public int getCapacity() {
        return this.li.size();
    }

    public int getAvailable() {
        return this.arrAvailable.length();
    }

    public static boolean isELUSIVE() {
        return ELUSIVE;
    }

    public static void setELUSIVE(boolean bl) {
        ELUSIVE = bl;
    }

    public static class CapacityReachedError
    extends RuntimeException {
        public CapacityReachedError(String string) {
            super(string);
        }
    }
}

