/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.properties.complexity.IBitArray;
import com.actelion.research.chem.properties.complexity.IndexHash;
import java.io.IOException;
import java.io.InputStream;

public class BitArray128
extends IndexHash
implements IBitArray {
    public static final int MAX_NUM_BITS = 128;
    long l1;
    long l2;
    protected char sizeAfterLastBitSet;

    public BitArray128() {
        this.sizeAfterLastBitSet = '\u0000';
    }

    public BitArray128(int n) {
        super(n);
    }

    public BitArray128(BitArray128 bitArray128) {
        this.copyIntoThis(bitArray128);
    }

    @Override
    public void copyIntoThis(IBitArray iBitArray) {
        BitArray128 bitArray128 = (BitArray128)iBitArray;
        this.setHash(bitArray128.hash);
        this.l1 = bitArray128.l1;
        this.l2 = bitArray128.l2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BitArray128)) {
            return false;
        }
        BitArray128 bitArray128 = (BitArray128)object;
        if (this.l1 != bitArray128.l1) {
            return false;
        }
        return this.l2 == bitArray128.l2;
    }

    @Override
    public void add(IBitArray iBitArray) {
        int n = iBitArray.getSizeAfterLastBitSet();
        for (int i = 0; i < n; ++i) {
            if (!iBitArray.isBitSet(i)) continue;
            this.setBit(i);
        }
    }

    @Override
    public boolean isBitSet(int n) {
        boolean bl = false;
        int n2 = 63 - n % 64;
        long l = 1L;
        l <<= n2;
        if (n < 64) {
            if ((this.l1 & l) != 0L) {
                bl = true;
            }
        } else if ((this.l2 & l) != 0L) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void setBit(int n) {
        int n2 = 63 - n % 64;
        long l = 1L;
        l <<= n2;
        if (n < 64) {
            this.l1 |= l;
        } else {
            this.l2 |= l;
        }
        this.setHash(-1);
        if (n >= this.sizeAfterLastBitSet) {
            this.sizeAfterLastBitSet = (char)(n + 1);
        }
    }

    public void unsetBit(int n) {
        int n2 = 63 - n % 64;
        long l = 1L;
        l <<= n2;
        if (n < 64) {
            this.l1 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.l2 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.setHash(-1);
        if (n + 1 == this.sizeAfterLastBitSet) {
            this.sizeAfterLastBitSet = '\u0000';
            for (int i = n; i >= 0; ++i) {
                if (!this.isBitSet(i)) continue;
                this.sizeAfterLastBitSet = (char)(i + 1);
            }
        }
    }

    @Override
    public boolean isOverlap(IBitArray iBitArray) {
        boolean bl = false;
        int n = iBitArray.getSizeAfterLastBitSet();
        for (int i = 0; i < n; ++i) {
            if (!this.isBitSet(i) || !iBitArray.isBitSet(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public int getBitsSet() {
        int n = 0;
        int n2 = this.getSizeAfterLastBitSet();
        for (int i = 0; i < n2; ++i) {
            if (!this.isBitSet(i)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getSizeAfterLastBitSet() {
        return this.sizeAfterLastBitSet;
    }

    @Override
    public void reset() {
        this.setHash(-1);
        this.l1 = 0L;
        this.l2 = 0L;
        this.sizeAfterLastBitSet = '\u0000';
    }

    public long getL1() {
        return this.l1;
    }

    public void setL1(long l) {
        this.l1 = l;
    }

    public long getL2() {
        return this.l2;
    }

    public void setL2(long l) {
        this.l2 = l;
    }

    public String toString() {
        return this.toStringBinary();
    }

    public String toStringBinary() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BitArray128.toStringBinary(this.l1));
        stringBuilder.append(BitArray128.toStringBinary(this.l2));
        return stringBuilder.toString();
    }

    private static String toStringBinary(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 64;
        for (int i = 0; i < n; ++i) {
            if ((l & 1L) == 1L) {
                stringBuilder.insert(0, "1");
            } else {
                stringBuilder.insert(0, "0");
            }
            l >>= 1;
        }
        return stringBuilder.toString().trim();
    }

    public static BitArray128 read(InputStream inputStream) throws IOException {
        BitArray128 bitArray128 = new BitArray128();
        bitArray128.setIndex((int)BitArray128.parseLong(inputStream));
        bitArray128.setHash((int)BitArray128.parseLong(inputStream));
        bitArray128.l1 = BitArray128.parseLong(inputStream);
        bitArray128.l2 = BitArray128.parseLong(inputStream);
        bitArray128.sizeAfterLastBitSet = (char)BitArray128.parseLong(inputStream);
        return bitArray128;
    }

    @Override
    public String write2String() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getIndex());
        stringBuilder.append(" ");
        stringBuilder.append(this.hashCode());
        stringBuilder.append(" ");
        stringBuilder.append(this.l1);
        stringBuilder.append(" ");
        stringBuilder.append(this.l2);
        stringBuilder.append(" ");
        stringBuilder.append(this.sizeAfterLastBitSet);
        return stringBuilder.toString();
    }

    public static long parseLong(InputStream inputStream) throws IOException {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while (32 != (n = inputStream.read()) && n != -1) {
            stringBuilder.append((char)n);
        }
        long l = Long.parseLong(stringBuilder.toString());
        return l;
    }
}

