/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.ParameterizedStringList;

public class PolarSurfaceAreaPredictor {
    public static final float cPSAUnknown = -1.0f;
    protected static final String[] cPolarAtomTypeName = new String[]{"[N](-*)(-*)-*", "[N](-*)=*", "[N]#*", "[N](-*)(=*)=* as in nitro", "[N](=*)#* middle atom of azide", "[N]1(-*)-*-*-1 3-membered ring", "[NH](-*)-*", "[NH]1-*-*-1 3-membered ring", "[NH]=*", "[NH2]-*", "[N+](-*)(-*)(-*)-*", "[N+](-*)(-*)=*", "[N+](-*)#* N in isocyano", "[NH+](-*)(-*)-*", "[NH+](-*)=*", "[NH2+](-*)-*", "[NH2+]=*", "[NH3+]-*", "[n](:*):*", "[n](:*)(:*):*", "[n](-*)(:*):*", "[n](=*)(:*):* as in pyridine-N-oxid", "[nH](:*):*", "[n+](:*)(:*):*", "[n+](-*)(:*):*", "[nH+](:*):*", "[O](-*)-*", "[O]1-*-*-1 3-membered ring", "[O]=*", "[OH]-*", "[O-]-*", "[o](:*):*", "[S](-*)-*", "[S]=*", "[S](-*)(-*)=*", "[S](-*)(-*)(=*)=*", "[SH]-*", "[s](:*):*", "[s](=*)(:*):*", "[P](-*)(-*)-*", "[P](-*)=*", "[P](-*)(-*)(-*)=*", "[PH](-*)(-*)=*"};
    private static final float[] cTPSAIncrement = new float[]{3.24f, 12.36f, 23.79f, 11.68f, 13.6f, 3.01f, 12.03f, 21.94f, 23.85f, 26.02f, 0.0f, 3.01f, 4.36f, 4.44f, 13.97f, 16.61f, 25.59f, 27.64f, 12.89f, 4.41f, 4.93f, 8.39f, 15.79f, 4.1f, 3.88f, 14.14f, 9.23f, 12.53f, 17.07f, 20.23f, 23.06f, 13.14f, 25.3f, 32.09f, 19.21f, 8.38f, 38.8f, 28.24f, 21.7f, 13.59f, 34.14f, 9.81f, 23.47f};

    public static int getPolarAtomTypeCount() {
        return cPolarAtomTypeName.length;
    }

    public float assessPSA(StereoMolecule stereoMolecule) {
        int[] nArray = this.getPolarAtomTypeCounts(stereoMolecule);
        float f = 0.0f;
        for (int i = 0; i < cTPSAIncrement.length; ++i) {
            f += (float)nArray[i] * cTPSAIncrement[i];
        }
        return f;
    }

    public ParameterizedStringList getDetail(StereoMolecule stereoMolecule) {
        ParameterizedStringList parameterizedStringList = new ParameterizedStringList();
        parameterizedStringList.add("The polar surface area prediction is based on an atom-type based", 2);
        parameterizedStringList.add("increment system, published by P. Ertl, B. Rohde, P. Selzer", 2);
        parameterizedStringList.add("in J. Med. Chem. 2000, 43, 3714-3717", 2);
        parameterizedStringList.add("Recognized atom types and their contributions are:", 2);
        this.addTPSAIncrements(stereoMolecule, parameterizedStringList);
        return parameterizedStringList;
    }

    private void addTPSAIncrements(StereoMolecule stereoMolecule, ParameterizedStringList parameterizedStringList) {
        int[] nArray = this.getPolarAtomTypeCounts(stereoMolecule);
        for (int i = 0; i < cTPSAIncrement.length; ++i) {
            if (nArray[i] == 0) continue;
            parameterizedStringList.add("" + nArray[i] + " * " + cTPSAIncrement[i] + "   AtomType: " + cPolarAtomTypeName[i], 2);
        }
    }

    public int[] getPolarAtomTypeCounts(StereoMolecule stereoMolecule) {
        int[] nArray = new int[cTPSAIncrement.length + 2];
        stereoMolecule.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            int n = this.getPolarAtomType(stereoMolecule, i);
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    private int getPolarAtomType(StereoMolecule stereoMolecule, int n) {
        switch (stereoMolecule.getAtomicNo(n)) {
            case 7: {
                if (stereoMolecule.isAromaticAtom(n)) {
                    if (stereoMolecule.getAtomCharge(n) == 0) {
                        if (stereoMolecule.getAllHydrogens(n) == 0) {
                            if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 2) {
                                return 18;
                            }
                            for (int i = 0; i < stereoMolecule.getNonHydrogenNeighbourCount(n); ++i) {
                                if (stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(n, i))) continue;
                                return 20;
                            }
                            return 19;
                        }
                        return 22;
                    }
                    if (stereoMolecule.getAtomCharge(n) == 1) {
                        if (stereoMolecule.getAllHydrogens(n) == 0) {
                            for (int i = 0; i < stereoMolecule.getNonHydrogenNeighbourCount(n); ++i) {
                                if (stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(n, i))) continue;
                                return stereoMolecule.getAtomCharge(stereoMolecule.getConnAtom(n, i)) < 0 ? 21 : 24;
                            }
                            return 23;
                        }
                        return 25;
                    }
                } else if (stereoMolecule.getAtomCharge(n) == 0) {
                    switch (stereoMolecule.getAllHydrogens(n)) {
                        case 0: {
                            switch (stereoMolecule.getAtomPi(n)) {
                                case 0: {
                                    if (stereoMolecule.getAtomRingSize(n) == 3) {
                                        return 5;
                                    }
                                    return 0;
                                }
                                case 1: {
                                    return 1;
                                }
                                case 2: {
                                    return 2;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (stereoMolecule.getAtomPi(n)) {
                                case 0: {
                                    if (stereoMolecule.getAtomRingSize(n) == 3) {
                                        return 7;
                                    }
                                    return 6;
                                }
                                case 1: {
                                    return 8;
                                }
                            }
                            break;
                        }
                        case 2: {
                            return 9;
                        }
                    }
                } else if (stereoMolecule.getAtomCharge(n) == 1) {
                    switch (stereoMolecule.getAllHydrogens(n)) {
                        case 0: {
                            switch (stereoMolecule.getAtomPi(n)) {
                                case 0: {
                                    return 10;
                                }
                                case 1: {
                                    return this.hasNegativeNeighbour(stereoMolecule, n) ? 3 : 11;
                                }
                                case 2: {
                                    if (stereoMolecule.getConnBondOrder(n, 0) == 2) {
                                        return this.hasNegativeNeighbour(stereoMolecule, n) ? 4 : cTPSAIncrement.length + 1;
                                    }
                                    return 12;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (stereoMolecule.getAtomPi(n)) {
                                case 0: {
                                    return 13;
                                }
                                case 1: {
                                    return 14;
                                }
                            }
                            break;
                        }
                        case 2: {
                            return stereoMolecule.getAtomPi(n) == 0 ? 15 : 16;
                        }
                        case 3: {
                            return 17;
                        }
                    }
                }
                return cTPSAIncrement.length + 1;
            }
            case 8: {
                if (stereoMolecule.isAromaticAtom(n)) {
                    if (stereoMolecule.getAtomCharge(n) == 0) {
                        return 31;
                    }
                } else {
                    if (stereoMolecule.getAtomCharge(n) == 0) {
                        if (stereoMolecule.getAtomPi(n) > 0) {
                            return 28;
                        }
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 1) {
                            return 29;
                        }
                        if (stereoMolecule.getAtomRingSize(n) == 3) {
                            return 27;
                        }
                        return 26;
                    }
                    if (stereoMolecule.getAtomCharge(n) == -1) {
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 1 && stereoMolecule.getAtomCharge(stereoMolecule.getConnAtom(n, 0)) > 0) {
                            return 28;
                        }
                        return 30;
                    }
                }
                return cTPSAIncrement.length + 1;
            }
            case 15: {
                if (stereoMolecule.getAtomCharge(n) == 0) {
                    if (stereoMolecule.getAllHydrogens(n) == 0) {
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 3 && stereoMolecule.getAtomPi(n) == 0) {
                            return 39;
                        }
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 2 && stereoMolecule.getAtomPi(n) == 1) {
                            return 40;
                        }
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 4 && stereoMolecule.getAtomPi(n) == 1) {
                            return 41;
                        }
                    } else if (stereoMolecule.getAllHydrogens(n) == 1 && stereoMolecule.getNonHydrogenNeighbourCount(n) == 3 && stereoMolecule.getAtomPi(n) == 1) {
                        return 42;
                    }
                }
                return cTPSAIncrement.length + 1;
            }
            case 16: {
                if (stereoMolecule.getAtomCharge(n) == 0) {
                    if (stereoMolecule.isAromaticAtom(n)) {
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 2) {
                            return 37;
                        }
                        return 38;
                    }
                    if (stereoMolecule.getAllHydrogens(n) == 0) {
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 2 && stereoMolecule.getAtomPi(n) == 0) {
                            return 32;
                        }
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 1 && stereoMolecule.getAtomPi(n) == 1) {
                            return 33;
                        }
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 3 && stereoMolecule.getAtomPi(n) == 1) {
                            return 34;
                        }
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n) == 4 && stereoMolecule.getAtomPi(n) == 2) {
                            return 35;
                        }
                    } else if (stereoMolecule.getAllHydrogens(n) == 1 && stereoMolecule.getNonHydrogenNeighbourCount(n) == 1) {
                        return 36;
                    }
                }
                return cTPSAIncrement.length + 1;
            }
        }
        return cTPSAIncrement.length;
    }

    private boolean hasNegativeNeighbour(StereoMolecule stereoMolecule, int n) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getAtomCharge(stereoMolecule.getConnAtom(n, i)) >= 0) continue;
            return true;
        }
        return false;
    }
}

