/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import java.util.TreeSet;

public class FastMolecularComplexityCalculator {
    protected static final int MAX_BOND_COUNT = 7;

    public static float assessComplexity(StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        int n4 = Math.min(stereoMolecule.getBonds() / 2, 7);
        if (n4 < 2) {
            return 0.0f;
        }
        stereoMolecule.ensureHelperArrays(63);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        TreeSet<String> treeSet = new TreeSet<String>();
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        boolean[][] blArray = new boolean[stereoMolecule.getBonds()][stereoMolecule.getBonds()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            for (n3 = 1; n3 < stereoMolecule.getConnAtoms(i); ++n3) {
                for (int j = 0; j < n3; ++j) {
                    n2 = stereoMolecule.getConnBond(i, n3);
                    n = stereoMolecule.getConnBond(i, j);
                    blArray[n2][n] = true;
                    blArray[n][n2] = true;
                }
            }
        }
        boolean[] blArray2 = new boolean[stereoMolecule.getBonds()];
        n3 = n4 - 2;
        int[] nArray2 = new int[n3 + 1];
        for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
            blArray2[n2] = true;
            n = 0;
            nArray2[0] = n2;
            while (true) {
                boolean bl = false;
                block5: while (!bl && nArray2[n] < stereoMolecule.getBonds() - 1) {
                    int n5 = n;
                    nArray2[n5] = nArray2[n5] + 1;
                    if (blArray2[nArray2[n]]) continue;
                    for (int i = n2; i < stereoMolecule.getBonds(); ++i) {
                        if (!blArray2[i] || !blArray[i][nArray2[n]]) continue;
                        bl = true;
                        continue block5;
                    }
                }
                if (bl) {
                    blArray2[nArray2[n]] = true;
                    if (n == n3) {
                        stereoMolecule.copyMoleculeByBonds(stereoMolecule2, blArray2, true, nArray);
                        treeSet.add(new Canonizer(stereoMolecule2).getIDCode());
                        blArray2[nArray2[n]] = false;
                        continue;
                    }
                    nArray2[++n] = n2;
                    continue;
                }
                if (--n < 0) break;
                blArray2[nArray2[n]] = false;
            }
            blArray2[n2] = false;
        }
        return (float)Math.log(treeSet.size()) / (float)n4;
    }
}

