/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.AtomTypeCalculator;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.ParameterizedStringList;
import com.actelion.research.util.SortedList;
import java.text.DecimalFormat;
import java.util.TreeMap;

public class CLogPPredictor {
    private static final int ATOM_TYPE_MODE = 6241;
    protected static final long[] ATOM_TYPE = new long[]{524290L, 524292L, 589826L, 589827L, 589828L, 589829L, 589832L, 589833L, 589837L, 589838L, 598019L, 598020L, 598024L, 606211L, 688130L, 688131L, 688132L, 688137L, 688142L, 696324L, 819202L, 819203L, 819204L, 819205L, 819214L, 827396L, 0x100004L, 0x110002L, 0x110003L, 0x110004L, 0x110008L, 1212420L, 1220611L, 1343492L, 1343496L, 1638402L, 1638403L, 17367042L, 17367043L, 17367044L, 17367045L, 17367048L, 0x1090009L, 17367053L, 17367054L, 17375236L, 17465346L, 17465348L, 17465353L, 17473540L, 1208483842L, 0x48080008L, 0x48080048L, 1208549378L, 1208549379L, 1208549380L, 1208549384L, 1208549388L, 1208549442L, 1208549443L, 1208549444L, 1208549448L, 1208557571L, 1208565763L, 1208565827L, 1409875970L, 1409875971L, 1409875972L, 1409875976L, 1409876034L, 1409876035L, 1409876036L, 1409876040L, 1409884163L, 1409974274L, 1409974280L, 1409974338L, 1678245892L, 1678311426L, 1678311427L, 1678311428L, 1678311432L, 1678311490L, 1678311491L, 1678311492L, 1678311496L, 1678409730L, 1678409731L, 1678409732L, 1678409794L, 1678540802L, 1678540808L, 1678540810L, 1678540866L, 2282291202L, 2282291203L, 2282291266L, 2282291267L, 2282389506L, 2282389507L, 2282389570L, 2282389571L, 2282389572L, 2282520578L, 2282520579L, 2282520642L, 2282520643L, 2282537027L, 2483617794L, 2483617795L, 2483617858L, 2483617859L, 0x94090044L, 2483617864L, 2483716098L, 2483716099L, 2483716162L, 2483716163L, 2484150275L, 2484248579L, 2752675842L, 3356033026L, 3356139523L, 3557359618L, 3557457922L, 3557588994L, 34510798914L, 34510798915L, 34510798916L, 34510798920L, 34510807107L, 34510815299L, 34712125506L, 34712125507L, 34712125508L, 34712125512L, 34712223810L, 34712223811L, 34712223812L, 34712223816L, 34980560962L, 34980560963L, 34980659266L, 34980659267L, 34980659268L, 35568287746L, 35568287747L, 35568287748L, 35568287752L, 35568287756L, 35568287810L, 35568287811L, 35568287812L, 35568287816L, 35568287820L, 35568386050L, 35568386051L, 35568386052L, 35568386114L, 35568386120L, 35568517122L, 35568517123L, 35568517124L, 35568517128L, 35568517186L, 35568517187L, 35568517188L, 35568517192L, 35568812034L, 35568812035L, 35568812098L, 35568812099L, 35568910338L, 35568910339L, 35568910403L, 35569336322L, 35569434626L, 35585064962L, 35585064963L, 35585064964L, 35585064968L, 35585065026L, 35585065027L, 35585065028L, 35585065032L, 35769614338L, 35769614340L, 35769614402L, 35769712642L, 35770138626L, 35770236930L, 35786391554L, 35786391555L, 2475109646403L, 2475109711874L, 2475109711875L, 2475109711938L, 2475109711939L, 2475109720067L, 2475109720131L, 2475109728259L, 2475109728323L, 2887426572290L, 2887426572291L, 2887426572354L, 2887426572355L, 2887627898882L, 2887627898883L, 2887627898946L, 2887627997186L, 2887627997250L, 3437182386178L, 3437182386179L, 3437182386242L, 3437182386243L, 3437383712770L, 3437383712771L, 3437383712834L, 3437383811074L, 3437652148226L, 3437652377602L, 4674132967426L, 4674132967490L, 4674132967491L, 4674132975619L, 4674334294018L, 4674334294082L, 4674334294083L, 4674334302211L, 4674334302275L, 4674334392322L, 4674334392386L, 4674602729474L, 4674602729538L, 4674602827842L, 4674602958850L, 4674602958914L, 5086449827842L, 5086449827848L, 5086449827906L, 5086449827907L, 5086449827912L, 5086651154434L, 5086651154498L, 5086651162627L, 5086651252738L, 5086651252743L, 5086651252802L, 5086651252808L, 5086651260931L, 5086919589890L, 5086919589954L, 5086919688194L, 5086919688258L, 5086919819330L, 5636205641794L, 5636406968322L, 5636406968386L, 5636407066626L, 5636407066690L, 5636675403842L, 5636675502082L, 5636675502146L, 70678116630594L, 70678116630595L, 70678116638787L, 70678116728898L, 70678116728899L, 70678116737091L, 70678116859970L, 70678132883522L, 70678132883523L, 71090433491010L, 71090433491011L, 71090433499203L, 71090433589314L, 71090433589315L, 71090433597507L, 71090433720386L, 71090449743938L, 71090449743939L, 71090634817602L, 71090634817603L, 71090634915906L, 71090635046978L, 71090651070530L, 71090651070536L, 71090651168834L, 71640189304898L, 71640189403202L, 71640189534274L, 71640205557826L, 71640390631490L, 71640390729794L, 71640390860866L, 71640406884418L, 71640675319874L, 72843853889538L, 72843853889539L, 72843853889602L, 72843853889603L, 72844055216130L, 72844055216131L, 72844055216194L, 72844055216195L, 72844055314434L, 72844055314498L, 72844323651586L, 72844323651587L, 72844323651650L, 72844323651651L, 72844323749891L, 72844323749954L, 72844323880963L, 72844927631362L, 72844927631426L, 72844927729666L, 72844927729730L, 72844927737859L, 72844927860738L, 72844927860744L, 72844927860802L, 72845128957954L, 72845128957960L, 72845128958018L, 72845128958019L, 72845128958024L, 72845129056258L, 72845129056264L, 72845129056322L, 72845129064451L, 72845129187330L, 72845129187394L, 72845397491714L, 72845397491778L, 72877156139074L, 72877156139075L, 72877357465666L, 72877357465667L, 72877357473859L, 72877357563970L, 72877357563971L, 72877625901122L, 72877625999426L, 72878213627906L, 72878213627907L, 72878213627970L, 72878213627971L, 72878213726210L, 72878213726274L, 72878214152194L, 72878214152258L, 72878214250498L, 72878214250504L, 72878214250562L, 72878230405122L, 73256170749954L, 73256170750018L, 73256372076546L, 73256372076610L, 73256640512066L, 73257445818370L, 73257445916674L, 73257714352130L, 73289472999490L, 73289674326082L, 73289674424386L, 73290530488322L, 73290531012674L, 73290531110914L, 73290547265538L, 5069024690438211L, 5069024690503681L, 5069024690503682L, 5069024690503746L, 5069024690511875L, 5069024690511939L, 5913449620635650L, 5913449620635714L, 5913449620643843L, 5913449620643907L, 5913861937496066L, 5913861937496130L, 5913862138822658L, 5913862138822722L, 5913862138920962L, 7039349527478274L, 7039349527478275L, 7039349527478338L, 7039349527478339L, 7039761844338690L, 7039762045665282L, 7039762045763586L, 7040311600152578L, 7040311600152642L, 7040311801479170L, 7040312069914626L, 7040312070012930L, 7040312070144002L, 9573586390548483L, 10417461564866567L, 10417461766193159L, 10417461766291463L, 10417461766291527L, 10418011522007047L, 10418011522105351L, 10418011790540807L, 10418011790540874L, 10419660588122120L, 10419660588122184L, 10419660789448712L, 10419660789547016L, 10419660789547080L, 11543361673035783L, 11543361673134087L, 11543911428947975L, 144748783329673283L, 149184212766359554L, 149184212766359618L, 149184212766367747L, 149184625083219970L, 149184625083220034L, 149184625284546562L, 149184625284546626L, 149184625284644866L, 149185175309025282L, 149186824307900423L, 149186825381543944L, 149186825381544008L, 149186825381642248L, 149186825381642312L, 149187374063714311L, 149254581510537218L, 149254581510537282L, 149254581711863810L, 149254581711863874L, 149254582786228232L, 149254582786228296L, 149254615870373890L, 149254615870373954L, 150028637696491522L, 150028637696491586L};
    protected static final float[] INCREMENT = new float[]{0.6967f, 0.0f, 0.4886f, -0.4727f, -0.0749f, 0.6262f, 0.2735f, 0.57f, 0.701f, 0.9534f, -3.6435f, -2.1509f, 0.4975f, -2.1995f, -0.2809f, -0.826f, -0.1785f, -1.6203f, -1.096f, -0.362f, 0.1395f, -0.2975f, -1.2908f, 1.0162f, -1.3825f, -2.5384f, 0.3317f, 0.4292f, -0.5824f, -0.1834f, 0.1306f, -0.5015f, 0.6262f, -0.5258f, 0.4244f, -0.161f, -0.2778f, 0.5111f, -0.4357f, -0.1041f, 0.3424f, -0.0615f, 0.6035f, 0.7227f, 0.4346f, -1.6821f, -0.331f, -0.498f, -1.4915f, -0.3651f, 0.4597f, 0.3384f, 0.6633f, 0.4544f, 0.1597f, 0.6339f, 0.3504f, 0.0449f, 0.342f, 0.2611f, 0.4046f, 0.5219f, -1.065f, -1.2314f, -1.8023f, -0.3632f, -0.4108f, 0.3057f, -0.1456f, -0.2713f, -0.5193f, 0.4526f, 0.5539f, 0.8374f, -0.707f, -0.4881f, -0.41f, 0.0f, 0.1479f, 0.3448f, 0.4298f, 0.5579f, -0.1265f, -0.0425f, 0.0767f, 0.6635f, -0.3812f, -0.8368f, 1.0287f, -0.1021f, 0.3587f, -0.5945f, 0.1692f, -0.1218f, 0.3283f, 0.2239f, 0.2043f, 0.059f, -0.4835f, 0.6165f, -0.4011f, 0.5578f, -0.2164f, -0.0175f, 0.2981f, 0.11f, 0.2715f, -0.2995f, -0.467f, 0.1566f, 0.0468f, -0.1321f, 1.3686f, 0.0f, -0.4116f, 1.0186f, -0.3935f, 0.5223f, 0.3685f, 0.2577f, 1.5193f, 0.2705f, 0.3791f, 0.012f, -0.3397f, 0.1483f, 0.2766f, 0.3593f, 0.7715f, 0.315f, -1.6185f, 0.1889f, -0.2652f, -0.0965f, 0.4202f, 0.1871f, -0.3684f, -0.0778f, 0.8943f, 0.3694f, 0.2879f, 0.4489f, -0.2601f, 0.4771f, 0.1923f, 0.4381f, 0.1695f, 0.4525f, 0.3352f, 0.1583f, 0.4036f, -0.048f, 0.5023f, -0.2649f, 0.7691f, -0.3552f, 1.0301f, -0.1141f, -0.5932f, 0.1749f, 0.1313f, -0.1804f, 0.3994f, 0.2291f, 0.3169f, 0.3599f, -0.0039f, -0.2956f, 0.4409f, -0.1609f, 0.3775f, -0.1346f, 0.2839f, 0.5129f, 0.1266f, 0.4294f, 0.2806f, 0.4907f, 0.354f, 0.2192f, 0.1565f, 0.6935f, 0.3618f, 0.6735f, 0.5778f, -0.5636f, 0.5569f, 0.3038f, -0.3276f, -0.6992f, 0.0103f, -0.4659f, 0.3818f, 0.3317f, 0.1841f, 0.7071f, 0.1227f, 0.7949f, -0.6592f, -1.3148f, -0.4067f, -0.1316f, -0.4925f, -0.0929f, -0.4352f, -0.2207f, -0.996f, -0.7238f, -0.5469f, -1.2939f, -0.0136f, 0.0657f, 0.7189f, 0.057f, 0.6619f, -0.6381f, -0.8073f, 0.2355f, 0.3048f, -0.0199f, -0.0752f, 0.4461f, 0.1559f, 1.1168f, -1.8039f, 0.2365f, -0.2206f, 0.448f, -1.134f, -0.5653f, -0.4053f, -0.1361f, 0.2199f, 0.0536f, -0.021f, 0.6985f, 0.9643f, -0.4152f, -1.0369f, -0.183f, 0.5883f, -0.2918f, -0.5294f, -0.6541f, 0.9473f, -0.1906f, -0.8484f, -0.3457f, 0.9541f, 1.4231f, -0.7924f, -0.602f, 0.08f, -0.2596f, 0.8382f, -0.4416f, -0.3704f, -0.7487f, -0.1079f, -0.2992f, -0.3277f, 0.0251f, -0.9188f, 0.1094f, 0.8231f, -3.2333f, 0.035f, 0.3818f, -0.738f, 0.2791f, 0.3206f, 0.5662f, -0.3784f, 0.4032f, -1.7948f, -0.1554f, 0.3785f, 0.0534f, -0.1653f, -0.0987f, -0.1005f, -0.6461f, 0.8035f, -0.2405f, -0.1238f, -0.3576f, 0.0961f, -0.6401f, 0.2029f, 0.2359f, 0.4951f, 0.1921f, -0.3745f, 0.3463f, 0.2899f, -0.1533f, -0.417f, 0.377f, 0.6998f, 0.594f, 0.5912f, -0.5571f, 0.0238f, -0.2475f, 0.0307f, -0.3875f, -0.7437f, 0.5144f, 0.0057f, 0.7655f, 0.172f, -2.5624f, -0.3066f, 0.3647f, 0.1727f, -0.0329f, -0.1893f, 0.0702f, -1.2454f, 0.1496f, -1.3825f, 0.4146f, -0.2668f, -0.1106f, 0.0362f, -0.3189f, -0.7278f, -0.0894f, -0.2277f, -0.2394f, 1.0112f, -0.2962f, 0.7776f, 0.2945f, -0.2234f, 0.2764f, 0.8011f, -0.1744f, 0.1581f, -1.7552f, -0.3848f, 0.5993f, 0.5268f, -0.0417f, 0.4733f, -0.3401f, -0.145f, 0.7088f, -0.1318f, 0.0426f, -0.5028f, 0.3832f, -0.0118f, -0.4358f, 0.3749f, -0.1203f, -0.5648f, -0.1972f, -0.8769f, -0.3675f, -0.2004f, -0.607f, -0.1857f, 0.3468f, -0.3624f, 0.5358f, -0.3701f, 0.1336f, 0.9545f, 0.1139f, -0.1699f, 0.3317f, 0.2891f, 0.2613f, -0.0344f, -1.9498f, -2.0249f, -0.6005f, -0.6258f, -1.2349f, 0.328f, -0.5434f, -0.7712f, -0.9057f, -0.1668f, -0.9905f, -0.0372f, -1.1638f, 0.1262f, -0.5248f, -0.1538f, -0.3682f, 0.3249f, 0.065f, 0.0511f, -0.4607f, 0.2231f, 0.2822f, 0.1397f, -0.4938f, 0.3948f, -0.4075f, -0.6411f, -0.0091f, -0.1333f, -0.5192f, -0.1661f, 0.3317f, -0.0707f, 0.4806f, 0.3828f, 0.2229f, 0.616f, 0.3371f, 0.1884f, 0.1381f, -1.4915f, 0.2833f, -0.1226f, -3.9189f, -0.4592f, -0.3435f, -0.6654f, -0.5056f, -0.8631f, 0.1536f, -0.6427f, -0.0884f, -0.0471f, 0.1106f, 0.3821f, -0.2392f, -0.4051f, 0.0891f, -0.6972f, -0.4699f, 0.0922f, 0.0806f, -0.6774f, -0.0622f, -0.93f, 0.1337f};
    public static final float cCLogPUnknown = -999.0f;
    private static SortedList<Long> sSortedTypeList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CLogPPredictor() {
        if (sSortedTypeList != null) return;
        Class<CLogPPredictor> clazz = CLogPPredictor.class;
        synchronized (CLogPPredictor.class) {
            if (sSortedTypeList != null) return;
            sSortedTypeList = new SortedList();
            long[] lArray = ATOM_TYPE;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long l = lArray[i];
                sSortedTypeList.add(l);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public float assessCLogP(StereoMolecule stereoMolecule) {
        float f = 0.0f;
        stereoMolecule.normalizeAmbiguousBonds();
        stereoMolecule.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            try {
                long l = AtomTypeCalculator.getAtomType(stereoMolecule, i, 6241);
                int n = sSortedTypeList.getIndex(l);
                if (n == -1) continue;
                f += INCREMENT[n];
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    public void getCLogPIncrements(StereoMolecule stereoMolecule, float[] fArray) {
        stereoMolecule.normalizeAmbiguousBonds();
        stereoMolecule.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            try {
                int n = sSortedTypeList.getIndex(AtomTypeCalculator.getAtomType(stereoMolecule, i, 6241));
                if (n == -1) continue;
                fArray[i] = INCREMENT[n];
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ParameterizedStringList getDetail(StereoMolecule stereoMolecule) {
        ParameterizedStringList parameterizedStringList = new ParameterizedStringList();
        parameterizedStringList.add("cLogP Values are estimated applying an atom-type based increment system.", 2);
        parameterizedStringList.add("Atom-types are 64-bit numbers describing atoms and their near surrounding.", 2);
        parameterizedStringList.add("Recognized atom types and their contributions are:", 2);
        if (stereoMolecule != null) {
            stereoMolecule.normalizeAmbiguousBonds();
            stereoMolecule.ensureHelperArrays(7);
            int n = 0;
            TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
            DecimalFormat decimalFormat = new DecimalFormat("#0.000");
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                try {
                    long l = AtomTypeCalculator.getAtomType(stereoMolecule, i, 6241);
                    Integer n2 = (Integer)treeMap.get(new Long(l));
                    if (n2 == null) {
                        treeMap.put(new Long(l), new Integer(1));
                        continue;
                    }
                    treeMap.put(new Long(l), new Integer(n2 + 1));
                    continue;
                }
                catch (Exception exception) {
                    ++n;
                }
            }
            if (n != 0) {
                parameterizedStringList.add("Warning: " + n + " atom type(s) could not be determined.", 2);
            }
            for (Long l : treeMap.keySet()) {
                if (sSortedTypeList.contains(l)) {
                    parameterizedStringList.add(treeMap.get(l) + " * " + decimalFormat.format(INCREMENT[sSortedTypeList.getIndex(l)]) + " AtomType: 0x" + Long.toHexString(l), 2);
                    continue;
                }
                parameterizedStringList.add("Warning: For atom type 0x" + Long.toHexString(l) + " (" + treeMap.get(l) + " times found) is no increment available.", 2);
            }
        }
        return parameterizedStringList;
    }
}

