/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.potentialenergy;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.torsionstrain.StatisticalTorsionTerm;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;

public class TorsionConstraint
implements PotentialEnergyTerm {
    private static double FORCE_CONSTANT = 50.0;
    private Conformer conf;
    private int[] torsionAtoms;
    private double targetValueMin;
    private double targetValueMax;

    public TorsionConstraint(Conformer conformer, int[] nArray, double d, double d2) {
        this.conf = conformer;
        this.torsionAtoms = nArray;
        this.targetValueMin = Math.PI * 2 * (d - d2) / 360.0;
        this.targetValueMax = Math.PI * 2 * (d + d2) / 360.0;
        if (this.targetValueMin < 0.0) {
            this.targetValueMin += Math.PI * 2;
        }
        if (this.targetValueMax < 0.0) {
            this.targetValueMax = Math.PI * 2;
        }
    }

    double computeDihedralTerm(double d) {
        double d2;
        double d3 = d;
        if (!(d > this.targetValueMin && d < this.targetValueMax || d > this.targetValueMin && this.targetValueMin > this.targetValueMax || d < this.targetValueMax && this.targetValueMin > this.targetValueMax)) {
            d2 = d - this.targetValueMin;
            double d4 = d - this.targetValueMax;
            d3 = Math.abs(d2) < Math.abs(d4) ? this.targetValueMin : this.targetValueMax;
        }
        d2 = d - d3;
        return d2;
    }

    @Override
    public double getFGValue(double[] dArray) {
        Coordinates coordinates;
        Coordinates coordinates2;
        Coordinates coordinates3;
        int n = this.torsionAtoms[0];
        int n2 = this.torsionAtoms[1];
        int n3 = this.torsionAtoms[2];
        int n4 = this.torsionAtoms[3];
        Coordinates coordinates4 = this.conf.getCoordinates(n);
        double d = Coordinates.getDihedral(coordinates4, coordinates3 = this.conf.getCoordinates(n2), coordinates2 = this.conf.getCoordinates(n3), coordinates = this.conf.getCoordinates(n4));
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        double d2 = this.computeDihedralTerm(d);
        double d3 = 0.5 * d2 * d2 * FORCE_CONSTANT;
        double d4 = FORCE_CONSTANT * d2;
        StatisticalTorsionTerm.getCartesianTorsionGradient(this.torsionAtoms, this.conf, dArray, d4, new Coordinates[]{coordinates4, coordinates3, coordinates2, coordinates}, null);
        return d3;
    }
}

