/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesaflex;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.PheSAAlignmentOptimizer;
import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.RotationDerivatives;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.conf.BondRotationHelper;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import com.actelion.research.chem.optimization.Evaluable;
import com.actelion.research.chem.phesa.AtomicGaussian;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesa.QuickMathCalculator;
import com.actelion.research.chem.phesa.ShapeVolume;
import com.actelion.research.chem.phesa.VolumeGaussian;
import com.actelion.research.chem.phesa.pharmacophore.pp.PPGaussian;
import java.util.Map;

public class EvaluableFlexibleOverlap
implements Evaluable {
    private static final double LAMBDA = 0.0625;
    private double e0 = 0.0;
    private Conformer fitConf;
    private StereoMolecule refMol;
    private PheSAAlignment shapeAlign;
    private boolean[] isHydrogen;
    private double[] v;
    private double[][] precalcPow;
    private double[] precalcExp;
    private double oAA;
    private double oAApp;
    private ForceFieldMMFF94 ff;
    private Map<String, Object> ffOptions;
    private PheSAAlignmentOptimizer.PheSASetting settings;
    private Coordinates[] origCoords;
    private Coordinates[] cachedCoords;
    private double[][] dRdvi1;
    private double[][] dRdvi2;
    private double[][] dRdvi3;
    private Coordinates origCOM;
    private BondRotationHelper torsionHelper;

    public EvaluableFlexibleOverlap(PheSAAlignment pheSAAlignment, StereoMolecule stereoMolecule, Conformer conformer, BondRotationHelper bondRotationHelper, PheSAAlignmentOptimizer.PheSASetting pheSASetting, boolean[] blArray, Map<String, Object> map) {
        ForceFieldMMFF94.initialize("MMFF94s+");
        this.ffOptions = map;
        this.shapeAlign = pheSAAlignment;
        this.fitConf = conformer;
        this.isHydrogen = blArray;
        this.settings = pheSASetting;
        this.refMol = stereoMolecule;
        this.torsionHelper = bondRotationHelper;
        this.init();
    }

    private void init() {
        this.ff = new ForceFieldMMFF94(this.fitConf.getMolecule(), "MMFF94s+", this.ffOptions);
        this.setInitialState();
        this.origCoords = new Coordinates[this.fitConf.getMolecule().getAllAtoms()];
        this.cachedCoords = new Coordinates[this.fitConf.getMolecule().getAllAtoms()];
        this.origCOM = new Coordinates();
        for (int i = 0; i < this.fitConf.getMolecule().getAllAtoms(); ++i) {
            this.origCoords[i] = new Coordinates(this.fitConf.getMolecule().getCoordinates(i));
            this.cachedCoords[i] = new Coordinates(this.fitConf.getMolecule().getCoordinates(i));
            this.origCOM.add(this.cachedCoords[i]);
        }
        this.origCOM.scale(1.0 / (double)this.cachedCoords.length);
        this.dRdvi1 = new double[3][3];
        this.dRdvi2 = new double[3][3];
        this.dRdvi3 = new double[3][3];
        this.oAA = this.getFGValueShapeSelf(new double[3 * this.refMol.getAllAtoms()], this.shapeAlign.getRefMolGauss(), true);
        this.oAApp = this.getFGValueSelfPP(this.shapeAlign.getRefMolGauss(), true);
    }

    public void setInitialState() {
        int n = 6 + this.torsionHelper.getRotatableBonds().length;
        this.v = new double[n];
        this.v[0] = 0.0;
        this.v[1] = 0.0;
        this.v[2] = 0.0;
        Quaternion quaternion = new Quaternion(1.0, 0.0, 0.0, 0.0);
        ExponentialMap exponentialMap = new ExponentialMap(quaternion);
        this.v[3] = exponentialMap.getP().x;
        this.v[4] = exponentialMap.getP().y;
        this.v[5] = exponentialMap.getP().z;
        for (int i = 0; i < this.torsionHelper.getRotatableBonds().length; ++i) {
            int[] nArray = this.torsionHelper.getTorsionAtoms()[i];
            this.v[6 + i] = TorsionDB.calculateTorsionExtended(this.fitConf, nArray);
        }
    }

    private void resetLigCoordinates() {
        for (int i = 0; i < this.fitConf.getMolecule().getAllAtoms(); ++i) {
            this.fitConf.setX(i, this.origCoords[i].x);
            this.fitConf.setY(i, this.origCoords[i].y);
            this.fitConf.setZ(i, this.origCoords[i].z);
        }
    }

    public EvaluableFlexibleOverlap(EvaluableFlexibleOverlap evaluableFlexibleOverlap) {
        this.shapeAlign = evaluableFlexibleOverlap.shapeAlign;
        this.fitConf = evaluableFlexibleOverlap.fitConf;
        this.isHydrogen = evaluableFlexibleOverlap.isHydrogen;
        this.v = evaluableFlexibleOverlap.v;
        this.precalcPow = evaluableFlexibleOverlap.precalcPow;
        this.precalcExp = evaluableFlexibleOverlap.precalcExp;
        this.init();
    }

    @Override
    public void setState(double[] dArray) {
        assert (this.v.length == dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 5 && dArray[i] > Math.PI) {
                int n = i;
                dArray[n] = dArray[n] - Math.PI * 2;
            }
            this.v[i] = dArray[i];
        }
        this.updateLigandCoordinates();
        this.shapeAlign.getMolGauss().update(this.fitConf);
    }

    public double[] getState(double[] dArray) {
        for (int i = 0; i < this.v.length; ++i) {
            dArray[i] = this.v[i];
        }
        return dArray;
    }

    public void setE0(double d) {
        this.e0 = d;
    }

    @Override
    public double[] getState() {
        return this.getState(new double[this.v.length]);
    }

    public PheSAAlignment getAlignment() {
        return this.shapeAlign;
    }

    public void updateLigandCoordinates() {
        this.resetLigCoordinates();
        this.updateDihedralAngles();
        for (int i = 0; i < this.fitConf.getMolecule().getAllAtoms(); ++i) {
            this.cachedCoords[i] = new Coordinates(this.fitConf.getCoordinates(i));
        }
        ExponentialMap exponentialMap = new ExponentialMap(this.v[3], this.v[4], this.v[5]);
        Quaternion quaternion = exponentialMap.toQuaternion();
        Translation translation = new Translation(this.origCOM.scaleC(-1.0));
        Translation translation2 = new Translation(this.origCOM);
        Rotation rotation = new Rotation(quaternion.getRotMatrix().getArray());
        Translation translation3 = new Translation(this.v[0], this.v[1], this.v[2]);
        TransformationSequence transformationSequence = new TransformationSequence();
        transformationSequence.addTransformation(translation);
        transformationSequence.addTransformation(rotation);
        transformationSequence.addTransformation(translation2);
        transformationSequence.addTransformation(translation3);
        transformationSequence.apply(this.fitConf);
    }

    private void updateDihedralAngles() {
        for (int i = 0; i < this.torsionHelper.getRotatableBonds().length; ++i) {
            double d = this.v[6 + i];
            int[] nArray = this.torsionHelper.getTorsionAtoms()[i];
            double d2 = TorsionDB.calculateTorsionExtended(this.fitConf, nArray);
            double d3 = d - d2;
            this.torsionHelper.rotateAroundBond(i, d3, this.fitConf, false);
        }
    }

    @Override
    public double getFGValue(double[] dArray) {
        Object object;
        int n;
        int n2;
        double[] dArray2 = new double[this.fitConf.getMolecule().getAllAtoms() * 3];
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray3 = new double[dArray2.length];
        double[] dArray4 = new double[dArray2.length];
        double[] dArray5 = new double[dArray2.length];
        double d3 = this.getFGValueShapeSelf(dArray5, this.shapeAlign.getMolGauss(), false);
        double d4 = this.getFGValueShape(dArray3);
        double d5 = this.getFGValueSelfPP(this.shapeAlign.getMolGauss(), false);
        double d6 = this.getFGValuePP();
        this.ff.setState(this.getCartState());
        this.ff.addGradient(dArray4);
        d = this.ff.getTotalEnergy();
        double[] dArray6 = dArray5;
        double[] dArray7 = dArray3;
        double[] dArray8 = new double[dArray2.length];
        d2 = (1.0 - this.settings.getPpWeight()) * (d4 / (d3 + this.oAA - d4)) + this.settings.getPpWeight() * (d6 / (d5 + this.oAApp - d6));
        double d7 = d - this.e0;
        double d8 = d7 < 10.0 ? 0.0 : d7 - 10.0;
        double d9 = -d2 + 0.0625 * d8 * d8;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray8[i] = dArray6[i] - dArray7[i];
        }
        double[] dArray9 = new double[dArray2.length];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray9[n2] = (1.0 - this.settings.getPpWeight()) * dArray7[n2] * (1.0 / (this.oAA + d3 - d4)) - (1.0 - this.settings.getPpWeight()) * d4 * Math.pow(this.oAA + d3 - d4, -2.0) * dArray8[n2];
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray2[n2] = -dArray9[n2] + d8 * 2.0 * 0.0625 * dArray4[n2];
        }
        for (n2 = 0; n2 < this.fitConf.getMolecule().getAllAtoms(); ++n2) {
            dArray[0] = dArray[0] + dArray2[3 * n2];
            dArray[1] = dArray[1] + dArray2[3 * n2 + 1];
            dArray[2] = dArray[2] + dArray2[3 * n2 + 2];
        }
        double[] dArray10 = new double[]{this.v[3], this.v[4], this.v[5]};
        RotationDerivatives rotationDerivatives = new RotationDerivatives(dArray10);
        rotationDerivatives.dRdv(0, this.dRdvi1);
        rotationDerivatives.dRdv(1, this.dRdvi2);
        rotationDerivatives.dRdv(2, this.dRdvi3);
        for (n = 0; n < this.fitConf.getMolecule().getAllAtoms(); ++n) {
            object = this.cachedCoords[n];
            Coordinates coordinates = ((Coordinates)object).rotateC(this.dRdvi1);
            dArray[3] = dArray[3] + (dArray2[3 * n] * coordinates.x + dArray2[3 * n + 1] * coordinates.y + dArray2[3 * n + 2] * coordinates.z);
            coordinates = ((Coordinates)object).rotateC(this.dRdvi2);
            dArray[4] = dArray[4] + (dArray2[3 * n] * coordinates.x + dArray2[3 * n + 1] * coordinates.y + dArray2[3 * n + 2] * coordinates.z);
            coordinates = ((Coordinates)object).rotateC(this.dRdvi3);
            dArray[5] = dArray[5] + (dArray2[3 * n] * coordinates.x + dArray2[3 * n + 1] * coordinates.y + dArray2[3 * n + 2] * coordinates.z);
        }
        for (n = 0; n < this.torsionHelper.getRotatableBonds().length; ++n) {
            object = this.torsionHelper.getSmallerSideAtomLists()[n];
            int n3 = this.torsionHelper.getRotationCenters()[n];
            int n4 = this.torsionHelper.getTorsionAtoms()[n][1] == n3 ? this.torsionHelper.getTorsionAtoms()[n][2] : this.torsionHelper.getTorsionAtoms()[n][1];
            Coordinates coordinates = this.fitConf.getCoordinates(n4).subC(this.fitConf.getCoordinates(n3));
            for (Object object2 : object) {
                Coordinates coordinates2 = this.fitConf.getCoordinates((int)object2).subC(this.fitConf.getCoordinates(n3));
                Coordinates coordinates3 = coordinates.cross(coordinates2);
                int n5 = 6 + n;
                dArray[n5] = dArray[n5] + (coordinates3.x * dArray2[3 * object2] + coordinates3.y * dArray2[3 * object2 + 1] + coordinates3.z * dArray2[3 * object2 + 2]);
            }
        }
        return d9;
    }

    public double getFGValueShape(double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        int n;
        double d11;
        double d12;
        double d13;
        ShapeVolume shapeVolume = this.shapeAlign.getMolGauss();
        ShapeVolume shapeVolume2 = this.shapeAlign.getRefMolGauss();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        double d14 = 0.0;
        for (AtomicGaussian gaussian3D : shapeVolume2.getAtomicGaussians()) {
            d13 = gaussian3D.getCenter().x;
            d12 = gaussian3D.getCenter().y;
            d11 = gaussian3D.getCenter().z;
            for (AtomicGaussian atomicGaussian : shapeVolume.getAtomicGaussians()) {
                n = atomicGaussian.getAtomId();
                d10 = 0.0;
                d9 = this.fitConf.getX(n);
                d8 = this.fitConf.getY(n);
                d7 = this.fitConf.getZ(n);
                d6 = d13 - d9;
                d5 = d12 - d8;
                d4 = d11 - d7;
                d3 = d6 * d6 + d5 * d5 + d4 * d4;
                d2 = gaussian3D.getWidth() + atomicGaussian.getWidth();
                d = 0.0;
                if (d3 < 10.0 && (d10 = gaussian3D.getHeight() * atomicGaussian.getHeight() * QuickMathCalculator.getInstance().quickExp(-(gaussian3D.getWidth() * atomicGaussian.getWidth() * d3) / d2) * QuickMathCalculator.getInstance().getPrefactor(gaussian3D.getAtomicNo(), atomicGaussian.getAtomicNo())) > 0.0) {
                    d14 += d10;
                    d = d10 * -2.0 * gaussian3D.getWidth() * atomicGaussian.getWidth() / (gaussian3D.getWidth() + atomicGaussian.getWidth());
                }
                int n2 = 3 * n;
                dArray[n2] = dArray[n2] + (d9 - d13) * d;
                int n3 = 3 * n + 1;
                dArray[n3] = dArray[n3] + (d8 - d12) * d;
                int n4 = 3 * n + 2;
                dArray[n4] = dArray[n4] + (d7 - d11) * d;
            }
        }
        if (shapeVolume2 instanceof MolecularVolume) {
            for (VolumeGaussian volumeGaussian : ((MolecularVolume)shapeVolume2).getVolumeGaussians()) {
                d13 = volumeGaussian.getCenter().x;
                d12 = volumeGaussian.getCenter().y;
                d11 = volumeGaussian.getCenter().z;
                for (AtomicGaussian atomicGaussian : shapeVolume.getAtomicGaussians()) {
                    n = atomicGaussian.getAtomId();
                    d10 = 0.0;
                    d9 = this.v[3 * n];
                    d8 = this.v[3 * n + 1];
                    d7 = this.v[3 * n + 2];
                    d6 = d13 - d9;
                    d5 = d12 - d8;
                    d4 = d11 - d7;
                    d3 = d6 * d6 + d5 * d5 + d4 * d4;
                    d2 = volumeGaussian.getWidth() + atomicGaussian.getWidth();
                    d = 0.0;
                    if (d3 < 10.0 && Math.abs(d10 = (double)volumeGaussian.getRole() * volumeGaussian.getHeight() * atomicGaussian.getHeight() * QuickMathCalculator.getInstance().quickExp(-(volumeGaussian.getWidth() * atomicGaussian.getWidth() * d3) / d2) * QuickMathCalculator.getInstance().getPrefactor(volumeGaussian.getAtomicNo(), atomicGaussian.getAtomicNo())) > 0.0) {
                        d14 += d10;
                        d = d10 * -2.0 * volumeGaussian.getWidth() * atomicGaussian.getWidth() / (volumeGaussian.getWidth() + atomicGaussian.getWidth());
                    }
                    int n5 = 3 * n;
                    dArray[n5] = dArray[n5] + (d9 - d13) * d;
                    int n6 = 3 * n + 1;
                    dArray[n6] = dArray[n6] + (d8 - d12) * d;
                    int n7 = 3 * n + 2;
                    dArray[n7] = dArray[n7] + (d7 - d11) * d;
                }
            }
        }
        return d14;
    }

    public double getFGValuePP() {
        ShapeVolume shapeVolume = this.shapeAlign.getMolGauss();
        ShapeVolume shapeVolume2 = this.shapeAlign.getRefMolGauss();
        double d = 0.0;
        for (PPGaussian pPGaussian : shapeVolume2.getPPGaussians()) {
            double d2 = pPGaussian.getCenter().x;
            double d3 = pPGaussian.getCenter().y;
            double d4 = pPGaussian.getCenter().z;
            for (PPGaussian pPGaussian2 : shapeVolume.getPPGaussians()) {
                double d5 = 0.0;
                Coordinates coordinates = pPGaussian2.getCenter();
                double d6 = coordinates.x;
                double d7 = coordinates.y;
                double d8 = coordinates.z;
                double d9 = d2 - d6;
                double d10 = d3 - d7;
                double d11 = d4 - d8;
                double d12 = d9 * d9 + d10 * d10 + d11 * d11;
                double d13 = pPGaussian.getWidth() + pPGaussian2.getWidth();
                if (!(d12 < 10.0) || !((d5 = pPGaussian.getWeight() * pPGaussian.getHeight() * pPGaussian2.getHeight() * QuickMathCalculator.getInstance().quickExp(-(pPGaussian.getWidth() * pPGaussian2.getWidth() * d12) / d13) * QuickMathCalculator.getInstance().getPrefactor(pPGaussian.getAtomicNo(), pPGaussian2.getAtomicNo())) > 0.0)) continue;
                double d14 = pPGaussian.getInteractionSimilarity(pPGaussian2);
                d += (d5 *= d14);
            }
        }
        return d;
    }

    public double getFGValueShapeSelf(double[] dArray, ShapeVolume shapeVolume, boolean bl) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        double d = 0.0;
        for (AtomicGaussian gaussian3D : shapeVolume.getAtomicGaussians()) {
            for (AtomicGaussian atomicGaussian : shapeVolume.getAtomicGaussians()) {
                d += this.getGradientContributionSelf(gaussian3D, atomicGaussian, dArray, bl);
            }
            if (!(shapeVolume instanceof MolecularVolume)) continue;
            for (VolumeGaussian volumeGaussian : ((MolecularVolume)shapeVolume).getVolumeGaussians()) {
                d += this.getGradientContributionSelf(gaussian3D, volumeGaussian, dArray, bl);
            }
        }
        if (shapeVolume instanceof MolecularVolume) {
            for (VolumeGaussian volumeGaussian : ((MolecularVolume)shapeVolume).getVolumeGaussians()) {
                for (VolumeGaussian volumeGaussian2 : ((MolecularVolume)shapeVolume).getVolumeGaussians()) {
                    d += this.getGradientContributionSelf(volumeGaussian, volumeGaussian2, dArray, bl);
                }
            }
        }
        return d;
    }

    public double getGradientContributionSelf(Gaussian3D gaussian3D, Gaussian3D gaussian3D2, double[] dArray, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        int n = gaussian3D2.getAtomId();
        double d7 = 0.0;
        int n2 = gaussian3D.getAtomId();
        if (bl) {
            d6 = gaussian3D.getCenter().x;
            d5 = gaussian3D.getCenter().y;
            d4 = gaussian3D.getCenter().z;
        } else {
            d6 = this.fitConf.getX(n2);
            d5 = this.fitConf.getY(n2);
            d4 = this.fitConf.getZ(n2);
        }
        if (bl) {
            d3 = gaussian3D2.getCenter().x;
            d2 = gaussian3D2.getCenter().y;
            d = gaussian3D2.getCenter().z;
        } else {
            d3 = this.fitConf.getX(n);
            d2 = this.fitConf.getY(n);
            d = this.fitConf.getZ(n);
        }
        double d8 = d6 - d3;
        double d9 = d5 - d2;
        double d10 = d4 - d;
        double d11 = d8 * d8 + d9 * d9 + d10 * d10;
        double d12 = gaussian3D.getWidth() + gaussian3D2.getWidth();
        double d13 = 0.0;
        double d14 = 1.0;
        if (gaussian3D instanceof VolumeGaussian) {
            d14 *= (double)((VolumeGaussian)gaussian3D).getRole();
        }
        if (gaussian3D2 instanceof VolumeGaussian) {
            d14 *= (double)((VolumeGaussian)gaussian3D2).getRole();
        }
        if (d11 < 10.0 && (d7 = d14 * gaussian3D.getHeight() * gaussian3D2.getHeight() * QuickMathCalculator.getInstance().quickExp(-(gaussian3D.getWidth() * gaussian3D2.getWidth() * d11) / d12) * QuickMathCalculator.getInstance().getPrefactor(gaussian3D.getAtomicNo(), gaussian3D2.getAtomicNo())) > 0.0) {
            d13 = d7 * -2.0 * gaussian3D.getWidth() * gaussian3D2.getWidth() / (gaussian3D.getWidth() + gaussian3D2.getWidth());
        }
        int n3 = 3 * n;
        dArray[n3] = dArray[n3] + (2.0 * d3 - 2.0 * d6) * d13;
        int n4 = 3 * n + 1;
        dArray[n4] = dArray[n4] + (2.0 * d2 - 2.0 * d5) * d13;
        int n5 = 3 * n + 2;
        dArray[n5] = dArray[n5] + (2.0 * d - 2.0 * d4) * d13;
        return d7;
    }

    public double getFGValueSelfPP(ShapeVolume shapeVolume, boolean bl) {
        double d = 0.0;
        for (PPGaussian pPGaussian : shapeVolume.getPPGaussians()) {
            double d2;
            double d3;
            double d4;
            if (bl) {
                d4 = pPGaussian.getCenter().x;
                d3 = pPGaussian.getCenter().y;
                d2 = pPGaussian.getCenter().z;
            } else {
                d4 = pPGaussian.getCenter().x;
                d3 = pPGaussian.getCenter().y;
                d2 = pPGaussian.getCenter().z;
            }
            for (PPGaussian pPGaussian2 : shapeVolume.getPPGaussians()) {
                double d5;
                double d6;
                double d7;
                double d8 = 0.0;
                if (bl) {
                    d7 = pPGaussian2.getCenter().x;
                    d6 = pPGaussian2.getCenter().y;
                    d5 = pPGaussian2.getCenter().z;
                } else {
                    d7 = pPGaussian2.getCenter().x;
                    d6 = pPGaussian2.getCenter().y;
                    d5 = pPGaussian2.getCenter().z;
                }
                double d9 = d4 - d7;
                double d10 = d3 - d6;
                double d11 = d2 - d5;
                double d12 = d9 * d9 + d10 * d10 + d11 * d11;
                double d13 = pPGaussian2.getWidth() + pPGaussian2.getWidth();
                if (!(d12 < 10.0) || !((d8 = pPGaussian.getWeight() * pPGaussian.getHeight() * pPGaussian2.getHeight() * QuickMathCalculator.getInstance().quickExp(-(pPGaussian.getWidth() * pPGaussian2.getWidth() * d12) / d13) * QuickMathCalculator.getInstance().getPrefactor(pPGaussian.getAtomicNo(), pPGaussian2.getAtomicNo())) > 0.0)) continue;
                double d14 = pPGaussian.getInteractionSimilarity(pPGaussian2);
                d += (d8 *= d14);
            }
        }
        return d;
    }

    public double[] getCartState() {
        double[] dArray = new double[3 * this.fitConf.getMolecule().getAllAtoms()];
        for (int i = 0; i < this.fitConf.getMolecule().getAllAtoms(); ++i) {
            dArray[3 * i] = this.fitConf.getCoordinates((int)i).x;
            dArray[3 * i + 1] = this.fitConf.getCoordinates((int)i).y;
            dArray[3 * i + 2] = this.fitConf.getCoordinates((int)i).z;
        }
        return dArray;
    }

    public Conformer getFitConf() {
        return this.fitConf;
    }

    public EvaluableFlexibleOverlap clone() {
        return new EvaluableFlexibleOverlap(this);
    }
}

