/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.Scaling;
import com.actelion.research.chem.alignment3d.transformation.Transformation;

public interface IPharmacophorePoint {
    public Coordinates getCenter();

    public void updateCoordinates(Coordinates[] var1);

    public Coordinates getDirectionality();

    public Coordinates getRotatedDirectionality(double[][] var1, double var2);

    public String encode();

    public double getSimilarity(IPharmacophorePoint var1);

    public int getCenterID();

    public void setCenterID(int var1);

    public void setDirectionality(Coordinates var1);

    public void updateAtomIndeces(int[] var1);

    public IPharmacophorePoint copyPharmacophorePoint();

    public void getDirectionalityDerivativeCartesian(double[] var1, double[] var2, Coordinates var3, double var4);

    public int getFunctionalityIndex();

    default public void applyTransformation(Transformation transformation) {
        transformation.apply(this.getCenter());
        if (transformation instanceof Rotation) {
            Rotation rotation = (Rotation)transformation;
            Coordinates coordinates = this.getRotatedDirectionality(rotation.getRotation(), 1.0);
            this.setDirectionality(coordinates);
        } else if (transformation instanceof Scaling) {
            Scaling scaling = (Scaling)transformation;
            double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
            Coordinates coordinates = this.getRotatedDirectionality(dArrayArray, scaling.getScalingFactor());
            this.setDirectionality(coordinates);
        }
    }

    default public double getVectorSimilarity(IPharmacophorePoint iPharmacophorePoint, Coordinates coordinates) {
        double d = 0.0;
        d = this.getDirectionality().dot(coordinates);
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    default public double getVectorSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        return this.getVectorSimilarity(iPharmacophorePoint, iPharmacophorePoint.getDirectionality());
    }

    public static enum Functionality {
        ACCEPTOR(0),
        DONOR(1),
        NEG_CHARGE(2),
        POS_CHARGE(3),
        AROM_RING(6),
        EXIT_VECTOR(7);

        private final int index;

        private Functionality(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

