/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;

public class DonorPoint
implements IPharmacophorePoint {
    private int donorAtom;
    private int donorHydrogen;
    private Coordinates directionality;
    private int interactionClass;
    private Coordinates center;

    public DonorPoint(StereoMolecule stereoMolecule, int n, int n2, int n3) {
        this.donorAtom = n;
        this.donorHydrogen = n2;
        this.interactionClass = n3;
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    private DonorPoint(String string, StereoMolecule stereoMolecule) {
        this.decode(string, stereoMolecule);
    }

    public DonorPoint(DonorPoint donorPoint) {
        this.donorAtom = donorPoint.donorAtom;
        this.donorHydrogen = donorPoint.donorHydrogen;
        this.directionality = new Coordinates(donorPoint.directionality);
        this.interactionClass = donorPoint.interactionClass;
        this.center = new Coordinates(donorPoint.center);
    }

    public static DonorPoint fromString(String string, StereoMolecule stereoMolecule) {
        return new DonorPoint(string, stereoMolecule);
    }

    @Override
    public void updateCoordinates(Coordinates[] coordinatesArray) {
        this.center = new Coordinates(coordinatesArray[this.donorHydrogen].x, coordinatesArray[this.donorHydrogen].y, coordinatesArray[this.donorHydrogen].z);
        this.directionality = coordinatesArray[this.donorHydrogen].subC(coordinatesArray[this.donorAtom]);
        this.directionality.scale(1.0 / this.directionality.getLength());
    }

    @Override
    public Coordinates getCenter() {
        return this.center;
    }

    @Override
    public Coordinates getDirectionality() {
        return this.directionality;
    }

    @Override
    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("d");
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.donorAtom));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.donorHydrogen));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.interactionClass));
        return stringBuilder.toString();
    }

    private void decode(String string, StereoMolecule stereoMolecule) {
        String[] stringArray = string.split(" ");
        this.donorAtom = Integer.decode(stringArray[1]);
        this.donorHydrogen = Integer.decode(stringArray[2]);
        this.interactionClass = Integer.decode(stringArray[3]);
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    @Override
    public double getSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        if (iPharmacophorePoint instanceof DonorPoint) {
            return 1.0;
        }
        return 0.0;
    }

    public int getInteractionClass() {
        return this.interactionClass;
    }

    @Override
    public int getCenterID() {
        return this.donorHydrogen;
    }

    @Override
    public void setCenterID(int n) {
        this.donorHydrogen = n;
    }

    @Override
    public void setDirectionality(Coordinates coordinates) {
        this.directionality = coordinates;
    }

    @Override
    public void updateAtomIndeces(int[] nArray) {
        this.donorAtom = nArray[this.donorAtom];
        this.donorHydrogen = nArray[this.donorHydrogen];
    }

    @Override
    public IPharmacophorePoint copyPharmacophorePoint() {
        return new DonorPoint(this);
    }

    @Override
    public Coordinates getRotatedDirectionality(double[][] dArray, double d) {
        Coordinates coordinates = new Coordinates();
        coordinates = this.directionality.rotateC(dArray);
        coordinates.scale(d);
        return coordinates;
    }

    @Override
    public void getDirectionalityDerivativeCartesian(double[] dArray, double[] dArray2, Coordinates coordinates, double d) {
        dArray[3 * this.donorHydrogen] = d * coordinates.x / 3.0;
        dArray[3 * this.donorHydrogen + 1] = d * coordinates.y / 3.0;
        dArray[3 * this.donorHydrogen + 2] = d * coordinates.z / 3.0;
        dArray[3 * this.donorAtom] = d * -coordinates.x / 3.0;
        dArray[3 * this.donorAtom + 1] = d * -coordinates.y / 3.0;
        dArray[3 * this.donorAtom + 2] = d * -coordinates.z / 3.0;
    }

    @Override
    public int getFunctionalityIndex() {
        return IPharmacophorePoint.Functionality.DONOR.getIndex();
    }
}

