/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import java.util.ArrayList;
import java.util.List;

public class ChargePoint
implements IPharmacophorePoint {
    private int chargeAtom;
    private List<Integer> neighbours;
    private int charge;
    private Coordinates center;
    private static final Coordinates directionality = new Coordinates(1.0, 0.0, 0.0);

    public ChargePoint(StereoMolecule stereoMolecule, int n, List<Integer> list, int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("charge should not be 0 ");
        }
        this.chargeAtom = n;
        this.neighbours = list;
        this.charge = n2;
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    public ChargePoint(ChargePoint chargePoint) {
        this.chargeAtom = chargePoint.chargeAtom;
        this.charge = chargePoint.charge;
        this.center = new Coordinates(chargePoint.center);
        this.neighbours = new ArrayList<Integer>();
        for (int n : chargePoint.neighbours) {
            this.neighbours.add(n);
        }
    }

    @Override
    public Coordinates getCenter() {
        return this.center;
    }

    @Override
    public void updateCoordinates(Coordinates[] coordinatesArray) {
        Coordinates coordinates = new Coordinates(coordinatesArray[this.chargeAtom]);
        if (this.neighbours != null) {
            for (int n : this.neighbours) {
                coordinates.add(coordinatesArray[n]);
            }
            coordinates.scale(1.0 / (double)(this.neighbours.size() + 1));
        }
        this.center = coordinates;
    }

    @Override
    public Coordinates getDirectionality() {
        return directionality;
    }

    @Override
    public Coordinates getRotatedDirectionality(double[][] dArray, double d) {
        Coordinates coordinates = new Coordinates(directionality);
        return coordinates;
    }

    private ChargePoint(String string, StereoMolecule stereoMolecule) {
        this.decode(string, stereoMolecule);
    }

    public static ChargePoint fromString(String string, StereoMolecule stereoMolecule) {
        return new ChargePoint(string, stereoMolecule);
    }

    private void decode(String string, StereoMolecule stereoMolecule) {
        String[] stringArray = string.split(" ");
        this.chargeAtom = Integer.decode(stringArray[1]);
        this.charge = Integer.decode(stringArray[2]);
        this.neighbours = new ArrayList<Integer>();
        for (int i = 3; i < stringArray.length; ++i) {
            this.neighbours.add(Integer.decode(stringArray[i]));
        }
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    @Override
    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("i");
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.chargeAtom));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.charge));
        stringBuilder.append(" ");
        for (Integer n : this.neighbours) {
            stringBuilder.append(n);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    @Override
    public double getSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        double d = 0.0;
        if (iPharmacophorePoint instanceof ChargePoint) {
            d = this.charge * ((ChargePoint)iPharmacophorePoint).charge > 0 ? 1.0 : 0.0;
        }
        return d;
    }

    @Override
    public int getCenterID() {
        return this.chargeAtom;
    }

    @Override
    public void setCenterID(int n) {
        this.chargeAtom = n;
    }

    @Override
    public void setDirectionality(Coordinates coordinates) {
    }

    public int getCharge() {
        return this.charge;
    }

    @Override
    public void updateAtomIndeces(int[] nArray) {
        this.chargeAtom = nArray[this.chargeAtom];
        for (int i = 0; i < this.neighbours.size(); ++i) {
            int n = nArray[this.neighbours.get(i)];
            this.neighbours.set(i, n);
        }
    }

    @Override
    public IPharmacophorePoint copyPharmacophorePoint() {
        return new ChargePoint(this);
    }

    @Override
    public void getDirectionalityDerivativeCartesian(double[] dArray, double[] dArray2, Coordinates coordinates, double d) {
    }

    @Override
    public double getVectorSimilarity(IPharmacophorePoint iPharmacophorePoint, Coordinates coordinates) {
        return 1.0;
    }

    @Override
    public double getVectorSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        return 1.0;
    }

    @Override
    public int getFunctionalityIndex() {
        if (this.charge < 0) {
            return IPharmacophorePoint.Functionality.NEG_CHARGE.getIndex();
        }
        return IPharmacophorePoint.Functionality.POS_CHARGE.getIndex();
    }

    public int getChargeAtom() {
        return this.chargeAtom;
    }

    public void setChargeAtom(int n) {
        this.chargeAtom = n;
    }

    public List<Integer> getNeighbours() {
        return this.neighbours;
    }

    public void setNeighbours(List<Integer> list) {
        this.neighbours = list;
    }
}

