/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.chem.phesa.pharmacophore.pp.AcceptorPoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.AromRingPoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.DonorPoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class PharmacophoreCalculator {
    public static final int ACCEPTOR_ID = 0;
    public static final int DONOR_ID = 1;
    public static final int CHARGE_NEG_ID = 2;
    public static final int CHARGE_POS_ID = 3;
    public static final int AROM_ID = 4;
    public static final int LIPO_ID = 5;
    public static final int AROM_RING_ID = 6;
    public static final int EXIT_VECTOR_ID = 7;
    public static final int MAX_ID = 7;

    private PharmacophoreCalculator() {
    }

    public static List<IPharmacophorePoint> getPharmacophorePoints(StereoMolecule stereoMolecule) {
        int n;
        ArrayList<IPharmacophorePoint> arrayList = new ArrayList<IPharmacophorePoint>();
        RingCollection ringCollection = stereoMolecule.getRingSet();
        for (n = 0; n < ringCollection.getSize(); ++n) {
            if (!ringCollection.isAromatic(n)) continue;
            int[] nArray = ringCollection.getRingAtoms(n);
            AromRingPoint aromRingPoint = new AromRingPoint(stereoMolecule, nArray[0], Arrays.stream(nArray).boxed().collect(Collectors.toList()));
            arrayList.add(aromRingPoint);
        }
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            int n2;
            int n3;
            if (stereoMolecule.getAtomicNo(n) == 1) {
                int n4;
                if (!PharmacophoreCalculator.isDonorHydrogen(stereoMolecule, n) || (n4 = InteractionAtomTypeCalculator.getAtomType(stereoMolecule, n3 = stereoMolecule.getConnAtom(n, 0))) < 0) continue;
                DonorPoint donorPoint = new DonorPoint(stereoMolecule, n3, n, n4);
                arrayList.add(donorPoint);
                continue;
            }
            if (stereoMolecule.getAtomicNo(n) != 7 && stereoMolecule.getAtomicNo(n) != 8 || !PharmacophoreCalculator.isAcceptor(stereoMolecule, n)) continue;
            n3 = stereoMolecule.getAllConnAtoms(n);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(stereoMolecule.getConnAtom(n, n2));
            }
            n2 = InteractionAtomTypeCalculator.getAtomType(stereoMolecule, n);
            if (n2 < 0) continue;
            if (stereoMolecule.getAtomicNo(n) == 8 && n3 == 1 && (stereoMolecule.getConnBondOrder(n, 0) == 2 || AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, n) || stereoMolecule.getAtomCharge(n) == -1)) {
                int n5 = stereoMolecule.getConnAtom(n, 0);
                if (stereoMolecule.getConnAtoms(n5) <= 1) continue;
                if (stereoMolecule.getAtomicNo(n5) != 16 && stereoMolecule.getAtomicNo(n5) != 15) {
                    int n6 = stereoMolecule.getConnAtom(n5, 0);
                    if (n6 == n) {
                        n6 = stereoMolecule.getConnAtom(n5, 1);
                    }
                    arrayList2.add(n6);
                    AcceptorPoint acceptorPoint = new AcceptorPoint(stereoMolecule, n, arrayList2, n2, 1);
                    arrayList.add(acceptorPoint);
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        int n7 = (Integer)iterator.next();
                        arrayList3.add(n7);
                    }
                    acceptorPoint = new AcceptorPoint(stereoMolecule, n, arrayList3, n2, 2);
                    arrayList.add(acceptorPoint);
                    continue;
                }
                AcceptorPoint acceptorPoint = new AcceptorPoint(stereoMolecule, n, arrayList2, n2);
                arrayList.add(acceptorPoint);
                continue;
            }
            if (arrayList2.size() == 0) continue;
            AcceptorPoint acceptorPoint = new AcceptorPoint(stereoMolecule, n, arrayList2, n2);
            arrayList.add(acceptorPoint);
        }
        return arrayList;
    }

    public static boolean isAcceptor(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) == 7 || stereoMolecule.getAtomicNo(n) == 8) {
            if (stereoMolecule.getAtomCharge(n) <= 0) {
                if (stereoMolecule.isAromaticAtom(n)) {
                    return stereoMolecule.getAllConnAtoms(n) < 3;
                }
                if (stereoMolecule.getAtomicNo(n) == 7) {
                    if (stereoMolecule.getConnAtoms(n) == 1 && stereoMolecule.getConnBondOrder(n, 0) == 3) {
                        return true;
                    }
                    if (stereoMolecule.isFlatNitrogen(n)) {
                        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
                            if (stereoMolecule.getConnBondOrder(n, i) <= 1) continue;
                            return true;
                        }
                        return false;
                    }
                    for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
                        int n2 = stereoMolecule.getConnAtom(n, i);
                        if (stereoMolecule.getAtomicNo(n2) != 6) continue;
                        for (int j = 0; j < stereoMolecule.getAllConnAtoms(n2); ++j) {
                            int n3 = stereoMolecule.getConnAtom(n2, j);
                            if (n == n3 || stereoMolecule.getBondOrder(stereoMolecule.getBond(n2, n3)) != 2) continue;
                            if (stereoMolecule.getAtomicNo(n3) == 7) {
                                return false;
                            }
                            if (stereoMolecule.getAtomicNo(n3) == 8) {
                                return false;
                            }
                            if (stereoMolecule.getAtomicNo(n3) != 16) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isDonorHydrogen(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) == 1) {
            int n2 = stereoMolecule.getConnAtom(n, 0);
            return stereoMolecule.getAtomCharge(n2) >= 0 && (stereoMolecule.getAtomicNo(n2) == 7 || stereoMolecule.getAtomicNo(n2) == 8);
        }
        return false;
    }

    public static boolean isDonorHeavyAtom(StereoMolecule stereoMolecule, int n) {
        boolean bl = false;
        if ((stereoMolecule.getAtomicNo(n) == 7 || stereoMolecule.getAtomicNo(n) == 8) && stereoMolecule.getAtomCharge(n) >= 0 && stereoMolecule.getAllHydrogens(n) > 0) {
            bl = true;
        }
        return bl;
    }
}

