/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.SingularValueDecomposition;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.phesa.AtomicGaussian;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesa.pharmacophore.pp.ExitVectorPoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.PPGaussian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ShapeVolume {
    protected List<PPGaussian> ppGaussians;
    protected List<AtomicGaussian> atomicGaussians;
    protected Coordinates com;

    public ShapeVolume() {
        this.ppGaussians = new ArrayList<PPGaussian>();
        this.atomicGaussians = new ArrayList<AtomicGaussian>();
    }

    public ShapeVolume(ShapeVolume shapeVolume) {
        this.atomicGaussians = new ArrayList<AtomicGaussian>();
        this.ppGaussians = new ArrayList<PPGaussian>();
        for (AtomicGaussian gaussian3D : shapeVolume.getAtomicGaussians()) {
            this.atomicGaussians.add(new AtomicGaussian(gaussian3D));
        }
        for (PPGaussian pPGaussian : shapeVolume.getPPGaussians()) {
            this.ppGaussians.add(new PPGaussian(pPGaussian));
        }
        this.com = new Coordinates(shapeVolume.com);
    }

    public void addPharmacophorePoint(PPGaussian pPGaussian) {
        this.ppGaussians.add(pPGaussian);
    }

    public void addAtomVolume(AtomicGaussian atomicGaussian) {
        this.atomicGaussians.add(atomicGaussian);
    }

    public void update(StereoMolecule stereoMolecule) {
        this.updateCoordinates(this.getAtomicGaussians(), stereoMolecule.getAtomCoordinates());
        this.updateCoordinates(this.getPPGaussians(), stereoMolecule.getAtomCoordinates());
    }

    public void update(Conformer conformer) {
        this.updateCoordinates(this.getAtomicGaussians(), conformer.getCoordinates());
        this.updateCoordinates(this.getPPGaussians(), conformer.getCoordinates());
    }

    public void transform(Transformation transformation) {
        this.transformGaussians(transformation);
    }

    public Rotation preProcess(Conformer conformer) {
        Coordinates coordinates = this.getCOM();
        if (conformer != null) {
            int n = conformer.getSize();
            for (int i = 0; i < n; ++i) {
                Coordinates coordinates2 = conformer.getCoordinates(i);
                coordinates2.sub(coordinates);
            }
        }
        this.translateToCOM(coordinates);
        Matrix matrix = this.createCanonicalOrientation(conformer);
        Rotation rotation = new Rotation(matrix.getArray());
        return rotation;
    }

    public void removeRings() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        for (PPGaussian pPGaussian : this.ppGaussians) {
            if (pPGaussian.getPharmacophorePoint().getFunctionalityIndex() == 4) {
                arrayList.add(n);
            }
            ++n;
        }
        Collections.reverse(arrayList);
        Iterator<PPGaussian> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)((Object)iterator.next());
            this.ppGaussians.remove(n2);
        }
    }

    public Matrix createCanonicalOrientation(Conformer conformer) {
        Matrix matrix = this.getCovarianceMatrix();
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrix.getArray(), null, null);
        Matrix matrix2 = new Matrix(singularValueDecomposition.getU());
        double d = matrix2.det();
        if (d < 0.0) {
            matrix2.set(0, 1, -matrix2.get(0, 1));
            matrix2.set(1, 1, -matrix2.get(1, 1));
            matrix2.set(2, 1, -matrix2.get(2, 1));
        }
        Rotation rotation = new Rotation(matrix2.getArray());
        if (conformer != null) {
            rotation.apply(conformer);
            this.update(conformer);
        } else {
            this.transformGaussians(rotation);
        }
        if (!this.isCanonicalOrientation()) {
            if (conformer != null) {
                PheSAAlignment.rotateMolAroundAxis180(conformer, PheSAAlignment.axis.X);
                this.update(conformer);
            } else {
                this.rotate180DegreeAroundAxis(PheSAAlignment.axis.X);
            }
            if (this.isCanonicalOrientation()) {
                matrix2.set(0, 1, -matrix2.get(0, 1));
                matrix2.set(1, 1, -matrix2.get(1, 1));
                matrix2.set(2, 1, -matrix2.get(2, 1));
                matrix2.set(0, 2, -matrix2.get(0, 2));
                matrix2.set(1, 2, -matrix2.get(1, 2));
                matrix2.set(2, 2, -matrix2.get(2, 2));
            } else {
                if (conformer != null) {
                    PheSAAlignment.rotateMolAroundAxis180(conformer, PheSAAlignment.axis.X);
                    this.update(conformer);
                    PheSAAlignment.rotateMolAroundAxis180(conformer, PheSAAlignment.axis.Y);
                    this.update(conformer);
                } else {
                    this.rotate180DegreeAroundAxis(PheSAAlignment.axis.X);
                    this.rotate180DegreeAroundAxis(PheSAAlignment.axis.Y);
                }
                if (this.isCanonicalOrientation()) {
                    matrix2.set(0, 0, -matrix2.get(0, 0));
                    matrix2.set(1, 0, -matrix2.get(1, 0));
                    matrix2.set(2, 0, -matrix2.get(2, 0));
                    matrix2.set(0, 2, -matrix2.get(0, 2));
                    matrix2.set(1, 2, -matrix2.get(1, 2));
                    matrix2.set(2, 2, -matrix2.get(2, 2));
                } else {
                    if (conformer != null) {
                        PheSAAlignment.rotateMolAroundAxis180(conformer, PheSAAlignment.axis.Y);
                        this.update(conformer);
                        PheSAAlignment.rotateMolAroundAxis180(conformer, PheSAAlignment.axis.Z);
                        this.update(conformer);
                    } else {
                        this.rotate180DegreeAroundAxis(PheSAAlignment.axis.Y);
                        this.rotate180DegreeAroundAxis(PheSAAlignment.axis.Z);
                    }
                    if (this.isCanonicalOrientation()) {
                        matrix2.set(0, 0, -matrix2.get(0, 0));
                        matrix2.set(1, 0, -matrix2.get(1, 0));
                        matrix2.set(2, 0, -matrix2.get(2, 0));
                        matrix2.set(0, 1, -matrix2.get(0, 1));
                        matrix2.set(1, 1, -matrix2.get(1, 1));
                        matrix2.set(2, 1, -matrix2.get(2, 1));
                    }
                }
            }
        }
        return matrix2;
    }

    protected boolean isCanonicalOrientation() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (AtomicGaussian atomicGaussian : this.atomicGaussians) {
            double d5 = atomicGaussian.center.x;
            double d6 = atomicGaussian.center.y;
            if (d5 > 0.0) {
                d += d5 * d5;
                ++n;
            } else {
                d2 += d5 * d5;
                ++n2;
            }
            if (d6 > 0.0) {
                d3 += d6 * d6;
                ++n3;
                continue;
            }
            d4 += d6 * d6;
            ++n4;
        }
        return (d /= (double)n) > (d2 /= (double)n2) && (d3 /= (double)n3) > (d4 /= (double)n4);
    }

    public Coordinates getCOM() {
        this.calcCOM();
        return this.com;
    }

    public void calcCOM() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (AtomicGaussian atomicGaussian : this.atomicGaussians) {
            d += atomicGaussian.getVolume();
            d2 += atomicGaussian.getCenter().x * atomicGaussian.getVolume();
            d3 += atomicGaussian.getCenter().y * atomicGaussian.getVolume();
            d4 += atomicGaussian.getCenter().z * atomicGaussian.getVolume();
        }
        this.com = new Coordinates(d2 /= d, d3 /= d, d4 /= d);
    }

    protected void updateCoordinates(List<? extends Gaussian3D> list, Coordinates[] coordinatesArray) {
        for (Gaussian3D gaussian3D : list) {
            gaussian3D.updateCoordinates(coordinatesArray);
        }
    }

    protected void transformGaussians(Transformation transformation) {
        ShapeVolume.transformGaussians(this.atomicGaussians, transformation);
        ShapeVolume.transformGaussians(this.ppGaussians, transformation);
    }

    protected static void transformGaussians(List<? extends Gaussian3D> list, Transformation transformation) {
        for (Gaussian3D gaussian3D : list) {
            gaussian3D.transform(transformation);
        }
    }

    protected static void rotateGaussian(List<? extends Gaussian3D> list, double[][] dArray) {
        for (Gaussian3D gaussian3D : list) {
            Coordinates coordinates = new Coordinates(gaussian3D.getCenter());
            coordinates.rotate(dArray);
            gaussian3D.setCenter(coordinates);
        }
    }

    protected static void rotateGaussians180DegreeAroundAxis(List<? extends Gaussian3D> list, PheSAAlignment.axis axis2) {
        for (Gaussian3D gaussian3D : list) {
            Coordinates coordinates = new Coordinates(gaussian3D.getCenter());
            PheSAAlignment.rotateCoordsAroundAxis180(coordinates, axis2);
            gaussian3D.setCenter(coordinates);
        }
    }

    protected void rotate180DegreeAroundAxis(PheSAAlignment.axis axis2) {
        ShapeVolume.rotateGaussians180DegreeAroundAxis(this.atomicGaussians, axis2);
        ShapeVolume.rotateGaussians180DegreeAroundAxis(this.ppGaussians, axis2);
    }

    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toString(this.atomicGaussians.size()));
        stringBuilder.append("  ");
        this.atomicGaussians.forEach(atomicGaussian -> {
            stringBuilder.append(atomicGaussian.encode());
            stringBuilder.append("  ");
        });
        stringBuilder.append(Integer.toString(this.ppGaussians.size()));
        stringBuilder.append("  ");
        this.ppGaussians.forEach(pPGaussian -> {
            stringBuilder.append(pPGaussian.encode());
            stringBuilder.append("  ");
        });
        return stringBuilder.toString();
    }

    public static ShapeVolume decode(String string) {
        int n;
        String[] stringArray = string.split("  ");
        int n2 = Integer.decode(stringArray[0].trim());
        int n3 = 1;
        int n4 = 1 + n2;
        ArrayList<AtomicGaussian> arrayList = new ArrayList<AtomicGaussian>();
        ArrayList<PPGaussian> arrayList2 = new ArrayList<PPGaussian>();
        for (n = n3; n < n4; ++n) {
            arrayList.add(AtomicGaussian.fromString(stringArray[n].trim()));
        }
        n = Integer.decode(stringArray[n4]);
        n3 = n4 + 1;
        n4 = n3 + n;
        for (int i = n3; i < n4; ++i) {
            arrayList2.add(PPGaussian.fromString(stringArray[i], null));
        }
        ShapeVolume shapeVolume = new ShapeVolume();
        arrayList.forEach(atomicGaussian -> shapeVolume.addAtomVolume((AtomicGaussian)atomicGaussian));
        arrayList2.forEach(pPGaussian -> shapeVolume.addPharmacophorePoint((PPGaussian)pPGaussian));
        return shapeVolume;
    }

    public List<PPGaussian> getExitVectorGaussians() {
        return this.ppGaussians.stream().filter(pPGaussian -> pPGaussian.getPharmacophorePoint() instanceof ExitVectorPoint).collect(Collectors.toList());
    }

    public List<PPGaussian> getPPGaussians() {
        return this.ppGaussians;
    }

    public void setPPGaussians(List<PPGaussian> list) {
        this.ppGaussians = list;
    }

    public List<AtomicGaussian> getAtomicGaussians() {
        return this.atomicGaussians;
    }

    public void setAtomicGaussians(List<AtomicGaussian> list) {
        this.atomicGaussians = list;
    }

    public Matrix getCovarianceMatrix() {
        Matrix matrix = new Matrix(3, 3);
        double d = 0.0;
        for (AtomicGaussian atomicGaussian : this.atomicGaussians) {
            d += atomicGaussian.getVolume();
            double d2 = atomicGaussian.getVolume() * atomicGaussian.getCenter().x * atomicGaussian.getCenter().x;
            matrix.addToElement(0, 0, d2);
            d2 = atomicGaussian.getVolume() * atomicGaussian.getCenter().x * atomicGaussian.getCenter().y;
            matrix.addToElement(0, 1, d2);
            d2 = atomicGaussian.getVolume() * atomicGaussian.getCenter().x * atomicGaussian.getCenter().z;
            matrix.addToElement(0, 2, d2);
            d2 = atomicGaussian.getVolume() * atomicGaussian.getCenter().y * atomicGaussian.getCenter().y;
            matrix.addToElement(1, 1, d2);
            d2 = atomicGaussian.getVolume() * atomicGaussian.getCenter().y * atomicGaussian.getCenter().z;
            matrix.addToElement(1, 2, d2);
            d2 = atomicGaussian.getVolume() * atomicGaussian.getCenter().z * atomicGaussian.getCenter().z;
            matrix.addToElement(2, 2, d2);
        }
        matrix.set(0, 0, matrix.get(0, 0) / d);
        matrix.set(0, 1, matrix.get(0, 1) / d);
        matrix.set(0, 2, matrix.get(0, 2) / d);
        matrix.set(1, 1, matrix.get(1, 1) / d);
        matrix.set(1, 2, matrix.get(1, 2) / d);
        matrix.set(2, 2, matrix.get(2, 2) / d);
        matrix.set(1, 0, matrix.get(0, 1));
        matrix.set(2, 0, matrix.get(0, 2));
        matrix.set(2, 1, matrix.get(1, 2));
        return matrix;
    }

    public double getSelfAtomOverlap() {
        double d = 0.0;
        for (AtomicGaussian atomicGaussian : this.atomicGaussians) {
            for (AtomicGaussian atomicGaussian2 : this.atomicGaussians) {
                d += atomicGaussian.getVolumeOverlap(atomicGaussian2);
            }
        }
        return d;
    }

    public double getSelfPPOverlap() {
        double d = 0.0;
        for (PPGaussian pPGaussian : this.ppGaussians) {
            for (PPGaussian pPGaussian2 : this.ppGaussians) {
                d += pPGaussian.getWeight() * pPGaussian.getSimilarity(pPGaussian2) * pPGaussian.getVolumeOverlap(pPGaussian2);
            }
        }
        return d;
    }

    public double[] getTotalAtomOverlap(double[] dArray, ShapeVolume shapeVolume) {
        double[] dArray2 = new double[2];
        ExponentialMap exponentialMap = new ExponentialMap(dArray[0], dArray[1], dArray[2]);
        double d = 0.0;
        double d2 = 0.0;
        Coordinates coordinates = shapeVolume.getCOM();
        double[][] dArray3 = exponentialMap.toQuaternion().getRotMatrix().getArray();
        List<AtomicGaussian> list = shapeVolume.atomicGaussians;
        Coordinates[] coordinatesArray = new Coordinates[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Coordinates object = new Coordinates(list.get(i).getCenter());
            object.sub(coordinates);
            object.rotate(dArray3);
            object.add(coordinates);
            object.x += dArray[3];
            object.y += dArray[4];
            object.z += dArray[5];
            coordinatesArray[i] = object;
        }
        for (AtomicGaussian atomicGaussian : this.atomicGaussians) {
            int n = 0;
            for (AtomicGaussian atomicGaussian2 : shapeVolume.atomicGaussians) {
                d += atomicGaussian.getVolumeOverlap(atomicGaussian2, coordinatesArray[n], 10.0);
                ++n;
            }
        }
        if (d < 0.0) {
            d = 0.0;
        }
        dArray2[0] = d;
        dArray2[1] = d2;
        return dArray2;
    }

    public double getTotalPPOverlap(double[] dArray, ShapeVolume shapeVolume) {
        ExponentialMap exponentialMap = new ExponentialMap(dArray[0], dArray[1], dArray[2]);
        double d = 0.0;
        Coordinates coordinates = shapeVolume.getCOM();
        double[][] dArray2 = exponentialMap.toQuaternion().getRotMatrix().getArray();
        List<PPGaussian> list = shapeVolume.ppGaussians;
        Coordinates[] coordinatesArray = new Coordinates[list.size()];
        Coordinates[] coordinatesArray2 = new Coordinates[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Coordinates object = new Coordinates(list.get(i).getCenter());
            object.sub(coordinates);
            object.rotate(dArray2);
            object.add(coordinates);
            object.x += dArray[3];
            object.y += dArray[4];
            object.z += dArray[5];
            coordinatesArray[i] = object;
            coordinatesArray2[i] = list.get(i).getRotatedDirectionality(dArray2, 1.0);
        }
        for (PPGaussian pPGaussian : this.ppGaussians) {
            int n = 0;
            for (PPGaussian pPGaussian2 : shapeVolume.ppGaussians) {
                d += pPGaussian.getWeight() * pPGaussian.getSimilarity(pPGaussian2, coordinatesArray2[n]) * pPGaussian.getVolumeOverlap(pPGaussian2, coordinatesArray[n], 10.0);
                ++n;
            }
        }
        return d;
    }

    public void translateToCOM(Coordinates coordinates) {
        for (AtomicGaussian gaussian3D : this.getAtomicGaussians()) {
            gaussian3D.getCenter().sub(coordinates);
        }
        for (PPGaussian pPGaussian : this.getPPGaussians()) {
            pPGaussian.getCenter().sub(coordinates);
        }
        this.calcCOM();
    }
}

