/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.chem.PeriodicTable;

public class QuickMathCalculator {
    private double[] precalcExp;
    private double[][] precalcPrefactors;
    private static QuickMathCalculator sInstance;

    private QuickMathCalculator() {
        this.precalculatePrefactors();
        this.precalculateExp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QuickMathCalculator getInstance() {
        if (sInstance != null) return sInstance;
        Class<QuickMathCalculator> clazz = QuickMathCalculator.class;
        synchronized (QuickMathCalculator.class) {
            if (sInstance != null) return sInstance;
            sInstance = new QuickMathCalculator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void precalculatePrefactors() {
        this.precalcPrefactors = new double[54][54];
        for (int i = 1; i < 54; ++i) {
            for (int j = 1; j < 54; ++j) {
                double d = PeriodicTable.getElement(i).getVDWRadius();
                double d2 = PeriodicTable.getElement(j).getVDWRadius();
                double d3 = 2.41798793102 / (d * d) + 2.41798793102 / (d2 * d2);
                this.precalcPrefactors[i][j] = Math.pow(Math.PI / d3, 1.5);
            }
        }
    }

    private void precalculateExp() {
        this.precalcExp = new double[1000];
        for (int i = 0; i < 1000; ++i) {
            this.precalcExp[i] = Math.exp((double)(-i) * 0.01);
        }
    }

    public double quickExp(double d) {
        int n = -1 * (int)(d * 100.0);
        double d2 = this.precalcExp[n];
        double d3 = this.precalcExp[n + 1];
        double d4 = -d * 100.0 - (double)n;
        double d5 = d2 + d4 * (d3 - d2);
        return d5;
    }

    public double getPrefactor(int n, int n2) {
        return this.precalcPrefactors[n][n2];
    }
}

