/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.MolecularVolume;
import java.util.ArrayList;

public class PheSAMolecule {
    private StereoMolecule mol;
    private ArrayList<MolecularVolume> shape;

    public PheSAMolecule() {
        this.mol = new StereoMolecule();
        this.shape = new ArrayList();
    }

    public PheSAMolecule(StereoMolecule stereoMolecule, MolecularVolume molecularVolume) {
        this.mol = stereoMolecule;
        this.shape = new ArrayList();
        this.shape.add(molecularVolume);
    }

    public PheSAMolecule(StereoMolecule stereoMolecule, ArrayList<MolecularVolume> arrayList) {
        this.mol = stereoMolecule;
        this.shape = arrayList;
    }

    public StereoMolecule getConformer(MolecularVolume molecularVolume) {
        int n = this.mol.getAllAtoms();
        StereoMolecule stereoMolecule = new StereoMolecule(this.mol);
        int n2 = 0;
        ArrayList<Coordinates> arrayList = molecularVolume.getHydrogens();
        for (int i = 0; i < n; ++i) {
            if (this.mol.getAtomicNo(i) == 1) {
                stereoMolecule.getCoordinates(i).set(arrayList.get(n2));
                ++n2;
            }
            for (int j = 0; j < molecularVolume.getAtomicGaussians().size(); ++j) {
                int n3 = molecularVolume.getAtomicGaussians().get(j).getAtomId();
                stereoMolecule.getCoordinates(n3).set(molecularVolume.getAtomicGaussians().get(j).getCenter());
            }
        }
        stereoMolecule.ensureHelperArrays(1);
        return stereoMolecule;
    }

    public StereoMolecule getConformer(int n) {
        return this.getConformer(this.shape.get(n));
    }

    public StereoMolecule getMolecule() {
        return this.mol;
    }

    public ArrayList<MolecularVolume> getVolumes() {
        return this.shape;
    }
}

