/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.calc.Matrix;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.phesa.AtomicGaussian;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesa.ShapeVolume;
import com.actelion.research.chem.phesa.VolumeGaussian;
import com.actelion.research.chem.phesa.pharmacophore.IonizableGroupDetector;
import com.actelion.research.chem.phesa.pharmacophore.PharmacophoreCalculator;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.PPGaussian;
import com.actelion.research.util.EncoderFloatingPointNumbers;
import java.util.ArrayList;
import java.util.List;

public class MolecularVolume
extends ShapeVolume {
    public static final double p = 2.82842712475;
    public static final double alpha_pref = 2.41798793102;
    private ArrayList<VolumeGaussian> volumeGaussians;
    private ArrayList<Coordinates> hydrogens;

    public MolecularVolume(List<AtomicGaussian> list, List<PPGaussian> list2, List<VolumeGaussian> list3, List<Coordinates> list4) {
        this.atomicGaussians = new ArrayList();
        for (AtomicGaussian object : list) {
            this.atomicGaussians.add(new AtomicGaussian(object));
        }
        this.ppGaussians = new ArrayList();
        for (PPGaussian pPGaussian : list2) {
            this.ppGaussians.add(new PPGaussian(pPGaussian));
        }
        this.hydrogens = new ArrayList();
        for (Coordinates coordinates : list4) {
            this.hydrogens.add(coordinates);
        }
        this.volumeGaussians = new ArrayList();
        for (VolumeGaussian volumeGaussian : list3) {
            this.volumeGaussians.add(new VolumeGaussian(volumeGaussian));
        }
        this.calcCOM();
    }

    public void updateCOM() {
        this.calcCOM();
    }

    private void updateAtomIndeces(List<? extends Gaussian3D> list, int[] nArray) {
        for (Gaussian3D gaussian3D : list) {
            gaussian3D.updateAtomIndeces(nArray);
        }
    }

    public void updateAtomIndeces(int[] nArray) {
        this.updateAtomIndeces(this.ppGaussians, nArray);
        this.updateAtomIndeces(this.atomicGaussians, nArray);
        this.updateAtomIndeces(this.volumeGaussians, nArray);
    }

    public MolecularVolume(StereoMolecule stereoMolecule) {
        this.hydrogens = new ArrayList();
        this.volumeGaussians = new ArrayList();
        this.calc(stereoMolecule);
        this.calcPPVolume(stereoMolecule);
        this.calcCOM();
    }

    public MolecularVolume(MolecularVolume molecularVolume, Conformer conformer) {
        this(molecularVolume);
        this.update(conformer);
    }

    public MolecularVolume(MolecularVolume molecularVolume) {
        this.atomicGaussians = new ArrayList();
        this.ppGaussians = new ArrayList();
        this.volumeGaussians = new ArrayList();
        for (AtomicGaussian object : molecularVolume.getAtomicGaussians()) {
            this.atomicGaussians.add(new AtomicGaussian(object));
        }
        for (PPGaussian pPGaussian : molecularVolume.getPPGaussians()) {
            this.ppGaussians.add(new PPGaussian(pPGaussian));
        }
        this.hydrogens = new ArrayList();
        for (Coordinates coordinates : molecularVolume.hydrogens) {
            this.hydrogens.add(new Coordinates(coordinates));
        }
        for (VolumeGaussian volumeGaussian : molecularVolume.volumeGaussians) {
            this.volumeGaussians.add(new VolumeGaussian(volumeGaussian));
        }
        this.com = new Coordinates(molecularVolume.com);
    }

    @Override
    public double getSelfAtomOverlap() {
        double d = 0.0;
        for (AtomicGaussian gaussian3D : this.atomicGaussians) {
            for (AtomicGaussian atomicGaussian : this.atomicGaussians) {
                d += gaussian3D.getVolumeOverlap(atomicGaussian);
            }
            for (VolumeGaussian volumeGaussian : this.volumeGaussians) {
                if (volumeGaussian.getRole() != 1) continue;
                d += (double)volumeGaussian.getRole() * gaussian3D.getVolumeOverlap(volumeGaussian);
            }
        }
        for (VolumeGaussian volumeGaussian : this.volumeGaussians) {
            if (volumeGaussian.getRole() != 1) continue;
            for (VolumeGaussian volumeGaussian2 : this.volumeGaussians) {
                if (volumeGaussian2.getRole() != 1) continue;
                d += volumeGaussian2.getVolumeOverlap(volumeGaussian);
            }
        }
        return d;
    }

    public double[] getTotalAtomOverlap(double[] dArray, MolecularVolume molecularVolume) {
        int n;
        double[] dArray2 = new double[2];
        ExponentialMap exponentialMap = new ExponentialMap(dArray[0], dArray[1], dArray[2]);
        double d = 0.0;
        double d2 = 0.0;
        Coordinates coordinates = molecularVolume.getCOM();
        double[][] dArray3 = exponentialMap.toQuaternion().getRotMatrix().getArray();
        List list = molecularVolume.atomicGaussians;
        Coordinates[] coordinatesArray = new Coordinates[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Coordinates object = new Coordinates(((AtomicGaussian)list.get(i)).getCenter());
            object.sub(coordinates);
            object.rotate(dArray3);
            object.add(coordinates);
            object.x += dArray[3];
            object.y += dArray[4];
            object.z += dArray[5];
            coordinatesArray[i] = object;
        }
        for (AtomicGaussian atomicGaussian : this.atomicGaussians) {
            n = 0;
            for (AtomicGaussian atomicGaussian2 : molecularVolume.atomicGaussians) {
                d += atomicGaussian.getVolumeOverlap(atomicGaussian2, coordinatesArray[n], 10.0);
                ++n;
            }
        }
        for (VolumeGaussian volumeGaussian : this.volumeGaussians) {
            n = 0;
            for (AtomicGaussian atomicGaussian2 : molecularVolume.atomicGaussians) {
                double d3 = (double)volumeGaussian.getRole() * volumeGaussian.getVolumeOverlap(atomicGaussian2, coordinatesArray[n], 10.0);
                d += d3;
                d2 += d3;
                ++n;
            }
        }
        if (d < 0.0) {
            d = 0.0;
        }
        dArray2[0] = d;
        dArray2[1] = d2;
        return dArray2;
    }

    private void calc(StereoMolecule stereoMolecule) {
        this.atomicGaussians = new ArrayList();
        int n = stereoMolecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            AtomicGaussian atomicGaussian;
            Coordinates coordinates;
            if (stereoMolecule.getAtomicNo(i) == 1) {
                this.hydrogens.add(new Coordinates(stereoMolecule.getCoordinates(i)));
                continue;
            }
            if (stereoMolecule.getAtomicNo(i) == 0) {
                coordinates = new Coordinates(stereoMolecule.getCoordinates(i));
                atomicGaussian = new AtomicGaussian(i, 6, coordinates);
                atomicGaussian.setWeight(0.0);
                this.atomicGaussians.add(atomicGaussian);
                continue;
            }
            coordinates = new Coordinates(stereoMolecule.getCoordinates(i));
            atomicGaussian = new AtomicGaussian(i, stereoMolecule.getAtomicNo(i), coordinates);
            this.atomicGaussians.add(atomicGaussian);
        }
    }

    @Override
    protected void rotate180DegreeAroundAxis(PheSAAlignment.axis axis2) {
        super.rotate180DegreeAroundAxis(axis2);
        MolecularVolume.rotateGaussians180DegreeAroundAxis(this.volumeGaussians, axis2);
    }

    private void calcPPVolume(StereoMolecule stereoMolecule) {
        this.ppGaussians = new ArrayList();
        ArrayList<IPharmacophorePoint> arrayList = new ArrayList<IPharmacophorePoint>();
        IonizableGroupDetector ionizableGroupDetector = new IonizableGroupDetector(stereoMolecule);
        arrayList.addAll(ionizableGroupDetector.detect());
        arrayList.addAll(PharmacophoreCalculator.getPharmacophorePoints(stereoMolecule));
        for (IPharmacophorePoint iPharmacophorePoint : arrayList) {
            this.ppGaussians.add(new PPGaussian(6, iPharmacophorePoint));
        }
    }

    @Override
    public void calcCOM() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (AtomicGaussian gaussian3D : this.atomicGaussians) {
            d += gaussian3D.getVolume();
            d2 += gaussian3D.getCenter().x * gaussian3D.getVolume();
            d3 += gaussian3D.getCenter().y * gaussian3D.getVolume();
            d4 += gaussian3D.getCenter().z * gaussian3D.getVolume();
        }
        for (VolumeGaussian volumeGaussian : this.volumeGaussians) {
            d += (double)volumeGaussian.getRole() * volumeGaussian.getVolume();
            d2 += (double)volumeGaussian.getRole() * volumeGaussian.getCenter().x * volumeGaussian.getVolume();
            d3 += (double)volumeGaussian.getRole() * volumeGaussian.getCenter().y * volumeGaussian.getVolume();
            d4 += (double)volumeGaussian.getRole() * volumeGaussian.getCenter().z * volumeGaussian.getVolume();
        }
        this.com = new Coordinates(d2 /= d, d3 /= d, d4 /= d);
    }

    @Override
    public Matrix getCovarianceMatrix() {
        double d;
        Matrix matrix = new Matrix(3, 3);
        double d2 = 0.0;
        for (AtomicGaussian gaussian3D : this.atomicGaussians) {
            d2 += gaussian3D.getVolume();
            d = gaussian3D.getVolume() * gaussian3D.getCenter().x * gaussian3D.getCenter().x;
            matrix.addToElement(0, 0, d);
            d = gaussian3D.getVolume() * gaussian3D.getCenter().x * gaussian3D.getCenter().y;
            matrix.addToElement(0, 1, d);
            d = gaussian3D.getVolume() * gaussian3D.getCenter().x * gaussian3D.getCenter().z;
            matrix.addToElement(0, 2, d);
            d = gaussian3D.getVolume() * gaussian3D.getCenter().y * gaussian3D.getCenter().y;
            matrix.addToElement(1, 1, d);
            d = gaussian3D.getVolume() * gaussian3D.getCenter().y * gaussian3D.getCenter().z;
            matrix.addToElement(1, 2, d);
            d = gaussian3D.getVolume() * gaussian3D.getCenter().z * gaussian3D.getCenter().z;
            matrix.addToElement(2, 2, d);
        }
        for (VolumeGaussian volumeGaussian : this.volumeGaussians) {
            d2 += (double)volumeGaussian.getRole() * volumeGaussian.getVolume();
            d = (double)volumeGaussian.getRole() * volumeGaussian.getVolume() * volumeGaussian.getCenter().x * volumeGaussian.getCenter().x;
            matrix.addToElement(0, 0, d);
            d = (double)volumeGaussian.getRole() * volumeGaussian.getVolume() * volumeGaussian.getCenter().x * volumeGaussian.getCenter().y;
            matrix.addToElement(0, 1, d);
            d = (double)volumeGaussian.getRole() * volumeGaussian.getVolume() * volumeGaussian.getCenter().x * volumeGaussian.getCenter().z;
            matrix.addToElement(0, 2, d);
            d = (double)volumeGaussian.getRole() * volumeGaussian.getVolume() * volumeGaussian.getCenter().y * volumeGaussian.getCenter().y;
            matrix.addToElement(1, 1, d);
            d = (double)volumeGaussian.getRole() * volumeGaussian.getVolume() * volumeGaussian.getCenter().y * volumeGaussian.getCenter().z;
            matrix.addToElement(1, 2, d);
            d = (double)volumeGaussian.getRole() * volumeGaussian.getVolume() * volumeGaussian.getCenter().z * volumeGaussian.getCenter().z;
            matrix.addToElement(2, 2, d);
        }
        matrix.set(0, 0, matrix.get(0, 0) / d2);
        matrix.set(0, 1, matrix.get(0, 1) / d2);
        matrix.set(0, 2, matrix.get(0, 2) / d2);
        matrix.set(1, 1, matrix.get(1, 1) / d2);
        matrix.set(1, 2, matrix.get(1, 2) / d2);
        matrix.set(2, 2, matrix.get(2, 2) / d2);
        matrix.set(1, 0, matrix.get(0, 1));
        matrix.set(2, 0, matrix.get(0, 2));
        matrix.set(2, 1, matrix.get(1, 2));
        return matrix;
    }

    public ArrayList<VolumeGaussian> getVolumeGaussians() {
        return this.volumeGaussians;
    }

    @Override
    protected void transformGaussians(Transformation transformation) {
        super.transformGaussians(transformation);
        MolecularVolume.transformGaussians(this.volumeGaussians, transformation);
    }

    public ArrayList<Coordinates> getHydrogens() {
        return this.hydrogens;
    }

    private void updateHydrogens(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = stereoMolecule.getAtoms(); i < stereoMolecule.getAllAtoms(); ++i) {
            this.hydrogens.get(n).set(new Coordinates(stereoMolecule.getCoordinates(i)));
            ++n;
        }
    }

    private void updateHydrogens(Conformer conformer) {
        int n = 0;
        for (int i = conformer.getMolecule().getAtoms(); i < conformer.getMolecule().getAllAtoms(); ++i) {
            this.hydrogens.get(n).set(new Coordinates(conformer.getCoordinates(i)));
            ++n;
        }
    }

    @Override
    public void update(StereoMolecule stereoMolecule) {
        this.updateCoordinates(this.getAtomicGaussians(), stereoMolecule.getAtomCoordinates());
        this.updateCoordinates(this.getPPGaussians(), stereoMolecule.getAtomCoordinates());
        this.updateCoordinates(this.getVolumeGaussians(), stereoMolecule.getAtomCoordinates());
        this.updateHydrogens(stereoMolecule);
    }

    @Override
    public void update(Conformer conformer) {
        this.updateCoordinates(this.getAtomicGaussians(), conformer.getCoordinates());
        this.updateCoordinates(this.getPPGaussians(), conformer.getCoordinates());
        this.updateCoordinates(this.getVolumeGaussians(), conformer.getCoordinates());
        this.updateHydrogens(conformer);
    }

    @Override
    public Matrix createCanonicalOrientation(Conformer conformer) {
        Matrix matrix = super.createCanonicalOrientation(conformer);
        for (VolumeGaussian volumeGaussian : this.getVolumeGaussians()) {
            volumeGaussian.rotateShift(matrix);
        }
        return matrix;
    }

    @Override
    public void translateToCOM(Coordinates coordinates) {
        for (AtomicGaussian object : this.getAtomicGaussians()) {
            object.getCenter().sub(coordinates);
        }
        for (PPGaussian pPGaussian : this.getPPGaussians()) {
            pPGaussian.getCenter().sub(coordinates);
        }
        for (VolumeGaussian volumeGaussian : this.getVolumeGaussians()) {
            volumeGaussian.translateRef(coordinates.scaleC(-1.0));
        }
        for (Coordinates coordinates2 : this.getHydrogens()) {
            coordinates2.sub(coordinates);
        }
        this.calcCOM();
    }

    /*
     * WARNING - void declaration
     */
    public String encodeFull() {
        void var3_9;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toString(this.atomicGaussians.size()));
        stringBuilder.append("  ");
        for (AtomicGaussian gaussian3D : this.atomicGaussians) {
            stringBuilder.append(gaussian3D.encode());
            stringBuilder.append("  ");
        }
        stringBuilder.append(Integer.toString(this.ppGaussians.size()));
        stringBuilder.append("  ");
        for (PPGaussian pPGaussian : this.ppGaussians) {
            stringBuilder.append(pPGaussian.encode().trim());
            stringBuilder.append("  ");
        }
        stringBuilder.append(Integer.toString(this.volumeGaussians.size()));
        stringBuilder.append("  ");
        for (VolumeGaussian volumeGaussian : this.volumeGaussians) {
            stringBuilder.append(volumeGaussian.encode());
            stringBuilder.append("  ");
        }
        Object object = new double[3 * this.hydrogens.size()];
        boolean bl = false;
        while (var3_9 < this.hydrogens.size()) {
            object[3 * var3_9] = this.hydrogens.get((int)var3_9).x;
            object[3 * var3_9 + 1] = this.hydrogens.get((int)var3_9).y;
            object[3 * var3_9 + 2] = this.hydrogens.get((int)var3_9).z;
            ++var3_9;
        }
        stringBuilder.append(EncoderFloatingPointNumbers.encode((double[])object, 13));
        return stringBuilder.toString();
    }

    public String encodeCoordsOnly() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        double[] dArray = new double[3 * this.atomicGaussians.size()];
        for (n = 0; n < this.atomicGaussians.size(); ++n) {
            dArray[3 * n] = ((AtomicGaussian)this.atomicGaussians.get((int)n)).getCenter().x;
            dArray[3 * n + 1] = ((AtomicGaussian)this.atomicGaussians.get((int)n)).getCenter().y;
            dArray[3 * n + 2] = ((AtomicGaussian)this.atomicGaussians.get((int)n)).getCenter().z;
        }
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray, 13));
        stringBuilder.append("  ");
        dArray = new double[3 * this.ppGaussians.size()];
        for (n = 0; n < this.ppGaussians.size(); ++n) {
            dArray[3 * n] = ((PPGaussian)this.ppGaussians.get((int)n)).getCenter().x;
            dArray[3 * n + 1] = ((PPGaussian)this.ppGaussians.get((int)n)).getCenter().y;
            dArray[3 * n + 2] = ((PPGaussian)this.ppGaussians.get((int)n)).getCenter().z;
        }
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray, 13));
        stringBuilder.append("  ");
        dArray = new double[3 * this.ppGaussians.size()];
        for (n = 0; n < this.ppGaussians.size(); ++n) {
            dArray[3 * n] = ((PPGaussian)this.ppGaussians.get((int)n)).getPharmacophorePoint().getDirectionality().x;
            dArray[3 * n + 1] = ((PPGaussian)this.ppGaussians.get((int)n)).getPharmacophorePoint().getDirectionality().y;
            dArray[3 * n + 2] = ((PPGaussian)this.ppGaussians.get((int)n)).getPharmacophorePoint().getDirectionality().z;
        }
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray, 13));
        stringBuilder.append("  ");
        dArray = new double[3 * this.volumeGaussians.size()];
        for (n = 0; n < this.volumeGaussians.size(); ++n) {
            dArray[3 * n] = this.volumeGaussians.get((int)n).getReferenceVector().x;
            dArray[3 * n + 1] = this.volumeGaussians.get((int)n).getReferenceVector().y;
            dArray[3 * n + 2] = this.volumeGaussians.get((int)n).getReferenceVector().z;
        }
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray, 13));
        stringBuilder.append("  ");
        dArray = new double[3 * this.volumeGaussians.size()];
        for (n = 0; n < this.volumeGaussians.size(); ++n) {
            dArray[3 * n] = this.volumeGaussians.get((int)n).getShiftVector().x;
            dArray[3 * n + 1] = this.volumeGaussians.get((int)n).getShiftVector().y;
            dArray[3 * n + 2] = this.volumeGaussians.get((int)n).getShiftVector().z;
        }
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray, 13));
        stringBuilder.append("  ");
        double[] dArray2 = new double[3 * this.hydrogens.size()];
        for (int i = 0; i < this.hydrogens.size(); ++i) {
            dArray2[3 * i] = this.hydrogens.get((int)i).x;
            dArray2[3 * i + 1] = this.hydrogens.get((int)i).y;
            dArray2[3 * i + 2] = this.hydrogens.get((int)i).z;
        }
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray2, 13));
        return stringBuilder.toString();
    }

    public static MolecularVolume decodeCoordsOnly(String string, MolecularVolume molecularVolume) {
        Coordinates coordinates;
        Gaussian3D gaussian3D;
        Coordinates coordinates2;
        int n;
        List<AtomicGaussian> list = molecularVolume.getAtomicGaussians();
        List<PPGaussian> list2 = molecularVolume.getPPGaussians();
        ArrayList<VolumeGaussian> arrayList = molecularVolume.getVolumeGaussians();
        String[] stringArray = string.split("  ");
        double[] dArray = EncoderFloatingPointNumbers.decode(stringArray[0]);
        double[] dArray2 = EncoderFloatingPointNumbers.decode(stringArray[1]);
        double[] dArray3 = EncoderFloatingPointNumbers.decode(stringArray[2]);
        double[] dArray4 = EncoderFloatingPointNumbers.decode(stringArray[3]);
        double[] dArray5 = EncoderFloatingPointNumbers.decode(stringArray[4]);
        double[] dArray6 = EncoderFloatingPointNumbers.decode(stringArray[5]);
        ArrayList<AtomicGaussian> arrayList2 = new ArrayList<AtomicGaussian>();
        ArrayList<PPGaussian> arrayList3 = new ArrayList<PPGaussian>();
        ArrayList<VolumeGaussian> arrayList4 = new ArrayList<VolumeGaussian>();
        ArrayList<Coordinates> arrayList5 = new ArrayList<Coordinates>();
        int n2 = dArray.length / 3;
        int n3 = dArray6.length / 3;
        int n4 = dArray2.length / 3;
        int n5 = dArray4.length / 3;
        for (n = 0; n < n2; ++n) {
            coordinates2 = new Coordinates(dArray[n * 3], dArray[n * 3 + 1], dArray[n * 3 + 2]);
            gaussian3D = new AtomicGaussian(list.get(n));
            gaussian3D.setCenter(coordinates2);
            arrayList2.add((AtomicGaussian)gaussian3D);
        }
        for (n = 0; n < n4; ++n) {
            coordinates2 = new Coordinates(dArray2[n * 3], dArray2[n * 3 + 1], dArray2[n * 3 + 2]);
            gaussian3D = new PPGaussian(list2.get(n));
            ((PPGaussian)gaussian3D).setCenter(new Coordinates(coordinates2.x, coordinates2.y, coordinates2.z));
            coordinates = new Coordinates(dArray3[n * 3], dArray3[n * 3 + 1], dArray3[n * 3 + 2]);
            ((PPGaussian)gaussian3D).getPharmacophorePoint().setDirectionality(coordinates);
            arrayList3.add((PPGaussian)gaussian3D);
        }
        for (n = 0; n < n5; ++n) {
            coordinates2 = new Coordinates(dArray4[n * 3], dArray4[n * 3 + 1], dArray4[n * 3 + 2]);
            gaussian3D = new VolumeGaussian((VolumeGaussian)arrayList.get(n));
            ((VolumeGaussian)gaussian3D).setReferenceVector(new Coordinates(coordinates2.x, coordinates2.y, coordinates2.z));
            coordinates = new Coordinates(dArray5[n * 3], dArray5[n * 3 + 1], dArray5[n * 3 + 2]);
            ((VolumeGaussian)gaussian3D).setShiftVector(coordinates);
            arrayList4.add((VolumeGaussian)gaussian3D);
        }
        for (n = 0; n < n3; ++n) {
            arrayList5.add(new Coordinates(dArray6[n * 3], dArray6[n * 3 + 1], dArray6[n * 3 + 2]));
        }
        return new MolecularVolume(arrayList2, arrayList3, arrayList4, arrayList5);
    }

    public static MolecularVolume decodeFull(String string, StereoMolecule stereoMolecule) {
        int n;
        int n2;
        String[] stringArray = string.split("  ");
        int n3 = Integer.decode(stringArray[0].trim());
        int n4 = 1;
        int n5 = 1 + n3;
        ArrayList<AtomicGaussian> arrayList = new ArrayList<AtomicGaussian>();
        ArrayList<PPGaussian> arrayList2 = new ArrayList<PPGaussian>();
        ArrayList<VolumeGaussian> arrayList3 = new ArrayList<VolumeGaussian>();
        ArrayList<Coordinates> arrayList4 = new ArrayList<Coordinates>();
        for (n2 = n4; n2 < n5; ++n2) {
            arrayList.add(AtomicGaussian.fromString(stringArray[n2].trim()));
        }
        n2 = Integer.decode(stringArray[n5]);
        n4 = n5 + 1;
        n5 = n4 + n2;
        for (n = n4; n < n5; ++n) {
            arrayList2.add(PPGaussian.fromString(stringArray[n], stereoMolecule));
        }
        n = Integer.decode(stringArray[n5]);
        n4 = n5 + 1;
        n5 = n4 + n;
        for (int i = n4; i < n5; ++i) {
            arrayList3.add(VolumeGaussian.fromString(stringArray[i], stereoMolecule));
        }
        double[] dArray = EncoderFloatingPointNumbers.decode(stringArray[stringArray.length - 1]);
        int n6 = dArray.length / 3;
        for (int i = 0; i < n6; ++i) {
            arrayList4.add(new Coordinates(dArray[i * 3], dArray[i * 3 + 1], dArray[i * 3 + 2]));
        }
        return new MolecularVolume(arrayList, arrayList2, arrayList3, arrayList4);
    }
}

