/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;
import com.actelion.research.chem.alignment3d.transformation.RotationDerivatives;
import com.actelion.research.chem.optimization.Evaluable;
import com.actelion.research.chem.phesa.AtomicGaussian;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesa.QuickMathCalculator;
import com.actelion.research.chem.phesa.ShapeVolume;
import com.actelion.research.chem.phesa.VolumeGaussian;
import com.actelion.research.chem.phesa.pharmacophore.pp.PPGaussian;
import java.util.ArrayList;
import java.util.List;

public class EvaluableOverlap
implements Evaluable {
    private double ppWeight;
    private PheSAAlignment shapeAlign;
    private double[] transform;
    private Coordinates[] cachedCoords;
    private Coordinates[] cachedCoordsPP;
    private Coordinates origCOM;
    private double[][] dv0At;
    private double[][] dv1At;
    private double[][] dv2At;
    private double[][] dv0PP;
    private double[][] dv1PP;
    private double[][] dv2PP;
    private double[][] results;
    private Coordinates[] fitAtGaussModCoords;
    private Coordinates[] fitPPGaussModCoords;

    public EvaluableOverlap(PheSAAlignment pheSAAlignment, double[] dArray) {
        this(pheSAAlignment, dArray, 0.5);
    }

    public EvaluableOverlap(PheSAAlignment pheSAAlignment, double[] dArray, double d) {
        int n;
        this.ppWeight = d;
        this.shapeAlign = pheSAAlignment;
        this.transform = dArray;
        this.fitAtGaussModCoords = new Coordinates[pheSAAlignment.getMolGauss().getAtomicGaussians().size()];
        this.fitPPGaussModCoords = new Coordinates[pheSAAlignment.getMolGauss().getPPGaussians().size()];
        this.dv0At = new double[this.fitAtGaussModCoords.length][3];
        this.dv1At = new double[this.fitAtGaussModCoords.length][3];
        this.dv2At = new double[this.fitAtGaussModCoords.length][3];
        this.dv0PP = new double[this.fitPPGaussModCoords.length][3];
        this.dv1PP = new double[this.fitPPGaussModCoords.length][3];
        this.dv2PP = new double[this.fitPPGaussModCoords.length][3];
        this.results = new double[pheSAAlignment.getRefMolGauss().getAtomicGaussians().size()][pheSAAlignment.getRefMolGauss().getAtomicGaussians().size()];
        this.cachedCoords = new Coordinates[pheSAAlignment.getMolGauss().getAtomicGaussians().size()];
        this.cachedCoordsPP = new Coordinates[pheSAAlignment.getMolGauss().getPPGaussians().size()];
        this.origCOM = new Coordinates();
        for (n = 0; n < pheSAAlignment.getMolGauss().getAtomicGaussians().size(); ++n) {
            this.cachedCoords[n] = pheSAAlignment.getMolGauss().getAtomicGaussians().get((int)n).center;
        }
        for (n = 0; n < pheSAAlignment.getMolGauss().getPPGaussians().size(); ++n) {
            this.cachedCoordsPP[n] = pheSAAlignment.getMolGauss().getPPGaussians().get((int)n).center;
        }
        for (Coordinates coordinates : this.cachedCoords) {
            this.origCOM.add(coordinates);
        }
        this.origCOM.scale(1.0 / (double)this.cachedCoords.length);
        for (Coordinates coordinates : this.cachedCoords) {
            coordinates.sub(this.origCOM);
        }
        for (Coordinates coordinates : this.cachedCoordsPP) {
            coordinates.sub(this.origCOM);
        }
    }

    public EvaluableOverlap(EvaluableOverlap evaluableOverlap) {
        this.shapeAlign = evaluableOverlap.shapeAlign;
        this.transform = evaluableOverlap.transform;
        this.dv0At = evaluableOverlap.dv0At;
        this.dv1At = evaluableOverlap.dv1At;
        this.dv2At = evaluableOverlap.dv2At;
        this.dv0PP = evaluableOverlap.dv0PP;
        this.dv0PP = evaluableOverlap.dv1PP;
        this.dv0PP = evaluableOverlap.dv2PP;
        this.fitAtGaussModCoords = evaluableOverlap.fitAtGaussModCoords;
        this.fitPPGaussModCoords = evaluableOverlap.fitPPGaussModCoords;
        this.results = evaluableOverlap.results;
    }

    private void getTransformedCoordinates(Coordinates[] coordinatesArray, List<? extends Gaussian3D> list) {
        ExponentialMap exponentialMap = new ExponentialMap(this.transform[0], this.transform[1], this.transform[2]);
        Quaternion quaternion = exponentialMap.toQuaternion();
        double[][] dArray = quaternion.getRotMatrix().getArray();
        for (int i = 0; i < list.size(); ++i) {
            Coordinates coordinates = new Coordinates(list.get((int)i).center);
            coordinates.sub(this.origCOM);
            coordinates.rotate(dArray);
            coordinates.add(this.origCOM);
            coordinates.x += this.transform[3];
            coordinates.y += this.transform[4];
            coordinates.z += this.transform[5];
            coordinatesArray[i] = coordinates;
        }
    }

    @Override
    public void setState(double[] dArray) {
        assert (this.transform.length == dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.transform[i] = dArray[i];
        }
    }

    public double[] getState(double[] dArray) {
        for (int i = 0; i < this.transform.length; ++i) {
            dArray[i] = this.transform[i];
        }
        return dArray;
    }

    @Override
    public double[] getState() {
        return this.getState(new double[this.transform.length]);
    }

    public PheSAAlignment getAlignment() {
        return this.shapeAlign;
    }

    @Override
    public double getFGValue(double[] dArray) {
        ShapeVolume shapeVolume = this.shapeAlign.getRefMolGauss();
        ShapeVolume shapeVolume2 = this.shapeAlign.getMolGauss();
        double d = 0.0;
        double[] dArray2 = new double[dArray.length];
        ArrayList<VolumeGaussian> arrayList = new ArrayList();
        if (shapeVolume instanceof MolecularVolume) {
            arrayList = ((MolecularVolume)shapeVolume).getVolumeGaussians();
        }
        d += (1.0 - this.ppWeight) * this.getFGValueOverlap(dArray2, shapeVolume.getAtomicGaussians(), shapeVolume2.getAtomicGaussians(), arrayList, this.dv0At, this.dv1At, this.dv2At, this.fitAtGaussModCoords);
        double[] dArray3 = new double[dArray.length];
        d += this.ppWeight * this.getFGValueOverlapPP(dArray3, shapeVolume.getPPGaussians(), shapeVolume2.getPPGaussians(), this.dv0PP, this.dv1PP, this.dv2PP, this.fitPPGaussModCoords);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (1.0 - this.ppWeight) * dArray2[i] + this.ppWeight * dArray3[i];
        }
        return d;
    }

    private void getEMapGradient(double[][] dArray, double[][] dArray2, double[][] dArray3, Coordinates[] coordinatesArray) {
        double[] dArray4 = new double[]{this.transform[0], this.transform[1], this.transform[2]};
        RotationDerivatives rotationDerivatives = new RotationDerivatives(dArray4);
        double[][] dArray5 = new double[3][3];
        double[][] dArray6 = new double[3][3];
        double[][] dArray7 = new double[3][3];
        rotationDerivatives.dRdv(0, dArray5);
        rotationDerivatives.dRdv(1, dArray6);
        rotationDerivatives.dRdv(2, dArray7);
        for (int i = 0; i < coordinatesArray.length; ++i) {
            Coordinates coordinates = coordinatesArray[i];
            Coordinates coordinates2 = coordinates.rotateC(dArray5);
            Coordinates coordinates3 = coordinates.rotateC(dArray6);
            Coordinates coordinates4 = coordinates.rotateC(dArray7);
            dArray[i][0] = coordinates2.x;
            dArray[i][1] = coordinates2.y;
            dArray[i][2] = coordinates2.z;
            dArray2[i][0] = coordinates3.x;
            dArray2[i][1] = coordinates3.y;
            dArray2[i][2] = coordinates3.z;
            dArray3[i][0] = coordinates4.x;
            dArray3[i][1] = coordinates4.y;
            dArray3[i][2] = coordinates4.z;
        }
    }

    private double getFGValueOverlap(double[] dArray, List<AtomicGaussian> list, List<AtomicGaussian> list2, List<VolumeGaussian> list3, double[][] dArray2, double[][] dArray3, double[][] dArray4, Coordinates[] coordinatesArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        Coordinates coordinates;
        Gaussian3D gaussian3D;
        double d10;
        int n;
        Gaussian3D gaussian3D2;
        int n2;
        this.getTransformedCoordinates(coordinatesArray, list2);
        this.getEMapGradient(dArray2, dArray3, dArray4, this.cachedCoords);
        double d11 = 0.0;
        for (n2 = 0; n2 < list.size(); ++n2) {
            gaussian3D2 = list.get(n2);
            for (n = 0; n < list2.size(); ++n) {
                d10 = 0.0;
                gaussian3D = list2.get(n);
                coordinates = coordinatesArray[n];
                d9 = gaussian3D2.getWidth() + gaussian3D.getWidth();
                d8 = gaussian3D2.getCenter().x - coordinates.x;
                d7 = gaussian3D2.getCenter().y - coordinates.y;
                d6 = gaussian3D2.getCenter().z - coordinates.z;
                d5 = d8 * d8 + d7 * d7 + d6 * d6;
                if (d5 >= 10.0 || !((d10 = gaussian3D2.getHeight() * gaussian3D.getHeight() * QuickMathCalculator.getInstance().quickExp(-(gaussian3D2.getWidth() * gaussian3D.getWidth() * d5) / d9) * QuickMathCalculator.getInstance().getPrefactor(gaussian3D2.getAtomicNo(), gaussian3D.getAtomicNo())) > 0.0)) continue;
                d11 += d10;
                d4 = d10 * -2.0 * gaussian3D2.getWidth() * gaussian3D.getWidth() / (gaussian3D2.getWidth() + gaussian3D.getWidth());
                d3 = dArray2[n][0] * d8 + dArray2[n][1] * d7 + dArray2[n][2] * d6;
                d2 = dArray3[n][0] * d8 + dArray3[n][1] * d7 + dArray3[n][2] * d6;
                d = dArray4[n][0] * d8 + dArray4[n][1] * d7 + dArray4[n][2] * d6;
                dArray[0] = dArray[0] + d4 * d3;
                dArray[1] = dArray[1] + d4 * d2;
                dArray[2] = dArray[2] + d4 * d;
                dArray[3] = dArray[3] + d4 * d8;
                dArray[4] = dArray[4] + d4 * d7;
                dArray[5] = dArray[5] + d4 * d6;
            }
        }
        for (n2 = 0; n2 < list3.size(); ++n2) {
            gaussian3D2 = list3.get(n2);
            for (n = 0; n < list2.size(); ++n) {
                d10 = 0.0;
                gaussian3D = list2.get(n);
                coordinates = coordinatesArray[n];
                d9 = gaussian3D2.getWidth() + gaussian3D.getWidth();
                d8 = gaussian3D2.getCenter().x - coordinates.x;
                d7 = gaussian3D2.getCenter().y - coordinates.y;
                d6 = gaussian3D2.getCenter().z - coordinates.z;
                d5 = d8 * d8 + d7 * d7 + d6 * d6;
                if (d5 >= 10.0 || !(Math.abs(d10 = (double)((VolumeGaussian)gaussian3D2).getRole() * gaussian3D2.getHeight() * gaussian3D.getHeight() * QuickMathCalculator.getInstance().quickExp(-(gaussian3D2.getWidth() * gaussian3D.getWidth() * d5) / d9) * QuickMathCalculator.getInstance().getPrefactor(gaussian3D2.getAtomicNo(), gaussian3D.getAtomicNo())) > 0.0)) continue;
                d11 += d10;
                d4 = d10 * -2.0 * gaussian3D2.getWidth() * gaussian3D.getWidth() / (gaussian3D2.getWidth() + gaussian3D.getWidth());
                d3 = dArray2[n][0] * d8 + dArray2[n][1] * d7 + dArray2[n][2] * d6;
                d2 = dArray3[n][0] * d8 + dArray3[n][1] * d7 + dArray3[n][2] * d6;
                d = dArray4[n][0] * d8 + dArray4[n][1] * d7 + dArray4[n][2] * d6;
                dArray[0] = dArray[0] + d4 * d3;
                dArray[1] = dArray[1] + d4 * d2;
                dArray[2] = dArray[2] + d4 * d;
                dArray[3] = dArray[3] + d4 * d8;
                dArray[4] = dArray[4] + d4 * d7;
                dArray[5] = dArray[5] + d4 * d6;
            }
        }
        return -1.0 * d11;
    }

    private double getFGValueOverlapPP(double[] dArray, List<PPGaussian> list, List<PPGaussian> list2, double[][] dArray2, double[][] dArray3, double[][] dArray4, Coordinates[] coordinatesArray) {
        this.getTransformedCoordinates(coordinatesArray, list2);
        this.getEMapGradient(dArray2, dArray3, dArray4, this.cachedCoordsPP);
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            PPGaussian pPGaussian = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                double d2;
                PPGaussian pPGaussian2 = list2.get(j);
                double d3 = 0.0;
                Coordinates coordinates = coordinatesArray[j];
                double d4 = pPGaussian.getWidth() + pPGaussian2.getWidth();
                double d5 = pPGaussian.getCenter().x - coordinates.x;
                double d6 = pPGaussian.getCenter().y - coordinates.y;
                double d7 = pPGaussian.getCenter().z - coordinates.z;
                double d8 = d5 * d5 + d6 * d6 + d7 * d7;
                if (d8 >= 10.0 || !((d3 = pPGaussian.getWeight() * pPGaussian.getHeight() * pPGaussian2.getHeight() * QuickMathCalculator.getInstance().quickExp(-(pPGaussian.getWidth() * pPGaussian2.getWidth() * d8) / d4) * QuickMathCalculator.getInstance().getPrefactor(pPGaussian.getAtomicNo(), pPGaussian2.getAtomicNo())) > 0.0) || (d2 = pPGaussian.getInteractionSimilarity(pPGaussian2)) == 0.0) continue;
                d += (d3 *= d2);
                double d9 = d3 * -2.0 * pPGaussian.getWidth() * pPGaussian2.getWidth() / (pPGaussian.getWidth() + pPGaussian2.getWidth());
                double d10 = dArray2[j][0] * d5 + dArray2[j][1] * d6 + dArray2[j][2] * d7;
                double d11 = dArray3[j][0] * d5 + dArray3[j][1] * d6 + dArray3[j][2] * d7;
                double d12 = dArray4[j][0] * d5 + dArray4[j][1] * d6 + dArray4[j][2] * d7;
                dArray[0] = dArray[0] + d9 * d10;
                dArray[1] = dArray[1] + d9 * d11;
                dArray[2] = dArray[2] + d9 * d12;
                dArray[3] = dArray[3] + d9 * d5;
                dArray[4] = dArray[4] + d9 * d6;
                dArray[5] = dArray[5] + d9 * d7;
            }
        }
        return -1.0 * d;
    }

    public EvaluableOverlap clone() {
        return new EvaluableOverlap(this);
    }
}

