/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.PheSAAlignmentOptimizer;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.ConformerSet;
import com.actelion.research.chem.conf.ConformerSetGenerator;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.PheSAMolecule;
import com.actelion.research.chem.phesaflex.FlexibleShapeAlignment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DescriptorHandlerShape
implements DescriptorHandler<PheSAMolecule, StereoMolecule> {
    private static final int CONFORMATIONS = 200;
    public static final int SIZE_CUTOFF = 200;
    private static DescriptorHandlerShape INSTANCE;
    public static final PheSAMolecule FAILED_OBJECT;
    private boolean singleBaseConformation;
    private List<Transformation> preProcessTransformations;
    private StereoMolecule[] previousAlignment;
    private double[] previousPhesaResult;
    private PheSAAlignmentOptimizer.PheSASetting phesaSetting;
    protected int maxConfs;
    protected double ppWeight;
    protected boolean flexible = false;
    protected ThreadMaster threadMaster;
    private ConformerSetGenerator conformerGenerator;

    public DescriptorHandlerShape() {
        this(false, 200, 0.5);
    }

    public DescriptorHandlerShape(boolean bl) {
        this(bl, 200, 0.5);
    }

    public DescriptorHandlerShape(boolean bl, double d) {
        this(bl, 200, d);
    }

    public DescriptorHandlerShape(int n, double d) {
        this(false, n, d);
    }

    public DescriptorHandlerShape(double d) {
        this(false, 200, d);
    }

    public DescriptorHandlerShape(boolean bl, int n, double d) {
        this.singleBaseConformation = bl;
        this.maxConfs = n;
        this.ppWeight = d;
        this.init();
        this.conformerGenerator = new ConformerSetGenerator(n);
        this.conformerGenerator.setThreadMaster(this.threadMaster);
        this.preProcessTransformations = new ArrayList<Transformation>();
        this.phesaSetting = new PheSAAlignmentOptimizer.PheSASetting();
    }

    public PheSAAlignmentOptimizer.PheSASetting getPhesaSetting() {
        return this.phesaSetting;
    }

    public void setPhesaSetting(PheSAAlignmentOptimizer.PheSASetting pheSASetting) {
        this.phesaSetting = pheSASetting;
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.threadMaster = threadMaster;
    }

    public List<Transformation> getPreProcessTransformations() {
        return this.preProcessTransformations;
    }

    @Override
    public PheSAMolecule createDescriptor(ConformerSet conformerSet) {
        this.preProcessTransformations = new ArrayList<Transformation>();
        try {
            Conformer conformer;
            this.init();
            ArrayList<MolecularVolume> arrayList = new ArrayList<MolecularVolume>();
            StereoMolecule stereoMolecule = ((Conformer)conformerSet.first()).toMolecule();
            if (stereoMolecule.getAtoms() > 200) {
                return FAILED_OBJECT;
            }
            MolecularVolume molecularVolume = new MolecularVolume(stereoMolecule);
            Iterator iterator = conformerSet.iterator();
            while (iterator.hasNext() && (conformer = (Conformer)iterator.next()) != null) {
                MolecularVolume molecularVolume2 = new MolecularVolume(molecularVolume, conformer);
                Coordinates coordinates = molecularVolume2.getCOM();
                Rotation rotation = molecularVolume2.preProcess(conformer);
                TransformationSequence transformationSequence = new TransformationSequence();
                transformationSequence.addTransformation(rotation.getInvert());
                transformationSequence.addTransformation(new Translation(new double[]{coordinates.x, coordinates.y, coordinates.z}));
                this.preProcessTransformations.add(transformationSequence);
                arrayList.add(molecularVolume2);
            }
            stereoMolecule = ((Conformer)conformerSet.first()).toMolecule();
            return new PheSAMolecule(stereoMolecule, arrayList);
        }
        catch (Exception exception) {
            return FAILED_OBJECT;
        }
    }

    public void init() {
        this.previousAlignment = new StereoMolecule[2];
    }

    @Override
    public PheSAMolecule createDescriptor(StereoMolecule stereoMolecule) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(31);
        boolean bl = false;
        for (int i = 1; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!(Math.abs(stereoMolecule.getAtomZ(i) - stereoMolecule.getAtomZ(0)) > 0.1)) continue;
            bl = true;
            break;
        }
        stereoMolecule2.stripSmallFragments();
        Canonizer canonizer = new Canonizer(stereoMolecule2);
        stereoMolecule2 = canonizer.getCanMolecule(true);
        ConformerSet conformerSet = new ConformerSet();
        if (!this.singleBaseConformation) {
            conformerSet = this.conformerGenerator.generateConformerSet(stereoMolecule2);
        } else {
            if (!bl) {
                return FAILED_OBJECT;
            }
            if (stereoMolecule2.getAllAtoms() - stereoMolecule2.getAtoms() == 0) {
                System.err.println("missing hydrogens in 3D structure");
                return FAILED_OBJECT;
            }
            conformerSet.add(new Conformer(stereoMolecule2));
        }
        return this.createDescriptor(conformerSet);
    }

    @Override
    public float getSimilarity(PheSAMolecule pheSAMolecule, PheSAMolecule pheSAMolecule2) {
        StereoMolecule[] stereoMoleculeArray = new StereoMolecule[]{pheSAMolecule.getMolecule(), pheSAMolecule2.getMolecule()};
        double[] dArray = PheSAAlignmentOptimizer.align(pheSAMolecule, pheSAMolecule2, stereoMoleculeArray, this.phesaSetting);
        this.setPreviousAlignment(stereoMoleculeArray);
        this.setPreviousPheSAResult(dArray);
        if (this.flexible) {
            FlexibleShapeAlignment flexibleShapeAlignment = new FlexibleShapeAlignment(stereoMoleculeArray[0], stereoMoleculeArray[1]);
            flexibleShapeAlignment.setSettings(this.phesaSetting);
            dArray = flexibleShapeAlignment.align();
            this.setPreviousPheSAResult(dArray);
        }
        return (float)dArray[0];
    }

    public StereoMolecule[] getPreviousAlignment() {
        return this.previousAlignment;
    }

    public double[] getPreviousPheSAResult() {
        return this.previousPhesaResult;
    }

    public void setPreviousAlignment(StereoMolecule[] stereoMoleculeArray) {
        this.previousAlignment = stereoMoleculeArray;
    }

    public void setPreviousPheSAResult(double[] dArray) {
        this.previousPhesaResult = dArray;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_ShapeAlign.version;
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_ShapeAlign;
    }

    @Override
    public String encode(PheSAMolecule pheSAMolecule) {
        if (this.calculationFailed(pheSAMolecule)) {
            return "Calculation Failed";
        }
        ArrayList<MolecularVolume> arrayList = null;
        if (!(pheSAMolecule instanceof PheSAMolecule)) {
            return "Calculation Failed";
        }
        PheSAMolecule pheSAMolecule2 = pheSAMolecule;
        arrayList = pheSAMolecule2.getVolumes();
        StringBuilder stringBuilder = new StringBuilder();
        int n = arrayList.size();
        stringBuilder.append(Integer.toString(n));
        stringBuilder.append("   ");
        stringBuilder.append(arrayList.get(0).encodeFull());
        stringBuilder.append("   ");
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(arrayList.get(i).encodeCoordsOnly());
            stringBuilder.append("   ");
        }
        stringBuilder.append("   ");
        StereoMolecule stereoMolecule = new StereoMolecule(pheSAMolecule2.getMolecule());
        Canonizer canonizer = new Canonizer(stereoMolecule, 64);
        String string = canonizer.getEncodedCoordinates(true);
        String string2 = canonizer.getIDCode();
        stringBuilder.append(string2);
        stringBuilder.append("   ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public PheSAMolecule decode(String string) {
        try {
            return string == null || string.length() == 0 ? null : (string.equals("Calculation Failed") ? FAILED_OBJECT : this.getDecodedObject(string));
        }
        catch (RuntimeException runtimeException) {
            return FAILED_OBJECT;
        }
    }

    private PheSAMolecule getDecodedObject(String string) {
        String[] stringArray = string.split("   ");
        String string2 = stringArray[stringArray.length - 2];
        String string3 = stringArray[stringArray.length - 1];
        StereoMolecule stereoMolecule = new StereoMolecule();
        IDCodeParserWithoutCoordinateInvention iDCodeParserWithoutCoordinateInvention = new IDCodeParserWithoutCoordinateInvention();
        iDCodeParserWithoutCoordinateInvention.parse(stereoMolecule, string2, string3);
        stereoMolecule.ensureHelperArrays(31);
        ArrayList<MolecularVolume> arrayList = new ArrayList<MolecularVolume>();
        int n = Integer.decode(stringArray[0]);
        MolecularVolume molecularVolume = MolecularVolume.decodeFull(stringArray[1], stereoMolecule);
        arrayList.add(molecularVolume);
        for (int i = 2; i < n + 1; ++i) {
            arrayList.add(MolecularVolume.decodeCoordsOnly(stringArray[i], molecularVolume));
        }
        PheSAMolecule pheSAMolecule = new PheSAMolecule(stereoMolecule, arrayList);
        return pheSAMolecule;
    }

    @Override
    public PheSAMolecule decode(byte[] byArray) {
        return this.decode(new String(byArray));
    }

    @Override
    public boolean calculationFailed(PheSAMolecule pheSAMolecule) {
        return pheSAMolecule.getVolumes().size() == 0;
    }

    @Override
    public DescriptorHandlerShape getThreadSafeCopy() {
        DescriptorHandlerShape descriptorHandlerShape = new DescriptorHandlerShape();
        descriptorHandlerShape.ppWeight = this.ppWeight;
        descriptorHandlerShape.flexible = this.flexible;
        descriptorHandlerShape.maxConfs = this.maxConfs;
        return descriptorHandlerShape;
    }

    public static DescriptorHandlerShape getDefaultInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DescriptorHandlerShape();
        }
        return INSTANCE;
    }

    public void setMaxConfs(int n) {
        this.maxConfs = n;
        this.init();
    }

    public void setFlexible(boolean bl) {
        this.flexible = bl;
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public double getPpWeight() {
        return this.ppWeight;
    }

    static {
        FAILED_OBJECT = new PheSAMolecule();
    }
}

