/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import com.actelion.research.chem.mmp.MMPReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MMPServices {
    private Map<String, MMPReader> mmpReaders = new HashMap<String, MMPReader>();

    private boolean verifyDatasetname(String string) {
        return this.mmpReaders.containsKey(string);
    }

    public String readMMPFile(BufferedReader bufferedReader, boolean bl) throws IOException, Exception {
        MMPReader mMPReader = new MMPReader(bufferedReader, bl);
        String string = mMPReader.getWhat("datasetName");
        this.mmpReaders.put(string, mMPReader);
        return string;
    }

    public int getChemicalSpaceSize(String string, String string2) {
        if (this.verifyDatasetname(string)) {
            return this.getChemicalSpaceSize(string, new String[]{string2});
        }
        return -1;
    }

    public int getChemicalSpaceSize(String string, String[] stringArray) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getChemicalSpaceSize(stringArray);
        }
        return -1;
    }

    public List<String> getChemicalSpace(String string, String[] stringArray, String string2, String string3) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getChemicalSpace(stringArray, string2, string3);
        }
        return null;
    }

    public String getMMPsDWAR(String string, String string2, String[] stringArray, String string3, String string4, int n, List<String> list) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getMMPsDWAR(string2, stringArray, string3, string4, n, list);
        }
        return null;
    }

    public String getChemicalSpaceDWAR(String string, String string2, String[] stringArray, String string3) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getChemicalSpaceDWAR(string2, stringArray, string3);
        }
        return null;
    }

    public int getTransformationsSize(String string, String string2, int n, int n2) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getTransformationsSize(string2, n, n2);
        }
        return -1;
    }

    public List<String[]> getTransformationsTable(String string, String[] stringArray, String string2, int n, int n2) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).transformationsListToTable(stringArray, string2, n, n2);
        }
        return null;
    }

    public String getTransformationsJSON(String string, String string2, String[] stringArray, String string3, int n, int n2, String string4) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getTransformationsJSON(string2, stringArray, string3, n, n2, string4);
        }
        return null;
    }

    public String getTransformationsDWAR(String string, String string2, String[] stringArray, String string3, int n, int n2, int n3, List<String> list) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getTransformationsDWAR(string2, stringArray, string3, n, n2, n3, list);
        }
        return null;
    }

    public String getIDCodeFromMolName(String string, String string2) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getIDCodeFromMolName(string2);
        }
        return null;
    }

    public List<String> getDataFields(String string) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getDataFields("fieldName");
        }
        return null;
    }

    public List<String> getLongDataFields(String string) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getDataFields("longFieldName");
        }
        return null;
    }

    public List<String> getCategoryNames(String string) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getDataFields("categoryName");
        }
        return null;
    }

    public List<String> getPercentiles5(String string) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getDataFields("percentile5");
        }
        return null;
    }

    public List<String> getPercentiles95(String string) {
        if (this.verifyDatasetname(string)) {
            return this.mmpReaders.get(string).getDataFields("percentile95");
        }
        return null;
    }

    public String getDatasetInformations(ArrayList<String> arrayList) {
        String string = "";
        for (String string2 : arrayList) {
            if (!this.mmpReaders.containsKey(string2)) continue;
            String string3 = this.mmpReaders.get(string2).getWhat("date");
            String string4 = this.mmpReaders.get(string2).getWhat("numberOfMolecules");
            String string5 = this.mmpReaders.get(string2).getWhat("randomMoleculeName");
            if (string != "") {
                string = string + "\n";
            }
            string = string + string2 + "\t" + string4 + "\t" + string3 + "\t" + string5;
        }
        return string;
    }
}

