/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import com.actelion.research.chem.mmp.MMPFragmenter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class MMPFragments {
    private File temp = File.createTempFile("fragments", ".tmp");
    private PrintWriter fragmentsWriter = new PrintWriter(this.temp);
    private int numberOfLines = 0;

    public MMPFragments() throws IOException {
        this.fragmentsWriter.println("key1FragmentIndex\tkey2FragmentIndex\tvalueFragmentIndex\tcutType\tmoleculeIndex");
    }

    public void addFragments(int n, List<MMPFragmenter.MoleculeIndexID> list) {
        for (MMPFragmenter.MoleculeIndexID moleculeIndexID : list) {
            this.addFragments(n, moleculeIndexID);
        }
    }

    public void addFragments(int n, MMPFragmenter.MoleculeIndexID moleculeIndexID) {
        int[] nArray = moleculeIndexID.getKeysIDAtoms();
        int[] nArray2 = moleculeIndexID.getKeysIndex();
        if (nArray.length == 1) {
            this.fragmentsWriter.println(Integer.toString(nArray2[0]) + "\t\t" + Integer.toString(moleculeIndexID.getValueIndex()) + "\t1\t" + Integer.toString(n));
        } else {
            this.fragmentsWriter.println(Integer.toString(nArray2[0]) + "\t" + Integer.toString(nArray2[1]) + "\t" + Integer.toString(moleculeIndexID.getValueIndex()) + "\t2\t" + Integer.toString(n));
        }
        ++this.numberOfLines;
    }

    public void writeFragments(PrintWriter printWriter) throws IOException {
        String string;
        this.fragmentsWriter.close();
        printWriter.println("<mmpFragments>");
        printWriter.println("<column properties>");
        printWriter.println("<columnName=\"key1FragmentIndex\">");
        printWriter.println("<columnName=\"key2FragmentIndex\">");
        printWriter.println("<columnName=\"valueFragmentIndex\">");
        printWriter.println("<columnName=\"cutType\">");
        printWriter.println("<columnName=\"moleculeIndex\">");
        printWriter.println("</column properties>");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.temp));
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(string);
        }
        bufferedReader.close();
        this.temp.delete();
        printWriter.println("</mmpFragments>");
    }

    public int getFragmentsCount() {
        return this.numberOfLines;
    }
}

