/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MMPFragmenter {
    private static final int SINGLE_CUT = 1;
    private static final int DOUBLE_CUT = 2;
    private static final int NUMBER_OF_CUTS = 2;
    public static final Integer KEYS_MIN_ATOMS = 4;
    private static final Integer VALUE_MAX_ATOMS = null;
    private static final String r1H = MMPFragmenter.createR1HMoleculeID();
    public static final String FRAGMENT_DELIMITER = "#";
    public static final int FRAGMENT_ATOMIC_NO = 142;
    private StereoMolecule mol;
    private List<String[]> moleculeFragmentsID;
    private HashMap<String, StereoMolecule> moleculeFragments;
    private List<MoleculeIndexID> moleculeIndexesID;
    private List<MoleculeIndexIDByte> moleculeIndexesIDByte;
    private Integer nRotBonds = null;
    private ArrayList<Integer> rotBondsIndex;

    public static String createR1HMoleculeID() {
        StereoMolecule stereoMolecule = new StereoMolecule();
        int n = stereoMolecule.addAtom(142);
        stereoMolecule.setAtomCustomLabel(n, FRAGMENT_DELIMITER);
        int n2 = stereoMolecule.addAtom(1);
        stereoMolecule.setAtomCustomLabel(n2, "[H]");
        stereoMolecule.addBond(n, n2, 1);
        return MMPFragmenter.getIDCodeWithCustomLabels(stereoMolecule);
    }

    private static String getIDCodeWithCustomLabels(StereoMolecule stereoMolecule) {
        Canonizer canonizer = new Canonizer(stereoMolecule, 8);
        return canonizer.getIDCode();
    }

    public MMPFragmenter(StereoMolecule stereoMolecule) {
        this.mol = this.removeHydrogens(stereoMolecule);
        this.moleculeFragmentsID = new ArrayList<String[]>();
        this.moleculeFragments = new HashMap();
        this.moleculeIndexesID = new ArrayList<MoleculeIndexID>();
        this.moleculeIndexesIDByte = new ArrayList<MoleculeIndexIDByte>();
    }

    public List<MoleculeIndexID> getMoleculeIndexesID() {
        return this.getMoleculeIndexesID(true);
    }

    public List<MoleculeIndexID> getMoleculeIndexesID(boolean bl) {
        if (this.nRotBonds == null) {
            this.fragmentMolecule(bl);
        }
        return this.moleculeIndexesID;
    }

    public List<String[]> getMoleculeFragmentsID() {
        if (this.nRotBonds == null) {
            this.fragmentMolecule(false);
        }
        return this.moleculeFragmentsID;
    }

    public List<MoleculeIndexIDByte> getMoleculeIndexesIDByte() {
        return this.getMoleculeIndexesIDByte(true);
    }

    public List<MoleculeIndexIDByte> getMoleculeIndexesIDByte(boolean bl) {
        if (this.nRotBonds == null) {
            this.fragmentMolecule(bl);
        }
        if (this.nRotBonds > 0 && this.moleculeIndexesIDByte.size() == 0) {
            for (MoleculeIndexID moleculeIndexID : this.moleculeIndexesID) {
                String[] stringArray = moleculeIndexID.keysID;
                String string = moleculeIndexID.valueID;
                Object object = null;
                if (stringArray.length == 1) {
                    object = new byte[][]{stringArray[0].getBytes(), stringArray[1].getBytes()};
                } else if (stringArray.length == 2) {
                    object = new byte[][]{stringArray[0].getBytes(), stringArray[1].getBytes(), stringArray[2].getBytes()};
                }
                byte[] byArray = string.getBytes();
                MoleculeIndexIDByte moleculeIndexIDByte = new MoleculeIndexIDByte((byte[][])object, byArray);
                this.moleculeIndexesIDByte.add(moleculeIndexIDByte);
            }
        }
        return this.moleculeIndexesIDByte;
    }

    public ArrayList<Integer> getRotBondsIndex() {
        if (this.rotBondsIndex == null) {
            this.rotBondsIndex = new ArrayList();
            for (int i = 0; i < this.mol.getBonds(); ++i) {
                if (this.mol.isRingBond(i) || this.mol.getBondOrder(i) != 1) continue;
                this.rotBondsIndex.add(i);
            }
        }
        return this.rotBondsIndex;
    }

    private int countRGroups(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 0 && stereoMolecule.getAtomicNo(i) < 142) continue;
            ++n;
        }
        return n;
    }

    private StereoMolecule addRGroups(StereoMolecule stereoMolecule) {
        return this.addRGroups(stereoMolecule, false);
    }

    private StereoMolecule addRGroups(StereoMolecule stereoMolecule, boolean bl) {
        int n = 1;
        stereoMolecule.ensureHelperArrays(1);
        if (!bl) {
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (stereoMolecule.getAtomicNo(i) != 0 && stereoMolecule.getAtomicNo(i) < 142) continue;
                stereoMolecule.setAtomicNo(i, 142 + n - 1);
                stereoMolecule.setAtomCustomLabel(i, FRAGMENT_DELIMITER + Integer.toString(n));
                ++n;
            }
        } else {
            for (int i = stereoMolecule.getAtoms() - 1; i >= 0; --i) {
                if (stereoMolecule.getAtomicNo(i) != 0 && stereoMolecule.getAtomicNo(i) < 142) continue;
                stereoMolecule.setAtomicNo(i, 142 + n - 1);
                stereoMolecule.setAtomCustomLabel(i, FRAGMENT_DELIMITER + Integer.toString(n));
                ++n;
            }
        }
        return stereoMolecule;
    }

    private MoleculeIndexID processFragments(StereoMolecule[] stereoMoleculeArray, int[] nArray, int[] nArray2, int n) {
        MoleculeIndexID moleculeIndexID = null;
        if (n == 1 && stereoMoleculeArray.length > 1) {
            String string = MMPFragmenter.getIDCodeWithCustomLabels(stereoMoleculeArray[0]);
            String string2 = MMPFragmenter.getIDCodeWithCustomLabels(stereoMoleculeArray[1]);
            moleculeIndexID = new MoleculeIndexID(new String[]{string}, string2, new int[]{stereoMoleculeArray[0].getAtoms() - 1}, stereoMoleculeArray[1].getAtoms() - 1, nArray, nArray2);
            if (KEYS_MIN_ATOMS == null || stereoMoleculeArray[0].getAtoms() >= KEYS_MIN_ATOMS) {
                this.moleculeFragments.put(string, stereoMoleculeArray[0]);
            }
            if (KEYS_MIN_ATOMS == null || stereoMoleculeArray[1].getAtoms() >= KEYS_MIN_ATOMS) {
                this.moleculeFragments.put(string2, stereoMoleculeArray[1]);
            }
        } else if (n == 2 && stereoMoleculeArray.length > 2) {
            for (StereoMolecule stereoMolecule : stereoMoleculeArray) {
                stereoMolecule.ensureHelperArrays(1);
            }
            if (this.countRGroups(stereoMoleculeArray[1]) == 2) {
                stereoMoleculeArray = new StereoMolecule[]{stereoMoleculeArray[1], stereoMoleculeArray[0], stereoMoleculeArray[2]};
            } else if (this.countRGroups(stereoMoleculeArray[2]) == 2) {
                stereoMoleculeArray = new StereoMolecule[]{stereoMoleculeArray[2], stereoMoleculeArray[0], stereoMoleculeArray[1]};
            }
            Canonizer canonizer = new Canonizer(stereoMoleculeArray[0]);
            int[] nArray3 = canonizer.getGraphIndexes();
            int[] nArray4 = new int[2];
            int n2 = 0;
            for (int i = 0; i < stereoMoleculeArray[0].getAtoms(); ++i) {
                if (stereoMoleculeArray[0].getAtomicNo(i) < 142 && stereoMoleculeArray[0].getAtomicNo(i) != 0) continue;
                nArray4[n2] = i;
                ++n2;
            }
            moleculeIndexID = nArray3[nArray4[0]] < nArray3[nArray4[1]] ? new MoleculeIndexID(new String[]{MMPFragmenter.getIDCodeWithCustomLabels(stereoMoleculeArray[1]), MMPFragmenter.getIDCodeWithCustomLabels(stereoMoleculeArray[2])}, MMPFragmenter.getIDCodeWithCustomLabels(this.addRGroups(stereoMoleculeArray[0])), new int[]{stereoMoleculeArray[1].getAtoms() - 1, stereoMoleculeArray[2].getAtoms() - 1}, stereoMoleculeArray[0].getAtoms() - 1, nArray, nArray2) : new MoleculeIndexID(new String[]{MMPFragmenter.getIDCodeWithCustomLabels(stereoMoleculeArray[2]), MMPFragmenter.getIDCodeWithCustomLabels(stereoMoleculeArray[1])}, MMPFragmenter.getIDCodeWithCustomLabels(this.addRGroups(stereoMoleculeArray[0], true)), new int[]{stereoMoleculeArray[2].getAtoms() - 1, stereoMoleculeArray[1].getAtoms() - 1}, stereoMoleculeArray[0].getAtoms() - 1, new int[]{nArray[1], nArray[0]}, new int[]{nArray2[1], nArray2[0]});
        }
        return moleculeIndexID;
    }

    private StereoMolecule removeHydrogens(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(15);
        stereoMolecule.setAllAtoms(stereoMolecule.getAtoms());
        stereoMolecule.setAllBonds(stereoMolecule.getBonds());
        return stereoMolecule;
    }

    public void fragmentMolecule() {
        this.fragmentMolecule(true);
    }

    public void fragmentMolecule(boolean bl) {
        StereoMolecule[] stereoMoleculeArray;
        int n;
        int[] nArray = new int[4];
        int[] nArray2 = new int[2];
        HashSet<String> hashSet = new HashSet<String>();
        StereoMolecule stereoMolecule = new StereoMolecule();
        this.mol.copyMolecule(stereoMolecule);
        stereoMolecule.ensureHelperArrays(1);
        for (n = 0; n < 2; ++n) {
            nArray[n * 2] = stereoMolecule.addAtom(142);
            stereoMolecule.setAtomCustomLabel(nArray[n * 2], FRAGMENT_DELIMITER);
            nArray[n * 2 + 1] = stereoMolecule.addAtom(142);
            stereoMolecule.setAtomCustomLabel(nArray[n * 2 + 1], FRAGMENT_DELIMITER);
            nArray2[n] = stereoMolecule.addBond(nArray[n * 2], nArray[n * 2 + 1], 1);
        }
        this.rotBondsIndex = this.getRotBondsIndex();
        this.nRotBonds = this.rotBondsIndex.size();
        for (n = 0; n < this.nRotBonds; ++n) {
            int n2 = stereoMolecule.getBondAtom(0, this.rotBondsIndex.get(n));
            int n3 = stereoMolecule.getBondAtom(1, this.rotBondsIndex.get(n));
            stereoMolecule.setBondType(nArray2[0], stereoMolecule.getBondType(this.rotBondsIndex.get(n)));
            stereoMolecule.setBondAtom(1, this.rotBondsIndex.get(n), nArray[0]);
            stereoMolecule.setBondAtom(0, nArray2[0], n3);
            stereoMoleculeArray = stereoMolecule.getFragments();
            MoleculeIndexID moleculeIndexID = this.processFragments(stereoMoleculeArray, new int[]{this.rotBondsIndex.get(n)}, new int[]{n3}, 1);
            if (!(KEYS_MIN_ATOMS != null && moleculeIndexID.keysIDAtoms[0] < KEYS_MIN_ATOMS || VALUE_MAX_ATOMS != null && moleculeIndexID.valueIDAtoms > VALUE_MAX_ATOMS)) {
                this.moleculeIndexesID.add(moleculeIndexID);
            }
            if (!(KEYS_MIN_ATOMS != null && moleculeIndexID.valueIDAtoms < KEYS_MIN_ATOMS || VALUE_MAX_ATOMS != null && moleculeIndexID.keysIDAtoms[0] > VALUE_MAX_ATOMS)) {
                MoleculeIndexID moleculeIndexID2 = new MoleculeIndexID(new String[]{moleculeIndexID.valueID}, moleculeIndexID.keysID[0], new int[]{moleculeIndexID.valueIDAtoms}, moleculeIndexID.keysIDAtoms[0], new int[]{this.rotBondsIndex.get(n)}, new int[]{n2});
                this.moleculeIndexesID.add(moleculeIndexID2);
            }
            if (KEYS_MIN_ATOMS == null || moleculeIndexID.keysIDAtoms[0] >= KEYS_MIN_ATOMS) {
                hashSet.add(moleculeIndexID.keysID[0]);
            }
            if (KEYS_MIN_ATOMS == null || moleculeIndexID.valueIDAtoms >= KEYS_MIN_ATOMS) {
                hashSet.add(moleculeIndexID.valueID);
            }
            for (int i = n + 1; i < this.nRotBonds; ++i) {
                int n4 = stereoMolecule.getBondAtom(1, this.rotBondsIndex.get(i));
                stereoMolecule.setBondType(nArray2[1], stereoMolecule.getBondType(this.rotBondsIndex.get(i)));
                stereoMolecule.setBondAtom(1, this.rotBondsIndex.get(i), nArray[2]);
                stereoMolecule.setBondAtom(0, nArray2[1], n4);
                StereoMolecule[] stereoMoleculeArray2 = stereoMolecule.getFragments();
                MoleculeIndexID moleculeIndexID3 = this.processFragments(stereoMoleculeArray2, new int[]{this.rotBondsIndex.get(n), this.rotBondsIndex.get(i)}, new int[]{n3, n4}, 2);
                if ((KEYS_MIN_ATOMS == null || moleculeIndexID3.keysIDAtoms[0] >= KEYS_MIN_ATOMS && moleculeIndexID3.keysIDAtoms[1] >= KEYS_MIN_ATOMS) && (VALUE_MAX_ATOMS == null || moleculeIndexID3.valueIDAtoms <= VALUE_MAX_ATOMS)) {
                    this.moleculeIndexesID.add(moleculeIndexID3);
                }
                stereoMolecule.setBondAtom(1, this.rotBondsIndex.get(i), n4);
                stereoMolecule.setBondAtom(0, nArray2[1], nArray[2]);
            }
            stereoMolecule.setBondAtom(1, this.rotBondsIndex.get(n), n3);
            stereoMolecule.setBondAtom(0, nArray2[0], nArray[0]);
        }
        for (Map.Entry<String, StereoMolecule> entry : this.moleculeFragments.entrySet()) {
            String string = entry.getKey();
            stereoMoleculeArray = entry.getValue();
            for (int i = stereoMoleculeArray.getAtoms() - 1; i >= 0; --i) {
                if (stereoMoleculeArray.getAtomicNo(i) != 0 && stereoMoleculeArray.getAtomicNo(i) < 142) continue;
                stereoMoleculeArray.setAtomicNo(i, 1);
                stereoMoleculeArray.setAtomCustomLabel(i, (String)null);
                break;
            }
            this.moleculeFragmentsID.add(new String[]{string, stereoMoleculeArray.getIDCode()});
        }
        if (bl) {
            this.generateWholeMoleculeVariations();
        }
    }

    public void generateWholeMoleculeVariations() {
        Object object;
        Object object2;
        HashMap<Object, ArrayList> hashMap = new HashMap<Object, ArrayList>();
        int n = this.mol.getAtoms();
        StereoMolecule stereoMolecule = new StereoMolecule();
        this.mol.copyMolecule(stereoMolecule);
        int n2 = stereoMolecule.addAtom(142);
        stereoMolecule.setAtomCustomLabel(n2, FRAGMENT_DELIMITER);
        stereoMolecule.ensureHelperArrays(1);
        for (int i = 0; i < stereoMolecule.getAtoms() - 1; ++i) {
            if (this.mol.getPlainHydrogens(i) <= 0) continue;
            int n3 = stereoMolecule.addBond(n2, i, 1);
            object2 = MMPFragmenter.getIDCodeWithCustomLabels(stereoMolecule);
            object = new ArrayList();
            if (hashMap.containsKey(object2)) {
                object = (ArrayList)hashMap.get(object2);
            }
            ((ArrayList)object).add(i);
            hashMap.put(object2, (ArrayList)object);
            stereoMolecule.deleteBond(n3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = new int[((ArrayList)entry.getValue()).size()];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = (Integer)((ArrayList)entry.getValue()).get(i);
            }
            object = new MoleculeIndexID(new String[]{(String)entry.getKey()}, r1H, new int[]{n}, 0, new int[]{-1}, (int[])object2);
            this.moleculeIndexesID.add((MoleculeIndexID)object);
        }
    }

    public StereoMolecule getMol() {
        return this.mol;
    }

    public class MoleculeIndexIDByte {
        private byte[][] keysIDByte;
        private byte[] valueIDByte;

        public MoleculeIndexIDByte() {
        }

        public MoleculeIndexIDByte(byte[][] byArray, byte[] byArray2) {
            this.keysIDByte = byArray;
            this.valueIDByte = byArray2;
        }

        public byte[][] getKeysIDByte() {
            return this.keysIDByte;
        }

        public byte[] getValueIDByte() {
            return this.valueIDByte;
        }
    }

    public static class MoleculeIndexID {
        private String[] keysID;
        private int[] keysIndex;
        private String valueID;
        private int valueIndex;
        private int[] keysIDAtoms;
        private int valueIDAtoms;
        private IDCodeParser idCodeParser = new IDCodeParser();
        private int[] bondIndexes;
        private int[] valueAtomIndexes;
        private List<Double[]> coordinates;
        private Integer[] chemicalSpaceSizes;

        public MoleculeIndexID() {
        }

        public MoleculeIndexID(String[] stringArray, int[] nArray, String string, int n, int[] nArray2, int n2, int[] nArray3, int[] nArray4) {
            this.keysID = stringArray;
            this.keysIndex = nArray;
            this.valueID = string;
            this.valueIndex = n;
            this.keysIDAtoms = nArray2;
            if (nArray2 == null) {
                this.keysIDAtoms = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.keysIDAtoms[i] = this.idCodeParser.getAtomCount(stringArray[i]) - 1;
                }
            }
            this.valueIDAtoms = n2;
            this.bondIndexes = nArray3;
            this.valueAtomIndexes = nArray4;
            this.coordinates = new ArrayList<Double[]>();
        }

        public MoleculeIndexID(String[] stringArray, String string, int[] nArray, int n, int[] nArray2, int[] nArray3) {
            this.keysID = stringArray;
            this.valueID = string;
            this.keysIDAtoms = nArray;
            if (nArray == null) {
                this.keysIDAtoms = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.keysIDAtoms[i] = this.idCodeParser.getAtomCount(stringArray[i]) - 1;
                }
            }
            this.valueIDAtoms = n;
            this.bondIndexes = nArray2;
            this.valueAtomIndexes = nArray3;
            this.coordinates = new ArrayList<Double[]>();
        }

        public String[] getKeysID() {
            return this.keysID;
        }

        public String getValueID() {
            return this.valueID;
        }

        public int[] getKeysIDAtoms() {
            return this.keysIDAtoms;
        }

        public int getValueIDAtoms() {
            return this.valueIDAtoms;
        }

        public int[] getKeysIndex() {
            return this.keysIndex;
        }

        public void setKeysIndex(int[] nArray) {
            this.keysIndex = nArray;
        }

        public int getValueIndex() {
            return this.valueIndex;
        }

        public void setValueIndex(int n) {
            this.valueIndex = n;
        }

        public int[] getBondIndexes() {
            return this.bondIndexes;
        }

        public int[] getValueAtomIndexes() {
            return this.valueAtomIndexes;
        }

        public void setCoordinates(double d, double d2) {
            this.coordinates.add(new Double[]{d, d2});
        }

        public List<Double[]> getCoordinates() {
            return this.coordinates;
        }

        public void setChemicalSpaceSize(Integer[] integerArray) {
            this.chemicalSpaceSizes = integerArray;
        }

        public Integer[] getChemicalSpaceSizes() {
            return this.chemicalSpaceSizes;
        }
    }
}

