/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.PossibleMappingsFrag2Mol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SubStructSearchExhaustiveTreeWalker {
    private static final boolean VERBOSE = false;
    private static final boolean OVERLAP = false;
    private static final boolean precheckTotalFormula = false;
    private static final int CARDINALITY_RING_ATOM = 16;
    private static final int CARDINALITY_HETERO_ATOM = 32;
    private static final int ELEMENTS = 83;
    private static final int MAX_NUM_ATOMS = 256;
    static final int LEN_RING_CLOSURES = 8;
    static final int LEN_MAPPING_BLOCK = 8;
    private StereoMolecule mol;
    private StereoMolecule frag;
    private int[] arrTotalFormularMol = new int[83];
    private int[] arrTotalFormularFrag = new int[83];
    private int[] arrCardinalityFragment = new int[256];
    private boolean[] arrVisited;
    private int[] arrMapMolecule;
    private List<int[]> liMatches;
    private PossibleMappingsFrag2Mol[] arrProcessingArray;
    private int[] arrFragIndexConnected = new int[256];
    private int[] arrMapFrag2ProcessingArray = new int[256];
    private boolean maxCapacityMatchListContainerReached;
    private LinkedList<PossibleMappingsFrag2Mol> liQueue;
    private List<Integer> liFragmentAtomNeighbours;
    private final int maxCapacity;

    public SubStructSearchExhaustiveTreeWalker() {
        this.arrMapMolecule = new int[256];
        this.arrVisited = new boolean[256];
        this.arrProcessingArray = new PossibleMappingsFrag2Mol[256];
        this.liQueue = new LinkedList();
        this.liFragmentAtomNeighbours = new ArrayList<Integer>();
        this.maxCapacity = 64;
        this.initProcessingArray();
    }

    public void setMolecule(StereoMolecule stereoMolecule) {
        this.mol = stereoMolecule;
    }

    public void setFragment(StereoMolecule stereoMolecule) {
        this.frag = stereoMolecule;
        this.calculateCardinalityFragment();
    }

    public int findFragmentInMolecule() {
        if (!this.isFulfillPrechecks()) {
            return 0;
        }
        this.maxCapacityMatchListContainerReached = false;
        int n = this.frag.getAtoms();
        int n2 = this.mol.getAtoms();
        Arrays.fill(this.arrMapMolecule, 0, n2, -1);
        Object object = new int[n];
        this.liMatches = new ArrayList<int[]>();
        Arrays.fill(object, -1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.determineProcessingArray();
        boolean bl = true;
        int n3 = 0;
        block0: while (bl) {
            Object object2;
            int n4;
            int n5;
            PossibleMappingsFrag2Mol possibleMappingsFrag2Mol = this.arrProcessingArray[n3];
            while (possibleMappingsFrag2Mol.empty()) {
                if (--n3 < 0) {
                    bl = false;
                    break block0;
                }
                possibleMappingsFrag2Mol = this.arrProcessingArray[n3];
                n5 = this.arrProcessingArray[n3].getIndexAtomFrag();
                n4 = object[n5];
                object[n5] = -1;
                this.arrMapMolecule[n4] = -1;
            }
            n5 = possibleMappingsFrag2Mol.pollIndexMappingAtomMolecule();
            n4 = possibleMappingsFrag2Mol.getIndexAtomFrag();
            object[n4] = n5;
            this.arrMapMolecule[n5] = n4;
            if (++n3 == n) {
                if (this.liMatches.size() == this.maxCapacity) {
                    this.maxCapacityMatchListContainerReached = true;
                    break;
                }
                this.liMatches.add((int[])object);
                object2 = new int[n];
                n3 = 0;
                object2[0] = object[0];
                for (int i = 1; i < n; ++i) {
                    object2[i] = -1;
                    this.arrProcessingArray[i].resetMappingMolecules();
                }
                object = object2;
                continue;
            }
            object2 = this.arrProcessingArray[n3];
            this.getAvailableMoleculeAtomNeighbours((PossibleMappingsFrag2Mol)object2, (int[])object, this.arrMapMolecule, (List<Integer>)arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)iterator.next();
                ((PossibleMappingsFrag2Mol)object2).addIndexMappingAtomMolecule(n6);
            }
        }
        return this.liMatches.size();
    }

    public List<int[]> getMatches() {
        return this.liMatches;
    }

    private void determineProcessingArray() {
        for (int i = 0; i < this.frag.getAtoms(); ++i) {
            this.arrProcessingArray[i].reset();
            this.arrVisited[i] = false;
        }
        this.determinePossibleMappingsFrag2MolStart();
        PossibleMappingsFrag2Mol possibleMappingsFrag2Mol = this.arrProcessingArray[0];
        int n = 0;
        ++n;
        this.arrVisited[possibleMappingsFrag2Mol.getIndexAtomFrag()] = true;
        this.liQueue.clear();
        this.liQueue.add(possibleMappingsFrag2Mol);
        this.liFragmentAtomNeighbours.clear();
        while (!this.liQueue.isEmpty()) {
            PossibleMappingsFrag2Mol possibleMappingsFrag2Mol2 = this.liQueue.pollLast();
            int n2 = possibleMappingsFrag2Mol2.getIndexAtomFrag();
            this.getFragmentAtomNeighbours(n2, this.liFragmentAtomNeighbours);
            for (int n3 : this.liFragmentAtomNeighbours) {
                if (this.arrVisited[n3]) continue;
                this.arrVisited[n3] = true;
                PossibleMappingsFrag2Mol possibleMappingsFrag2Mol3 = this.arrProcessingArray[n];
                possibleMappingsFrag2Mol3.setIndexAtomFrag(n3);
                possibleMappingsFrag2Mol2.addChild(possibleMappingsFrag2Mol3);
                ++n;
                this.liQueue.push(possibleMappingsFrag2Mol3);
            }
        }
        this.addRingClosures(this.arrProcessingArray);
    }

    private void addRingClosures(PossibleMappingsFrag2Mol[] possibleMappingsFrag2MolArray) {
        int n;
        int n2 = this.frag.getAtoms();
        for (n = 0; n < n2; ++n) {
            this.arrMapFrag2ProcessingArray[possibleMappingsFrag2MolArray[n].getIndexAtomFrag()] = n;
        }
        for (n = n2 - 1; n >= 0; --n) {
            int n3;
            int n4;
            int n5;
            PossibleMappingsFrag2Mol possibleMappingsFrag2Mol = possibleMappingsFrag2MolArray[n];
            int n6 = possibleMappingsFrag2Mol.getIndexAtomFrag();
            int n7 = 0;
            if (possibleMappingsFrag2Mol.getParent() != null) {
                ++n7;
            }
            if ((n7 += (n5 = possibleMappingsFrag2Mol.getChilds())) == (n4 = this.frag.getConnAtoms(n6))) continue;
            Arrays.fill(this.arrFragIndexConnected, 0, n2, 0);
            if (possibleMappingsFrag2Mol.getParent() != null) {
                this.arrFragIndexConnected[possibleMappingsFrag2Mol.getParent().getIndexAtomFrag()] = 1;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                PossibleMappingsFrag2Mol possibleMappingsFrag2Mol2 = possibleMappingsFrag2Mol.getChild(n3);
                this.arrFragIndexConnected[possibleMappingsFrag2Mol2.getIndexAtomFrag()] = 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int n8;
                int n9;
                int n10 = this.frag.getConnAtom(n6, n3);
                if (this.arrFragIndexConnected[n10] != 0 || (n9 = this.arrMapFrag2ProcessingArray[n10]) >= (n8 = possibleMappingsFrag2Mol.getIndexProcessingArray())) continue;
                possibleMappingsFrag2Mol.addIndexCounterAtomFragmentRingClosure(n10);
            }
        }
    }

    private void getFragmentAtomNeighbours(int n, List<Integer> list) {
        list.clear();
        int n2 = this.frag.getConnAtoms(n);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.frag.getConnAtom(n, i);
            list.add(n3);
        }
    }

    private void getAvailableMoleculeAtomNeighbours(PossibleMappingsFrag2Mol possibleMappingsFrag2Mol, int[] nArray, int[] nArray2, List<Integer> list) {
        PossibleMappingsFrag2Mol possibleMappingsFrag2Mol2 = possibleMappingsFrag2Mol.getParent();
        int n = nArray[possibleMappingsFrag2Mol2.getIndexAtomFrag()];
        int n2 = possibleMappingsFrag2Mol.getIndexAtomFrag();
        int n3 = possibleMappingsFrag2Mol2.getIndexAtomFrag();
        list.clear();
        int n4 = this.mol.getConnAtoms(n);
        int n5 = this.frag.getBond(n3, n2);
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7 = this.mol.getConnAtom(n, i);
            if (nArray2[n7] != -1 || !this.areAtomsSimilar(n7, n2) || !this.areBondsSimilar(n6 = this.mol.getBond(n, n7), n5)) continue;
            boolean bl = true;
            if (possibleMappingsFrag2Mol.getRingClosures() > 0 && !this.isRingClosureBondMatch(possibleMappingsFrag2Mol, n7, nArray)) {
                bl = false;
            }
            if (!bl) continue;
            list.add(n7);
        }
    }

    private boolean isRingClosureBondMatch(PossibleMappingsFrag2Mol possibleMappingsFrag2Mol, int n, int[] nArray) {
        boolean bl = true;
        int n2 = possibleMappingsFrag2Mol.getRingClosures();
        int n3 = possibleMappingsFrag2Mol.getIndexAtomFrag();
        for (int i = 0; i < n2; ++i) {
            int n4 = possibleMappingsFrag2Mol.getIndexCounterAtomFragmentRingClosure(i);
            int n5 = nArray[n4];
            int n6 = this.frag.getBond(n4, n3);
            int n7 = this.mol.getBond(n5, n);
            if (n7 == -1) {
                bl = false;
                break;
            }
            if (this.areBondsSimilar(n7, n6)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean areAtomsSimilar(int n, int n2) {
        int n3 = this.mol.getConnAtoms(n);
        int n4 = this.frag.getConnAtoms(n2);
        if (n4 > n3) {
            return false;
        }
        if (this.frag.getAtomicNo(n2) == 0) {
            return true;
        }
        if (this.mol.getAtomicNo(n) == 0) {
            return false;
        }
        return this.mol.getAtomicNo(n) == this.frag.getAtomicNo(n2);
    }

    private boolean areBondsSimilar(int n, int n2) {
        boolean bl = false;
        if (this.mol.isDelocalizedBond(n) && this.frag.isDelocalizedBond(n2)) {
            bl = true;
        } else if (this.mol.getBondType(n) == this.frag.getBondType(n2)) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        return bl;
    }

    private boolean isFulfillPrechecks() {
        boolean bl = true;
        if (this.frag.getAtoms() > this.mol.getAtoms()) {
            return false;
        }
        if (this.frag.getBonds() > this.mol.getBonds()) {
            return false;
        }
        return bl;
    }

    private void initProcessingArray() {
        PossibleMappingsFrag2Mol possibleMappingsFrag2Mol;
        this.arrProcessingArray[0] = possibleMappingsFrag2Mol = new PossibleMappingsFrag2Mol(0, 256);
        for (int i = 1; i < this.arrProcessingArray.length; ++i) {
            this.arrProcessingArray[i] = new PossibleMappingsFrag2Mol(i);
        }
    }

    private void determinePossibleMappingsFrag2MolStart() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.frag.getAtoms(); ++i) {
            if (this.arrCardinalityFragment[i] <= n) continue;
            n = this.arrCardinalityFragment[i];
            n2 = i;
        }
        PossibleMappingsFrag2Mol possibleMappingsFrag2Mol = this.arrProcessingArray[0];
        possibleMappingsFrag2Mol.setIndexAtomFrag(n2);
        for (int i = 0; i < this.mol.getAtoms(); ++i) {
            if (!this.areAtomsSimilar(i, n2)) continue;
            possibleMappingsFrag2Mol.addIndexMappingAtomMolecule(i);
        }
    }

    private void calculateCardinalityFragment() {
        for (int i = 0; i < this.frag.getAtoms(); ++i) {
            this.arrCardinalityFragment[i] = SubStructSearchExhaustiveTreeWalker.calculateCardinality(this.frag, i);
        }
    }

    private static int calculateCardinality(StereoMolecule stereoMolecule, int n) {
        int n2 = 0;
        int n3 = stereoMolecule.getAtomicNo(n);
        if (n3 != 1 && n3 != 6) {
            n2 += 32;
        }
        if (stereoMolecule.isRingAtom(n)) {
            n2 += 16;
        }
        return n2;
    }

    public boolean isMaxCapacityMatchListContainerReached() {
        return this.maxCapacityMatchListContainerReached;
    }
}

