/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.ContainerListWithIntVec;
import com.actelion.research.chem.mcs.ListWithIntVec;
import com.actelion.research.util.SizeOf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ExhaustiveFragmentGeneratorAtoms {
    private static final boolean DEBUG = false;
    private static int MAX_NUM_FRAGMENTS = 400000;
    private static int CAPACITY_FRAGMENTS = 8000000;
    private static final int MAX_NUM_ATOMS = 256;
    private List<HashSet<ListWithIntVec>> liHashSetIntegerList;
    private ExtendedMolecule mol;
    private int nAtomsMolecule;
    private int sizeIntVec;
    private int maximumFragmentSite;
    private ListWithIntVec livNeighbours;
    private ContainerListWithIntVec containerListWithIntVec;
    private List<ListWithIntVec> liIntegerListSolution = new ArrayList<ListWithIntVec>();
    private List<ListWithIntVec> liIntegerListTmp = new ArrayList<ListWithIntVec>();
    private boolean fragmentsGenerated;
    private int capacityLimitBreakes;

    public ExhaustiveFragmentGeneratorAtoms() {
        int n = 8;
        this.containerListWithIntVec = new ContainerListWithIntVec(n, CAPACITY_FRAGMENTS);
        System.out.println("ExhaustiveFragmentGenerator Used mem " + SizeOf.usedMemoryMB() + "[MB].");
    }

    public void set(ExtendedMolecule extendedMolecule, int n) {
        this.initHashSet(n);
        this.mol = extendedMolecule;
        this.nAtomsMolecule = extendedMolecule.getAtoms();
        if (this.nAtomsMolecule > 256) {
            throw new RuntimeException("Maximum number of atoms exceeded.");
        }
        this.sizeIntVec = (this.nAtomsMolecule + 32 - 1) / 32;
        this.maximumFragmentSite = n;
        this.livNeighbours = new ListWithIntVec(this.sizeIntVec, -1);
        this.fragmentsGenerated = false;
        this.containerListWithIntVec.reset();
        this.capacityLimitBreakes = 0;
    }

    private void initHashSet(int n) {
        int n2;
        this.liIntegerListSolution.clear();
        this.liIntegerListTmp.clear();
        if (this.liHashSetIntegerList == null) {
            this.liHashSetIntegerList = new ArrayList<HashSet<ListWithIntVec>>();
        }
        int n3 = this.liHashSetIntegerList.size();
        for (n2 = 0; n2 < this.liHashSetIntegerList.size(); ++n2) {
            this.liHashSetIntegerList.get(n2).clear();
        }
        for (n2 = n3; n2 < n + 1; ++n2) {
            int n4 = 1000;
            if (n2 > 15) {
                n4 = 1000000;
            } else if (n2 > 10) {
                n4 = 100000;
            } else if (n2 > 5) {
                n4 = 10000;
            }
            this.liHashSetIntegerList.add(new HashSet(n4));
        }
    }

    public void generateFragments() {
        int n = this.mol.getAtoms();
        for (int i = 0; i < n; ++i) {
            this.getAllPossibleNeigbourCombinationsConsidersPrevious(i);
        }
        this.fragmentsGenerated = true;
    }

    public List<ListWithIntVec> get(int n) {
        if (!this.fragmentsGenerated) {
            throw new RuntimeException("Fragments have to be generated first. Call generateFragments().");
        }
        return new ArrayList<ListWithIntVec>((Collection)this.liHashSetIntegerList.get(n));
    }

    public List<ListWithIntVec> getFragmentsForSingleAtom(int n) {
        this.initHashSet(this.maximumFragmentSite);
        return this.getAllPossibleNeigbourCombinationsConsidersPrevious(n);
    }

    private List<ListWithIntVec> getAllPossibleNeigbourCombinationsConsidersPrevious(int n) {
        this.liIntegerListSolution.clear();
        ListWithIntVec listWithIntVec = this.containerListWithIntVec.get();
        listWithIntVec.addBit(n);
        listWithIntVec.calculateHash();
        this.liIntegerListSolution.add(listWithIntVec);
        if (this.maximumFragmentSite == 1) {
            return this.liIntegerListSolution;
        }
        boolean bl = false;
        while (!bl) {
            this.liIntegerListTmp.clear();
            int n2 = this.liIntegerListSolution.get(0).size();
            HashSet<ListWithIntVec> hashSet = this.liHashSetIntegerList.get(n2 + 1);
            if (hashSet.size() >= MAX_NUM_FRAGMENTS) {
                ++this.capacityLimitBreakes;
                break;
            }
            block1: for (ListWithIntVec listWithIntVec2 : this.liIntegerListSolution) {
                ListWithIntVec listWithIntVec3 = this.getAllReachableNeighbours(this.mol, listWithIntVec2);
                for (int i = 0; i < listWithIntVec3.size(); ++i) {
                    ListWithIntVec listWithIntVec4 = this.containerListWithIntVec.getWithCopy(listWithIntVec2);
                    if (listWithIntVec4.addBit(listWithIntVec3.get(i))) {
                        listWithIntVec4.calculateHash();
                        if (hashSet.add(listWithIntVec4)) {
                            this.liIntegerListTmp.add(listWithIntVec4);
                            if (this.liIntegerListTmp.size() != MAX_NUM_FRAGMENTS) continue;
                            ++this.capacityLimitBreakes;
                            break block1;
                        }
                        this.containerListWithIntVec.back(listWithIntVec4);
                        continue;
                    }
                    this.containerListWithIntVec.back(listWithIntVec4);
                }
            }
            this.liIntegerListSolution.clear();
            this.liIntegerListSolution.addAll(this.liIntegerListTmp);
            if (this.liIntegerListSolution.isEmpty()) {
                bl = true;
                continue;
            }
            int n3 = this.liIntegerListSolution.get(0).size();
            for (ListWithIntVec listWithIntVec3 : this.liIntegerListSolution) {
                if (listWithIntVec3.size() == this.maximumFragmentSite) {
                    bl = true;
                }
                if (n3 == listWithIntVec3.size()) continue;
                throw new RuntimeException("Error in algorithm.");
            }
        }
        return this.liIntegerListSolution;
    }

    private ListWithIntVec getAllReachableNeighbours(ExtendedMolecule extendedMolecule, ListWithIntVec listWithIntVec) {
        this.livNeighbours.reset();
        for (int i = 0; i < listWithIntVec.size(); ++i) {
            int n = listWithIntVec.get(i);
            int n2 = extendedMolecule.getAllConnAtoms(n);
            for (int j = 0; j < n2; ++j) {
                int n3 = extendedMolecule.getConnAtom(n, j);
                if (listWithIntVec.isBitSet(n3)) continue;
                this.livNeighbours.addBit(n3);
            }
        }
        return this.livNeighbours;
    }

    public int getCapacityLimitBreakes() {
        return this.capacityLimitBreakes;
    }

    public static String getIdCodeFromFragment(StereoMolecule stereoMolecule, ListWithIntVec listWithIntVec) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < listWithIntVec.size(); ++i) {
            blArray[listWithIntVec.get((int)i)] = true;
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
        stereoMolecule2.ensureHelperArrays(7);
        Canonizer canonizer = new Canonizer(stereoMolecule2);
        return canonizer.getIDCode();
    }
}

