/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.parser;

import com.actelion.research.chem.io.pdb.parser.AtomRecord;
import java.util.List;

public class ModelParser {
    private int indexLine;

    public void parse(List<String> list, int n, List<AtomRecord> list2, List<AtomRecord> list3) {
        String string = "ATOM";
        String string2 = "HETATM";
        String string3 = list.get(n);
        if (!(string3.startsWith(string) || string3.startsWith(string2) || string3.startsWith("MODEL"))) {
            throw new RuntimeException("Error in parsing atoms.");
        }
        this.indexLine = n;
        int n2 = n;
        AtomRecord atomRecord = null;
        for (int i = n2; i < list.size(); ++i) {
            AtomRecord atomRecord2;
            String string4 = list.get(i);
            if (string4.startsWith(string)) {
                atomRecord = atomRecord2 = this.parseAtom(string4);
                list2.add(atomRecord2);
                continue;
            }
            if (string4.startsWith(string2)) {
                atomRecord = atomRecord2 = this.parseAtom(string4);
                list3.add(atomRecord2);
                continue;
            }
            if (string4.startsWith("ANISOU")) continue;
            if (string4.startsWith("TER")) {
                if (atomRecord == null) continue;
                atomRecord.setTerminalC(true);
                continue;
            }
            if (string4.startsWith("MODEL")) continue;
            if (string4.startsWith("ENDMDL")) {
                if (atomRecord == null) continue;
                atomRecord.setTerminalC(true);
                continue;
            }
            this.indexLine = i;
            break;
        }
    }

    private AtomRecord parseAtom(String string) {
        int n = Integer.parseInt(string.substring(6, 11).trim());
        String string2 = string.substring(12, 16).trim();
        String string3 = string.substring(16, 17).trim();
        String string4 = string.substring(17, 20).trim();
        String string5 = string.substring(21, 22).trim();
        int n2 = Integer.parseInt(string.substring(22, 26).trim());
        String string6 = string.substring(26, 27).trim();
        double d = Double.parseDouble(string.substring(30, 38).trim());
        double d2 = -Double.parseDouble(string.substring(38, 46).trim());
        double d3 = -Double.parseDouble(string.substring(46, 54).trim());
        double d4 = string.length() < 60 ? 1.0 : Double.parseDouble(string.substring(54, 60).trim());
        double d5 = string.length() < 66 ? 50.0 : Double.parseDouble(string.substring(60, 66).trim());
        String string7 = string.length() < 78 ? string2.substring(0, 1) : string.substring(76, 78).trim();
        string7 = string7.toLowerCase();
        string7 = string7.substring(0, 1).toUpperCase() + string7.substring(1);
        AtomRecord atomRecord = new AtomRecord(n, string2, string3, string4, string5, n2, string6, d, d2, d3, d4, d5, string7);
        return atomRecord;
    }

    public int getIndexLine() {
        return this.indexLine;
    }
}

