/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.converter;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;

public class GeometryCalculator {
    public static final Coordinates getCoordinates(StereoMolecule stereoMolecule, int n) {
        return new Coordinates(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomZ(n));
    }

    public static final double getAngle(StereoMolecule stereoMolecule, int n, int n2, int n3) {
        Coordinates coordinates = stereoMolecule.getCoordinates(n);
        Coordinates coordinates2 = stereoMolecule.getCoordinates(n2);
        Coordinates coordinates3 = stereoMolecule.getCoordinates(n3);
        return coordinates.subC(coordinates2).getAngle(coordinates3.subC(coordinates2));
    }

    public static final double getAngle(Coordinates coordinates, Coordinates coordinates2, Coordinates coordinates3) {
        return coordinates.subC(coordinates2).getAngle(coordinates3.subC(coordinates2));
    }

    public static final double getDihedral(StereoMolecule stereoMolecule, int n, int n2, int n3, int n4) {
        Coordinates coordinates = stereoMolecule.getCoordinates(n);
        Coordinates coordinates2 = stereoMolecule.getCoordinates(n2);
        Coordinates coordinates3 = stereoMolecule.getCoordinates(n3);
        Coordinates coordinates4 = stereoMolecule.getCoordinates(n4);
        return coordinates.getDihedral(coordinates2, coordinates3, coordinates4);
    }

    public static final Coordinates getCenterGravity(StereoMolecule stereoMolecule) {
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            coordinates.x += stereoMolecule.getAtomX(i);
            coordinates.y += stereoMolecule.getAtomY(i);
            coordinates.z += stereoMolecule.getAtomZ(i);
        }
        coordinates.x /= (double)stereoMolecule.getAllAtoms();
        coordinates.y /= (double)stereoMolecule.getAllAtoms();
        coordinates.z /= (double)stereoMolecule.getAllAtoms();
        return coordinates;
    }

    public static final Coordinates[] getBounds(StereoMolecule stereoMolecule) {
        if (stereoMolecule.getAllAtoms() == 0) {
            return new Coordinates[]{new Coordinates(0.0, 0.0, 0.0), new Coordinates(0.0, 0.0, 0.0)};
        }
        Coordinates[] coordinatesArray = new Coordinates[]{new Coordinates(3.4028234663852886E38, 3.4028234663852886E38, 3.4028234663852886E38), new Coordinates(-3.4028234663852886E38, -3.4028234663852886E38, -3.4028234663852886E38)};
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            coordinatesArray[0].x = Math.min(coordinatesArray[0].x, stereoMolecule.getAtomX(i));
            coordinatesArray[0].y = Math.min(coordinatesArray[0].y, stereoMolecule.getAtomY(i));
            coordinatesArray[0].z = Math.min(coordinatesArray[0].z, stereoMolecule.getAtomZ(i));
            coordinatesArray[1].x = Math.max(coordinatesArray[1].x, stereoMolecule.getAtomX(i));
            coordinatesArray[1].y = Math.max(coordinatesArray[1].y, stereoMolecule.getAtomY(i));
            coordinatesArray[1].z = Math.max(coordinatesArray[1].z, stereoMolecule.getAtomZ(i));
        }
        return coordinatesArray;
    }

    public static final void translate(StereoMolecule stereoMolecule, Coordinates coordinates) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            stereoMolecule.setAtomX(i, stereoMolecule.getAtomX(i) + coordinates.x);
            stereoMolecule.setAtomY(i, stereoMolecule.getAtomY(i) + coordinates.y);
            stereoMolecule.setAtomZ(i, stereoMolecule.getAtomZ(i) + coordinates.z);
        }
    }
}

