/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;

public class RXNFileParser {
    private static final String RXN_V3_COUNTS_LINE = "M  V30 COUNTS";
    private static final String V30_BEGIN_REACTANT = "M  V30 BEGIN REACTANT";
    private static final String V30_BEGIN_PRODUCT = "M  V30 BEGIN PRODUCT";
    private static final String RXN_MAGIC = "$RXN";
    private static final String RXN_V3_MAGIC = "$RXN V3000";
    private static final String END_CTAB = "M  V30 END CTAB";
    private static final String END_MOL_TAG = "M  END";
    private static final String MOL_MAGIC = "$MOL";
    private static final String AUX_MOLFILE_HEADER = "\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n";
    private static final int DEFAULT_CAPACITY = 32768;

    public Reaction getReaction(String string) throws Exception {
        return this.getReaction(string, false);
    }

    public Reaction getReaction(String string, boolean bl) throws Exception {
        Reaction reaction = new Reaction();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        this.parse(reaction, bufferedReader, bl);
        return reaction;
    }

    public Reaction getReaction(File file) throws Exception {
        return this.getReaction(file, false);
    }

    public Reaction getReaction(File file, boolean bl) throws Exception {
        Reaction reaction = new Reaction();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BOMSkipper.skip(bufferedReader);
        this.parse(reaction, bufferedReader, bl);
        return reaction;
    }

    public boolean parse(Reaction reaction, String string) throws Exception {
        return this.parse(reaction, string, false);
    }

    public boolean parse(Reaction reaction, String string, boolean bl) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        return this.parse(reaction, bufferedReader, bl);
    }

    public boolean parse(Reaction reaction, File file) throws Exception {
        return this.parse(reaction, file, false);
    }

    public boolean parse(Reaction reaction, File file, boolean bl) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BOMSkipper.skip(bufferedReader);
        return this.parse(reaction, bufferedReader, bl);
    }

    public boolean parse(Reaction reaction, BufferedReader bufferedReader) throws Exception {
        return this.parse(reaction, bufferedReader, false);
    }

    public boolean parse(Reaction reaction, BufferedReader bufferedReader, boolean bl) throws Exception {
        String string = bufferedReader.readLine();
        boolean bl2 = false;
        if (string == null || !string.startsWith(RXN_MAGIC)) {
            throw new Exception("'$RXN' tag not found");
        }
        bl2 = string.equals(RXN_V3_MAGIC) ? this.parseV3(reaction, bufferedReader, bl) : this.parseV2(reaction, bufferedReader, bl);
        return bl2;
    }

    private boolean parseV3(Reaction reaction, BufferedReader bufferedReader, boolean bl) throws Exception {
        String string;
        String string2 = bufferedReader.readLine().trim();
        if (string2.length() != 0) {
            reaction.setName(string2);
        }
        bufferedReader.readLine();
        String string3 = bufferedReader.readLine();
        if (!bl && string3.startsWith("OCL_RXN_V1.0:") && ReactionEncoder.decode(string = string3.substring("OCL_RXN_V1.0:".length()), true, reaction) != null) {
            return true;
        }
        string = bufferedReader.readLine();
        MolfileParser molfileParser = new MolfileParser();
        if (string != null && string.startsWith(RXN_V3_COUNTS_LINE)) {
            StringBuffer stringBuffer;
            StereoMolecule stereoMolecule;
            int n;
            String string4 = string.substring(13).trim();
            String[] stringArray = string4.split(" ");
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            if (n2 > 0) {
                string = bufferedReader.readLine();
                if (V30_BEGIN_REACTANT.equals(string)) {
                    for (n = 0; n < n2; ++n) {
                        stereoMolecule = new StereoMolecule();
                        stringBuffer = new StringBuffer(32768);
                        stringBuffer.append(AUX_MOLFILE_HEADER);
                        do {
                            string = bufferedReader.readLine();
                            stringBuffer.append(string);
                            stringBuffer.append("\n");
                        } while (string != null && !string.startsWith(END_CTAB));
                        molfileParser.parse(stereoMolecule, stringBuffer);
                        reaction.addReactant(stereoMolecule);
                    }
                }
                string = bufferedReader.readLine();
            }
            if (n3 > 0 && V30_BEGIN_PRODUCT.equals(string = bufferedReader.readLine())) {
                for (n = 0; n < n3; ++n) {
                    stereoMolecule = new StereoMolecule();
                    stringBuffer = new StringBuffer(32768);
                    stringBuffer.append(AUX_MOLFILE_HEADER);
                    do {
                        string = bufferedReader.readLine();
                        stringBuffer.append(string);
                        stringBuffer.append("\n");
                    } while (string != null && !string.startsWith(END_CTAB));
                    molfileParser.parse(stereoMolecule, stringBuffer);
                    reaction.addProduct(stereoMolecule);
                }
                string = bufferedReader.readLine();
            }
            return true;
        }
        return false;
    }

    private boolean parseV2(Reaction reaction, BufferedReader bufferedReader, boolean bl) throws Exception {
        StringBuffer stringBuffer;
        StereoMolecule stereoMolecule;
        int n;
        String string;
        String string2 = bufferedReader.readLine().trim();
        if (string2.length() != 0) {
            reaction.setName(string2);
        }
        bufferedReader.readLine();
        String string3 = bufferedReader.readLine();
        if (!bl && string3.startsWith("OCL_RXN_V1.0:") && ReactionEncoder.decode(string = string3.substring("OCL_RXN_V1.0:".length()), true, reaction) != null) {
            return true;
        }
        string = bufferedReader.readLine();
        int n2 = Integer.parseInt(string.substring(0, 3).trim());
        int n3 = Integer.parseInt(string.substring(3, 6).trim());
        MolfileParser molfileParser = new MolfileParser();
        for (n = 0; n < n2; ++n) {
            string = bufferedReader.readLine();
            if (string == null || !string.startsWith(MOL_MAGIC)) {
                throw new Exception("'$MOL' tag not found");
            }
            stereoMolecule = new StereoMolecule();
            stringBuffer = new StringBuffer(32768);
            do {
                string = bufferedReader.readLine();
                stringBuffer.append(string);
                stringBuffer.append("\n");
            } while (string != null && !string.startsWith(END_MOL_TAG));
            if (string == null) {
                throw new Exception("'M  END' not found");
            }
            molfileParser.parse(stereoMolecule, stringBuffer);
            reaction.addReactant(stereoMolecule);
        }
        for (n = 0; n < n3; ++n) {
            string = bufferedReader.readLine();
            if (string == null || !string.startsWith(MOL_MAGIC)) {
                throw new Exception("'$MOL' tag not found");
            }
            stereoMolecule = new StereoMolecule();
            stringBuffer = new StringBuffer(32768);
            do {
                string = bufferedReader.readLine();
                stringBuffer.append(string);
                stringBuffer.append("\n");
            } while (string != null && !string.startsWith(END_MOL_TAG));
            if (string == null) {
                throw new Exception("'M  END' not found");
            }
            molfileParser.parse(stereoMolecule, stringBuffer);
            reaction.addProduct(stereoMolecule);
        }
        return true;
    }
}

