/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class RXNFileCreator {
    public static final String RXN_CODE_TAG = "OCL_RXN_V1.0:";
    private static final String NL = System.lineSeparator();
    private StringBuffer rxnbuffer = null;

    public RXNFileCreator(Reaction reaction) {
        this(reaction, null);
    }

    public RXNFileCreator(Reaction reaction, String string) {
        Reaction reaction2 = new Reaction(reaction);
        try {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("$RXN" + NL);
            stringWriter.write(string != null ? string : "");
            stringWriter.write(NL + NL);
            stringWriter.write(RXN_CODE_TAG + ReactionEncoder.encode(reaction, true, 11));
            stringWriter.write(NL);
            stringWriter.write("  " + reaction2.getReactants() + "  " + reaction2.getProducts() + NL);
            double d = this.getScalingFactor(reaction2);
            for (int i = 0; i < reaction2.getMolecules(); ++i) {
                stringWriter.write("$MOL" + NL);
                new MolfileCreator(reaction2.getMolecule(i), true, d, null).writeMolfile(stringWriter);
            }
            this.rxnbuffer = stringWriter.getBuffer();
            stringWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error in RXNFileCreator: " + exception);
        }
    }

    private double getScalingFactor(Reaction reaction) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            d += reaction.getMolecule(i).getAverageBondLength() * (double)reaction.getMolecule(i).getAllBonds();
            n += reaction.getMolecule(i).getAllBonds();
        }
        if (n != 0) {
            return (double)n / d;
        }
        return 1.0;
    }

    public String getRXNfile() {
        return this.rxnbuffer != null ? this.rxnbuffer.toString() : null;
    }

    public void writeRXNfile(Writer writer) throws IOException {
        if (this.rxnbuffer == null) {
            throw new IOException("NULL RXNFileBuffer!");
        }
        writer.write(this.rxnbuffer.toString());
    }
}

