/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandlerStandard2DFactory;
import com.actelion.research.chem.descriptor.DescriptorHelper;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.io.CompoundTableConstants;
import com.actelion.research.io.BOMSkipper;
import com.actelion.research.util.BinaryDecoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

public class DWARFileParser
extends CompoundFileParser
implements DescriptorConstants,
CompoundTableConstants {
    public static final int MODE_COORDINATES_PREFER_2D = 1;
    public static final int MODE_COORDINATES_PREFER_3D = 2;
    public static final int MODE_COORDINATES_REQUIRE_2D = 3;
    public static final int MODE_COORDINATES_REQUIRE_3D = 4;
    private static final int MODE_COORDINATE_MASK = 7;
    public static final int MODE_BUFFER_HEAD_AND_TAIL = 8;
    public static final int MODE_EXTRACT_DETAILS = 16;
    private String[] mFieldName;
    private String[] mFieldData;
    private String mLine;
    private String mCoordinate3DColumnName;
    private int[] mFieldIndex;
    private int mRecordCount;
    private int mMode;
    private int mIDCodeColumn;
    private int mCoordinateColumn;
    private int mCoordinate2DColumn;
    private int mCoordinate3DColumn;
    private int mMoleculeNameColumn;
    private int mFragFpColumn;
    private TreeMap<String, Properties> mColumnPropertyMap;
    private TreeMap<String, SpecialField> mSpecialFieldMap;
    private TreeMap<String, Integer> mDescriptorColumnMap;
    private ArrayList<String> mHeadOrTailLineList;
    private HashMap<String, byte[]> mDetails;

    public DWARFileParser(String string) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = 1;
            this.init();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    public DWARFileParser(File file) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = 1;
            this.init();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    public DWARFileParser(Reader reader) {
        try {
            this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.mMode = 1;
            this.init();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    public DWARFileParser(String string, int n) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = n;
            this.init();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    public DWARFileParser(File file, int n) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = n;
            this.init();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    public DWARFileParser(Reader reader, int n) {
        try {
            this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.mMode = n;
            this.init();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    private String readHeadOrTailLine() throws IOException {
        String string = this.mReader.readLine();
        if ((this.mMode & 8) != 0 && string != null) {
            this.mHeadOrTailLineList.add(string);
        }
        return string;
    }

    private void init() throws IOException {
        Object object2;
        this.setDescriptorHandlerFactory(DescriptorHandlerStandard2DFactory.getFactory());
        if ((this.mMode & 8) != 0) {
            this.mHeadOrTailLineList = new ArrayList();
        }
        int n = this.mMode & 7;
        String string = this.readHeadOrTailLine();
        if (string == null || !string.equals("<datawarrior-fileinfo>")) {
            throw new IOException("no header found");
        }
        this.mRecordCount = -1;
        string = this.readHeadOrTailLine();
        while (string != null && !string.equals("</datawarrior-fileinfo>")) {
            if (string.startsWith("<version")) {
                object2 = this.extractValue(string);
                if (!((String)object2).startsWith("3.") && !((String)object2).equals("")) {
                    throw new IOException("unsupported .dwar file version");
                }
            } else if (string.startsWith("<rowcount")) {
                try {
                    this.mRecordCount = Integer.parseInt(this.extractValue(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string = this.readHeadOrTailLine();
        }
        string = this.readHeadOrTailLine();
        while (string != null && (string.equals("<datawarrior explanation>") || string.equals("<datawarrior macroList>"))) {
            string = this.readHeadOrTailLine();
            while (string != null && !string.equals("</datawarrior explanation>") && !string.equals("</datawarrior macroList>")) {
                string = this.readHeadOrTailLine();
            }
            string = this.readHeadOrTailLine();
        }
        this.mColumnPropertyMap = new TreeMap();
        if (string != null && string.equals("<column properties>")) {
            string = this.readHeadOrTailLine();
            object2 = null;
            while (string != null && !string.equals("</column properties>")) {
                if (string.startsWith("<columnName")) {
                    object2 = this.extractValue(string);
                    this.mColumnPropertyMap.put((String)object2, new Properties());
                } else if (string.startsWith("<columnProperty")) {
                    String[] object3 = this.extractValue(string).split("\\t");
                    if (object3.length == 1) {
                        this.mColumnPropertyMap.get(object2).setProperty(object3[0], "");
                    } else {
                        this.mColumnPropertyMap.get(object2).setProperty(object3[0], object3[1]);
                    }
                }
                string = this.readHeadOrTailLine();
            }
            string = this.readHeadOrTailLine();
        }
        this.mSpecialFieldMap = new TreeMap();
        for (String string2 : this.mColumnPropertyMap.keySet()) {
            Properties properties = this.mColumnPropertyMap.get(string2);
            String string3 = properties.getProperty("specialType");
            if (string3 == null) continue;
            this.mSpecialFieldMap.put(string2, new SpecialField(string2, string3, properties.getProperty("parent"), properties.getProperty("idColumn"), properties.getProperty("version")));
        }
        object2 = new ArrayList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string == null) {
            throw new IOException("unexpected end of file");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            String string4;
            if ((n3 = string.indexOf(9, n2)) == -1) {
                string4 = string.substring(n2);
            } else {
                string4 = string.substring(n2, n3);
                n2 = n3 + 1;
            }
            if (this.mSpecialFieldMap.containsKey(string4)) {
                this.mSpecialFieldMap.get((Object)string4).fieldIndex = n4;
            } else {
                ((ArrayList)object2).add(string4);
                arrayList.add(new Integer(n4));
            }
            ++n4;
        } while (n3 != -1);
        this.mFieldName = new String[((ArrayList)object2).size()];
        this.mFieldIndex = new int[((ArrayList)object2).size()];
        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            this.mFieldName[i] = (String)((ArrayList)object2).get(i);
            this.mFieldIndex[i] = (Integer)arrayList.get(i);
        }
        this.mFieldData = new String[n4];
        this.mIDCodeColumn = -1;
        this.mCoordinateColumn = -1;
        this.mCoordinate2DColumn = -1;
        this.mCoordinate3DColumn = -1;
        this.mMoleculeNameColumn = -1;
        this.mFragFpColumn = -1;
        SpecialField specialField = this.mSpecialFieldMap.get("Structure");
        if (specialField == null || !specialField.type.equals("idcode")) {
            for (SpecialField specialField2 : this.mSpecialFieldMap.values()) {
                if (!specialField2.type.equals("idcode") || specialField != null && specialField.fieldIndex <= specialField2.fieldIndex) continue;
                specialField = specialField2;
            }
        }
        if (specialField != null) {
            if (specialField.idColumn != null) {
                for (int i = 0; i < this.mFieldName.length; ++i) {
                    if (!specialField.idColumn.equals(this.mFieldName[i])) continue;
                    this.mMoleculeNameColumn = this.mFieldIndex[i];
                    break;
                }
            }
            this.mIDCodeColumn = specialField.fieldIndex;
            for (SpecialField specialField2 : this.mSpecialFieldMap.values()) {
                if (!specialField.name.equals(specialField2.parent)) continue;
                if (DWARFileParser.DESCRIPTOR_FFP512.shortName.equals(specialField2.type) && "1.2.1".equals(specialField2.version)) {
                    this.mFragFpColumn = specialField2.fieldIndex;
                } else if ("idcoordinates2D".equals(specialField2.type)) {
                    this.mCoordinate2DColumn = specialField2.fieldIndex;
                } else if ("idcoordinates3D".equals(specialField2.type)) {
                    this.mCoordinate3DColumn = specialField2.fieldIndex;
                    this.mCoordinate3DColumnName = specialField2.name;
                }
                if (!DescriptorHelper.isDescriptorShortName(specialField2.type) || !DescriptorHelper.getDescriptorInfo((String)specialField2.type).version.equals(specialField2.version)) continue;
                if (this.mDescriptorColumnMap == null) {
                    this.mDescriptorColumnMap = new TreeMap();
                }
                this.mDescriptorColumnMap.put(specialField2.type, new Integer(specialField2.fieldIndex));
            }
            if (this.mCoordinate2DColumn != -1 && (n == 3 || n == 1 || n == 2 && this.mCoordinate3DColumn == -1)) {
                this.mCoordinateColumn = this.mCoordinate2DColumn;
            }
            if (this.mCoordinate3DColumn != -1 && (n == 4 || n == 2 || n == 1 && this.mCoordinate2DColumn == -1)) {
                this.mCoordinateColumn = this.mCoordinate3DColumn;
            }
        }
    }

    public boolean hasStructures() {
        return this.mIDCodeColumn != -1;
    }

    public boolean hasStructureCoordinates() {
        return this.mCoordinateColumn != -1;
    }

    public boolean hasStructureCoordinates2D() {
        return this.mCoordinate2DColumn != -1;
    }

    public boolean hasStructureCoordinates3D() {
        return this.mCoordinate3DColumn != -1;
    }

    public String getStructureCoordinates3DColumnName() {
        return this.mCoordinate3DColumnName;
    }

    @Override
    public String[] getFieldNames() {
        return this.mFieldName;
    }

    public int getSpecialFieldIndex(String string) {
        for (SpecialField specialField : this.mSpecialFieldMap.values()) {
            if (!string.equals(specialField.name)) continue;
            return specialField.fieldIndex;
        }
        return -1;
    }

    public int getChildFieldIndex(String string, String string2) {
        for (SpecialField specialField : this.mSpecialFieldMap.values()) {
            if (!string.equals(specialField.parent) || !string2.equals(specialField.type)) continue;
            return specialField.fieldIndex;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.mRecordCount;
    }

    public ArrayList<String> getHeadOrTail() {
        return this.mHeadOrTailLineList;
    }

    public HashMap<String, byte[]> getDetails() {
        return this.mDetails;
    }

    public String getRow() {
        return this.mLine;
    }

    @Override
    protected boolean advanceToNext() {
        if (this.mReader == null) {
            return false;
        }
        this.mLine = null;
        try {
            this.mLine = this.mReader.readLine();
            if (this.mLine == null || this.mLine.equals("<datawarrior properties>") || this.mLine.equals("<hitlist data>") || this.mLine.equals("<detail data>") || this.mLine.startsWith("<data dependent properties type=\"")) {
                if ((this.mMode & 8) != 0) {
                    this.mHeadOrTailLineList.clear();
                    this.mHeadOrTailLineList.add(this.mLine);
                }
                while (this.mLine != null) {
                    if (this.mLine.equals("<detail data>") && (this.mMode & 0x10) != 0) {
                        this.extractDetails();
                    }
                    this.mLine = this.readHeadOrTailLine();
                }
                this.mReader.close();
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.mLine.indexOf(9);
        while (n3 != -1) {
            if (n < this.mFieldData.length) {
                this.mFieldData[n] = this.mLine.substring(n2, n3).replace("<NL>", "\n").replace("<TAB>", "\t");
            }
            ++n;
            n2 = n3 + 1;
            n3 = this.mLine.indexOf(9, n2);
        }
        if (n < this.mFieldData.length) {
            this.mFieldData[n] = this.mLine.substring(n2).replace("<NL>", "\n").replace("<TAB>", "\t");
        }
        return true;
    }

    private void extractDetails() {
        this.mDetails = new HashMap();
        try {
            String string;
            while ((string = this.readHeadOrTailLine()) != null && !string.equals("</detail data>")) {
                if (!string.startsWith("<detailID")) continue;
                String string2 = this.extractValue(string);
                BinaryDecoder binaryDecoder = new BinaryDecoder(this.mReader);
                int n = binaryDecoder.initialize(8);
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)binaryDecoder.read();
                }
                this.mDetails.put(string2, byArray);
            }
        }
        catch (Exception exception) {
            this.mDetails = null;
        }
    }

    @Override
    public String getIDCode() {
        if (this.mIDCodeColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mIDCodeColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public String getCoordinates() {
        if (this.mCoordinateColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mCoordinateColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    public String getCoordinates2D() {
        if (this.mCoordinate2DColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mCoordinate2DColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    public String getCoordinates3D() {
        if (this.mCoordinate3DColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mCoordinate3DColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public String getMoleculeName() {
        if (this.mMoleculeNameColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mMoleculeNameColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public Object getDescriptor(String string) {
        String string2;
        Integer n = this.mDescriptorColumnMap == null ? null : this.mDescriptorColumnMap.get(string);
        String string3 = string2 = n == null ? null : this.mFieldData[n];
        return string2 == null || string2.length() == 0 ? super.getDescriptor(string) : (this.getDescriptorHandlerFactory() == null ? null : this.getDescriptorHandlerFactory().getDefaultDescriptorHandler(string).decode(string2));
    }

    public String getIndex() {
        if (this.mFragFpColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mFragFpColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public String getFieldData(int n) {
        return this.mFieldData[this.mFieldIndex[n]];
    }

    public TreeMap<String, SpecialField> getSpecialFieldMap() {
        return this.mSpecialFieldMap;
    }

    public String getSpecialFieldData(int n) {
        return this.mFieldData[n];
    }

    public Properties getColumnProperties(String string) {
        return this.mColumnPropertyMap.get(string);
    }

    private String extractValue(String string) {
        int n = string.indexOf("=\"") + 2;
        int n2 = string.indexOf("\"", n);
        return string.substring(n, n2);
    }

    public class SpecialField {
        public String name;
        public String type;
        public String parent;
        public String idColumn;
        public String version;
        public int fieldIndex;

        public SpecialField(String string, String string2, String string3, String string4, String string5) {
            this.name = string;
            this.type = string2;
            this.parent = string3;
            this.idColumn = string4;
            this.version = string5;
            this.fieldIndex = -1;
        }
    }
}

