/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorHandlerFactory;
import com.actelion.research.chem.io.CompoundFileHelper;
import com.actelion.research.chem.io.DWARFileParser;
import com.actelion.research.chem.io.SDFileParser;
import java.io.BufferedReader;
import java.io.IOException;

public abstract class CompoundFileParser {
    private StereoMolecule mMol;
    private DescriptorHandlerFactory mDHFactory;
    private boolean mStructureUpToDate;
    private boolean mIDCodeUpToDate;
    private String mIDCode;
    private String mCoords;
    protected BufferedReader mReader;

    public static CompoundFileParser createParser(String string) {
        CompoundFileParser compoundFileParser = null;
        int n = CompoundFileHelper.getFileType(string);
        if (n == 1) {
            compoundFileParser = new DWARFileParser(string);
        } else if (n == 768) {
            compoundFileParser = new SDFileParser(string);
        }
        return compoundFileParser.mReader == null ? null : compoundFileParser;
    }

    public abstract String[] getFieldNames();

    public abstract String getFieldData(int var1);

    public abstract int getRowCount();

    protected abstract boolean advanceToNext();

    public boolean isOpen() {
        return this.mReader != null;
    }

    public boolean next() {
        this.mStructureUpToDate = false;
        this.mIDCodeUpToDate = false;
        return this.advanceToNext();
    }

    public final void close() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getIDCode() {
        this.updateIDCodeAndCoords();
        return this.mIDCode;
    }

    public String getCoordinates() {
        this.updateIDCodeAndCoords();
        return this.mCoords;
    }

    public abstract String getMoleculeName();

    public void setDescriptorHandlerFactory(DescriptorHandlerFactory descriptorHandlerFactory) {
        this.mDHFactory = descriptorHandlerFactory;
    }

    public DescriptorHandlerFactory getDescriptorHandlerFactory() {
        return this.mDHFactory;
    }

    public int getFieldIndex(String string) {
        String[] stringArray = this.getFieldNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getDescriptor(String string) {
        if (this.mDHFactory != null) {
            Object t;
            DescriptorHandler descriptorHandler = this.mDHFactory.getDefaultDescriptorHandler(string);
            return descriptorHandler.calculationFailed(t = descriptorHandler.createDescriptor(this.getMolecule())) ? null : t;
        }
        return null;
    }

    private void updateIDCodeAndCoords() {
        if (!this.mIDCodeUpToDate) {
            try {
                StereoMolecule stereoMolecule = new StereoMolecule(this.getMolecule());
                stereoMolecule.normalizeAmbiguousBonds();
                stereoMolecule.canonizeCharge(true);
                Canonizer canonizer = new Canonizer(stereoMolecule);
                this.mIDCode = canonizer.getIDCode();
                this.mCoords = canonizer.getEncodedCoordinates();
            }
            catch (Exception exception) {
                this.mIDCode = null;
                this.mCoords = null;
            }
            this.mIDCodeUpToDate = true;
        }
    }

    public StereoMolecule getMolecule() {
        if (!this.mStructureUpToDate) {
            String string = this.getIDCode();
            String string2 = this.getCoordinates();
            this.mMol = null;
            try {
                this.mMol = new IDCodeParser(string2 == null).getCompactMolecule(string, string2);
                if (this.mMol != null) {
                    this.mMol.setName(this.getMoleculeName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mStructureUpToDate = true;
        return this.mMol;
    }
}

