/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.interactionstatistics;

import com.actelion.research.chem.interactionstatistics.InteractionDistanceStatistics;
import com.actelion.research.chem.interactionstatistics.SplineFunction;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InteractionSimilarityTable {
    private static final double LOWER_BOUNDARY = 1.6;
    private static final double UPPER_BOUNDARY = 4.5;
    private static final double WELL_DEPTH_CUTOFF = 2.0;
    private static InteractionSimilarityTable instance = null;
    private final InteractionDistanceStatistics stats;
    private final Map<Integer, Integer> keyToId = new HashMap<Integer, Integer>();
    private final InteractionDescriptor[][] iDsToDescriptor;
    private final double[][] similarityTable;
    Set<Integer> atomKeys;

    private InteractionSimilarityTable() {
        this.stats = InteractionDistanceStatistics.getInstance();
        this.atomKeys = this.stats.getAtomKeySet();
        int n = this.atomKeys.size();
        int n2 = 0;
        for (int n3 : this.atomKeys) {
            this.keyToId.putIfAbsent(n3, n2);
            ++n2;
        }
        this.iDsToDescriptor = new InteractionDescriptor[n][n];
        for (int n3 : this.atomKeys) {
            for (int n4 : this.atomKeys) {
                SplineFunction splineFunction = this.stats.getFunction(n3, n4);
                this.iDsToDescriptor[this.keyToId.get((Object)Integer.valueOf((int)n3)).intValue()][this.keyToId.get((Object)Integer.valueOf((int)n4)).intValue()] = new InteractionDescriptor(splineFunction);
            }
        }
        this.similarityTable = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int n3 = i; n3 < n; ++n3) {
                double d = 0.0;
                int n5 = 0;
                for (int j = 0; j < this.iDsToDescriptor.length; ++j) {
                    InteractionDescriptor interactionDescriptor = this.iDsToDescriptor[j][i];
                    InteractionDescriptor interactionDescriptor2 = this.iDsToDescriptor[j][n3];
                    double d2 = interactionDescriptor.N + interactionDescriptor2.N;
                    d += interactionDescriptor.dist(interactionDescriptor2) * d2;
                    n5 = (int)((double)n5 + d2);
                }
                double d3 = n5 > 0 ? d / (double)n5 : 5.0;
                this.similarityTable[n3][i] = d3;
                this.similarityTable[i][n3] = d3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InteractionSimilarityTable getInstance() {
        if (instance != null) return instance;
        Class<InteractionSimilarityTable> clazz = InteractionSimilarityTable.class;
        synchronized (InteractionSimilarityTable.class) {
            if (instance != null) return instance;
            instance = new InteractionSimilarityTable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public double getDistance(int n, int n2) {
        int n3 = this.keyToId.get(InteractionDistanceStatistics.getInstance().getKey(n));
        int n4 = this.keyToId.get(InteractionDistanceStatistics.getInstance().getKey(n2));
        return this.similarityTable[n3][n4];
    }

    public double getDissimilarity(int n, int n2) {
        int n3 = this.keyToId.get(InteractionDistanceStatistics.getInstance().getKey(n));
        int n4 = this.keyToId.get(InteractionDistanceStatistics.getInstance().getKey(n2));
        double d = 0.0;
        for (int i = 0; i < this.similarityTable.length; ++i) {
            double d2 = Math.abs(this.similarityTable[n3][i] - this.similarityTable[n4][i]);
            d += d2;
        }
        return d / (double)this.similarityTable.length;
    }

    public List<Integer> getEquivalentTypes(int n, double d) {
        n = InteractionDistanceStatistics.getInstance().getKey(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : this.atomKeys) {
            if (!(this.getDissimilarity(n, n2) < d)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    public static class InteractionDescriptor {
        public int N;
        public double optimalDist;
        public double optimalStrength;

        public InteractionDescriptor(SplineFunction splineFunction) {
            if (splineFunction == null) {
                return;
            }
            this.N = splineFunction.getTotalOccurences();
            try {
                this.optimalStrength = 100.0;
                this.optimalDist = -1.0;
                for (double d = 1.6; d < 4.5; d += 0.05) {
                    double d2 = splineFunction.getFGValue(d)[0];
                    if (!(this.optimalStrength < 0.0) || !(d2 > this.optimalStrength + 0.5)) {
                        if (!(d2 < this.optimalStrength)) continue;
                        this.optimalDist = d;
                        this.optimalStrength = d2;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double dist(InteractionDescriptor interactionDescriptor) {
            double d = this.optimalDist > 0.0 ? this.optimalStrength : 0.0;
            double d2 = this.optimalDist > 0.0 ? this.optimalDist : 4.5;
            double d3 = interactionDescriptor.optimalDist > 0.0 ? interactionDescriptor.optimalStrength : 0.0;
            double d4 = interactionDescriptor.optimalDist > 0.0 ? interactionDescriptor.optimalDist : 4.5;
            double d5 = Math.abs(d2 - d4) / 2.9;
            double d6 = Math.abs(d3 - d) > 2.0 ? 1.0 : Math.abs(d3 - d) / 2.0;
            return 0.5 * d5 + 0.5 * d6;
        }

        public String toString() {
            return new DecimalFormat("0.0").format(this.optimalDist) + ":" + new DecimalFormat("0.00").format(this.optimalStrength) + " [" + this.N + "]";
        }
    }
}

