/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.interactionstatistics;

import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.chem.interactionstatistics.SplineFunction;
import com.actelion.research.util.FastSpline;
import com.actelion.research.util.SmoothingSplineInterpolator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class InteractionDistanceStatistics {
    private static volatile InteractionDistanceStatistics instance = new InteractionDistanceStatistics();
    private static final String BASE_PATH = "/resources/interactionstatistics/";
    private volatile Map<Long, SplineFunction> pairPotentials;
    public static final double OCCURENCE_CUTOFF = 500.0;
    public static final double CUTOFF_RADIUS = 6.0;
    public static final double BIN_SIZE = 0.2;
    public static final double CHI = 1.0E-4;
    public static final double MAX = 10.0;
    private final Map<Long, int[]> interactionStatistics = new ConcurrentHashMap<Long, int[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InteractionDistanceStatistics getInstance() {
        if (instance != null) return instance;
        Class<InteractionDistanceStatistics> clazz = InteractionDistanceStatistics.class;
        synchronized (InteractionDistanceStatistics.class) {
            if (instance != null) return instance;
            instance = new InteractionDistanceStatistics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getInteractionClasses() {
        return this.pairPotentials.keySet().size();
    }

    public Map<Long, SplineFunction> getPairPotentials() {
        return this.pairPotentials;
    }

    public List<Integer> getAtomTypes() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (long l : this.pairPotentials.keySet()) {
            int[] nArray = this.splitLongToInts(l);
            hashSet.add(nArray[0]);
            hashSet.add(nArray[1]);
        }
        return new ArrayList<Integer>(hashSet);
    }

    public Set<Integer> getAtomKeySet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (long l : this.pairPotentials.keySet()) {
            int[] nArray = this.splitLongToInts(l);
            int n = this.getKey(nArray[0]);
            int n2 = this.getKey(nArray[1]);
            hashSet.add(n);
            hashSet.add(n2);
        }
        return hashSet;
    }

    private synchronized void calculatePotentials() {
        this.splineCalculation();
    }

    private InteractionDistanceStatistics() {
        this.initialize();
    }

    private void initialize() {
        try {
            this.readFromFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.calculatePotentials();
    }

    public long combineIntsToLong(int n, int n2) {
        int n3;
        int n4;
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        long l = (long)n4 << 32 | (long)n3;
        return l;
    }

    private int[] splitLongToInts(long l) {
        int n = (int)(l >> 32);
        int n2 = (int)l;
        return new int[]{n, n2};
    }

    private boolean isGenericAtomPair(int n, int n2) {
        return this.isGenericAtomType(n) && this.isGenericAtomType(n2);
    }

    private boolean isGenericAtomType(int n) {
        return Integer.toBinaryString(n).length() <= InteractionAtomTypeCalculator.AtomFlagCount.BASIC_ATOM_FLAG_COUNT.getCount();
    }

    private boolean isSpecificAtomType(int n) {
        return Integer.toBinaryString(n).length() <= InteractionAtomTypeCalculator.AtomFlagCount.FUNC_GROUP_FLAG_COUNT.getCount();
    }

    public int getKey(int n) {
        if (this.isSpecificAtomType(n)) {
            return n & InteractionAtomTypeCalculator.AtomPropertyMask.SPECIFIC.getMask();
        }
        return n;
    }

    private boolean isGenericAtomPair(long l) {
        int[] nArray = this.splitLongToInts(l);
        return this.isGenericAtomPair(nArray[0], nArray[1]);
    }

    public void addInteraction(int n, int n2, double d) {
        if (d >= 6.0) {
            return;
        }
        long l = this.combineIntsToLong(n, n2);
        this.interactionStatistics.putIfAbsent(l, new int[30]);
        int n3 = (int)(0.5 + d / 0.2);
        int[] nArray = this.interactionStatistics.get(l);
        if (n3 < nArray.length) {
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
        }
    }

    public void write(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (long l : this.interactionStatistics.keySet()) {
            int[] nArray = this.interactionStatistics.get(l);
            bufferedWriter.write(Long.toString(l));
            for (int i = 0; i < nArray.length; ++i) {
                bufferedWriter.write(" " + nArray[i]);
            }
            bufferedWriter.write(System.getProperty("line.separator"));
        }
        bufferedWriter.write(System.getProperty("line.separator"));
        bufferedWriter.close();
    }

    public void readFromFile() throws IOException {
        try {
            String string;
            String string2 = "/resources/interactionstatistics/InteractionStatistics.txt";
            URL uRL = InteractionDistanceStatistics.class.getResource(string2);
            if (uRL == null) {
                throw new RuntimeException("Could not find the interactions parameter file in the classpath: " + string2);
            }
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null && string.length() != 0) {
                String[] stringArray = string.split(" ");
                long l = Long.parseLong(stringArray[0]);
                int[] nArray = new int[30];
                for (int i = 1; i < stringArray.length; ++i) {
                    nArray[i - 1] = Integer.parseInt(stringArray[i]);
                }
                this.interactionStatistics.putIfAbsent(l, nArray);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void splineCalculation() {
        this.pairPotentials = new HashMap<Long, SplineFunction>();
        double[] dArray = new double[30];
        this.interactionStatistics.entrySet().stream().forEach(entry -> {
            SplineFunction splineFunction = new SplineFunction();
            splineFunction.setOccurencesArray((int[])entry.getValue());
            this.pairPotentials.putIfAbsent((Long)entry.getKey(), splineFunction);
        });
        Map<Long, double[]> map = this.interactionStatistics.entrySet().stream().collect(Collectors.toMap(entry -> (Long)entry.getKey(), entry -> this.distanceNormalization((int[])entry.getValue())));
        AtomicInteger atomicInteger = new AtomicInteger(0);
        map.entrySet().stream().filter(entry -> this.isGenericAtomPair((Long)entry.getKey())).forEach(entry -> {
            atomicInteger.getAndIncrement();
            IntStream.range(0, ((double[])entry.getValue()).length).forEach(n -> {
                int n2 = n;
                dArray[n2] = dArray[n2] + ((double[])entry.getValue())[n];
            });
        });
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] / (double)atomicInteger.get();
        }
        map.replaceAll((l, dArray2) -> this.normalize((double[])dArray2, dArray));
        double[] dArray3 = new double[dArray.length];
        IntStream.range(0, dArray3.length).forEach(n -> {
            dArray[n] = ((double)n + 0.5) * 0.2;
        });
        for (long l2 : map.keySet()) {
            int n4;
            double[] dArray4 = new double[dArray3.length];
            Arrays.fill(dArray4, 1.0);
            SmoothingSplineInterpolator smoothingSplineInterpolator = new SmoothingSplineInterpolator();
            smoothingSplineInterpolator.setLambda(0.005);
            smoothingSplineInterpolator.setSigma(dArray4);
            FastSpline fastSpline = smoothingSplineInterpolator.interpolate(dArray3, map.get(l2));
            double[] dArray5 = new double[dArray3.length];
            for (n4 = 0; n4 < dArray3.length; ++n4) {
                try {
                    dArray5[n4] = fastSpline.value(dArray3[n4]);
                    continue;
                }
                catch (Exception exception) {
                    dArray5[n4] = 0.0;
                }
            }
            n4 = -1;
            int n5 = -1;
            for (int i = 1; i < dArray5.length - 1; ++i) {
                if (dArray5[i - 1] < dArray5[i] && dArray5[i + 1] < dArray5[i]) {
                    if (n5 != -1) continue;
                    n5 = i;
                    continue;
                }
                if (!(dArray5[i - 1] > dArray5[i]) || !(dArray5[i + 1] > dArray5[i])) continue;
                if (n4 == -1) {
                    n4 = i;
                    continue;
                }
                if (!(dArray5[i] < dArray5[n4])) continue;
                n4 = i;
            }
            if (n5 >= 0 && n5 < n4) {
                double d = 10.0 / ((double)n5 * 0.2);
                for (int i = n5 - 1; i >= 0; --i) {
                    dArray5[i] = dArray5[i + 1] + d * 0.2;
                }
                fastSpline = smoothingSplineInterpolator.interpolate(dArray3, dArray5);
            }
            SplineFunction splineFunction = this.pairPotentials.get(l2);
            splineFunction.setSplineFunction(fastSpline);
            splineFunction.setDiscreteFunction(map.get(l2));
        }
    }

    private double[] normalize(double[] dArray, double[] dArray2) {
        IntStream.range(0, dArray.length).forEach(n -> {
            dArray[n] = -Math.log((dArray[n] + 1.0E-4) / (dArray2[n] + 1.0E-4));
        });
        return dArray;
    }

    private double[] distanceNormalization(int[] nArray) {
        double d;
        int n;
        double[] dArray = new double[nArray.length];
        double d2 = 0.0;
        for (n = 0; n < nArray.length; ++n) {
            d = 4.1887902047863905 * (Math.pow(0.2 * ((double)n + 0.5), 3.0) - Math.pow(0.2 * ((double)n - 0.5), 3.0));
            d2 += (double)nArray[n] / d;
        }
        if (d2 == 0.0) {
            return dArray;
        }
        for (n = 0; n < nArray.length; ++n) {
            d = 4.1887902047863905 * (Math.pow(0.2 * ((double)n + 0.5), 3.0) - Math.pow(0.2 * ((double)n - 0.5), 3.0));
            dArray[n] = (double)nArray[n] / (d * d2);
        }
        return dArray;
    }

    public SplineFunction getFunction(long l) {
        return this.pairPotentials.get(l);
    }

    public SplineFunction getFunction(int n, int n2) {
        int n3;
        int n4 = n & InteractionAtomTypeCalculator.AtomPropertyMask.SPECIFIC.getMask();
        long l = this.combineIntsToLong(n4, n3 = n2 & InteractionAtomTypeCalculator.AtomPropertyMask.SPECIFIC.getMask());
        SplineFunction splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        int n5 = n & InteractionAtomTypeCalculator.AtomPropertyMask.EXTENDED.getMask();
        int n6 = n2 & InteractionAtomTypeCalculator.AtomPropertyMask.EXTENDED.getMask();
        l = this.combineIntsToLong(n4, n6);
        splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        l = this.combineIntsToLong(n5, n3);
        splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        l = this.combineIntsToLong(n5, n6);
        splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        int n7 = n & InteractionAtomTypeCalculator.AtomPropertyMask.BASIC.getMask();
        int n8 = n2 & InteractionAtomTypeCalculator.AtomPropertyMask.BASIC.getMask();
        l = this.combineIntsToLong(n7, n3);
        splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        l = this.combineIntsToLong(n4, n8);
        splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        l = this.combineIntsToLong(n7, n6);
        splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        l = this.combineIntsToLong(n5, n8);
        splineFunction = this.pairPotentials.get(l);
        if (splineFunction != null && (double)splineFunction.getTotalOccurences() > 500.0) {
            return splineFunction;
        }
        l = this.combineIntsToLong(n7, n8);
        splineFunction = this.pairPotentials.get(l);
        return splineFunction;
    }
}

