/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.interactionstatistics;

import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.PeriodicTable;
import com.actelion.research.chem.StereoMolecule;

public class InteractionAtomTypeCalculator {
    private static int getFunctionalGroupValue(StereoMolecule stereoMolecule, int n) {
        return InteractionAtomTypeCalculator.getFunctionalGroup(stereoMolecule, n) << AtomPropertyShift.FUNCTIONAL_GROUP_SHIFT.getShift();
    }

    private static int getFunctionalGroup(StereoMolecule stereoMolecule, int n) {
        int n2;
        int n3;
        stereoMolecule.ensureHelperArrays(1);
        int n4 = stereoMolecule.getAtomicNo(n);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stereoMolecule.getConnAtoms(n); ++n3) {
            n2 = stereoMolecule.getConnBondOrder(n, n3);
            if (n2 == 2) {
                ++n6;
            } else if (n2 == 3) {
                ++n7;
            }
            ++n5;
        }
        if (n4 == 8) {
            int n8;
            int n9;
            int n10;
            int n11;
            if (n5 == 1) {
                if (InteractionAtomTypeCalculator.getPaths(stereoMolecule, n, 7, -1, 8, -1) > 0) {
                    return FunctionalGroup.NITRO.id;
                }
                n3 = InteractionAtomTypeCalculator.getNeighbours(stereoMolecule, n, 15, -1);
                if (n3 > 0) {
                    n2 = stereoMolecule.getConnAtom(n, 0);
                    n11 = InteractionAtomTypeCalculator.getNeighbours(stereoMolecule, n2, 8, -1);
                    n9 = n11 - (n10 = InteractionAtomTypeCalculator.getPaths(stereoMolecule, n2, 8, -1, -1, -1));
                    if (n9 == 1) {
                        return 0;
                    }
                    if (n9 >= 2) {
                        return FunctionalGroup.PHOSPHONATE.id;
                    }
                }
                if ((n2 = InteractionAtomTypeCalculator.getNeighbours(stereoMolecule, n, 16, -1)) > 0) {
                    n11 = stereoMolecule.getConnAtom(n, 0);
                    n10 = InteractionAtomTypeCalculator.getPaths(stereoMolecule, n, 16, -1, 7, 1);
                    n9 = InteractionAtomTypeCalculator.getNeighbours(stereoMolecule, n11, 8, -1);
                    int n12 = n9 - (n8 = InteractionAtomTypeCalculator.getPaths(stereoMolecule, n11, 8, -1, -1, -1));
                    if (n12 > 0 && n10 > 0) {
                        return FunctionalGroup.SULFONAMIDE.id;
                    }
                    if (n12 == 1) {
                        return FunctionalGroup.SULFOXIDE.id;
                    }
                    if (n12 == 2) {
                        return FunctionalGroup.SULFONE.id;
                    }
                    if (n12 == 3) {
                        return FunctionalGroup.SULFONATE.id;
                    }
                }
            }
            if ((n3 = InteractionAtomTypeCalculator.getPaths(stereoMolecule, n, 6, -1, 8, -1)) > 0) {
                for (n2 = 0; n2 < stereoMolecule.getConnAtoms(n); ++n2) {
                    n11 = stereoMolecule.getConnAtom(n, n2);
                    if (stereoMolecule.getAtomicNo(n11) != 6) continue;
                    for (n10 = 0; n10 < stereoMolecule.getConnAtoms(n11); ++n10) {
                        n9 = stereoMolecule.getConnAtom(n11, n10);
                        if (n9 == n || stereoMolecule.getAtomicNo(n9) != 8) continue;
                        int n13 = n8 = stereoMolecule.getBondOrder(stereoMolecule.getBond(n11, n9)) > 1 ? 1 : 0;
                        if (n6 + n8 <= 0) continue;
                        if (stereoMolecule.getNonHydrogenNeighbourCount(n9) == 1 && n5 == 1) {
                            return FunctionalGroup.CARBOXYL.id;
                        }
                        if (stereoMolecule.getAllConnAtoms(n9) == 1 && n5 > 1) {
                            return FunctionalGroup.ESTER.id;
                        }
                        if (stereoMolecule.getAllConnAtoms(n9) <= 1 || n5 != 1) continue;
                        return FunctionalGroup.ESTER.id;
                    }
                }
            }
            if (n6 < 1 && stereoMolecule.getNonHydrogenNeighbourCount(n) == 1 && InteractionAtomTypeCalculator.getPaths(stereoMolecule, n, 6, 1, 6, 2) > 0) {
                return FunctionalGroup.ENOL.id;
            }
            if (n6 == 1 && InteractionAtomTypeCalculator.getPaths(stereoMolecule, n, 6, -1, 7, 1) > 0) {
                return FunctionalGroup.AMIDE.id;
            }
            return 0;
        }
        if (n4 == 7) {
            if (n5 == 4) {
                return 0;
            }
            if (stereoMolecule.isAromaticAtom(n)) {
                if (n5 <= 2) {
                    for (n3 = 0; n3 < stereoMolecule.getAllConnAtoms(n); ++n3) {
                        n2 = stereoMolecule.getConnAtom(n, n3);
                        if (!stereoMolecule.isAromaticAtom(n2)) continue;
                        for (int i = 0; i < stereoMolecule.getConnAtoms(n2); ++i) {
                            int n14 = stereoMolecule.getConnAtom(n2, i);
                            if (!stereoMolecule.isAromaticAtom(n14) || n14 == n || stereoMolecule.getAtomicNo(n14) != 7 || stereoMolecule.getConnAtoms(n14) > 2) continue;
                            return FunctionalGroup.N_SP2_TAUT.id;
                        }
                    }
                }
                return 0;
            }
            if (InteractionAtomTypeCalculator.getNeighbours(stereoMolecule, n, 8, -1) >= 2) {
                return FunctionalGroup.NITRO.id;
            }
            if (n5 == 1 && n7 > 0) {
                return 0;
            }
            if (InteractionAtomTypeCalculator.getPaths(stereoMolecule, n, 6, 1, 8, 2) > 0) {
                return FunctionalGroup.AMIDE.id;
            }
            if (InteractionAtomTypeCalculator.getPaths(stereoMolecule, n, 16, 1, 8, 2) > 0) {
                return FunctionalGroup.SULFONAMIDE.id;
            }
            n3 = 0;
            block5: for (n2 = 0; n2 < stereoMolecule.getAllConnAtoms(n); ++n2) {
                int n15 = stereoMolecule.getConnAtom(n, n2);
                if (stereoMolecule.getAtomicNo(n15) != 6 || stereoMolecule.getConnAtoms(n15) != 3 || InteractionAtomTypeCalculator.getNeighbours(stereoMolecule, n15, 7, 2) <= 0) continue;
                n3 = 1;
                for (int i = 0; i < stereoMolecule.getAllConnAtoms(n15); ++i) {
                    int n16 = stereoMolecule.getConnAtom(n15, i);
                    if (n != n16 && (stereoMolecule.getAtomicNo(n16) != 7 || stereoMolecule.isAromaticAtom(n16))) continue block5;
                }
                return FunctionalGroup.GUANIDINE.id;
            }
            if (n3 != 0) {
                return FunctionalGroup.AMIDINE.id;
            }
            if (n6 == 0 && stereoMolecule.isFlatNitrogen(n)) {
                return FunctionalGroup.SP2_AMINE.id;
            }
        }
        return 0;
    }

    private static int getHybridizationValue(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) == 6 || stereoMolecule.getAtomicNo(n) == 7 || stereoMolecule.getAtomicNo(n) == 8) {
            int n2 = stereoMolecule.getAtomPi(n);
            int n3 = n2 == 2 ? 1 : (n2 == 1 || stereoMolecule.getAtomicNo(n) == 5 ? 2 : 3);
            return n3 << AtomPropertyShift.HYBRID_SHIFT.getShift();
        }
        return 0;
    }

    private static int getAtomicNoValue(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getAtomicNo(n);
        return n2;
    }

    private static int getAromValue(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.isAromaticAtom(n) ? 1 : 0;
        int n3 = 0;
        if (n2 > 0) {
            n3 = AtomPropertyMask.AROM.getMask();
        }
        return n3;
    }

    private static int getStabilizationValue(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.isStabilizedAtom(n) ? 1 : 0;
        int n3 = 0;
        if (n2 > 0) {
            n3 = AtomPropertyMask.STABILIZED.getMask();
        }
        return n3;
    }

    private static int getNeighbours(StereoMolecule stereoMolecule, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n5 = stereoMolecule.getConnAtom(n, i);
            int n6 = stereoMolecule.getBondOrder(stereoMolecule.getBond(n, n5));
            if (n2 >= 0 && stereoMolecule.getAtomicNo(n5) != n2 || n3 > 0 && n6 != n3) continue;
            ++n4;
        }
        return n4;
    }

    private static int getPaths(StereoMolecule stereoMolecule, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n7 = stereoMolecule.getConnAtom(n, i);
            int n8 = stereoMolecule.getBondOrder(stereoMolecule.getBond(n, n7));
            if (n2 > 0 && stereoMolecule.getAtomicNo(n7) != n2 || n3 > 0 && n8 != n3) continue;
            for (int j = 0; j < stereoMolecule.getAllConnAtoms(n7); ++j) {
                int n9 = stereoMolecule.getConnAtom(n7, j);
                if (n9 == n) continue;
                int n10 = stereoMolecule.getBondOrder(stereoMolecule.getBond(n7, n9));
                if (n4 > 0 && stereoMolecule.getAtomicNo(n9) != n4 || n5 > 0 && n10 != n5) continue;
                ++n6;
            }
        }
        return n6;
    }

    public static int getAtomType(StereoMolecule stereoMolecule, int n) {
        int n2 = 0;
        n2 += InteractionAtomTypeCalculator.getFunctionalGroupValue(stereoMolecule, n);
        n2 += InteractionAtomTypeCalculator.getHybridizationValue(stereoMolecule, n);
        n2 += InteractionAtomTypeCalculator.getStabilizationValue(stereoMolecule, n);
        n2 += InteractionAtomTypeCalculator.getAromValue(stereoMolecule, n);
        return n2 += InteractionAtomTypeCalculator.getAtomicNoValue(stereoMolecule, n);
    }

    public static int getAtomType(FunctionalGroup functionalGroup, int n, boolean bl, int n2, boolean bl2) {
        int n3 = 0;
        if (functionalGroup != null) {
            n3 += functionalGroup.id << AtomPropertyShift.FUNCTIONAL_GROUP_SHIFT.getShift();
        }
        n3 += n2 << AtomPropertyShift.HYBRID_SHIFT.getShift();
        if (bl2) {
            n3 += AtomPropertyMask.STABILIZED.getMask();
        }
        if (bl) {
            n3 += AtomPropertyMask.AROM.getMask();
        }
        return n3 += n;
    }

    public static String getString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PeriodicTable.symbol(n & AtomPropertyMask.ATOMIC_NO.getMask()));
        int n2 = (n & AtomPropertyMask.HYBRID.getMask()) >> AtomPropertyShift.HYBRID_SHIFT.getShift();
        if (n2 > 0) {
            stringBuilder.append("." + n2);
        }
        int n3 = (n & AtomPropertyMask.NONHNEIGHBOURS.getMask()) >> AtomPropertyShift.NEIGHBOURS_SHIFT.getShift();
        stringBuilder.append("-" + n3 + "-");
        String string = (n & AtomPropertyMask.STABILIZED.getMask()) > 0 ? ".St" : "";
        stringBuilder.append(string);
        String string2 = (n & AtomPropertyMask.AROM.getMask()) > 0 ? ".Ar" : "";
        stringBuilder.append(string2);
        int n4 = (n & AtomPropertyMask.FUNCTIONAL_GROUP.getMask()) >> AtomPropertyShift.FUNCTIONAL_GROUP_SHIFT.getShift();
        for (FunctionalGroup functionalGroup : FunctionalGroup.values()) {
            if (functionalGroup.getId() != n4) continue;
            stringBuilder.append("(");
            stringBuilder.append(functionalGroup.getString());
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static int getAtomicNumber(int n) {
        return n & AtomPropertyMask.ATOMIC_NO.getMask();
    }

    public static boolean isCarbonInteraction(int n) {
        int n2 = InteractionAtomTypeCalculator.getAtomicNumber(n);
        return n2 == 6;
    }

    public static boolean isAromatic(int n) {
        return (n & AtomPropertyMask.AROM.getMask()) > 0;
    }

    public static void setInteractionTypes(Molecule3D molecule3D) {
        for (int i = 0; i < molecule3D.getAtoms(); ++i) {
            int n = InteractionAtomTypeCalculator.getAtomType(molecule3D, i);
            molecule3D.setInteractionAtomType(i, n);
        }
    }

    public static int getGenericDonor() {
        return InteractionAtomTypeCalculator.getAtomType(null, 8, false, 3, false);
    }

    public static int getGenericAcceptor() {
        return InteractionAtomTypeCalculator.getAtomType(null, 8, false, 3, false);
    }

    public static int getGenericPosCharge() {
        return InteractionAtomTypeCalculator.getAtomType(null, 7, false, 3, false);
    }

    public static int getGenericNegCharge() {
        return InteractionAtomTypeCalculator.getAtomType(FunctionalGroup.CARBOXYL, 8, false, 2, false);
    }

    public static enum AtomFlagCount {
        FUNC_GROUP_FLAG_COUNT(20),
        BASIC_ATOM_FLAG_COUNT(12),
        EXTENDED_ATOM_FLAG_COUNT(14);

        private final int count;

        private AtomFlagCount(int n2) {
            this.count = n2;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static enum AtomPropertyShift {
        HYBRID_SHIFT(7),
        NEIGHBOURS_SHIFT(9),
        FUNCTIONAL_GROUP_SHIFT(16);

        private final int shift;

        private AtomPropertyShift(int n2) {
            this.shift = n2;
        }

        public int getShift() {
            return this.shift;
        }
    }

    public static enum AtomPropertyMask {
        ATOMIC_NO(127),
        HYBRID(384),
        NONHNEIGHBOURS(3584),
        AROM(4096),
        STABILIZED(8192),
        FUNCTIONAL_GROUP(1032192),
        BASIC(511),
        EXTENDED(16383),
        SPECIFIC(1036287);

        private final int mask;

        private AtomPropertyMask(int n2) {
            this.mask = n2;
        }

        public int getMask() {
            return this.mask;
        }
    }

    public static enum FunctionalGroup {
        NITRO("NO2", 1),
        ESTER("COOR", 2),
        CARBOXYL("COO", 3),
        SULFONAMIDE("HNSO2R", 4),
        SULFONATE("SO3", 5),
        PHOSPHONATE("PO3", 6),
        SULFOXIDE("SO", 7),
        SULFONE("SO2", 8),
        AMIDE("HNCO", 9),
        AMIDINE("N=C-N", 10),
        GUANIDINE("N-C(-N)=N", 11),
        N_SP2_TAUT("N=C-N(Ar)", 12),
        SP2_AMINE("C=CNX2", 13),
        ENOL("C=COH", 14);

        private String s;
        private int id;

        private FunctionalGroup(String string2, int n2) {
            this.s = string2;
            this.id = n2;
        }

        public String getString() {
            return this.s;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("FunctionalGroup{");
            stringBuilder.append("s='").append(this.s).append('\'');
            stringBuilder.append(", id=").append(this.id);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }
}

