/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.inchi;

import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;

public class InChIJNI {
    public static boolean inchiToMolecule(String string, StereoMolecule stereoMolecule) {
        try {
            JniInchiOutputStructure jniInchiOutputStructure = JniInchiWrapper.getStructureFromInchi(new JniInchiInputInchi(string));
            InChIJNI.getMolecule(jniInchiOutputStructure, stereoMolecule);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static String inchiToSMILES(String string) {
        try {
            StereoMolecule stereoMolecule = new StereoMolecule();
            InChIJNI.inchiToMolecule(string, stereoMolecule);
            return IsomericSmilesCreator.createSmiles(stereoMolecule);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static String toJSON(JniInchiStructure jniInchiStructure) {
        Object object;
        int n;
        int n2 = jniInchiStructure.getNumAtoms();
        int n3 = jniInchiStructure.getNumBonds();
        int n4 = jniInchiStructure.getNumStereo0D();
        HashMap<JniInchiAtom, Integer> hashMap = new HashMap<JniInchiAtom, Integer>();
        String string = "{\"atoms\":[\n";
        String string2 = "";
        for (n = 0; n < n2; ++n) {
            object = jniInchiStructure.getAtom(n);
            hashMap.put((JniInchiAtom)object, n);
            if (n > 0) {
                string = string + ",\n";
            }
            string = string + "{\n";
            string = string + InChIJNI.toJSON("index", n, ",");
            string = string + InChIJNI.toJSON("elementType", ((JniInchiAtom)object).getElementType(), ",");
            string = string + InChIJNI.toJSON("charge", ((JniInchiAtom)object).getCharge(), ",");
            string = string + InChIJNI.toJSON("isotopeMass", ((JniInchiAtom)object).getIsotopicMass(), ",");
            string = string + InChIJNI.toJSON("implicitH", ((JniInchiAtom)object).getImplicitH(), ",");
            string = string + InChIJNI.toJSON("radical", (Object)((JniInchiAtom)object).getRadical(), ",");
            string = string + InChIJNI.toJSON("x", ((JniInchiAtom)object).getX(), ",");
            string = string + InChIJNI.toJSON("y", ((JniInchiAtom)object).getY(), ",");
            string = string + InChIJNI.toJSON("z", ((JniInchiAtom)object).getZ(), ",");
            string = string + InChIJNI.toJSON("implicitDeuterium", ((JniInchiAtom)object).getImplicitDeuterium(), ",");
            string = string + InChIJNI.toJSON("implicitProtium", ((JniInchiAtom)object).getImplicitProtium(), ",");
            string = string + InChIJNI.toJSON("implicitTritium", ((JniInchiAtom)object).getImplicitTritium(), "");
            string = string + "}";
        }
        string = string + "\n],\n\"bonds\":[\n";
        for (n = 0; n < n3; ++n) {
            if (n > 0) {
                string = string + ",\n";
            }
            string = string + "{\n";
            object = jniInchiStructure.getBond(n);
            string = string + InChIJNI.toJSON("originAtom", hashMap.get(((JniInchiBond)object).getOriginAtom()), ",");
            string = string + InChIJNI.toJSON("targetAtom", hashMap.get(((JniInchiBond)object).getTargetAtom()), ",");
            string = string + InChIJNI.toJSON("bondType", (Object)((JniInchiBond)object).getBondType(), ",");
            string = string + InChIJNI.toJSON("bondStereo", (Object)((JniInchiBond)object).getBondStereo(), "");
            string = string + "}";
        }
        string = string + "\n],\n\"stereo\":[\n";
        for (n = 0; n < n4; ++n) {
            if (n > 0) {
                string = string + ",\n";
            }
            string = string + "{\n";
            object = jniInchiStructure.getStereo0D(n);
            string = string + InChIJNI.toJSON("centralAtomID", hashMap.get(((JniInchiStereo0D)object).getCentralAtom()), ",");
            string = string + InChIJNI.toJSON("debugString", ((JniInchiStereo0D)object).getDebugString(), ",");
            string = string + InChIJNI.toJSON("disconnectedParity", (Object)((JniInchiStereo0D)object).getDisconnectedParity(), ",");
            string = string + InChIJNI.toJSON("parity", (Object)((JniInchiStereo0D)object).getParity(), ",");
            string = string + InChIJNI.toJSON("stereoType", (Object)((JniInchiStereo0D)object).getStereoType(), ",");
            JniInchiAtom[] jniInchiAtomArray = ((JniInchiStereo0D)object).getNeighbors();
            int[] nArray = new int[jniInchiAtomArray.length];
            for (int i = 0; i < jniInchiAtomArray.length; ++i) {
                nArray[i] = (Integer)hashMap.get(((JniInchiStereo0D)object).getNeighbor(i));
            }
            string = string + InChIJNI.toJSON("neighbors", nArray, "");
            string = string + "}";
        }
        string = string + "\n]}\n";
        return string;
    }

    private static String toJSON(String string, Object object, String string2) {
        string = "\"" + string + "\"";
        String string3 = null;
        if (object instanceof int[]) {
            string3 = "";
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                string3 = string3 + "," + nArray[i];
            }
            string3 = "[" + (string3.length() > 1 ? string3.substring(1) : "") + "]";
        } else {
            string3 = object instanceof String ? "\"" + object + "\"" : "" + string3;
        }
        return string + ":" + string3 + string2 + "\n";
    }

    private static void getMolecule(JniInchiOutputStructure jniInchiOutputStructure, final StereoMolecule stereoMolecule) {
        int n;
        int n2;
        Object object;
        int n3;
        Object object2;
        final boolean[] blArray = new boolean[]{false};
        StereoMolecule stereoMolecule2 = new StereoMolecule(){

            @Override
            public int getAtomParity(int n) {
                if (blArray[0]) {
                    switch (n) {
                        case 10: 
                        case 15: 
                        case 16: {
                            return 2;
                        }
                        case 9: 
                        case 12: {
                            return 1;
                        }
                    }
                    return stereoMolecule.getAtomParity(n);
                }
                return super.getAtomParity(n);
            }
        };
        int n4 = jniInchiOutputStructure.getNumAtoms();
        int n5 = jniInchiOutputStructure.getNumBonds();
        int n6 = jniInchiOutputStructure.getNumStereo0D();
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            object2 = jniInchiOutputStructure.getAtom(i);
            n7 += ((JniInchiAtom)object2).getImplicitH();
        }
        ArrayList<JniInchiAtom> arrayList = new ArrayList<JniInchiAtom>();
        object2 = new HashMap();
        for (n3 = 0; n3 < n4; ++n3) {
            object = jniInchiOutputStructure.getAtom(n3);
            arrayList.add((JniInchiAtom)object);
            String string = ((JniInchiAtom)object).getElementType();
            n2 = stereoMolecule2.addAtom(Molecule.getAtomicNoFromLabel(string));
            stereoMolecule2.setAtomCharge(n2, ((JniInchiAtom)object).getCharge());
            stereoMolecule2.setAtomX(n2, -1.0);
            object2.put(object, n3);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            object = jniInchiOutputStructure.getStereo0D(n3);
            int n8 = (Integer)object2.get(((JniInchiStereo0D)object).getCentralAtom());
            n2 = InChIJNI.decodeParity(((JniInchiStereo0D)object).getParity());
            stereoMolecule2.setAtomParity(n8, n2, false);
            JniInchiAtom[] jniInchiAtomArray = ((JniInchiStereo0D)object).getNeighbors();
            int[] nArray = new int[jniInchiAtomArray.length];
            for (n = 0; n < jniInchiAtomArray.length; ++n) {
                nArray[n] = (Integer)object2.get(((JniInchiStereo0D)object).getNeighbor(n));
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            object = jniInchiOutputStructure.getBond(n3);
            JniInchiAtom jniInchiAtom = ((JniInchiBond)object).getOriginAtom();
            JniInchiAtom jniInchiAtom2 = ((JniInchiBond)object).getTargetAtom();
            int n9 = InChIJNI.getBondType((JniInchiBond)object);
            int n10 = (Integer)object2.get(jniInchiAtom);
            n = (Integer)object2.get(jniInchiAtom2);
            stereoMolecule2.addBond(n10, n, n9);
        }
        stereoMolecule2.copyMolecule(stereoMolecule);
        blArray[0] = true;
        stereoMolecule2.setParitiesValid(0);
        new CoordinateInventor(65).invent(stereoMolecule2);
        blArray[0] = false;
        stereoMolecule2.copyMolecule(stereoMolecule);
    }

    private static int decodeParity(INCHI_PARITY iNCHI_PARITY) {
        switch (iNCHI_PARITY) {
            case EVEN: {
                return 2;
            }
            case ODD: {
                return 1;
            }
            case UNKNOWN: {
                return 3;
            }
        }
        return 0;
    }

    private static int getBondType(JniInchiBond jniInchiBond) {
        INCHI_BOND_TYPE iNCHI_BOND_TYPE = jniInchiBond.getBondType();
        INCHI_BOND_STEREO iNCHI_BOND_STEREO = jniInchiBond.getBondStereo();
        switch (iNCHI_BOND_TYPE) {
            case NONE: {
                return 0;
            }
            case ALTERN: {
                return 64;
            }
            case DOUBLE: {
                return 2;
            }
            case TRIPLE: {
                return 4;
            }
            case SINGLE: {
                break;
            }
        }
        return 1;
    }
}

