/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.type;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.type.Bond;
import java.util.HashSet;

public final class Torsion {
    public static int getType(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = mMFFMolecule.getBond(n2, n3);
        int n7 = Bond.getType(tables, mMFFMolecule, n, n2);
        int n8 = Bond.getType(tables, mMFFMolecule, n2, n3);
        int n9 = Bond.getType(tables, mMFFMolecule, n3, n4);
        int n10 = n8;
        if (n8 == 0 && mMFFMolecule.getBondOrder(n6) == 1 && (n7 == 1 || n9 == 1)) {
            n10 = 2;
        }
        if ((n5 = Torsion.inRingOfSize(mMFFMolecule, n, n2, n3, n4)) == 4 && mMFFMolecule.getBond(n, n3) == -1 && mMFFMolecule.getBond(n2, n4) == -1) {
            return 40 + n10;
        }
        if (n5 == 5 && (mMFFMolecule.getAtomType(n) == 1 || mMFFMolecule.getAtomType(n2) == 1 || mMFFMolecule.getAtomType(n3) == 1 || mMFFMolecule.getAtomType(n4) == 1)) {
            return 50 + n10;
        }
        return n10;
    }

    public static int inRingOfSize(MMFFMolecule mMFFMolecule, int n, int n2, int n3, int n4) {
        if (mMFFMolecule.getBond(n, n2) == -1 || mMFFMolecule.getBond(n2, n3) == -1 || mMFFMolecule.getBond(n3, n4) == -1) {
            return 0;
        }
        if (mMFFMolecule.getBond(n4, n) >= 0) {
            return 4;
        }
        RingCollection ringCollection = mMFFMolecule.getRingSet();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n);
        hashSet.add(n2);
        hashSet.add(n3);
        hashSet.add(n4);
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            if (ringCollection.getRingSize(i) != 5) continue;
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            for (int n5 : ringCollection.getRingAtoms(i)) {
                hashSet2.add(n5);
            }
            if (!hashSet2.containsAll(hashSet)) continue;
            return 5;
        }
        return 0;
    }
}

