/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.type;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.RingBoolean;
import java.util.ArrayList;
import java.util.Iterator;

public class Atom {
    public static int getType(MMFFMolecule mMFFMolecule, int n) {
        if (mMFFMolecule.getAtomType(n) > -1) {
            return mMFFMolecule.getAtomType(n);
        }
        if (mMFFMolecule.getAtomicNo(n) == 1) {
            return Atom.getHydrogenType(mMFFMolecule, n);
        }
        return Atom.getHeavyType(mMFFMolecule, n);
    }

    private static int getHeavyType(MMFFMolecule mMFFMolecule, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        if (mMFFMolecule.isAromaticAtom(n)) {
            if (Atom.isInAromaticRingOfSize(mMFFMolecule, n, 5)) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(mMFFMolecule.getAllAtoms());
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(mMFFMolecule.getAllAtoms());
                n10 = 0;
                n9 = 0;
                n8 = 0;
                if (mMFFMolecule.getAtomicNo(n) == 6 || mMFFMolecule.getAtomicNo(n) == 7) {
                    for (int i = 0; i < mMFFMolecule.getAllConnAtoms(n); ++i) {
                        n7 = mMFFMolecule.getConnAtom(n, i);
                        if (!Atom.isInAromaticRingOfSize(mMFFMolecule, n7, 5)) continue;
                        if (Atom.inSameRing(mMFFMolecule, n, n7, 5) && (mMFFMolecule.getAtomicNo(n7) == 8 || mMFFMolecule.getAtomicNo(n7) == 16 || mMFFMolecule.getAtomicNo(n7) == 7 && Atom.degree(mMFFMolecule, n7) == 3 && !Atom.isAtomNOxide(mMFFMolecule, n7))) {
                            arrayList.add(n7);
                        }
                        for (n6 = 0; n6 < mMFFMolecule.getAllConnAtoms(n7); ++n6) {
                            n5 = mMFFMolecule.getConnAtom(n7, n6);
                            if (n5 == n || !Atom.isInAromaticRingOfSize(mMFFMolecule, n5, 5) || !Atom.inSameRing(mMFFMolecule, n, n5, 5) || mMFFMolecule.getAtomicNo(n5) != 8 && mMFFMolecule.getAtomicNo(n5) != 16 && (mMFFMolecule.getAtomicNo(n5) != 7 || Atom.degree(mMFFMolecule, n5) != 3 || Atom.isAtomNOxide(mMFFMolecule, n5))) continue;
                            arrayList2.add(n5);
                        }
                    }
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        n7 = (Integer)iterator.next();
                        if (mMFFMolecule.getAtomicNo(n7) != 8 && mMFFMolecule.getAtomicNo(n7) != 16) continue;
                        n9 = 1;
                        break;
                    }
                    iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        n7 = (Integer)iterator.next();
                        if (mMFFMolecule.getAtomicNo(n7) != 8 && mMFFMolecule.getAtomicNo(n7) != 16) continue;
                        n8 = 1;
                        break;
                    }
                    block34: for (n4 = 0; n4 < arrayList.size(); ++n4) {
                        for (n7 = n4; n7 < arrayList2.size(); ++n7) {
                            if (!Atom.inSameRing(mMFFMolecule, (Integer)arrayList.get(n4), (Integer)arrayList2.get(n7), 5)) continue;
                            n10 = 1;
                            continue block34;
                        }
                    }
                }
                switch (mMFFMolecule.getAtomicNo(n)) {
                    case 6: {
                        if (arrayList2.isEmpty()) {
                            n4 = 0;
                            n7 = 0;
                            n6 = 0;
                            n5 = 0;
                            for (n3 = 0; n3 < mMFFMolecule.getAllConnAtoms(n); ++n3) {
                                n2 = mMFFMolecule.getConnAtom(n, n3);
                                if (mMFFMolecule.getAtomicNo(n2) != 7 || Atom.degree(mMFFMolecule, n2) != 3) continue;
                                ++n4;
                                if (mMFFMolecule.getAtomCharge(n2) > 0 && !Atom.isAtomNOxide(mMFFMolecule, n2)) {
                                    ++n7;
                                }
                                if (Atom.isInAromaticRingOfSize(mMFFMolecule, n2, 5)) {
                                    ++n6;
                                }
                                if (!Atom.isInAromaticRingOfSize(mMFFMolecule, n2, 6)) continue;
                                ++n5;
                            }
                            if ((n4 == 2 && n6 > 0 || n4 == 3 && n6 == 2) && n7 > 0 && n5 == 0) {
                                return 80;
                            }
                        }
                        if (!(arrayList.isEmpty() ^ arrayList2.isEmpty())) {
                            n4 = 1;
                            n7 = 1;
                            for (n6 = 0; n6 < mMFFMolecule.getAllConnAtoms(n); ++n6) {
                                n5 = mMFFMolecule.getConnAtom(n, n6);
                                if (mMFFMolecule.getAtomicNo(n5) != 6 || !Atom.inRingOfSize(mMFFMolecule, n5, 6)) {
                                    n4 = 0;
                                }
                                if (!Atom.inSameRing(mMFFMolecule, n, n5, 5) || mMFFMolecule.isAromaticAtom(n5)) continue;
                                n7 = 0;
                            }
                            if (arrayList.isEmpty() && arrayList2.isEmpty() && n4 == 0 && n7 != 0) {
                                return 78;
                            }
                            if (!arrayList.isEmpty() && !arrayList.isEmpty() && (n10 == 0 || n9 == 0 && n8 == 0)) {
                                return 78;
                            }
                        }
                        if (!arrayList.isEmpty() && (arrayList2.isEmpty() || n9 != 0)) {
                            return 63;
                        }
                        if (arrayList2.isEmpty() || !arrayList.isEmpty() && n8 == 0) break;
                        return 64;
                    }
                    case 7: {
                        if (Atom.isAtomNOxide(mMFFMolecule, n)) {
                            return 82;
                        }
                        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                            if (Atom.degree(mMFFMolecule, n) == 3) {
                                return 39;
                            }
                            return 76;
                        }
                        if (Atom.degree(mMFFMolecule, n) == 3 && arrayList.isEmpty() ^ arrayList2.isEmpty()) {
                            return 81;
                        }
                        if (!arrayList.isEmpty() && (arrayList2.isEmpty() || n9 != 0)) {
                            return 65;
                        }
                        if (!arrayList2.isEmpty() && (arrayList.isEmpty() || n8 != 0)) {
                            return 66;
                        }
                        if (arrayList.isEmpty() || arrayList2.isEmpty()) break;
                        return 79;
                    }
                    case 8: {
                        return 59;
                    }
                    case 16: {
                        return 44;
                    }
                }
            }
            if (Atom.isInAromaticRingOfSize(mMFFMolecule, n, 6)) {
                switch (mMFFMolecule.getAtomicNo(n)) {
                    case 6: {
                        return 37;
                    }
                    case 7: {
                        if (Atom.isAtomNOxide(mMFFMolecule, n)) {
                            return 69;
                        }
                        if (Atom.degree(mMFFMolecule, n) == 3) {
                            return 58;
                        }
                        return 38;
                    }
                }
            }
        }
        switch (mMFFMolecule.getAtomicNo(n)) {
            case 3: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 92;
            }
            case 6: {
                if (Atom.degree(mMFFMolecule, n) == 4) {
                    if (mMFFMolecule.getAtomRingSize(n) == 3) {
                        return 22;
                    }
                    if (mMFFMolecule.getAtomRingSize(n) == 4) {
                        return 20;
                    }
                    return 1;
                }
                if (Atom.degree(mMFFMolecule, n) == 3) {
                    int n11 = 0;
                    int n12 = 0;
                    n10 = 0;
                    n9 = 0;
                    n8 = 0;
                    for (n4 = 0; n4 < mMFFMolecule.getAllConnAtoms(n); ++n4) {
                        n7 = mMFFMolecule.getConnAtom(n, n4);
                        if (mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n7)) == 2) {
                            n8 = mMFFMolecule.getAtomicNo(n7);
                        }
                        if (Atom.degree(mMFFMolecule, n7) == 1) {
                            if (mMFFMolecule.getAtomicNo(n7) == 8) {
                                ++n10;
                            }
                            if (mMFFMolecule.getAtomicNo(n7) != 16) continue;
                            ++n9;
                            continue;
                        }
                        if (mMFFMolecule.getAtomicNo(n7) != 7) continue;
                        if (Atom.degree(mMFFMolecule, n7) == 3) {
                            ++n12;
                            continue;
                        }
                        if (Atom.degree(mMFFMolecule, n7) != 2 || mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n7)) != 2) continue;
                        ++n11;
                    }
                    if (n12 >= 2 && n11 == 0 && n8 == 7) {
                        return 57;
                    }
                    if (n10 == 2 || n9 == 2) {
                        return 41;
                    }
                    if (mMFFMolecule.getAtomRingSize(n) == 4 && n8 == 6) {
                        return 30;
                    }
                    if (n8 == 7 || n8 == 8 || n8 == 15 || n8 == 16) {
                        return 3;
                    }
                    return 2;
                }
                if (Atom.degree(mMFFMolecule, n) == 2) {
                    return 4;
                }
                if (Atom.degree(mMFFMolecule, n) != 1) break;
                return 60;
            }
            case 7: {
                int n13 = 0;
                boolean bl = false;
                for (n10 = 0; n10 < mMFFMolecule.getAllConnAtoms(n); ++n10) {
                    n9 = mMFFMolecule.getConnAtom(n, n10);
                    if (mMFFMolecule.getAtomicNo(n9) == 8 && Atom.degree(mMFFMolecule, n9) == 1) {
                        ++n13;
                    }
                    if (mMFFMolecule.getOccupiedValence(n) + mMFFMolecule.getImplicitHydrogens(n) < 3 || mMFFMolecule.getAtomicNo(n9) != 15 && mMFFMolecule.getAtomicNo(n9) != 16) continue;
                    n8 = 0;
                    for (n4 = 0; n4 < mMFFMolecule.getAllConnAtoms(n9); ++n4) {
                        n7 = mMFFMolecule.getConnAtom(n9, n4);
                        if (mMFFMolecule.getAtomicNo(n7) != 8 || Atom.degree(mMFFMolecule, n7) != 1) continue;
                        ++n8;
                    }
                    if (bl) continue;
                    bl = n8 >= 2;
                }
                if (Atom.degree(mMFFMolecule, n) == 4) {
                    if (Atom.isAtomNOxide(mMFFMolecule, n)) {
                        return 68;
                    }
                    return 34;
                }
                if (Atom.degree(mMFFMolecule, n) == 3) {
                    if (mMFFMolecule.getOccupiedValence(n) + mMFFMolecule.getImplicitHydrogens(n) >= 4) {
                        n10 = 0;
                        for (n9 = 0; n9 < mMFFMolecule.getAllConnAtoms(n); ++n9) {
                            n8 = mMFFMolecule.getConnAtom(n, n9);
                            if (mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n8)) != 2) continue;
                            int n14 = n10 = mMFFMolecule.getAtomicNo(n8) == 7 || mMFFMolecule.getAtomicNo(n8) == 6 ? 1 : 0;
                            if (mMFFMolecule.getAtomicNo(n8) != 6) continue;
                            for (n4 = 0; n10 != 0 && n4 < mMFFMolecule.getAllConnAtoms(n8); ++n4) {
                                n7 = mMFFMolecule.getConnAtom(n8, n4);
                                if (n7 == n) continue;
                                n10 = mMFFMolecule.getAtomicNo(n7) != 7 || Atom.degree(mMFFMolecule, n7) != 3 ? 1 : 0;
                            }
                        }
                        if (n13 == 1) {
                            return 67;
                        }
                        if (n13 >= 2) {
                            return 45;
                        }
                        if (n10 != 0) {
                            return 54;
                        }
                    }
                    if (mMFFMolecule.getOccupiedValence(n) + mMFFMolecule.getImplicitHydrogens(n) >= 3) {
                        n10 = 0;
                        n9 = 0;
                        n8 = 0;
                        n4 = 0;
                        n7 = 0;
                        n6 = 0;
                        n5 = 0;
                        n3 = 0;
                        n2 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        for (int i = 0; i < mMFFMolecule.getAllConnAtoms(n); ++i) {
                            int n18;
                            int n19;
                            int n20;
                            int n21;
                            int n22;
                            int n23;
                            int n24;
                            int n25;
                            int n26 = mMFFMolecule.getConnAtom(n, i);
                            if (mMFFMolecule.getAtomicNo(n26) == 6) {
                                n7 = 1;
                                if (mMFFMolecule.isAromaticAtom(n26) && mMFFMolecule.getAtomRingSize(n26) == 6) {
                                    n6 = 1;
                                }
                                n2 = 0;
                                n15 = 0;
                                n16 = 0;
                                n17 = 0;
                                n25 = 0;
                                n24 = 0;
                                for (n23 = 0; n23 < mMFFMolecule.getAllConnAtoms(n26); ++n23) {
                                    n22 = mMFFMolecule.getConnAtom(n26, n23);
                                    n21 = mMFFMolecule.getBond(n26, n22);
                                    if (mMFFMolecule.getBondOrder(n21) == 2 && (mMFFMolecule.getAtomicNo(n22) == 8 || mMFFMolecule.getAtomicNo(n22) == 16)) {
                                        n10 = 1;
                                    }
                                    if (mMFFMolecule.getBondOrder(n21) == 2 || mMFFMolecule.isAromaticBond(n21) && (mMFFMolecule.getAtomicNo(n22) == 6 || mMFFMolecule.getAtomicNo(n22) == 7 && Atom.inRings(mMFFMolecule, n22) == 1)) {
                                        n5 = mMFFMolecule.getAtomicNo(n22);
                                    }
                                    if (mMFFMolecule.getBondOrder(n21) == 3) {
                                        n3 = mMFFMolecule.getAtomicNo(n22);
                                    }
                                    if (mMFFMolecule.getAtomicNo(n22) == 7 && Atom.degree(mMFFMolecule, n22) == 3) {
                                        if (mMFFMolecule.getAtomCharge(n22) == 1) {
                                            ++n25;
                                        }
                                        if (Atom.isInAromaticRingOfSize(mMFFMolecule, n26, 6)) {
                                            ++n24;
                                        }
                                        n20 = 0;
                                        for (n19 = 0; n19 < mMFFMolecule.getAllConnAtoms(n22); ++n19) {
                                            n18 = mMFFMolecule.getConnAtom(n22, n19);
                                            if (mMFFMolecule.getAtomicNo(n18) != 8) continue;
                                            ++n20;
                                        }
                                        if (n20 < 2) {
                                            ++n15;
                                        }
                                    }
                                    if (mMFFMolecule.getAtomicNo(n22) == 7 && Atom.degree(mMFFMolecule, n22) == 2 && (mMFFMolecule.getBondOrder(n21) == 2 || mMFFMolecule.isAromaticBond(n21))) {
                                        ++n2;
                                    }
                                    if (!mMFFMolecule.isAromaticAtom(n22)) continue;
                                    if (mMFFMolecule.getAtomicNo(n22) == 8) {
                                        ++n16;
                                    }
                                    if (mMFFMolecule.getAtomicNo(n22) != 16) continue;
                                    ++n17;
                                }
                                if (n5 != 7) continue;
                                if (n15 == 2 && n2 == 0 && n25 > 0 && n24 == 0 && Atom.degree(mMFFMolecule, n26) < 4) {
                                    n9 = 1;
                                }
                                if (n15 != 3) continue;
                                n8 = 1;
                                continue;
                            }
                            if (mMFFMolecule.getAtomicNo(n26) != 7) continue;
                            n25 = 0;
                            n24 = 0;
                            n23 = 0;
                            for (n22 = 0; n22 < mMFFMolecule.getAllConnAtoms(n26); ++n22) {
                                n21 = mMFFMolecule.getConnAtom(n26, n22);
                                n20 = mMFFMolecule.getBond(n26, n21);
                                if (mMFFMolecule.getBondOrder(n20) != 2) continue;
                                if (mMFFMolecule.getAtomicNo(n21) == 6) {
                                    for (n19 = 0; n19 < mMFFMolecule.getAllConnAtoms(n21); ++n19) {
                                        n18 = mMFFMolecule.getConnAtom(n21, n19);
                                        if (n18 == n) continue;
                                        if (mMFFMolecule.getAtomicNo(n18) == 7) {
                                            ++n25;
                                            continue;
                                        }
                                        if (mMFFMolecule.getAtomicNo(n18) == 8) {
                                            ++n24;
                                            continue;
                                        }
                                        if (mMFFMolecule.getAtomicNo(n18) != 16) continue;
                                        ++n23;
                                    }
                                    if (n25 == 0 && n24 == 0 && n23 == 0 && n6 == 0) {
                                        n4 = 1;
                                    }
                                }
                                if (mMFFMolecule.getAtomicNo(n21) != 7 || n6 != 0) continue;
                                n4 = 1;
                            }
                        }
                        if (n7 != 0) {
                            if (n3 == 7) {
                                bl = true;
                            }
                            if (n9 != 0) {
                                return 55;
                            }
                            if (n8 != 0) {
                                return 56;
                            }
                            if (n10 == 0 && !bl && (n16 == 0 && n17 == 0 && n6 != 0 || n5 == 6 || n5 == 7 || n5 == 15 || n3 == 6)) {
                                return 40;
                            }
                        }
                        if (!(bl || n10 == 0 && n4 == 0)) {
                            return 10;
                        }
                    }
                }
                if (Atom.degree(mMFFMolecule, n) == 2) {
                    if (mMFFMolecule.getOccupiedValence(n) + mMFFMolecule.getImplicitHydrogens(n) == 4) {
                        n10 = 0;
                        for (n9 = 0; n10 == 0 && n9 < mMFFMolecule.getAllConnAtoms(n); ++n9) {
                            n8 = mMFFMolecule.getConnAtom(n, n9);
                            n10 = mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n8)) == 3 ? 1 : 0;
                        }
                        if (n10 != 0) {
                            return 61;
                        }
                        return 53;
                    }
                    if (mMFFMolecule.getOccupiedValence(n) + mMFFMolecule.getImplicitHydrogens(n) == 3) {
                        n10 = 0;
                        n9 = 0;
                        for (n8 = 0; n8 < mMFFMolecule.getAllConnAtoms(n); ++n8) {
                            n4 = mMFFMolecule.getConnAtom(n, n8);
                            if (mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n4)) != 2) continue;
                            n10 = mMFFMolecule.getAtomicNo(n4) == 8 && n13 == 1 ? 1 : 0;
                            n9 = mMFFMolecule.getAtomicNo(n4) == 6 || mMFFMolecule.getAtomicNo(n4) == 7 ? 1 : 0;
                        }
                        if (n10 != 0 && n9 == 0) {
                            return 46;
                        }
                        if (n9 != 0) {
                            return 9;
                        }
                    }
                    if (mMFFMolecule.getOccupiedValence(n) + mMFFMolecule.getImplicitHydrogens(n) >= 2) {
                        n10 = 0;
                        for (n9 = 0; n9 < mMFFMolecule.getAllConnAtoms(n); ++n9) {
                            n8 = mMFFMolecule.getConnAtom(n, n9);
                            if (mMFFMolecule.getAtomicNo(n8) != 16) continue;
                            n4 = 0;
                            for (n7 = 0; n7 < mMFFMolecule.getAllConnAtoms(n8); ++n7) {
                                n6 = mMFFMolecule.getConnAtom(n8, n7);
                                if (mMFFMolecule.getAtomicNo(n6) != 8 || Atom.degree(mMFFMolecule, n6) != 1) continue;
                                ++n4;
                            }
                            n10 = n4 == 1 ? 1 : 0;
                        }
                        if (n10 != 0) {
                            return 48;
                        }
                        if (!bl) {
                            return 62;
                        }
                    }
                }
                if (bl) {
                    return 43;
                }
                if (Atom.degree(mMFFMolecule, n) == 1) {
                    n10 = 0;
                    n9 = 0;
                    for (n8 = 0; n10 == 0 && n9 == 0 && n8 < mMFFMolecule.getAllConnAtoms(n); ++n8) {
                        n4 = mMFFMolecule.getConnAtom(n, n8);
                        int n27 = n10 = mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n4)) == 3 ? 1 : 0;
                        if (mMFFMolecule.getAtomicNo(n4) != 7 || Atom.degree(mMFFMolecule, n4) != 2) continue;
                        for (n7 = 0; n9 == 0 && n7 < mMFFMolecule.getAllConnAtoms(n4); ++n7) {
                            n6 = mMFFMolecule.getConnAtom(n4, n7);
                            n9 = mMFFMolecule.getAtomicNo(n6) == 7 && Atom.degree(mMFFMolecule, n6) == 2 || mMFFMolecule.getAtomicNo(n6) == 6 && Atom.degree(mMFFMolecule, n6) == 3 ? 1 : 0;
                        }
                    }
                    if (n10 != 0) {
                        return 42;
                    }
                    if (n9 != 0) {
                        return 47;
                    }
                }
                return 8;
            }
            case 8: {
                if (Atom.degree(mMFFMolecule, n) == 3) {
                    return 49;
                }
                if (Atom.degree(mMFFMolecule, n) == 2) {
                    if (mMFFMolecule.getOccupiedValence(n) + mMFFMolecule.getImplicitHydrogens(n) == 3) {
                        return 51;
                    }
                    n10 = 0;
                    for (n9 = 0; n9 < mMFFMolecule.getAllConnAtoms(n); ++n9) {
                        n8 = mMFFMolecule.getConnAtom(n, n9);
                        if (mMFFMolecule.getAtomicNo(n8) != 1) continue;
                        ++n10;
                    }
                    if (n10 + mMFFMolecule.getImplicitHydrogens(n) == 2) {
                        return 70;
                    }
                    return 6;
                }
                if (mMFFMolecule.getConnAtoms(n) > 1) break;
                n10 = 0;
                n9 = 0;
                n8 = 0;
                n4 = mMFFMolecule.getAllConnAtoms(n) - mMFFMolecule.getConnAtoms(n) + mMFFMolecule.getImplicitHydrogens(n) > 0 ? 1 : 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n3 = 0;
                n2 = 0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                for (int i = 0; !(i >= mMFFMolecule.getAllConnAtoms(n) || n4 != 0 || n7 != 0 || n6 != 0 || n5 != 0 || n3 != 0 || n2 != 0 || bl || bl2 || bl3 || bl4 || bl5 || bl6); ++i) {
                    int n28 = mMFFMolecule.getConnAtom(n, i);
                    if (mMFFMolecule.getAtomicNo(n28) == 6 || mMFFMolecule.getAtomicNo(n28) == 7 || mMFFMolecule.getAtomicNo(n28) == 16) {
                        for (int j = 0; j < mMFFMolecule.getAllConnAtoms(n28); ++j) {
                            int n29 = mMFFMolecule.getConnAtom(n28, j);
                            if (mMFFMolecule.getAtomicNo(n29) == 7 && Atom.degree(mMFFMolecule, n29) == 2) {
                                ++n10;
                            }
                            if (mMFFMolecule.getAtomicNo(n29) == 8 && Atom.degree(mMFFMolecule, n29) == 1) {
                                ++n9;
                            }
                            if (mMFFMolecule.getAtomicNo(n29) != 16 || Atom.degree(mMFFMolecule, n29) != 1) continue;
                            ++n8;
                        }
                    }
                    int n30 = n4 = mMFFMolecule.getAtomicNo(n28) == 1 ? 1 : 0;
                    if (mMFFMolecule.getAtomicNo(n28) == 6) {
                        n7 = n9 == 2 ? 1 : 0;
                        n6 = mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n28)) == 2 ? 1 : 0;
                        int n31 = n5 = mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n28)) == 1 && n9 == 1 ? 1 : 0;
                    }
                    if (mMFFMolecule.getAtomicNo(n28) == 7) {
                        int n32 = n3 = mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n28)) == 2 ? 1 : 0;
                        if (mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n28)) == 1 && n9 == 1) {
                            n2 = Atom.degree(mMFFMolecule, n28) == 2 || mMFFMolecule.getOccupiedValence(n28) + mMFFMolecule.getImplicitHydrogens(n28) == 3 ? 1 : 0;
                            bl = mMFFMolecule.getOccupiedValence(n28) + mMFFMolecule.getImplicitHydrogens(n28) == 4;
                        }
                        boolean bl7 = bl2 = n9 >= 2;
                    }
                    if (mMFFMolecule.getAtomicNo(n28) == 16) {
                        bl3 = n8 == 1;
                        bl4 = mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n28)) == 1 || mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n28)) == 2 && n9 + n10 > 1;
                        bl5 = mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n28)) == 2 && n9 + n10 == 1;
                    }
                    bl6 = mMFFMolecule.getAtomicNo(n28) == 15 || mMFFMolecule.getAtomicNo(n28) == 17;
                }
                if (n5 != 0 || n2 != 0 || n4 != 0) {
                    return 35;
                }
                if (n7 != 0 || bl2 || bl || bl3 || bl4 || bl6) {
                    return 32;
                }
                if (n6 == 0 && n3 == 0 && !bl5) break;
                return 7;
            }
            case 9: {
                if (mMFFMolecule.getConnAtoms(n) == 1) {
                    return 11;
                }
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 89;
            }
            case 11: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 93;
            }
            case 12: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 99;
            }
            case 14: {
                return 19;
            }
            case 15: {
                if (Atom.degree(mMFFMolecule, n) == 4) {
                    return 25;
                }
                if (Atom.degree(mMFFMolecule, n) == 3) {
                    return 26;
                }
                if (Atom.degree(mMFFMolecule, n) != 2) break;
                return 75;
            }
            case 16: {
                if (Atom.degree(mMFFMolecule, n) == 3 || Atom.degree(mMFFMolecule, n) == 4) {
                    n10 = 0;
                    n9 = 0;
                    n8 = 0;
                    for (n4 = 0; n4 < mMFFMolecule.getAllConnAtoms(n); ++n4) {
                        n7 = mMFFMolecule.getConnAtom(n, n4);
                        if (mMFFMolecule.getAtomicNo(n7) == 6 && mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n7)) == 2) {
                            n8 = 1;
                        }
                        if (mMFFMolecule.getConnAtoms(n7) == 1 && mMFFMolecule.getAtomicNo(n7) == 8 || Atom.degree(mMFFMolecule, n7) == 2 && mMFFMolecule.getAtomicNo(n7) == 7) {
                            ++n10;
                        }
                        if (mMFFMolecule.getConnAtoms(n7) != 1 || mMFFMolecule.getAtomicNo(n7) != 16) continue;
                        ++n9;
                    }
                    if (Atom.degree(mMFFMolecule, n) == 3 && n10 == 2 && n8 != 0 || Atom.degree(mMFFMolecule, n) == 4) {
                        return 18;
                    }
                    if (n10 > 0 && n9 > 0 || n10 == 2 && n8 == 0) {
                        return 73;
                    }
                    return 17;
                }
                if (Atom.degree(mMFFMolecule, n) == 2) {
                    n10 = 0;
                    for (n9 = 0; n9 < mMFFMolecule.getAllConnAtoms(n); ++n9) {
                        n8 = mMFFMolecule.getConnAtom(n, n9);
                        if (mMFFMolecule.getAtomicNo(n8) != 8 || mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n8)) != 2) continue;
                        n10 = 1;
                    }
                    if (n10 != 0) {
                        return 74;
                    }
                    return 15;
                }
                if (Atom.degree(mMFFMolecule, n) != 1) break;
                n10 = 0;
                n9 = 0;
                for (n8 = 0; n8 < mMFFMolecule.getAllConnAtoms(n); ++n8) {
                    n4 = mMFFMolecule.getConnAtom(n, n8);
                    for (n7 = 0; n7 < mMFFMolecule.getAllConnAtoms(n4); ++n7) {
                        n6 = mMFFMolecule.getConnAtom(n4, n7);
                        if (mMFFMolecule.getAtomicNo(n6) != 16 || Atom.degree(mMFFMolecule, n6) != 1) continue;
                        ++n10;
                    }
                    if (mMFFMolecule.getAtomicNo(n4) != 6 || mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n, n4)) != 2) continue;
                    n9 = 1;
                }
                if (n9 != 0 && n10 != 2) {
                    return 16;
                }
                return 72;
            }
            case 17: {
                if (mMFFMolecule.getConnAtoms(n) == 4) {
                    n10 = 0;
                    for (n9 = 0; n9 < mMFFMolecule.getAllConnAtoms(n); ++n9) {
                        n8 = mMFFMolecule.getConnAtom(n, n9);
                        if (mMFFMolecule.getAtomicNo(n8) != 8) continue;
                        ++n10;
                    }
                    if (n10 == 4) {
                        return 77;
                    }
                }
                if (mMFFMolecule.getConnAtoms(n) == 1) {
                    return 12;
                }
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 90;
            }
            case 19: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 94;
            }
            case 20: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 96;
            }
            case 26: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                if (mMFFMolecule.getAtomCharge(n) == 2) {
                    return 87;
                }
                if (mMFFMolecule.getAtomCharge(n) != 3) break;
                return 88;
            }
            case 29: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                if (mMFFMolecule.getAtomCharge(n) == 1) {
                    return 97;
                }
                if (mMFFMolecule.getAtomCharge(n) != 2) break;
                return 98;
            }
            case 30: {
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 95;
            }
            case 35: {
                if (mMFFMolecule.getConnAtoms(n) == 1) {
                    return 13;
                }
                if (mMFFMolecule.getConnAtoms(n) != 0) break;
                return 91;
            }
            case 53: {
                if (mMFFMolecule.getConnAtoms(n) != 1) break;
                return 14;
            }
        }
        return 0;
    }

    private static int getHydrogenType(MMFFMolecule mMFFMolecule, int n) {
        for (int i = 0; i < mMFFMolecule.getAllConnAtoms(n); ++i) {
            int n2 = mMFFMolecule.getConnAtom(n, i);
            switch (mMFFMolecule.getAtomicNo(n2)) {
                case 6: {
                    return 5;
                }
                case 7: {
                    switch (Atom.getHeavyType(mMFFMolecule, n2)) {
                        case 8: 
                        case 39: 
                        case 62: 
                        case 67: 
                        case 68: {
                            return 23;
                        }
                        case 34: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 58: 
                        case 81: {
                            return 36;
                        }
                        case 9: {
                            return 27;
                        }
                    }
                    return 28;
                }
                case 8: {
                    switch (Atom.getHeavyType(mMFFMolecule, n2)) {
                        case 49: {
                            return 50;
                        }
                        case 51: {
                            return 52;
                        }
                        case 70: {
                            return 31;
                        }
                        case 6: {
                            boolean bl = false;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            for (int j = 0; j < mMFFMolecule.getAllConnAtoms(n2); ++j) {
                                int n3 = mMFFMolecule.getConnAtom(n2, j);
                                if (mMFFMolecule.getAtomicNo(n3) == 6) {
                                    for (int k = 0; k < mMFFMolecule.getAllConnAtoms(n3); ++k) {
                                        int n4 = mMFFMolecule.getConnAtom(n3, k);
                                        if (n4 == n2) continue;
                                        int n5 = mMFFMolecule.getBond(n3, n4);
                                        if (!(mMFFMolecule.getAtomicNo(n4) != 6 && mMFFMolecule.getAtomicNo(n4) != 7 || mMFFMolecule.getBondOrder(n5) != 2 && !mMFFMolecule.isAromaticBond(n5))) {
                                            bl = true;
                                        }
                                        if (mMFFMolecule.getAtomicNo(n4) != 8 || mMFFMolecule.getBondOrder(n5) != 2) continue;
                                        bl2 = true;
                                    }
                                }
                                if (mMFFMolecule.getAtomicNo(n3) == 15) {
                                    bl3 = true;
                                }
                                if (mMFFMolecule.getAtomicNo(n3) != 16) continue;
                                bl4 = true;
                            }
                            if (bl2 || bl3) {
                                return 24;
                            }
                            if (bl) {
                                return 29;
                            }
                            if (!bl4) break;
                            return 33;
                        }
                    }
                    return 21;
                }
                case 14: {
                    return 5;
                }
                case 15: {
                    return 71;
                }
                case 16: {
                    return 71;
                }
            }
        }
        return 0;
    }

    private static boolean isAtomNOxide(MMFFMolecule mMFFMolecule, int n) {
        if (mMFFMolecule.getAtomicNo(n) == 7 && Atom.degree(mMFFMolecule, n) >= 3) {
            for (int i = 0; i < mMFFMolecule.getAllConnAtoms(n); ++i) {
                int n2 = mMFFMolecule.getConnAtom(n, i);
                if (mMFFMolecule.getAtomicNo(n2) != 8 || Atom.degree(mMFFMolecule, n2) != 1) continue;
                return true;
            }
        }
        return false;
    }

    public static int inRings(MMFFMolecule mMFFMolecule, int n) {
        RingCollection ringCollection = mMFFMolecule.getRingSet();
        int n2 = 0;
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            if (ringCollection.getAtomIndex(i, n) < 0) continue;
            ++n2;
        }
        return n2;
    }

    public static boolean isInAromaticRingOfSize(MMFFMolecule mMFFMolecule, int n, int n2) {
        if (mMFFMolecule.isAromaticAtom(n)) {
            RingCollection ringCollection = mMFFMolecule.getRingSet();
            for (int i = 0; i < ringCollection.getSize(); ++i) {
                if (ringCollection.getRingSize(i) != n2 || !ringCollection.isAtomMember(i, n) || !mMFFMolecule.ringIsMMFFAromatic(i)) continue;
                return true;
            }
        }
        return false;
    }

    public static RingBoolean ringIsMMFFAromatic(MMFFMolecule mMFFMolecule, int n) {
        RingCollection ringCollection = mMFFMolecule.getRingSet();
        if (!ringCollection.isAromatic(n)) {
            return RingBoolean.FALSE;
        }
        if (ringCollection.getRingSize(n) == 6) {
            for (int n2 : ringCollection.getRingAtoms(n)) {
                if (mMFFMolecule.getOccupiedValence(n2) + mMFFMolecule.getImplicitHydrogens(n2) == Atom.degree(mMFFMolecule, n2) + 1) continue;
                return RingBoolean.FALSE;
            }
            for (int n2 : ringCollection.getRingBonds(n)) {
                int n3;
                int[] nArray = new int[]{-1, -1};
                if (mMFFMolecule.getBondOrder(n2) != 1) continue;
                block2: for (n3 = 0; n3 <= 1; ++n3) {
                    int n4 = mMFFMolecule.getBondAtom(n3, n2);
                    for (int i = 0; i < mMFFMolecule.getAllConnAtoms(n4); ++i) {
                        int n5 = mMFFMolecule.getConnAtom(n4, i);
                        if (ringCollection.isAtomMember(n, n5) || mMFFMolecule.getBondOrder(mMFFMolecule.getBond(n4, n5)) != 2) continue;
                        nArray[n3] = n5;
                        continue block2;
                    }
                }
                if (nArray[0] <= -1 || nArray[1] <= -1) continue;
                for (n3 = 0; n3 < ringCollection.getSize(); ++n3) {
                    if (ringCollection.isAtomMember(n3, nArray[0]) && ringCollection.isAtomMember(n3, nArray[1]) && !mMFFMolecule.isSetRingMMFFAromaticity(n3)) {
                        return RingBoolean.NOT_SET;
                    }
                    if (!ringCollection.isAtomMember(n3, nArray[0]) || !ringCollection.isAtomMember(n3, nArray[1]) || mMFFMolecule.ringIsMMFFAromatic(n3)) continue;
                    return RingBoolean.FALSE;
                }
            }
        }
        if (ringCollection.getRingSize(n) == 5) {
            int n6 = 1;
            for (int n7 : ringCollection.getRingAtoms(n)) {
                if (mMFFMolecule.getOccupiedValence(n7) + mMFFMolecule.getImplicitHydrogens(n7) == Atom.degree(mMFFMolecule, n7) && n6 > 0) {
                    --n6;
                    continue;
                }
                if (mMFFMolecule.getOccupiedValence(n7) + mMFFMolecule.getImplicitHydrogens(n7) == Atom.degree(mMFFMolecule, n7) + 1) continue;
                return RingBoolean.FALSE;
            }
        }
        return RingBoolean.TRUE;
    }

    public static int degree(MMFFMolecule mMFFMolecule, int n) {
        return mMFFMolecule.getAllConnAtoms(n) + mMFFMolecule.getImplicitHydrogens(n);
    }

    public static boolean inRingOfSize(MMFFMolecule mMFFMolecule, int n, int n2) {
        if (mMFFMolecule.isRingAtom(n)) {
            RingCollection ringCollection = mMFFMolecule.getRingSet();
            for (int i = 0; i < ringCollection.getSize(); ++i) {
                if (ringCollection.getRingSize(i) != n2 || !ringCollection.isAtomMember(i, n)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean inSameRing(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        if (!mMFFMolecule.isRingAtom(n) || !mMFFMolecule.isRingAtom(n2)) {
            return false;
        }
        RingCollection ringCollection = mMFFMolecule.getRingSet();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            if (ringCollection.getRingSize(i) != n3 || !ringCollection.isAtomMember(i, n) || !ringCollection.isAtomMember(i, n2)) continue;
            return true;
        }
        return false;
    }
}

